/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spellchecker.inspections.Splitter;

public abstract class TokenConsumer {
    public void consumeToken(PsiElement element, Splitter splitter) {
        this.consumeToken(element, false, splitter);
    }

    public void consumeToken(PsiElement element, boolean useRename, Splitter splitter) {
        if (element instanceof PsiLanguageInjectionHost && !(element instanceof PsiComment)) {
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
            if (!range.isEmpty()) {
                String text = ElementManipulators.getValueText((PsiElement)element);
                this.consumeToken(element, text, useRename, range.getStartOffset(), TextRange.allOf((String)text), splitter);
            }
        } else {
            String text = element.getText();
            this.consumeToken(element, text, useRename, 0, TextRange.allOf((String)text), splitter);
        }
    }

    public abstract void consumeToken(PsiElement var1, String var2, boolean var3, int var4, TextRange var5, Splitter var6);
}

