"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2017 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================
"""

import builtins
import collections.abc
import sys
import typing

import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import tensorflow.compiler.xla.service.hlo_pb2
import tensorflow.compiler.xla.xla_data_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CompilationEnvironmentsProto(google.protobuf.message.Message):
    """Proto version of `xla::CompilationEnvironments`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    @property
    def environments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]: ...
    def __init__(
        self,
        *,
        environments: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["environments", b"environments"]) -> None: ...

global___CompilationEnvironmentsProto = CompilationEnvironmentsProto

@typing.final
class DebugOptions(google.protobuf.message.Message):
    """Debugging options for XLA. These options may change at any time - there are
    no guarantees about backward or forward compatibility for these fields.

    Debug options naming and organization:

    1. Backend-agnostic options: `xla_$flag_name` - go first, and sorted
       alphabetically by the flag name.

    2. Backend-specific options: `xla_$backend_$flag_name` - must be in the
       corresponding backend section, and sorted alphabetically by the flag name.
    --------------------------------------------------------------------------//
    XLA backend-agnostic options.
    --------------------------------------------------------------------------//
    go/keep-sorted start
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ShapeChecks:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ShapeChecksEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._ShapeChecks.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IGNORE: DebugOptions._ShapeChecks.ValueType  # 0
        """Do not insert any shape checks for dynamically shaped operations; output
        buffers might contain garbage data if shapes don't match.
        """
        RUNTIME: DebugOptions._ShapeChecks.ValueType  # 1
        """Check shapes at runtime, will insert an extra synchronization if shapes
        cannot be proven correct at compile time.
        """
        COMPILE_TIME: DebugOptions._ShapeChecks.ValueType  # 2
        """Will refuse to compile any program where shape correctness can not be
        established at compile time.
        """

    class ShapeChecks(_ShapeChecks, metaclass=_ShapeChecksEnumTypeWrapper): ...
    IGNORE: DebugOptions.ShapeChecks.ValueType  # 0
    """Do not insert any shape checks for dynamically shaped operations; output
    buffers might contain garbage data if shapes don't match.
    """
    RUNTIME: DebugOptions.ShapeChecks.ValueType  # 1
    """Check shapes at runtime, will insert an extra synchronization if shapes
    cannot be proven correct at compile time.
    """
    COMPILE_TIME: DebugOptions.ShapeChecks.ValueType  # 2
    """Will refuse to compile any program where shape correctness can not be
    established at compile time.
    """

    class _StepMarkerLocation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StepMarkerLocationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._StepMarkerLocation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STEP_MARK_AT_ENTRY: DebugOptions._StepMarkerLocation.ValueType  # 0
        """Generate a step marker at the program entry. This handles the case where
        each step is done by one or multiple program execution(s). Only the first
        program will be tagged for generating a step marker at the program entry.
        This is the default.
        """
        STEP_MARK_AT_TOP_LEVEL_WHILE_LOOP: DebugOptions._StepMarkerLocation.ValueType  # 1
        """Generate a step marker at each iteration of the top level while loop,
        which is assumed to be a training loop.
        """
        STEP_MARK_AT_SECOND_LEVEL_WHILE_LOOP: DebugOptions._StepMarkerLocation.ValueType  # 3
        """Generate a step marker at each iteration of the second level while loops,
        which is assumed to be a training or eval loop.
        """
        STEP_MARK_NONE: DebugOptions._StepMarkerLocation.ValueType  # 2
        """No step marker generated."""

    class StepMarkerLocation(_StepMarkerLocation, metaclass=_StepMarkerLocationEnumTypeWrapper): ...
    STEP_MARK_AT_ENTRY: DebugOptions.StepMarkerLocation.ValueType  # 0
    """Generate a step marker at the program entry. This handles the case where
    each step is done by one or multiple program execution(s). Only the first
    program will be tagged for generating a step marker at the program entry.
    This is the default.
    """
    STEP_MARK_AT_TOP_LEVEL_WHILE_LOOP: DebugOptions.StepMarkerLocation.ValueType  # 1
    """Generate a step marker at each iteration of the top level while loop,
    which is assumed to be a training loop.
    """
    STEP_MARK_AT_SECOND_LEVEL_WHILE_LOOP: DebugOptions.StepMarkerLocation.ValueType  # 3
    """Generate a step marker at each iteration of the second level while loops,
    which is assumed to be a training or eval loop.
    """
    STEP_MARK_NONE: DebugOptions.StepMarkerLocation.ValueType  # 2
    """No step marker generated."""

    class _CollectiveOpType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CollectiveOpTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._CollectiveOpType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOOP: DebugOptions._CollectiveOpType.ValueType  # 0
        ALLREDUCE: DebugOptions._CollectiveOpType.ValueType  # 1
        ALLGATHER: DebugOptions._CollectiveOpType.ValueType  # 2
        REDUCESCATTER: DebugOptions._CollectiveOpType.ValueType  # 3
        COLLECTIVEBROADCAST: DebugOptions._CollectiveOpType.ValueType  # 4
        ALLTOALL: DebugOptions._CollectiveOpType.ValueType  # 5
        COLLECTIVEPERMUTE: DebugOptions._CollectiveOpType.ValueType  # 6

    class CollectiveOpType(_CollectiveOpType, metaclass=_CollectiveOpTypeEnumTypeWrapper):
        """Enum to define all collective ops
        that xla supports.
        """

    NOOP: DebugOptions.CollectiveOpType.ValueType  # 0
    ALLREDUCE: DebugOptions.CollectiveOpType.ValueType  # 1
    ALLGATHER: DebugOptions.CollectiveOpType.ValueType  # 2
    REDUCESCATTER: DebugOptions.CollectiveOpType.ValueType  # 3
    COLLECTIVEBROADCAST: DebugOptions.CollectiveOpType.ValueType  # 4
    ALLTOALL: DebugOptions.CollectiveOpType.ValueType  # 5
    COLLECTIVEPERMUTE: DebugOptions.CollectiveOpType.ValueType  # 6

    class _CommandBufferCmdType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CommandBufferCmdTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._CommandBufferCmdType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: DebugOptions._CommandBufferCmdType.ValueType  # 0
        FUSION: DebugOptions._CommandBufferCmdType.ValueType  # 1
        CUBLAS: DebugOptions._CommandBufferCmdType.ValueType  # 2
        CUDNN: DebugOptions._CommandBufferCmdType.ValueType  # 3
        COLLECTIVES: DebugOptions._CommandBufferCmdType.ValueType  # 4
        CONDITIONALS: DebugOptions._CommandBufferCmdType.ValueType  # 5
        CUSTOM_CALL: DebugOptions._CommandBufferCmdType.ValueType  # 6
        CUBLASLT: DebugOptions._CommandBufferCmdType.ValueType  # 7

    class CommandBufferCmdType(_CommandBufferCmdType, metaclass=_CommandBufferCmdTypeEnumTypeWrapper):
        """Commands are categorized into 5 types:
        FUSION represents regular fusion kernels.
        CUBLAS/CUBLASLT, CUDNN, and COLLECTIVES represent library calls.
        CONDITIONALS represents control flow.
        """

    INVALID: DebugOptions.CommandBufferCmdType.ValueType  # 0
    FUSION: DebugOptions.CommandBufferCmdType.ValueType  # 1
    CUBLAS: DebugOptions.CommandBufferCmdType.ValueType  # 2
    CUDNN: DebugOptions.CommandBufferCmdType.ValueType  # 3
    COLLECTIVES: DebugOptions.CommandBufferCmdType.ValueType  # 4
    CONDITIONALS: DebugOptions.CommandBufferCmdType.ValueType  # 5
    CUSTOM_CALL: DebugOptions.CommandBufferCmdType.ValueType  # 6
    CUBLASLT: DebugOptions.CommandBufferCmdType.ValueType  # 7

    class _PartitioningAlgorithm:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PartitioningAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._PartitioningAlgorithm.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PARTITIONING_ALGORITHM_NOOP: DebugOptions._PartitioningAlgorithm.ValueType  # 0
        PARTITIONING_ALGORITHM_EXP0: DebugOptions._PartitioningAlgorithm.ValueType  # 1
        PARTITIONING_ALGORITHM_EXP1: DebugOptions._PartitioningAlgorithm.ValueType  # 2
        PARTITIONING_ALGORITHM_EXP2: DebugOptions._PartitioningAlgorithm.ValueType  # 3

    class PartitioningAlgorithm(_PartitioningAlgorithm, metaclass=_PartitioningAlgorithmEnumTypeWrapper): ...
    PARTITIONING_ALGORITHM_NOOP: DebugOptions.PartitioningAlgorithm.ValueType  # 0
    PARTITIONING_ALGORITHM_EXP0: DebugOptions.PartitioningAlgorithm.ValueType  # 1
    PARTITIONING_ALGORITHM_EXP1: DebugOptions.PartitioningAlgorithm.ValueType  # 2
    PARTITIONING_ALGORITHM_EXP2: DebugOptions.PartitioningAlgorithm.ValueType  # 3

    class _WhileLoopUnrolling:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WhileLoopUnrollingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._WhileLoopUnrolling.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WHILE_LOOP_UNROLLING_NO_UNROLL: DebugOptions._WhileLoopUnrolling.ValueType  # 0
        WHILE_LOOP_UNROLLING_DOUBLE_BUFFER: DebugOptions._WhileLoopUnrolling.ValueType  # 1
        """Has the same effect as setting
        `xla_gpu_enable_while_loop_double_buffering`.
        """
        WHILE_LOOP_UNROLLING_FULL_UNROLL: DebugOptions._WhileLoopUnrolling.ValueType  # 2
        """Enables full loop unrolling using the same strategy as `DOUBLE_BUFFER`."""

    class WhileLoopUnrolling(_WhileLoopUnrolling, metaclass=_WhileLoopUnrollingEnumTypeWrapper): ...
    WHILE_LOOP_UNROLLING_NO_UNROLL: DebugOptions.WhileLoopUnrolling.ValueType  # 0
    WHILE_LOOP_UNROLLING_DOUBLE_BUFFER: DebugOptions.WhileLoopUnrolling.ValueType  # 1
    """Has the same effect as setting
    `xla_gpu_enable_while_loop_double_buffering`.
    """
    WHILE_LOOP_UNROLLING_FULL_UNROLL: DebugOptions.WhileLoopUnrolling.ValueType  # 2
    """Enables full loop unrolling using the same strategy as `DOUBLE_BUFFER`."""

    class _AutotuneCacheMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AutotuneCacheModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DebugOptions._AutotuneCacheMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUTOTUNE_CACHE_MODE_UNSPECIFIED: DebugOptions._AutotuneCacheMode.ValueType  # 0
        AUTOTUNE_CACHE_MODE_UPDATE: DebugOptions._AutotuneCacheMode.ValueType  # 1
        """If the cache exists per fusion autotuner loads it and terminates,
        otherwise runs autotuner and dumps the result.
        """
        AUTOTUNE_CACHE_MODE_READ: DebugOptions._AutotuneCacheMode.ValueType  # 2
        """Sets readonly access to the cache for the per fusion autotuner. Same as
        above, but doesn't dump anything.
        """

    class AutotuneCacheMode(_AutotuneCacheMode, metaclass=_AutotuneCacheModeEnumTypeWrapper): ...
    AUTOTUNE_CACHE_MODE_UNSPECIFIED: DebugOptions.AutotuneCacheMode.ValueType  # 0
    AUTOTUNE_CACHE_MODE_UPDATE: DebugOptions.AutotuneCacheMode.ValueType  # 1
    """If the cache exists per fusion autotuner loads it and terminates,
    otherwise runs autotuner and dumps the result.
    """
    AUTOTUNE_CACHE_MODE_READ: DebugOptions.AutotuneCacheMode.ValueType  # 2
    """Sets readonly access to the cache for the per fusion autotuner. Same as
    above, but doesn't dump anything.
    """

    @typing.final
    class XlaBackendExtraOptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    XLA_CPU_ENABLE_CONCURRENCY_OPTIMIZED_SCHEDULER_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_FAST_MATH_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_FAST_MIN_MAX_FIELD_NUMBER: builtins.int
    XLA_CPU_FAST_MATH_HONOR_DIVISION_FIELD_NUMBER: builtins.int
    XLA_CPU_FAST_MATH_HONOR_FUNCTIONS_FIELD_NUMBER: builtins.int
    XLA_CPU_FAST_MATH_HONOR_INFS_FIELD_NUMBER: builtins.int
    XLA_CPU_FAST_MATH_HONOR_NANS_FIELD_NUMBER: builtins.int
    XLA_CPU_USE_THUNK_RUNTIME_FIELD_NUMBER: builtins.int
    XLA_CPU_PARALLEL_CODEGEN_SPLIT_COUNT_FIELD_NUMBER: builtins.int
    XLA_CPU_PREFER_VECTOR_WIDTH_FIELD_NUMBER: builtins.int
    XLA_GPU_EXPERIMENTAL_AUTOTUNE_CACHE_MODE_FIELD_NUMBER: builtins.int
    XLA_GPU_EXPERIMENTAL_DISABLE_BINARY_LIBRARIES_FIELD_NUMBER: builtins.int
    XLA_GPU_EXPERIMENTAL_ENABLE_TRITON_SOFTMAX_PRIORITY_FUSION_FIELD_NUMBER: builtins.int
    XLA_GPU_UNSUPPORTED_ENABLE_TRITON_GEMM_FIELD_NUMBER: builtins.int
    XLA_HLO_GRAPH_ADDRESSES_FIELD_NUMBER: builtins.int
    XLA_HLO_PROFILE_FIELD_NUMBER: builtins.int
    XLA_DISABLE_HLO_PASSES_FIELD_NUMBER: builtins.int
    XLA_ENABLE_HLO_PASSES_ONLY_FIELD_NUMBER: builtins.int
    XLA_DISABLE_ALL_HLO_PASSES_FIELD_NUMBER: builtins.int
    XLA_BACKEND_OPTIMIZATION_LEVEL_FIELD_NUMBER: builtins.int
    XLA_EMBED_IR_IN_EXECUTABLE_FIELD_NUMBER: builtins.int
    XLA_ELIMINATE_HLO_IMPLICIT_BROADCAST_FIELD_NUMBER: builtins.int
    XLA_CPU_MULTI_THREAD_EIGEN_FIELD_NUMBER: builtins.int
    XLA_GPU_CUDA_DATA_DIR_FIELD_NUMBER: builtins.int
    XLA_GPU_FTZ_FIELD_NUMBER: builtins.int
    XLA_LLVM_ENABLE_ALIAS_SCOPE_METADATA_FIELD_NUMBER: builtins.int
    XLA_LLVM_ENABLE_NOALIAS_METADATA_FIELD_NUMBER: builtins.int
    XLA_LLVM_ENABLE_INVARIANT_LOAD_METADATA_FIELD_NUMBER: builtins.int
    XLA_LLVM_DISABLE_EXPENSIVE_PASSES_FIELD_NUMBER: builtins.int
    XLA_TEST_ALL_OUTPUT_LAYOUTS_FIELD_NUMBER: builtins.int
    XLA_TEST_ALL_INPUT_LAYOUTS_FIELD_NUMBER: builtins.int
    XLA_HLO_GRAPH_SHARDING_COLOR_FIELD_NUMBER: builtins.int
    XLA_CPU_USE_MKL_DNN_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_FAST_MIN_MAX_FIELD_NUMBER: builtins.int
    XLA_ALLOW_EXCESS_PRECISION_FIELD_NUMBER: builtins.int
    XLA_GPU_CRASH_ON_VERIFICATION_FAILURES_FIELD_NUMBER: builtins.int
    XLA_GPU_AUTOTUNE_LEVEL_FIELD_NUMBER: builtins.int
    XLA_FORCE_HOST_PLATFORM_DEVICE_COUNT_FIELD_NUMBER: builtins.int
    XLA_GPU_DISABLE_GPUASM_OPTIMIZATIONS_FIELD_NUMBER: builtins.int
    XLA_GPU_SHAPE_CHECKS_FIELD_NUMBER: builtins.int
    XLA_HLO_EVALUATOR_USE_FAST_PATH_FIELD_NUMBER: builtins.int
    XLA_ALLOW_SCALAR_INDEX_DYNAMIC_OPS_FIELD_NUMBER: builtins.int
    XLA_STEP_MARKER_LOCATION_FIELD_NUMBER: builtins.int
    XLA_DUMP_TO_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_MODULE_RE_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_PASS_RE_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_TEXT_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_PROTO_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_DOT_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_URL_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_HTML_FIELD_NUMBER: builtins.int
    XLA_DUMP_FUSION_VISUALIZATION_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_SNAPSHOTS_FIELD_NUMBER: builtins.int
    XLA_DUMP_INCLUDE_TIMESTAMP_FIELD_NUMBER: builtins.int
    XLA_DUMP_MAX_HLO_MODULES_FIELD_NUMBER: builtins.int
    XLA_DUMP_MODULE_METADATA_FIELD_NUMBER: builtins.int
    XLA_DUMP_COMPRESS_PROTOS_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_AS_LONG_TEXT_FIELD_NUMBER: builtins.int
    XLA_GPU_FORCE_CONV_NCHW_FIELD_NUMBER: builtins.int
    XLA_GPU_FORCE_CONV_NHWC_FIELD_NUMBER: builtins.int
    XLA_GPU_PTX_FILE_FIELD_NUMBER: builtins.int
    XLA_GPU_DUMP_LLVMIR_FIELD_NUMBER: builtins.int
    XLA_DUMP_ENABLE_MLIR_PRETTY_FORM_FIELD_NUMBER: builtins.int
    XLA_GPU_ALGORITHM_DENYLIST_PATH_FIELD_NUMBER: builtins.int
    XLA_TPU_DETECT_NAN_FIELD_NUMBER: builtins.int
    XLA_TPU_DETECT_INF_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_XPROF_TRACEME_FIELD_NUMBER: builtins.int
    XLA_GPU_UNSAFE_FALLBACK_TO_DRIVER_ON_PTXAS_NOT_FOUND_FIELD_NUMBER: builtins.int
    XLA_GPU_ASM_EXTRA_FLAGS_FIELD_NUMBER: builtins.int
    XLA_MULTIHEAP_SIZE_CONSTRAINT_PER_HEAP_FIELD_NUMBER: builtins.int
    XLA_DETAILED_LOGGING_FIELD_NUMBER: builtins.int
    XLA_ENABLE_DUMPING_FIELD_NUMBER: builtins.int
    XLA_GPU_FORCE_COMPILATION_PARALLELISM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_LLVM_MODULE_COMPILATION_PARALLELISM_FIELD_NUMBER: builtins.int
    XLA_GPU_DETERMINISTIC_OPS_FIELD_NUMBER: builtins.int
    XLA_GPU_LLVM_IR_FILE_FIELD_NUMBER: builtins.int
    XLA_GPU_DISABLE_ASYNC_COLLECTIVES_FIELD_NUMBER: builtins.int
    XLA_GPU_ALL_REDUCE_COMBINE_THRESHOLD_BYTES_FIELD_NUMBER: builtins.int
    XLA_GPU_ALL_GATHER_COMBINE_THRESHOLD_BYTES_FIELD_NUMBER: builtins.int
    XLA_GPU_REDUCE_SCATTER_COMBINE_THRESHOLD_BYTES_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_ALL_GATHER_COMBINE_BY_DIM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_REDUCE_SCATTER_COMBINE_BY_DIM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_REASSOCIATION_FOR_CONVERTED_AR_FIELD_NUMBER: builtins.int
    XLA_GPU_ALL_REDUCE_BLUECONNECT_NUM_DEVICES_PER_HOST_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_WHILE_LOOP_REDUCE_SCATTER_CODE_MOTION_FIELD_NUMBER: builtins.int
    XLA_GPU_COLLECTIVE_INFLATION_FACTOR_FIELD_NUMBER: builtins.int
    XLA_LLVM_FORCE_INLINE_BEFORE_SPLIT_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUDNN_FRONTEND_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUDNN_FMHA_FIELD_NUMBER: builtins.int
    XLA_GPU_FUSED_ATTENTION_USE_CUDNN_RNG_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUDNN_LAYER_NORM_FIELD_NUMBER: builtins.int
    XLA_DUMP_DISABLE_METADATA_FIELD_NUMBER: builtins.int
    XLA_DUMP_HLO_PIPELINE_RE_FIELD_NUMBER: builtins.int
    XLA_GPU_STRICT_CONV_ALGORITHM_PICKER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUSTOM_FUSIONS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUSTOM_FUSIONS_RE_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_DYNAMIC_SLICE_FUSION_FIELD_NUMBER: builtins.int
    XLA_GPU_NCCL_TERMINATION_TIMEOUT_SECONDS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_SHARED_CONSTANTS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUBLASLT_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_COMMAND_BUFFER_FIELD_NUMBER: builtins.int
    XLA_GPU_GRAPH_MIN_GRAPH_SIZE_FIELD_NUMBER: builtins.int
    XLA_GPU_GRAPH_ENABLE_CONCURRENT_REGION_FIELD_NUMBER: builtins.int
    XLA_GPU_REDZONE_SCRATCH_MAX_MEGABYTES_FIELD_NUMBER: builtins.int
    XLA_GPU_REDZONE_PADDING_BYTES_FIELD_NUMBER: builtins.int
    XLA_CPU_USE_ACL_FIELD_NUMBER: builtins.int
    XLA_CPU_STRICT_DOT_CONV_MATH_FIELD_NUMBER: builtins.int
    XLA_GPU_USE_RUNTIME_FUSION_FIELD_NUMBER: builtins.int
    XLA_DUMP_LATENCY_HIDING_SCHEDULE_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_MLIR_TILING_AND_FUSION_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_CUSTOM_MATMUL_TILING_FIELD_NUMBER: builtins.int
    XLA_CPU_MATMUL_TILING_M_DIM_FIELD_NUMBER: builtins.int
    XLA_CPU_MATMUL_TILING_N_DIM_FIELD_NUMBER: builtins.int
    XLA_CPU_MATMUL_TILING_K_DIM_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_MLIR_FUSION_OUTLINING_FIELD_NUMBER: builtins.int
    XLA_CPU_ENABLE_EXPERIMENTAL_DEALLOCATION_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_LATENCY_HIDING_SCHEDULER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_HIGHEST_PRIORITY_ASYNC_STREAM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_ANALYTICAL_LATENCY_ESTIMATOR_FIELD_NUMBER: builtins.int
    XLA_GPU_LHS_ENABLE_GPU_ASYNC_TRACKER_FIELD_NUMBER: builtins.int
    XLA_GPU_PGLE_PROFILE_FILE_OR_DIRECTORY_PATH_FIELD_NUMBER: builtins.int
    XLA_GPU_MEMORY_LIMIT_SLOP_FACTOR_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PIPELINED_COLLECTIVES_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PIPELINED_ALL_REDUCE_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PIPELINED_ALL_GATHER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PIPELINED_REDUCE_SCATTER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PIPELINED_P2P_FIELD_NUMBER: builtins.int
    XLA_GPU_RUN_POST_LAYOUT_COLLECTIVE_PIPELINER_FIELD_NUMBER: builtins.int
    XLA_GPU_COLLECTIVE_PERMUTE_DECOMPOSER_THRESHOLD_FIELD_NUMBER: builtins.int
    XLA_PARTITIONING_ALGORITHM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_TRITON_GEMM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUDNN_INT8X32_CONVOLUTION_REORDERING_FIELD_NUMBER: builtins.int
    XLA_GPU_TRITON_GEMM_ANY_FIELD_NUMBER: builtins.int
    XLA_GPU_EXHAUSTIVE_TILING_SEARCH_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PRIORITY_FUSION_FIELD_NUMBER: builtins.int
    XLA_GPU_DUMP_AUTOTUNE_RESULTS_TO_FIELD_NUMBER: builtins.int
    XLA_GPU_LOAD_AUTOTUNE_RESULTS_FROM_FIELD_NUMBER: builtins.int
    XLA_GPU_TARGET_CONFIG_FILENAME_FIELD_NUMBER: builtins.int
    XLA_GPU_AUTO_SPMD_PARTITIONING_MEMORY_BUDGET_GB_FIELD_NUMBER: builtins.int
    XLA_GPU_AUTO_SPMD_PARTITIONING_MEMORY_BUDGET_RATIO_FIELD_NUMBER: builtins.int
    XLA_GPU_TRITON_GEMM_DISABLE_REDUCED_PRECISION_REDUCTION_FIELD_NUMBER: builtins.int
    XLA_GPU_TRITON_FUSION_LEVEL_FIELD_NUMBER: builtins.int
    XLA_GPU_DUMP_AUTOTUNED_GEMM_FUSIONS_FIELD_NUMBER: builtins.int
    XLA_GPU_OVERRIDE_GEMM_AUTOTUNER_FIELD_NUMBER: builtins.int
    XLA_GPU_COPY_INSERTION_USE_REGION_ANALYSIS_FIELD_NUMBER: builtins.int
    XLA_GPU_COLLECT_COST_MODEL_STATS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_SPLIT_K_AUTOTUNING_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_REDUCTION_EPILOGUE_FUSION_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_NCCL_CLIQUE_OPTIMIZATION_FIELD_NUMBER: builtins.int
    XLA_GPU_MOCK_CUSTOM_CALLS_FIELD_NUMBER: builtins.int
    XLA_GPU_CUBLAS_FALLBACK_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_WHILE_LOOP_DOUBLE_BUFFERING_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_WHILE_LOOP_UNROLLING_FIELD_NUMBER: builtins.int
    XLA_GPU_ENSURE_MINOR_DOT_CONTRACTION_DIMS_FIELD_NUMBER: builtins.int
    XLA_GPU_FILTER_KERNELS_SPILLING_REGISTERS_ON_AUTOTUNING_FIELD_NUMBER: builtins.int
    XLA_DEBUG_BUFFER_ASSIGNMENT_SHOW_MAX_FIELD_NUMBER: builtins.int
    XLA_GPU_LLVM_VERIFICATION_LEVEL_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_CUB_RADIX_SORT_FIELD_NUMBER: builtins.int
    XLA_GPU_THRESHOLD_FOR_WINDOWED_EINSUM_MIB_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_TRITON_HOPPER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_NCCL_USER_BUFFERS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_NCCL_COMM_SPLITTING_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_NCCL_PER_STREAM_COMMS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_LIBNVPTXCOMPILER_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_DOT_STRENGTH_REDUCTION_FIELD_NUMBER: builtins.int
    XLA_GPU_MULTI_STREAMED_WINDOWED_EINSUM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_BF16_6WAY_GEMM_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_BF16_3WAY_GEMM_FIELD_NUMBER: builtins.int
    XLA_GPU_NCCL_COLLECTIVE_MAX_NCHANNELS_FIELD_NUMBER: builtins.int
    XLA_GPU_NCCL_P2P_MAX_NCHANNELS_FIELD_NUMBER: builtins.int
    XLA_GPU_MLIR_EMITTER_LEVEL_FIELD_NUMBER: builtins.int
    XLA_GPU_GEMM_REWRITE_SIZE_THRESHOLD_FIELD_NUMBER: builtins.int
    XLA_GPU_REQUIRE_COMPLETE_AOT_AUTOTUNE_RESULTS_FIELD_NUMBER: builtins.int
    XLA_GPU_CUDNN_GEMM_FUSION_LEVEL_FIELD_NUMBER: builtins.int
    XLA_GPU_USE_MEMCPY_LOCAL_P2P_FIELD_NUMBER: builtins.int
    XLA_GPU_AUTOTUNE_MAX_SOLUTIONS_FIELD_NUMBER: builtins.int
    XLA_DUMP_LARGE_CONSTANTS_FIELD_NUMBER: builtins.int
    XLA_GPU_VERIFY_TRITON_FUSION_NUMERICS_FIELD_NUMBER: builtins.int
    XLA_GPU_DUMP_AUTOTUNE_LOGS_TO_FIELD_NUMBER: builtins.int
    XLA_REDUCE_WINDOW_REWRITE_BASE_LENGTH_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_HOST_MEMORY_OFFLOADING_FIELD_NUMBER: builtins.int
    XLA_GPU_EXCLUDE_NONDETERMINISTIC_OPS_FIELD_NUMBER: builtins.int
    XLA_GPU_NCCL_TERMINATE_ON_ERROR_FIELD_NUMBER: builtins.int
    XLA_GPU_SHARD_AUTOTUNING_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_APPROX_COSTLY_COLLECTIVES_FIELD_NUMBER: builtins.int
    XLA_GPU_KERNEL_CACHE_FILE_FIELD_NUMBER: builtins.int
    XLA_GPU_UNSAFE_PIPELINED_LOOP_ANNOTATOR_FIELD_NUMBER: builtins.int
    XLA_GPU_PER_FUSION_AUTOTUNE_CACHE_DIR_FIELD_NUMBER: builtins.int
    XLA_CMD_BUFFER_TRACE_CACHE_SIZE_FIELD_NUMBER: builtins.int
    XLA_GPU_TEMP_BUFFER_USE_SEPARATE_COLOR_FIELD_NUMBER: builtins.int
    LEGACY_COMMAND_BUFFER_CUSTOM_CALL_TARGETS_FIELD_NUMBER: builtins.int
    XLA_SYNTAX_SUGAR_ASYNC_OPS_FIELD_NUMBER: builtins.int
    XLA_GPU_AUTOTUNE_GEMM_RTOL_FIELD_NUMBER: builtins.int
    XLA_ENABLE_COMMAND_BUFFERS_DURING_PROFILING_FIELD_NUMBER: builtins.int
    XLA_GPU_CUDNN_GEMM_MAX_PLANS_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_LIBNVJITLINK_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_TRITON_GEMM_INT4_FIELD_NUMBER: builtins.int
    XLA_GPU_ASYNC_DOT_FIELD_NUMBER: builtins.int
    XLA_GPU_ENABLE_PGLE_ACCURACY_CHECKER_FIELD_NUMBER: builtins.int
    XLA_GPU_EXECUTABLE_WARN_STUCK_TIMEOUT_SECONDS_FIELD_NUMBER: builtins.int
    XLA_GPU_EXECUTABLE_TERMINATE_TIMEOUT_SECONDS_FIELD_NUMBER: builtins.int
    XLA_EXPERIMENTAL_IGNORE_CHANNEL_ID_FIELD_NUMBER: builtins.int
    XLA_BACKEND_EXTRA_OPTIONS_FIELD_NUMBER: builtins.int
    xla_cpu_enable_concurrency_optimized_scheduler: builtins.bool
    """--------------------------------------------------------------------------//
    XLA:CPU options.
    --------------------------------------------------------------------------//

    go/keep-sorted start newline_separated=yes

    When true, XLA:CPU uses HLO module scheduler that is optimized for
    extracting concurrency at the cost of extra memory: we extend the live
    ranges of temporaries to allow XLA runtime to schedule independent
    operations in parallel on separate threads.
    """
    xla_cpu_enable_fast_math: builtins.bool
    """When true, "unsafe" mathematical optimizations are enabled. These
    transformations include but are not limited to:

     - Reducing the precision of operations (e.g. using an approximate sin
       function, or transforming x/y into x * (1/y)).
     - Assuming that operations never produce or consume NaN or +/- Inf (this
       behavior can be adjusted using xla_cpu_fast_math_allow_{nans|infs}).
     - Assuming that +0 and -0 are indistinguishable.
    """
    xla_cpu_enable_fast_min_max: builtins.bool
    """When false we lower the Minimum and Maximum hlos in the CPU backend such
    that Min(NotNaN, NaN) = Min(NaN, NotNaN) = NaN.  In other words, if flag
    this is false we always propagate NaNs through Min and Max.

    Note, this does not correspond to the exact same behavior as the gpu flag
    below!
    """
    xla_cpu_fast_math_honor_division: builtins.bool
    """When xla_cpu_enable_fast_math is true then this controls whether we forbid
    to use the reciprocal of an argument instead of division. Ignored when
    xla_cpu_enable_fast_math is false.
    """
    xla_cpu_fast_math_honor_functions: builtins.bool
    """When xla_cpu_enable_fast_math is true then this controls whether we forbid
    to approximate calculations for functions. Ignored when
    xla_cpu_enable_fast_math is false.
    """
    xla_cpu_fast_math_honor_infs: builtins.bool
    """When xla_cpu_enable_fast_math is true then this controls whether we allow
    operations to produce infinites. Ignored when xla_cpu_enable_fast_math is
    false.
    """
    xla_cpu_fast_math_honor_nans: builtins.bool
    """When xla_cpu_enable_fast_math is true then this controls whether we allow
    operations to produce NaNs.  Ignored when xla_cpu_enable_fast_math is
    false.
    """
    xla_cpu_use_thunk_runtime: builtins.bool
    """When true, XLA:CPU uses the thunk runtime to execute compiled program."""
    xla_cpu_parallel_codegen_split_count: builtins.int
    """The number of parts to split the LLVM module into before codegen. This
    allows XLA to compile all parts in parallel, and resolve kernel symbols
    from different dynamic libraries.
    """
    xla_cpu_prefer_vector_width: builtins.int
    """A `prefer-vector-width` value that is passed to the LLVM backend. Default
    value is `256` (AVX2 on x86 platforms).
    """
    xla_gpu_experimental_autotune_cache_mode: global___DebugOptions.AutotuneCacheMode.ValueType
    """--------------------------------------------------------------------------//
    XLA:GPU options.
    --------------------------------------------------------------------------//
    go/keep-sorted start newline_separated=yes skip_lines=1

    Specifies the behavior of per kernel autotuning cache.
    """
    xla_gpu_experimental_disable_binary_libraries: builtins.bool
    """Experimentally disables binary libraries in GPU compiler passes."""
    xla_gpu_experimental_enable_triton_softmax_priority_fusion: builtins.bool
    """Gates the experimental feature coupling the Triton Softmax pattern matcher
    with priority fusion.
    """
    xla_gpu_unsupported_enable_triton_gemm: builtins.bool
    """Internal debug/testing flag to switch Triton GEMM fusions on or off."""
    xla_hlo_graph_addresses: builtins.bool
    """--------------------------------------------------------------------------//
    A bag of XLA options that have to be categorized.
    --------------------------------------------------------------------------//

    Show addresses of HLO ops in graph dump.
    """
    xla_hlo_profile: builtins.bool
    """Instrument the computation to collect per-HLO cycle counts."""
    xla_disable_all_hlo_passes: builtins.bool
    """Disables all HLO passes.  Notes that some passes are necessary for
    correctness and the invariants that must be satisfied by "fully optimized"
    HLO are different for different devices and may change over time.  The only
    "guarantee", such as it is, is that if you compile XLA and dump the
    optimized HLO for some graph, you should be able to run it again on the
    same device with the same build of XLA.
    """
    xla_backend_optimization_level: builtins.int
    """Numerical optimization level for the XLA compiler backend; the specific
    interpretation of this value is left to the backends.
    """
    xla_embed_ir_in_executable: builtins.bool
    """Embed the compiler IR as a string in the executable."""
    xla_eliminate_hlo_implicit_broadcast: builtins.bool
    """Eliminate implicit broadcasts when lowering user computations to HLO
    instructions; use explicit broadcast instead.
    """
    xla_cpu_multi_thread_eigen: builtins.bool
    """When generating calls to Eigen in the CPU backend, use multi-threaded Eigen
    mode.
    """
    xla_gpu_cuda_data_dir: builtins.str
    """Path to directory with cuda/ptx tools and libraries."""
    xla_gpu_ftz: builtins.bool
    """Enable flush-to-zero semantics in the GPU backend."""
    xla_llvm_enable_alias_scope_metadata: builtins.bool
    """If true, in LLVM-based backends, emit !alias.scope metadata in
    generated IR.
    """
    xla_llvm_enable_noalias_metadata: builtins.bool
    """If true, in LLVM-based backends, emit !noalias metadata in the
    generated IR.
    """
    xla_llvm_enable_invariant_load_metadata: builtins.bool
    """If true, in LLVM-based backends, emit !invariant.load metadata in
    the generated IR.
    """
    xla_llvm_disable_expensive_passes: builtins.bool
    """If true, a set of expensive LLVM optimization passes will not be run."""
    xla_test_all_output_layouts: builtins.bool
    """This is used by ClientLibraryTestBase::ComputeAndCompare*. If true, the
    computation will run n! times with all permunations of layouts for the
    output shape in rank n. For example, with a 3D shape, all permutations of
    the set {0, 1, 2} are tried.
    """
    xla_test_all_input_layouts: builtins.bool
    """This is used by ClientLibraryTestBase::ComputeAndCompare*. If true, the
    computation will run for all permunations of layouts of all input
    arguments. For example, with 2 input arguments in 2D and 4D shapes, the
    computation will run 2! * 4! times.
    """
    xla_hlo_graph_sharding_color: builtins.bool
    """Assign colors based on sharding information when generating the Graphviz
    HLO graph.
    """
    xla_cpu_use_mkl_dnn: builtins.bool
    """Generate calls to MKL-DNN in the CPU backend."""
    xla_gpu_enable_fast_min_max: builtins.bool
    """When true we lower the Minimum and Maximum hlos in the GPU backend such
    that Min(NotNaN, NaN) = Min(NaN, NotNaN) = NotNaN.  In other words, if flag
    this is true we don't propagate NaNs through Min and Max.

    Note, this does not correspond to the exact same behavior as the cpu flag
    above!
    """
    xla_allow_excess_precision: builtins.bool
    """Allows xla to increase the output precision of floating point operations
    and all floating-point conversions to be simplified, including those
    that affect the numerics. The `FloatNormalization` pass inserts many
    `f32 -> bf16 -> f32` conversion pairs. These are not removed by the
    `AlgebraicSimplifier`, as that will only simplify conversions that are
    no-ops, e.g. `bf16 -> f32 -> bf16`. Removing these improves accuracy.
    """
    xla_gpu_crash_on_verification_failures: builtins.bool
    """Crashes the program when any kind of verification fails, instead of just
    logging the failures. One example is cross checking of convolution results
    among different algorithms.
    """
    xla_gpu_autotune_level: builtins.int
    """0:   Disable gemm and convolution autotuning.
    1:   Enable autotuning, but disable correctness checking.
    2:   Also set output buffers to random numbers during autotuning.
    3:   Also reset output buffers to random numbers after autotuning each
         algorithm.
    4+:  Also check for correct outputs and for out-of-bounds reads/writes.

    Default: 4.
    """
    xla_force_host_platform_device_count: builtins.int
    """Force the host platform to pretend that there are these many host
    "devices".  All these devices are backed by the same threadpool.  Defaults
    to 1.

    Setting this to anything other than 1 can increase overhead from context
    switching but we let the user override this behavior to help run tests on
    the host that run models in parallel across multiple devices.
    """
    xla_gpu_disable_gpuasm_optimizations: builtins.bool
    """If set to true XLA:GPU invokes `ptxas` with -O0 (default is -O3)."""
    xla_gpu_shape_checks: global___DebugOptions.ShapeChecks.ValueType
    xla_hlo_evaluator_use_fast_path: builtins.bool
    """Enable fast math with eigen in the HLO evaluator."""
    xla_allow_scalar_index_dynamic_ops: builtins.bool
    """Temporary option to allow support for both the R1 and the scalar index
    versions of DynamicSlice and DynamicUpdateSlice. Only used for testing.
    """
    xla_step_marker_location: global___DebugOptions.StepMarkerLocation.ValueType
    """Option to emit a target-specific marker to indicate the start of a training
    step. The location of the marker (if any) is determined by the option
    value.
    """
    xla_dump_to: builtins.str
    """
    BEGIN flags controlling dumping HLO modules for debugging.

    When dumping is enabled, HLO modules dumped at the very beginning and end
    of compilation, and optionally also during the pass pipeline.

    In general, if you set one of these flags, we will try to infer reasonable
    defaults for the others.  For example:

     * Setting --xla_dump_to=/tmp/foo without specifying a format
       with --xla_dump_hlo_as_* will turn on --xla_dump_hlo_as_text.

     * Setting --xla_dump_hlo_as_text without specifying --xla_dump_to will
       dump to stdout.

    Directory to dump into.
    """
    xla_dump_hlo_module_re: builtins.str
    """If specified, will only dump modules which match this regexp."""
    xla_dump_hlo_pass_re: builtins.str
    """If this flag is specified, will also dump HLO before and after passes that
    match this regular expression.  Set to .* to dump before/after all passes.
    """
    xla_dump_hlo_as_text: builtins.bool
    """Specifies the format that HLO is dumped in.  Multiple of these may be
    specified.
    """
    xla_dump_hlo_as_proto: builtins.bool
    xla_dump_hlo_as_dot: builtins.bool
    xla_dump_hlo_as_url: builtins.bool
    xla_dump_hlo_as_html: builtins.bool
    """Dump HLO graphs as an HTML (DOT -> SVG inlined in HTML)"""
    xla_dump_fusion_visualization: builtins.bool
    """Dump the visualization of the fusion progress."""
    xla_dump_hlo_snapshots: builtins.bool
    """If true, every time an HLO module is run, we will dump an HloSnapshot
    (essentially, a serialized module plus its inputs) to the --xla_dump_to
    directory.
    """
    xla_dump_include_timestamp: builtins.bool
    """Include a timestamp in the dumped filenames."""
    xla_dump_max_hlo_modules: builtins.int
    """Max number of hlo module dumps in a directory. Set to < 0 for unbounded."""
    xla_dump_module_metadata: builtins.bool
    """Dump HloModuleMetadata as a text proto for each HLO module."""
    xla_dump_compress_protos: builtins.bool
    """GZip-compress protos dumped via --xla_dump_hlo_as_proto."""
    xla_dump_hlo_as_long_text: builtins.bool
    """Dump HLO in long text format. Ignored unless xla_dump_hlo_as_text is true."""
    xla_gpu_force_conv_nchw: builtins.bool
    """
    END flags controlling dumping HLO modules.

    Overrides for XLA GPU's convolution layout heuristic.
    """
    xla_gpu_force_conv_nhwc: builtins.bool
    xla_gpu_dump_llvmir: builtins.bool
    """Whether to dump llvm ir when compiling to ptx."""
    xla_dump_enable_mlir_pretty_form: builtins.bool
    """Whether to dump mlir using pretty print form."""
    xla_gpu_algorithm_denylist_path: builtins.str
    """Denylist for cuDNN convolutions."""
    xla_tpu_detect_nan: builtins.bool
    """Debug options that trigger execution errors when NaN or Inf are detected."""
    xla_tpu_detect_inf: builtins.bool
    xla_cpu_enable_xprof_traceme: builtins.bool
    """True if TraceMe annotations are enabled for XLA:CPU."""
    xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found: builtins.bool
    """It is usually preferable to not fallback to the driver; it can consume more
    memory, or have bugs.
    """
    xla_gpu_asm_extra_flags: builtins.str
    """Extra parameters to pass the GPU assembler."""
    xla_multiheap_size_constraint_per_heap: builtins.int
    """Per-heap size constraint. New heaps will be created if per-heap max size is
    reached.
    """
    xla_detailed_logging: builtins.bool
    """Enable detailed logging into vlog. If this is disabled, no
    compilation summary will be printed in the end of computation.
    """
    xla_enable_dumping: builtins.bool
    """Enable HLO dumping. If this is disabled, no HLO modules will be dumped."""
    xla_gpu_force_compilation_parallelism: builtins.int
    """Overrides normal multi-threaded compilation setting to use this many
    threads. Setting to 0 (the default value) means no enforcement.
    """
    xla_gpu_enable_llvm_module_compilation_parallelism: builtins.bool
    xla_gpu_deterministic_ops: builtins.bool
    """Guarantees run-to-run determinism.
    This flag implies --xla_gpu_exclude_nondeterministic_ops and in addition
    disables autotuning.
    """
    xla_gpu_all_reduce_combine_threshold_bytes: builtins.int
    """Size threshold (in bytes) for the GPU collective combiners."""
    xla_gpu_all_gather_combine_threshold_bytes: builtins.int
    xla_gpu_reduce_scatter_combine_threshold_bytes: builtins.int
    xla_gpu_enable_all_gather_combine_by_dim: builtins.bool
    """Combine all-gather/scatter-reduce ops with the same dimension or
    irrespective of their dimension.
    """
    xla_gpu_enable_reduce_scatter_combine_by_dim: builtins.bool
    xla_gpu_enable_reassociation_for_converted_ar: builtins.bool
    """Enable allreduce reassociation on allreduces that are converted to a wider
    type. The resulting allreduce will be promoted to a wider-typed allreduce.
    """
    xla_gpu_all_reduce_blueconnect_num_devices_per_host: builtins.int
    """Number of devices per host for first stage of BlueConnect decomposition
    pass. The pass will attempt to decompose all-reduces ops into a
    ReduceScatter-AllReduce-AllGather sequence, with the initial ReduceScatter
    being performed over all of the devices in the same host. Set to < 1 to
    disable all-reduce decomposition.
    """
    xla_gpu_enable_while_loop_reduce_scatter_code_motion: builtins.bool
    """Enable hoisting of reduce-scatter out of while loops."""
    xla_gpu_collective_inflation_factor: builtins.int
    """Inflate collective cost by running each collective multiple times."""
    xla_llvm_force_inline_before_split: builtins.bool
    """Whether to force inline before llvm module split to get a more balanced
    splits for parallel compilation.
    """
    xla_gpu_enable_cudnn_frontend: builtins.bool
    """Whether to use the cuDNN frontend API for convolutions when possible."""
    xla_gpu_enable_cudnn_fmha: builtins.bool
    xla_gpu_fused_attention_use_cudnn_rng: builtins.bool
    xla_gpu_enable_cudnn_layer_norm: builtins.bool
    """Rewrite layer norm patterns into cuDNN library calls."""
    xla_dump_disable_metadata: builtins.bool
    """Disable dumping metadata in HLO dumps."""
    xla_dump_hlo_pipeline_re: builtins.str
    """If this flag is specified, will only dump HLO before and after passes in
    the pass pipeline that matches this regular expression. Default empty value
    enables dumping in all pipelines.
    """
    xla_gpu_strict_conv_algorithm_picker: builtins.bool
    """If true, abort immediately when conv algorithm picker fails, rather than
    logging a warning and proceeding with fallback.
    """
    xla_gpu_enable_custom_fusions: builtins.bool
    """If true, XLA will try to pattern match subgraphs of HLO operations into
    custom fusions registered in the current process (pre-compiled hand written
    kernels, e.g. various GEMM fusions writtent in CUTLASS).
    """
    xla_gpu_enable_custom_fusions_re: builtins.str
    """A regular expression enabling only a subset of custom fusions. Enabled only
    if `xla_gpu_enable_custom_fusion` set to true.
    """
    xla_gpu_enable_dynamic_slice_fusion: builtins.bool
    """Enables address computation fusion to optimize dynamic-slice and
    dynamic-update-slice operations around library calls.
    """
    xla_gpu_nccl_termination_timeout_seconds: builtins.int
    """Timeout in seconds before terminating jobs that are stuck in a NCCL
    Rendezvous. Negative value disables the timeout and will not terminate.
    """
    xla_gpu_enable_shared_constants: builtins.bool
    """Enables shared constants for XLA/GPU. This allows large constants to be
    shared among multiple GPU executables.
    """
    xla_gpu_enable_cublaslt: builtins.bool
    """Whether to use cuBLASLt for GEMMs on GPUs."""
    xla_gpu_graph_min_graph_size: builtins.int
    """This number determines how many moved instructions like fusion kernels are
    required for a region to be captured as a function to be launched as a GPU
    graph.
    """
    xla_gpu_graph_enable_concurrent_region: builtins.bool
    """Identify concurrent regions in GPU graphs and execute them concurrently."""
    xla_gpu_redzone_scratch_max_megabytes: builtins.int
    """Size threshold (in megabytes) for the GPU redzone scratch allocator."""
    xla_gpu_redzone_padding_bytes: builtins.int
    """Amount of padding the redzone allocator will put on one side of each buffer
    it allocates.  (So the buffer's total size will be increased by 2x this
    value.)

    Higher values make it more likely that we'll catch an out-of-bounds read or
    write.  Smaller values consume less memory during autotuning.  Note that a
    fused cudnn conv has up to 6 total buffers (4 inputs, 1 output, and 1
    scratch), so this can be multiplied by quite a lot.
    """
    xla_cpu_use_acl: builtins.bool
    """Generate calls to Arm Compute Library in the CPU backend."""
    xla_cpu_strict_dot_conv_math: builtins.bool
    """By default, XLA:CPU will run fp16 dot/conv as fp32, as this is generally
    (much) faster on our hardware.  Set this flag to disable this behavior.
    """
    xla_gpu_use_runtime_fusion: builtins.bool
    """An option to enable using cuDNN runtime compiled fusion kernels which is
    available and recommended for Ampere+ GPUs.
    """
    xla_dump_latency_hiding_schedule: builtins.bool
    xla_cpu_enable_mlir_tiling_and_fusion: builtins.bool
    """By default, MLIR lowering will use Linalg elementwise fusion. If this flag
    is enabled, the pipeline will use tiling, fusion, peeling, vectorization
    instead.
    """
    xla_cpu_enable_custom_matmul_tiling: builtins.bool
    """XLA:CPU-Next tiling parameters for matmul."""
    xla_cpu_matmul_tiling_m_dim: builtins.int
    xla_cpu_matmul_tiling_n_dim: builtins.int
    xla_cpu_matmul_tiling_k_dim: builtins.int
    xla_cpu_enable_mlir_fusion_outlining: builtins.bool
    xla_cpu_enable_experimental_deallocation: builtins.bool
    """If set, use the experimental deallocation pass from mlir-hlo."""
    xla_gpu_enable_latency_hiding_scheduler: builtins.bool
    xla_gpu_enable_highest_priority_async_stream: builtins.bool
    xla_gpu_enable_analytical_latency_estimator: builtins.bool
    xla_gpu_lhs_enable_gpu_async_tracker: builtins.bool
    xla_gpu_pgle_profile_file_or_directory_path: builtins.str
    xla_gpu_memory_limit_slop_factor: builtins.int
    xla_gpu_enable_pipelined_collectives: builtins.bool
    xla_gpu_enable_pipelined_all_reduce: builtins.bool
    xla_gpu_enable_pipelined_all_gather: builtins.bool
    xla_gpu_enable_pipelined_reduce_scatter: builtins.bool
    xla_gpu_enable_pipelined_p2p: builtins.bool
    xla_gpu_run_post_layout_collective_pipeliner: builtins.bool
    xla_gpu_collective_permute_decomposer_threshold: builtins.int
    """The minimum data size in bytes to trigger collective-permute-decomposer
    transformation.
    """
    xla_partitioning_algorithm: global___DebugOptions.PartitioningAlgorithm.ValueType
    """The partitioning algorithm to be used in the PartitionAssignment pass."""
    xla_gpu_enable_triton_gemm: builtins.bool
    xla_gpu_enable_cudnn_int8x32_convolution_reordering: builtins.bool
    xla_gpu_triton_gemm_any: builtins.bool
    """Creates triton fusion for all supported gemms.
    To make sure only triton gemm is chosen by the autotuner run with
    `xla_gpu_cublas_fallback` set to false.
    """
    xla_gpu_exhaustive_tiling_search: builtins.bool
    xla_gpu_enable_priority_fusion: builtins.bool
    xla_gpu_dump_autotune_results_to: builtins.str
    """File to write autotune results to. It will be a binary file unless the name
    ends with .txt or .textproto. Warning: The results are written at every
    compilation, possibly multiple times per process. This only works on CUDA.
    """
    xla_gpu_load_autotune_results_from: builtins.str
    """File to load autotune results from. It will be considered a binary file
    unless the name ends with .txt or .textproto. At most one loading will
    happen during the lifetime of one process, even if the first one is
    unsuccessful or different file paths are passed here. This only works on
    CUDA.
    """
    xla_gpu_target_config_filename: builtins.str
    """Description of the target platform in GpuTargetConfigProto format; if
    provided, deviceless compilation is assumed, and the current device is
    ignored.
    """
    xla_gpu_auto_spmd_partitioning_memory_budget_gb: builtins.int
    """Memory budget in GB per device for AutoSharding."""
    xla_gpu_auto_spmd_partitioning_memory_budget_ratio: builtins.float
    """See the definition of the
    xla_gpu_auto_spmd_partitioning_memory_budget_ratio flag for the meaning of
    this field.
    """
    xla_gpu_triton_gemm_disable_reduced_precision_reduction: builtins.bool
    xla_gpu_triton_fusion_level: builtins.int
    xla_gpu_dump_autotuned_gemm_fusions: builtins.bool
    xla_gpu_override_gemm_autotuner: builtins.str
    xla_gpu_copy_insertion_use_region_analysis: builtins.bool
    xla_gpu_collect_cost_model_stats: builtins.bool
    """If true, each fusion instruction will have a cost model runtime estimate in
    backend config after compilation.
    """
    xla_gpu_enable_split_k_autotuning: builtins.bool
    xla_gpu_enable_reduction_epilogue_fusion: builtins.bool
    """Whether reduction epilogue fusion is enabled in fusion passes."""
    xla_gpu_enable_nccl_clique_optimization: builtins.bool
    """Allow early return when acquiring NCCL cliques."""
    xla_gpu_mock_custom_calls: builtins.bool
    """Replace custom calls with noop operations."""
    xla_gpu_cublas_fallback: builtins.bool
    """Allow Triton GEMM autotuning to fall back to cuBLAS when that is
    faster.
    """
    xla_gpu_enable_while_loop_double_buffering: builtins.bool
    """Enable double buffering for loops."""
    xla_gpu_enable_while_loop_unrolling: global___DebugOptions.WhileLoopUnrolling.ValueType
    """Determine the while loop unrolling scheme."""
    xla_gpu_ensure_minor_dot_contraction_dims: builtins.bool
    """Change the layout of the second triton dot operand to be column major.
    Only works for (bf16 x bf16) -> bf16.
    """
    xla_gpu_filter_kernels_spilling_registers_on_autotuning: builtins.bool
    """Filter out kernels that spill registers during autotuning."""
    xla_debug_buffer_assignment_show_max: builtins.int
    """Maximum number of buffers to print when debugging buffer assignment."""
    xla_gpu_llvm_verification_level: builtins.int
    xla_gpu_enable_cub_radix_sort: builtins.bool
    """Enable radix sort using CUB."""
    xla_gpu_threshold_for_windowed_einsum_mib: builtins.int
    """Threshold to enable windowed einsum (collective matmul) in MB."""
    xla_gpu_enable_triton_hopper: builtins.bool
    """Enables currently disabled features within Triton for Hopper."""
    xla_gpu_enable_nccl_user_buffers: builtins.bool
    """Enable NCCL user buffers."""
    xla_gpu_enable_nccl_comm_splitting: builtins.bool
    """Enable NCCL communicator splitting."""
    xla_gpu_enable_nccl_per_stream_comms: builtins.bool
    """Enable NCCL per stream communicators."""
    xla_gpu_enable_libnvptxcompiler: builtins.bool
    """If enabled, uses the libnvptxcompiler library to compile PTX to cuBIN."""
    xla_gpu_enable_dot_strength_reduction: builtins.bool
    xla_gpu_multi_streamed_windowed_einsum: builtins.bool
    """Whether to use multiple compute streams to run windowed einsum."""
    xla_gpu_enable_bf16_6way_gemm: builtins.bool
    """If enabled, uses bf16_6way gemm to compute F32 gemm."""
    xla_gpu_enable_bf16_3way_gemm: builtins.bool
    """If enabled, uses bf16_3way gemm to compute F32 gemm."""
    xla_gpu_nccl_collective_max_nchannels: builtins.int
    """Specify the maximum number of channels(SMs) NCCL
    will use for collective operations.
    """
    xla_gpu_nccl_p2p_max_nchannels: builtins.int
    """Specify the maximum number of channels(SMs) NCCL
    will use for p2p operations.
    """
    xla_gpu_mlir_emitter_level: builtins.int
    """Choose the level of mlir emitters that are enabled.
    Current levels:
    0: Disabled.
    1: Loop emitter
    2: + Loop-like emitters
    3: + Transpose
    4: + Reduce
    """
    xla_gpu_gemm_rewrite_size_threshold: builtins.int
    """Threshold to rewrite matmul to cuBLAS or Triton (minimum combined number of
    elements of both matrices in non-batch dimensions to be considered for a
    rewrite).
    """
    xla_gpu_require_complete_aot_autotune_results: builtins.bool
    """If true, will require complete AOT autotuning results; in the case of
    missing AOT result, the model will not be compiled or executed, a
    `NotFound` error will be returned.
    """
    xla_gpu_cudnn_gemm_fusion_level: builtins.int
    """Let GEMM fusion autotuning probe cuDNN as a backend.
    Current levels:
    0: Disabled.
    1: Fusions of GEMM, elementwise, transpose/reshape operations.
    2: + Broadcasts, slicing.
    3: + Nontrivial noncontracting dimension reshapes/transposes.
    """
    xla_gpu_use_memcpy_local_p2p: builtins.bool
    """This instructs the runtime whether to use
    memcpy for p2p communication when source and
    target are located within a node(nvlink).
    """
    xla_gpu_autotune_max_solutions: builtins.int
    """If non-zero, limits the number of solutions to be used by GEMM autotuner.
    This might be useful if underlying math library returns too many GEMM
    solutions.
    """
    xla_dump_large_constants: builtins.bool
    """If true, large constants will be printed out when dumping HLOs."""
    xla_gpu_verify_triton_fusion_numerics: builtins.bool
    """If true, will verify that the numerical results of Triton fusions match
    the results of regular emitters.
    """
    xla_gpu_dump_autotune_logs_to: builtins.str
    """File to write autotune logs to. It will stored in txt format."""
    xla_reduce_window_rewrite_base_length: builtins.int
    """Base length to rewrite the reduce window to, no rewrite if set to 0."""
    xla_gpu_enable_host_memory_offloading: builtins.bool
    """If true, will enable host memory offloading on a device."""
    xla_gpu_exclude_nondeterministic_ops: builtins.bool
    """Excludes non-deterministic ops from compiled executables.
    Unlike --xla_gpu_deterministic_ops does not disable autotuning - the
    compilation itself can be non-deterministic.
    At present, the HLO op SelectAndScatter does not have a
    deterministic XLA:GPU implementation.
    Compilation errors out if SelectAndScatter is encountered.
    Scatter ops can non-deterministic by default; these get converted to
    a deterministic implementation.
    """
    xla_gpu_nccl_terminate_on_error: builtins.bool
    """If true, Nccl errors will terminate the process."""
    xla_gpu_shard_autotuning: builtins.bool
    xla_gpu_enable_approx_costly_collectives: builtins.bool
    xla_gpu_kernel_cache_file: builtins.str
    xla_gpu_unsafe_pipelined_loop_annotator: builtins.bool
    """Recognises rotate-right patterns (slice, slice, concat) within a while
    loop and labels the while loop as a pipelined while loop. This is an
    unsafe flag.
    """
    xla_gpu_per_fusion_autotune_cache_dir: builtins.str
    xla_cmd_buffer_trace_cache_size: builtins.int
    """The command buffer trace cache size, increasing the cache size may
    sometimes reduces the chances of doing command buffer tracing for
    updating command buffer instance.
    """
    xla_gpu_temp_buffer_use_separate_color: builtins.bool
    """Enable this flag will use a separate memory space color for
    temp buffer, and then will use separate memory allocator to allocate it,
    as there is no other memory allocation interference,
    it will allocate temp buffer to some fix address on every iteration,
    which is good for cuda-graph perf.
    """
    xla_syntax_sugar_async_ops: builtins.bool
    """This flag is used for controlling HLO dumping and NVTX marker. If turned
    on, both HLO dumping and NVTX marker will use syntactic sugar wrappers
    as op names, while the actual op names will be shown if turned off.

    Here is an example HLO excerpt with the flag off:

      async_computation {
       param_0 = f32[1,4,8]{1,0,2} parameter(0)
       ROOT all-to-all.3.1 = f32[1,4,8]{1,0,2} all-to-all(param_0),
                             replica_groups={{0,1,2,3,4,5,6,7}}, dimensions={2}
      }
     ...

     all-to-all-start =
       ((f32[1,4,8]{1,0,2}), f32[1,4,8]{1,0,2}) async-start(bitcast.24.0),
       calls=async_computation, backend_config={...}
     all-to-all-done = f32[1,4,8]{1,0,2} async-done(all-to-all-start)

    and with the flag on:

     all-to-all-start = ((f32[1,4,8]{1,0,2}), f32[1,4,8]{1,0,2})
                        all-to-all-start(bitcast.24.0),
                        replica_groups={{0,1,2,3,4,5,6,7}}, dimensions={2},
                        backend_config={...}
     all-to-all-done = f32[1,4,8]{1,0,2} all-to-all-done(all-to-all-start)
    """
    xla_gpu_autotune_gemm_rtol: builtins.float
    """Relative precision for comparing different GEMM solutions"""
    xla_enable_command_buffers_during_profiling: builtins.bool
    """Allow launching command buffers while profiling active.
    When disabled, execute in op-by-op mode.
    TODO(b/355487968): Remove this option when validation complete.
    """
    xla_gpu_cudnn_gemm_max_plans: builtins.int
    """Limit for the number of kernel configurations (plans) to use during
    autotuning of cuDNN GEMM fusions. The more - the slower the autotuning
    but potentially higher the performance.
    """
    xla_gpu_enable_libnvjitlink: builtins.bool
    """If enabled, uses the libnvjitlink library for PTX compilation and linking"""
    xla_gpu_enable_triton_gemm_int4: builtins.bool
    """If enabled, generates triton gemm kernels for int4 inputs."""
    xla_gpu_async_dot: builtins.bool
    """If true, XLA will wrap `dot` operations into async computations in an
    effort to parallelize matrix operations.
    """
    xla_gpu_enable_pgle_accuracy_checker: builtins.bool
    """Enables strict PGLE checking. If an FDO profile is specified and latency
    hiding scheduler encounters missing instructions in the profile
    compilation will halt.
    """
    xla_gpu_executable_warn_stuck_timeout_seconds: builtins.int
    """Timeouts for RendezvousSingle stuck warning and termination."""
    xla_gpu_executable_terminate_timeout_seconds: builtins.int
    xla_experimental_ignore_channel_id: builtins.bool
    """Whether to ignore channel ids(including verifier channel id checks)
    for collectives in the given HLO.
    """
    @property
    def xla_disable_hlo_passes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of HLO passes to disable/enable. These names must exactly match the
        pass names as specified by the HloPassInterface::name() method.

        At least one of xla_disable_hlo_passes and xla_enable_hlo_passes_only must
        be empty.
        """

    @property
    def xla_enable_hlo_passes_only(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def xla_gpu_ptx_file(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Paths to files with ptx code."""

    @property
    def xla_gpu_llvm_ir_file(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Paths to files with LLVM code."""

    @property
    def xla_gpu_disable_async_collectives(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___DebugOptions.CollectiveOpType.ValueType]: ...
    @property
    def xla_gpu_enable_command_buffer(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___DebugOptions.CommandBufferCmdType.ValueType]:
        """Determine the types of commands that are recorded into command buffers."""

    @property
    def legacy_command_buffer_custom_call_targets(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Custom call targets with legacy registry API (non FFI API),
        that support recording to command buffer custom command,
        i.e., custom call target supports cuda-graph capturing for CUDA devices.
        This flag is read if CUSTOM_CALL command type is recorded into
        command buffer.
        """

    @property
    def xla_backend_extra_options(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Next id: 331

        Extra options to pass to the compilation backend (e.g. LLVM); specific
        interpretation of these values is left to the backend.
        """

    def __init__(
        self,
        *,
        xla_cpu_enable_concurrency_optimized_scheduler: builtins.bool | None = ...,
        xla_cpu_enable_fast_math: builtins.bool | None = ...,
        xla_cpu_enable_fast_min_max: builtins.bool | None = ...,
        xla_cpu_fast_math_honor_division: builtins.bool | None = ...,
        xla_cpu_fast_math_honor_functions: builtins.bool | None = ...,
        xla_cpu_fast_math_honor_infs: builtins.bool | None = ...,
        xla_cpu_fast_math_honor_nans: builtins.bool | None = ...,
        xla_cpu_use_thunk_runtime: builtins.bool | None = ...,
        xla_cpu_parallel_codegen_split_count: builtins.int | None = ...,
        xla_cpu_prefer_vector_width: builtins.int | None = ...,
        xla_gpu_experimental_autotune_cache_mode: global___DebugOptions.AutotuneCacheMode.ValueType | None = ...,
        xla_gpu_experimental_disable_binary_libraries: builtins.bool | None = ...,
        xla_gpu_experimental_enable_triton_softmax_priority_fusion: builtins.bool | None = ...,
        xla_gpu_unsupported_enable_triton_gemm: builtins.bool | None = ...,
        xla_hlo_graph_addresses: builtins.bool | None = ...,
        xla_hlo_profile: builtins.bool | None = ...,
        xla_disable_hlo_passes: collections.abc.Iterable[builtins.str] | None = ...,
        xla_enable_hlo_passes_only: collections.abc.Iterable[builtins.str] | None = ...,
        xla_disable_all_hlo_passes: builtins.bool | None = ...,
        xla_backend_optimization_level: builtins.int | None = ...,
        xla_embed_ir_in_executable: builtins.bool | None = ...,
        xla_eliminate_hlo_implicit_broadcast: builtins.bool | None = ...,
        xla_cpu_multi_thread_eigen: builtins.bool | None = ...,
        xla_gpu_cuda_data_dir: builtins.str | None = ...,
        xla_gpu_ftz: builtins.bool | None = ...,
        xla_llvm_enable_alias_scope_metadata: builtins.bool | None = ...,
        xla_llvm_enable_noalias_metadata: builtins.bool | None = ...,
        xla_llvm_enable_invariant_load_metadata: builtins.bool | None = ...,
        xla_llvm_disable_expensive_passes: builtins.bool | None = ...,
        xla_test_all_output_layouts: builtins.bool | None = ...,
        xla_test_all_input_layouts: builtins.bool | None = ...,
        xla_hlo_graph_sharding_color: builtins.bool | None = ...,
        xla_cpu_use_mkl_dnn: builtins.bool | None = ...,
        xla_gpu_enable_fast_min_max: builtins.bool | None = ...,
        xla_allow_excess_precision: builtins.bool | None = ...,
        xla_gpu_crash_on_verification_failures: builtins.bool | None = ...,
        xla_gpu_autotune_level: builtins.int | None = ...,
        xla_force_host_platform_device_count: builtins.int | None = ...,
        xla_gpu_disable_gpuasm_optimizations: builtins.bool | None = ...,
        xla_gpu_shape_checks: global___DebugOptions.ShapeChecks.ValueType | None = ...,
        xla_hlo_evaluator_use_fast_path: builtins.bool | None = ...,
        xla_allow_scalar_index_dynamic_ops: builtins.bool | None = ...,
        xla_step_marker_location: global___DebugOptions.StepMarkerLocation.ValueType | None = ...,
        xla_dump_to: builtins.str | None = ...,
        xla_dump_hlo_module_re: builtins.str | None = ...,
        xla_dump_hlo_pass_re: builtins.str | None = ...,
        xla_dump_hlo_as_text: builtins.bool | None = ...,
        xla_dump_hlo_as_proto: builtins.bool | None = ...,
        xla_dump_hlo_as_dot: builtins.bool | None = ...,
        xla_dump_hlo_as_url: builtins.bool | None = ...,
        xla_dump_hlo_as_html: builtins.bool | None = ...,
        xla_dump_fusion_visualization: builtins.bool | None = ...,
        xla_dump_hlo_snapshots: builtins.bool | None = ...,
        xla_dump_include_timestamp: builtins.bool | None = ...,
        xla_dump_max_hlo_modules: builtins.int | None = ...,
        xla_dump_module_metadata: builtins.bool | None = ...,
        xla_dump_compress_protos: builtins.bool | None = ...,
        xla_dump_hlo_as_long_text: builtins.bool | None = ...,
        xla_gpu_force_conv_nchw: builtins.bool | None = ...,
        xla_gpu_force_conv_nhwc: builtins.bool | None = ...,
        xla_gpu_ptx_file: collections.abc.Iterable[builtins.str] | None = ...,
        xla_gpu_dump_llvmir: builtins.bool | None = ...,
        xla_dump_enable_mlir_pretty_form: builtins.bool | None = ...,
        xla_gpu_algorithm_denylist_path: builtins.str | None = ...,
        xla_tpu_detect_nan: builtins.bool | None = ...,
        xla_tpu_detect_inf: builtins.bool | None = ...,
        xla_cpu_enable_xprof_traceme: builtins.bool | None = ...,
        xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found: builtins.bool | None = ...,
        xla_gpu_asm_extra_flags: builtins.str | None = ...,
        xla_multiheap_size_constraint_per_heap: builtins.int | None = ...,
        xla_detailed_logging: builtins.bool | None = ...,
        xla_enable_dumping: builtins.bool | None = ...,
        xla_gpu_force_compilation_parallelism: builtins.int | None = ...,
        xla_gpu_enable_llvm_module_compilation_parallelism: builtins.bool | None = ...,
        xla_gpu_deterministic_ops: builtins.bool | None = ...,
        xla_gpu_llvm_ir_file: collections.abc.Iterable[builtins.str] | None = ...,
        xla_gpu_disable_async_collectives: collections.abc.Iterable[global___DebugOptions.CollectiveOpType.ValueType] | None = ...,
        xla_gpu_all_reduce_combine_threshold_bytes: builtins.int | None = ...,
        xla_gpu_all_gather_combine_threshold_bytes: builtins.int | None = ...,
        xla_gpu_reduce_scatter_combine_threshold_bytes: builtins.int | None = ...,
        xla_gpu_enable_all_gather_combine_by_dim: builtins.bool | None = ...,
        xla_gpu_enable_reduce_scatter_combine_by_dim: builtins.bool | None = ...,
        xla_gpu_enable_reassociation_for_converted_ar: builtins.bool | None = ...,
        xla_gpu_all_reduce_blueconnect_num_devices_per_host: builtins.int | None = ...,
        xla_gpu_enable_while_loop_reduce_scatter_code_motion: builtins.bool | None = ...,
        xla_gpu_collective_inflation_factor: builtins.int | None = ...,
        xla_llvm_force_inline_before_split: builtins.bool | None = ...,
        xla_gpu_enable_cudnn_frontend: builtins.bool | None = ...,
        xla_gpu_enable_cudnn_fmha: builtins.bool | None = ...,
        xla_gpu_fused_attention_use_cudnn_rng: builtins.bool | None = ...,
        xla_gpu_enable_cudnn_layer_norm: builtins.bool | None = ...,
        xla_dump_disable_metadata: builtins.bool | None = ...,
        xla_dump_hlo_pipeline_re: builtins.str | None = ...,
        xla_gpu_strict_conv_algorithm_picker: builtins.bool | None = ...,
        xla_gpu_enable_custom_fusions: builtins.bool | None = ...,
        xla_gpu_enable_custom_fusions_re: builtins.str | None = ...,
        xla_gpu_enable_dynamic_slice_fusion: builtins.bool | None = ...,
        xla_gpu_nccl_termination_timeout_seconds: builtins.int | None = ...,
        xla_gpu_enable_shared_constants: builtins.bool | None = ...,
        xla_gpu_enable_cublaslt: builtins.bool | None = ...,
        xla_gpu_enable_command_buffer: collections.abc.Iterable[global___DebugOptions.CommandBufferCmdType.ValueType] | None = ...,
        xla_gpu_graph_min_graph_size: builtins.int | None = ...,
        xla_gpu_graph_enable_concurrent_region: builtins.bool | None = ...,
        xla_gpu_redzone_scratch_max_megabytes: builtins.int | None = ...,
        xla_gpu_redzone_padding_bytes: builtins.int | None = ...,
        xla_cpu_use_acl: builtins.bool | None = ...,
        xla_cpu_strict_dot_conv_math: builtins.bool | None = ...,
        xla_gpu_use_runtime_fusion: builtins.bool | None = ...,
        xla_dump_latency_hiding_schedule: builtins.bool | None = ...,
        xla_cpu_enable_mlir_tiling_and_fusion: builtins.bool | None = ...,
        xla_cpu_enable_custom_matmul_tiling: builtins.bool | None = ...,
        xla_cpu_matmul_tiling_m_dim: builtins.int | None = ...,
        xla_cpu_matmul_tiling_n_dim: builtins.int | None = ...,
        xla_cpu_matmul_tiling_k_dim: builtins.int | None = ...,
        xla_cpu_enable_mlir_fusion_outlining: builtins.bool | None = ...,
        xla_cpu_enable_experimental_deallocation: builtins.bool | None = ...,
        xla_gpu_enable_latency_hiding_scheduler: builtins.bool | None = ...,
        xla_gpu_enable_highest_priority_async_stream: builtins.bool | None = ...,
        xla_gpu_enable_analytical_latency_estimator: builtins.bool | None = ...,
        xla_gpu_lhs_enable_gpu_async_tracker: builtins.bool | None = ...,
        xla_gpu_pgle_profile_file_or_directory_path: builtins.str | None = ...,
        xla_gpu_memory_limit_slop_factor: builtins.int | None = ...,
        xla_gpu_enable_pipelined_collectives: builtins.bool | None = ...,
        xla_gpu_enable_pipelined_all_reduce: builtins.bool | None = ...,
        xla_gpu_enable_pipelined_all_gather: builtins.bool | None = ...,
        xla_gpu_enable_pipelined_reduce_scatter: builtins.bool | None = ...,
        xla_gpu_enable_pipelined_p2p: builtins.bool | None = ...,
        xla_gpu_run_post_layout_collective_pipeliner: builtins.bool | None = ...,
        xla_gpu_collective_permute_decomposer_threshold: builtins.int | None = ...,
        xla_partitioning_algorithm: global___DebugOptions.PartitioningAlgorithm.ValueType | None = ...,
        xla_gpu_enable_triton_gemm: builtins.bool | None = ...,
        xla_gpu_enable_cudnn_int8x32_convolution_reordering: builtins.bool | None = ...,
        xla_gpu_triton_gemm_any: builtins.bool | None = ...,
        xla_gpu_exhaustive_tiling_search: builtins.bool | None = ...,
        xla_gpu_enable_priority_fusion: builtins.bool | None = ...,
        xla_gpu_dump_autotune_results_to: builtins.str | None = ...,
        xla_gpu_load_autotune_results_from: builtins.str | None = ...,
        xla_gpu_target_config_filename: builtins.str | None = ...,
        xla_gpu_auto_spmd_partitioning_memory_budget_gb: builtins.int | None = ...,
        xla_gpu_auto_spmd_partitioning_memory_budget_ratio: builtins.float | None = ...,
        xla_gpu_triton_gemm_disable_reduced_precision_reduction: builtins.bool | None = ...,
        xla_gpu_triton_fusion_level: builtins.int | None = ...,
        xla_gpu_dump_autotuned_gemm_fusions: builtins.bool | None = ...,
        xla_gpu_override_gemm_autotuner: builtins.str | None = ...,
        xla_gpu_copy_insertion_use_region_analysis: builtins.bool | None = ...,
        xla_gpu_collect_cost_model_stats: builtins.bool | None = ...,
        xla_gpu_enable_split_k_autotuning: builtins.bool | None = ...,
        xla_gpu_enable_reduction_epilogue_fusion: builtins.bool | None = ...,
        xla_gpu_enable_nccl_clique_optimization: builtins.bool | None = ...,
        xla_gpu_mock_custom_calls: builtins.bool | None = ...,
        xla_gpu_cublas_fallback: builtins.bool | None = ...,
        xla_gpu_enable_while_loop_double_buffering: builtins.bool | None = ...,
        xla_gpu_enable_while_loop_unrolling: global___DebugOptions.WhileLoopUnrolling.ValueType | None = ...,
        xla_gpu_ensure_minor_dot_contraction_dims: builtins.bool | None = ...,
        xla_gpu_filter_kernels_spilling_registers_on_autotuning: builtins.bool | None = ...,
        xla_debug_buffer_assignment_show_max: builtins.int | None = ...,
        xla_gpu_llvm_verification_level: builtins.int | None = ...,
        xla_gpu_enable_cub_radix_sort: builtins.bool | None = ...,
        xla_gpu_threshold_for_windowed_einsum_mib: builtins.int | None = ...,
        xla_gpu_enable_triton_hopper: builtins.bool | None = ...,
        xla_gpu_enable_nccl_user_buffers: builtins.bool | None = ...,
        xla_gpu_enable_nccl_comm_splitting: builtins.bool | None = ...,
        xla_gpu_enable_nccl_per_stream_comms: builtins.bool | None = ...,
        xla_gpu_enable_libnvptxcompiler: builtins.bool | None = ...,
        xla_gpu_enable_dot_strength_reduction: builtins.bool | None = ...,
        xla_gpu_multi_streamed_windowed_einsum: builtins.bool | None = ...,
        xla_gpu_enable_bf16_6way_gemm: builtins.bool | None = ...,
        xla_gpu_enable_bf16_3way_gemm: builtins.bool | None = ...,
        xla_gpu_nccl_collective_max_nchannels: builtins.int | None = ...,
        xla_gpu_nccl_p2p_max_nchannels: builtins.int | None = ...,
        xla_gpu_mlir_emitter_level: builtins.int | None = ...,
        xla_gpu_gemm_rewrite_size_threshold: builtins.int | None = ...,
        xla_gpu_require_complete_aot_autotune_results: builtins.bool | None = ...,
        xla_gpu_cudnn_gemm_fusion_level: builtins.int | None = ...,
        xla_gpu_use_memcpy_local_p2p: builtins.bool | None = ...,
        xla_gpu_autotune_max_solutions: builtins.int | None = ...,
        xla_dump_large_constants: builtins.bool | None = ...,
        xla_gpu_verify_triton_fusion_numerics: builtins.bool | None = ...,
        xla_gpu_dump_autotune_logs_to: builtins.str | None = ...,
        xla_reduce_window_rewrite_base_length: builtins.int | None = ...,
        xla_gpu_enable_host_memory_offloading: builtins.bool | None = ...,
        xla_gpu_exclude_nondeterministic_ops: builtins.bool | None = ...,
        xla_gpu_nccl_terminate_on_error: builtins.bool | None = ...,
        xla_gpu_shard_autotuning: builtins.bool | None = ...,
        xla_gpu_enable_approx_costly_collectives: builtins.bool | None = ...,
        xla_gpu_kernel_cache_file: builtins.str | None = ...,
        xla_gpu_unsafe_pipelined_loop_annotator: builtins.bool | None = ...,
        xla_gpu_per_fusion_autotune_cache_dir: builtins.str | None = ...,
        xla_cmd_buffer_trace_cache_size: builtins.int | None = ...,
        xla_gpu_temp_buffer_use_separate_color: builtins.bool | None = ...,
        legacy_command_buffer_custom_call_targets: collections.abc.Iterable[builtins.str] | None = ...,
        xla_syntax_sugar_async_ops: builtins.bool | None = ...,
        xla_gpu_autotune_gemm_rtol: builtins.float | None = ...,
        xla_enable_command_buffers_during_profiling: builtins.bool | None = ...,
        xla_gpu_cudnn_gemm_max_plans: builtins.int | None = ...,
        xla_gpu_enable_libnvjitlink: builtins.bool | None = ...,
        xla_gpu_enable_triton_gemm_int4: builtins.bool | None = ...,
        xla_gpu_async_dot: builtins.bool | None = ...,
        xla_gpu_enable_pgle_accuracy_checker: builtins.bool | None = ...,
        xla_gpu_executable_warn_stuck_timeout_seconds: builtins.int | None = ...,
        xla_gpu_executable_terminate_timeout_seconds: builtins.int | None = ...,
        xla_experimental_ignore_channel_id: builtins.bool | None = ...,
        xla_backend_extra_options: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["legacy_command_buffer_custom_call_targets", b"legacy_command_buffer_custom_call_targets", "xla_allow_excess_precision", b"xla_allow_excess_precision", "xla_allow_scalar_index_dynamic_ops", b"xla_allow_scalar_index_dynamic_ops", "xla_backend_extra_options", b"xla_backend_extra_options", "xla_backend_optimization_level", b"xla_backend_optimization_level", "xla_cmd_buffer_trace_cache_size", b"xla_cmd_buffer_trace_cache_size", "xla_cpu_enable_concurrency_optimized_scheduler", b"xla_cpu_enable_concurrency_optimized_scheduler", "xla_cpu_enable_custom_matmul_tiling", b"xla_cpu_enable_custom_matmul_tiling", "xla_cpu_enable_experimental_deallocation", b"xla_cpu_enable_experimental_deallocation", "xla_cpu_enable_fast_math", b"xla_cpu_enable_fast_math", "xla_cpu_enable_fast_min_max", b"xla_cpu_enable_fast_min_max", "xla_cpu_enable_mlir_fusion_outlining", b"xla_cpu_enable_mlir_fusion_outlining", "xla_cpu_enable_mlir_tiling_and_fusion", b"xla_cpu_enable_mlir_tiling_and_fusion", "xla_cpu_enable_xprof_traceme", b"xla_cpu_enable_xprof_traceme", "xla_cpu_fast_math_honor_division", b"xla_cpu_fast_math_honor_division", "xla_cpu_fast_math_honor_functions", b"xla_cpu_fast_math_honor_functions", "xla_cpu_fast_math_honor_infs", b"xla_cpu_fast_math_honor_infs", "xla_cpu_fast_math_honor_nans", b"xla_cpu_fast_math_honor_nans", "xla_cpu_matmul_tiling_k_dim", b"xla_cpu_matmul_tiling_k_dim", "xla_cpu_matmul_tiling_m_dim", b"xla_cpu_matmul_tiling_m_dim", "xla_cpu_matmul_tiling_n_dim", b"xla_cpu_matmul_tiling_n_dim", "xla_cpu_multi_thread_eigen", b"xla_cpu_multi_thread_eigen", "xla_cpu_parallel_codegen_split_count", b"xla_cpu_parallel_codegen_split_count", "xla_cpu_prefer_vector_width", b"xla_cpu_prefer_vector_width", "xla_cpu_strict_dot_conv_math", b"xla_cpu_strict_dot_conv_math", "xla_cpu_use_acl", b"xla_cpu_use_acl", "xla_cpu_use_mkl_dnn", b"xla_cpu_use_mkl_dnn", "xla_cpu_use_thunk_runtime", b"xla_cpu_use_thunk_runtime", "xla_debug_buffer_assignment_show_max", b"xla_debug_buffer_assignment_show_max", "xla_detailed_logging", b"xla_detailed_logging", "xla_disable_all_hlo_passes", b"xla_disable_all_hlo_passes", "xla_disable_hlo_passes", b"xla_disable_hlo_passes", "xla_dump_compress_protos", b"xla_dump_compress_protos", "xla_dump_disable_metadata", b"xla_dump_disable_metadata", "xla_dump_enable_mlir_pretty_form", b"xla_dump_enable_mlir_pretty_form", "xla_dump_fusion_visualization", b"xla_dump_fusion_visualization", "xla_dump_hlo_as_dot", b"xla_dump_hlo_as_dot", "xla_dump_hlo_as_html", b"xla_dump_hlo_as_html", "xla_dump_hlo_as_long_text", b"xla_dump_hlo_as_long_text", "xla_dump_hlo_as_proto", b"xla_dump_hlo_as_proto", "xla_dump_hlo_as_text", b"xla_dump_hlo_as_text", "xla_dump_hlo_as_url", b"xla_dump_hlo_as_url", "xla_dump_hlo_module_re", b"xla_dump_hlo_module_re", "xla_dump_hlo_pass_re", b"xla_dump_hlo_pass_re", "xla_dump_hlo_pipeline_re", b"xla_dump_hlo_pipeline_re", "xla_dump_hlo_snapshots", b"xla_dump_hlo_snapshots", "xla_dump_include_timestamp", b"xla_dump_include_timestamp", "xla_dump_large_constants", b"xla_dump_large_constants", "xla_dump_latency_hiding_schedule", b"xla_dump_latency_hiding_schedule", "xla_dump_max_hlo_modules", b"xla_dump_max_hlo_modules", "xla_dump_module_metadata", b"xla_dump_module_metadata", "xla_dump_to", b"xla_dump_to", "xla_eliminate_hlo_implicit_broadcast", b"xla_eliminate_hlo_implicit_broadcast", "xla_embed_ir_in_executable", b"xla_embed_ir_in_executable", "xla_enable_command_buffers_during_profiling", b"xla_enable_command_buffers_during_profiling", "xla_enable_dumping", b"xla_enable_dumping", "xla_enable_hlo_passes_only", b"xla_enable_hlo_passes_only", "xla_experimental_ignore_channel_id", b"xla_experimental_ignore_channel_id", "xla_force_host_platform_device_count", b"xla_force_host_platform_device_count", "xla_gpu_algorithm_denylist_path", b"xla_gpu_algorithm_denylist_path", "xla_gpu_all_gather_combine_threshold_bytes", b"xla_gpu_all_gather_combine_threshold_bytes", "xla_gpu_all_reduce_blueconnect_num_devices_per_host", b"xla_gpu_all_reduce_blueconnect_num_devices_per_host", "xla_gpu_all_reduce_combine_threshold_bytes", b"xla_gpu_all_reduce_combine_threshold_bytes", "xla_gpu_asm_extra_flags", b"xla_gpu_asm_extra_flags", "xla_gpu_async_dot", b"xla_gpu_async_dot", "xla_gpu_auto_spmd_partitioning_memory_budget_gb", b"xla_gpu_auto_spmd_partitioning_memory_budget_gb", "xla_gpu_auto_spmd_partitioning_memory_budget_ratio", b"xla_gpu_auto_spmd_partitioning_memory_budget_ratio", "xla_gpu_autotune_gemm_rtol", b"xla_gpu_autotune_gemm_rtol", "xla_gpu_autotune_level", b"xla_gpu_autotune_level", "xla_gpu_autotune_max_solutions", b"xla_gpu_autotune_max_solutions", "xla_gpu_collect_cost_model_stats", b"xla_gpu_collect_cost_model_stats", "xla_gpu_collective_inflation_factor", b"xla_gpu_collective_inflation_factor", "xla_gpu_collective_permute_decomposer_threshold", b"xla_gpu_collective_permute_decomposer_threshold", "xla_gpu_copy_insertion_use_region_analysis", b"xla_gpu_copy_insertion_use_region_analysis", "xla_gpu_crash_on_verification_failures", b"xla_gpu_crash_on_verification_failures", "xla_gpu_cublas_fallback", b"xla_gpu_cublas_fallback", "xla_gpu_cuda_data_dir", b"xla_gpu_cuda_data_dir", "xla_gpu_cudnn_gemm_fusion_level", b"xla_gpu_cudnn_gemm_fusion_level", "xla_gpu_cudnn_gemm_max_plans", b"xla_gpu_cudnn_gemm_max_plans", "xla_gpu_deterministic_ops", b"xla_gpu_deterministic_ops", "xla_gpu_disable_async_collectives", b"xla_gpu_disable_async_collectives", "xla_gpu_disable_gpuasm_optimizations", b"xla_gpu_disable_gpuasm_optimizations", "xla_gpu_dump_autotune_logs_to", b"xla_gpu_dump_autotune_logs_to", "xla_gpu_dump_autotune_results_to", b"xla_gpu_dump_autotune_results_to", "xla_gpu_dump_autotuned_gemm_fusions", b"xla_gpu_dump_autotuned_gemm_fusions", "xla_gpu_dump_llvmir", b"xla_gpu_dump_llvmir", "xla_gpu_enable_all_gather_combine_by_dim", b"xla_gpu_enable_all_gather_combine_by_dim", "xla_gpu_enable_analytical_latency_estimator", b"xla_gpu_enable_analytical_latency_estimator", "xla_gpu_enable_approx_costly_collectives", b"xla_gpu_enable_approx_costly_collectives", "xla_gpu_enable_bf16_3way_gemm", b"xla_gpu_enable_bf16_3way_gemm", "xla_gpu_enable_bf16_6way_gemm", b"xla_gpu_enable_bf16_6way_gemm", "xla_gpu_enable_command_buffer", b"xla_gpu_enable_command_buffer", "xla_gpu_enable_cub_radix_sort", b"xla_gpu_enable_cub_radix_sort", "xla_gpu_enable_cublaslt", b"xla_gpu_enable_cublaslt", "xla_gpu_enable_cudnn_fmha", b"xla_gpu_enable_cudnn_fmha", "xla_gpu_enable_cudnn_frontend", b"xla_gpu_enable_cudnn_frontend", "xla_gpu_enable_cudnn_int8x32_convolution_reordering", b"xla_gpu_enable_cudnn_int8x32_convolution_reordering", "xla_gpu_enable_cudnn_layer_norm", b"xla_gpu_enable_cudnn_layer_norm", "xla_gpu_enable_custom_fusions", b"xla_gpu_enable_custom_fusions", "xla_gpu_enable_custom_fusions_re", b"xla_gpu_enable_custom_fusions_re", "xla_gpu_enable_dot_strength_reduction", b"xla_gpu_enable_dot_strength_reduction", "xla_gpu_enable_dynamic_slice_fusion", b"xla_gpu_enable_dynamic_slice_fusion", "xla_gpu_enable_fast_min_max", b"xla_gpu_enable_fast_min_max", "xla_gpu_enable_highest_priority_async_stream", b"xla_gpu_enable_highest_priority_async_stream", "xla_gpu_enable_host_memory_offloading", b"xla_gpu_enable_host_memory_offloading", "xla_gpu_enable_latency_hiding_scheduler", b"xla_gpu_enable_latency_hiding_scheduler", "xla_gpu_enable_libnvjitlink", b"xla_gpu_enable_libnvjitlink", "xla_gpu_enable_libnvptxcompiler", b"xla_gpu_enable_libnvptxcompiler", "xla_gpu_enable_llvm_module_compilation_parallelism", b"xla_gpu_enable_llvm_module_compilation_parallelism", "xla_gpu_enable_nccl_clique_optimization", b"xla_gpu_enable_nccl_clique_optimization", "xla_gpu_enable_nccl_comm_splitting", b"xla_gpu_enable_nccl_comm_splitting", "xla_gpu_enable_nccl_per_stream_comms", b"xla_gpu_enable_nccl_per_stream_comms", "xla_gpu_enable_nccl_user_buffers", b"xla_gpu_enable_nccl_user_buffers", "xla_gpu_enable_pgle_accuracy_checker", b"xla_gpu_enable_pgle_accuracy_checker", "xla_gpu_enable_pipelined_all_gather", b"xla_gpu_enable_pipelined_all_gather", "xla_gpu_enable_pipelined_all_reduce", b"xla_gpu_enable_pipelined_all_reduce", "xla_gpu_enable_pipelined_collectives", b"xla_gpu_enable_pipelined_collectives", "xla_gpu_enable_pipelined_p2p", b"xla_gpu_enable_pipelined_p2p", "xla_gpu_enable_pipelined_reduce_scatter", b"xla_gpu_enable_pipelined_reduce_scatter", "xla_gpu_enable_priority_fusion", b"xla_gpu_enable_priority_fusion", "xla_gpu_enable_reassociation_for_converted_ar", b"xla_gpu_enable_reassociation_for_converted_ar", "xla_gpu_enable_reduce_scatter_combine_by_dim", b"xla_gpu_enable_reduce_scatter_combine_by_dim", "xla_gpu_enable_reduction_epilogue_fusion", b"xla_gpu_enable_reduction_epilogue_fusion", "xla_gpu_enable_shared_constants", b"xla_gpu_enable_shared_constants", "xla_gpu_enable_split_k_autotuning", b"xla_gpu_enable_split_k_autotuning", "xla_gpu_enable_triton_gemm", b"xla_gpu_enable_triton_gemm", "xla_gpu_enable_triton_gemm_int4", b"xla_gpu_enable_triton_gemm_int4", "xla_gpu_enable_triton_hopper", b"xla_gpu_enable_triton_hopper", "xla_gpu_enable_while_loop_double_buffering", b"xla_gpu_enable_while_loop_double_buffering", "xla_gpu_enable_while_loop_reduce_scatter_code_motion", b"xla_gpu_enable_while_loop_reduce_scatter_code_motion", "xla_gpu_enable_while_loop_unrolling", b"xla_gpu_enable_while_loop_unrolling", "xla_gpu_ensure_minor_dot_contraction_dims", b"xla_gpu_ensure_minor_dot_contraction_dims", "xla_gpu_exclude_nondeterministic_ops", b"xla_gpu_exclude_nondeterministic_ops", "xla_gpu_executable_terminate_timeout_seconds", b"xla_gpu_executable_terminate_timeout_seconds", "xla_gpu_executable_warn_stuck_timeout_seconds", b"xla_gpu_executable_warn_stuck_timeout_seconds", "xla_gpu_exhaustive_tiling_search", b"xla_gpu_exhaustive_tiling_search", "xla_gpu_experimental_autotune_cache_mode", b"xla_gpu_experimental_autotune_cache_mode", "xla_gpu_experimental_disable_binary_libraries", b"xla_gpu_experimental_disable_binary_libraries", "xla_gpu_experimental_enable_triton_softmax_priority_fusion", b"xla_gpu_experimental_enable_triton_softmax_priority_fusion", "xla_gpu_filter_kernels_spilling_registers_on_autotuning", b"xla_gpu_filter_kernels_spilling_registers_on_autotuning", "xla_gpu_force_compilation_parallelism", b"xla_gpu_force_compilation_parallelism", "xla_gpu_force_conv_nchw", b"xla_gpu_force_conv_nchw", "xla_gpu_force_conv_nhwc", b"xla_gpu_force_conv_nhwc", "xla_gpu_ftz", b"xla_gpu_ftz", "xla_gpu_fused_attention_use_cudnn_rng", b"xla_gpu_fused_attention_use_cudnn_rng", "xla_gpu_gemm_rewrite_size_threshold", b"xla_gpu_gemm_rewrite_size_threshold", "xla_gpu_graph_enable_concurrent_region", b"xla_gpu_graph_enable_concurrent_region", "xla_gpu_graph_min_graph_size", b"xla_gpu_graph_min_graph_size", "xla_gpu_kernel_cache_file", b"xla_gpu_kernel_cache_file", "xla_gpu_lhs_enable_gpu_async_tracker", b"xla_gpu_lhs_enable_gpu_async_tracker", "xla_gpu_llvm_ir_file", b"xla_gpu_llvm_ir_file", "xla_gpu_llvm_verification_level", b"xla_gpu_llvm_verification_level", "xla_gpu_load_autotune_results_from", b"xla_gpu_load_autotune_results_from", "xla_gpu_memory_limit_slop_factor", b"xla_gpu_memory_limit_slop_factor", "xla_gpu_mlir_emitter_level", b"xla_gpu_mlir_emitter_level", "xla_gpu_mock_custom_calls", b"xla_gpu_mock_custom_calls", "xla_gpu_multi_streamed_windowed_einsum", b"xla_gpu_multi_streamed_windowed_einsum", "xla_gpu_nccl_collective_max_nchannels", b"xla_gpu_nccl_collective_max_nchannels", "xla_gpu_nccl_p2p_max_nchannels", b"xla_gpu_nccl_p2p_max_nchannels", "xla_gpu_nccl_terminate_on_error", b"xla_gpu_nccl_terminate_on_error", "xla_gpu_nccl_termination_timeout_seconds", b"xla_gpu_nccl_termination_timeout_seconds", "xla_gpu_override_gemm_autotuner", b"xla_gpu_override_gemm_autotuner", "xla_gpu_per_fusion_autotune_cache_dir", b"xla_gpu_per_fusion_autotune_cache_dir", "xla_gpu_pgle_profile_file_or_directory_path", b"xla_gpu_pgle_profile_file_or_directory_path", "xla_gpu_ptx_file", b"xla_gpu_ptx_file", "xla_gpu_reduce_scatter_combine_threshold_bytes", b"xla_gpu_reduce_scatter_combine_threshold_bytes", "xla_gpu_redzone_padding_bytes", b"xla_gpu_redzone_padding_bytes", "xla_gpu_redzone_scratch_max_megabytes", b"xla_gpu_redzone_scratch_max_megabytes", "xla_gpu_require_complete_aot_autotune_results", b"xla_gpu_require_complete_aot_autotune_results", "xla_gpu_run_post_layout_collective_pipeliner", b"xla_gpu_run_post_layout_collective_pipeliner", "xla_gpu_shape_checks", b"xla_gpu_shape_checks", "xla_gpu_shard_autotuning", b"xla_gpu_shard_autotuning", "xla_gpu_strict_conv_algorithm_picker", b"xla_gpu_strict_conv_algorithm_picker", "xla_gpu_target_config_filename", b"xla_gpu_target_config_filename", "xla_gpu_temp_buffer_use_separate_color", b"xla_gpu_temp_buffer_use_separate_color", "xla_gpu_threshold_for_windowed_einsum_mib", b"xla_gpu_threshold_for_windowed_einsum_mib", "xla_gpu_triton_fusion_level", b"xla_gpu_triton_fusion_level", "xla_gpu_triton_gemm_any", b"xla_gpu_triton_gemm_any", "xla_gpu_triton_gemm_disable_reduced_precision_reduction", b"xla_gpu_triton_gemm_disable_reduced_precision_reduction", "xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found", b"xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found", "xla_gpu_unsafe_pipelined_loop_annotator", b"xla_gpu_unsafe_pipelined_loop_annotator", "xla_gpu_unsupported_enable_triton_gemm", b"xla_gpu_unsupported_enable_triton_gemm", "xla_gpu_use_memcpy_local_p2p", b"xla_gpu_use_memcpy_local_p2p", "xla_gpu_use_runtime_fusion", b"xla_gpu_use_runtime_fusion", "xla_gpu_verify_triton_fusion_numerics", b"xla_gpu_verify_triton_fusion_numerics", "xla_hlo_evaluator_use_fast_path", b"xla_hlo_evaluator_use_fast_path", "xla_hlo_graph_addresses", b"xla_hlo_graph_addresses", "xla_hlo_graph_sharding_color", b"xla_hlo_graph_sharding_color", "xla_hlo_profile", b"xla_hlo_profile", "xla_llvm_disable_expensive_passes", b"xla_llvm_disable_expensive_passes", "xla_llvm_enable_alias_scope_metadata", b"xla_llvm_enable_alias_scope_metadata", "xla_llvm_enable_invariant_load_metadata", b"xla_llvm_enable_invariant_load_metadata", "xla_llvm_enable_noalias_metadata", b"xla_llvm_enable_noalias_metadata", "xla_llvm_force_inline_before_split", b"xla_llvm_force_inline_before_split", "xla_multiheap_size_constraint_per_heap", b"xla_multiheap_size_constraint_per_heap", "xla_partitioning_algorithm", b"xla_partitioning_algorithm", "xla_reduce_window_rewrite_base_length", b"xla_reduce_window_rewrite_base_length", "xla_step_marker_location", b"xla_step_marker_location", "xla_syntax_sugar_async_ops", b"xla_syntax_sugar_async_ops", "xla_test_all_input_layouts", b"xla_test_all_input_layouts", "xla_test_all_output_layouts", b"xla_test_all_output_layouts", "xla_tpu_detect_inf", b"xla_tpu_detect_inf", "xla_tpu_detect_nan", b"xla_tpu_detect_nan"]) -> None: ...

global___DebugOptions = DebugOptions

@typing.final
class GpuCompilationEnvironment(google.protobuf.message.Message):
    """Contains flags which affects the GPU compilation result.
    These flags are part of Debug Options as of now, and will be migrated to
    this proto.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DUMMY_FLAG_FIELD_NUMBER: builtins.int
    dummy_flag: builtins.int
    """Temporary dummy flag is added to test the flow.
    To be removed when we add flags here.
    """
    def __init__(
        self,
        *,
        dummy_flag: builtins.int | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dummy_flag", b"dummy_flag"]) -> None: ...

global___GpuCompilationEnvironment = GpuCompilationEnvironment

@typing.final
class ShardableValueUpdatePairProto(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_PARAMETER_NUMBER_FIELD_NUMBER: builtins.int
    PARAMETER_SHAPE_INDEX_FIELD_NUMBER: builtins.int
    OUTPUT_SHAPE_INDEX_FIELD_NUMBER: builtins.int
    input_parameter_number: builtins.int
    @property
    def parameter_shape_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def output_shape_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        input_parameter_number: builtins.int | None = ...,
        parameter_shape_index: collections.abc.Iterable[builtins.int] | None = ...,
        output_shape_index: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["input_parameter_number", b"input_parameter_number", "output_shape_index", b"output_shape_index", "parameter_shape_index", b"parameter_shape_index"]) -> None: ...

global___ShardableValueUpdatePairProto = ShardableValueUpdatePairProto

@typing.final
class ExecutionOptions(google.protobuf.message.Message):
    """These settings control how XLA compiles and/or runs code.  Not all settings
    will have an effect on every platform.

    When adding new fields, keep in mind that boolean fields default to false.
    Next id: 25.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHAPE_WITH_OUTPUT_LAYOUT_FIELD_NUMBER: builtins.int
    SEED_FIELD_NUMBER: builtins.int
    DEBUG_OPTIONS_FIELD_NUMBER: builtins.int
    DEVICE_HANDLES_FIELD_NUMBER: builtins.int
    NUM_REPLICAS_FIELD_NUMBER: builtins.int
    DEVICE_ASSIGNMENT_FIELD_NUMBER: builtins.int
    ALIAS_PASSTHROUGH_PARAMS_FIELD_NUMBER: builtins.int
    NUM_PARTITIONS_FIELD_NUMBER: builtins.int
    LAUNCH_ID_FIELD_NUMBER: builtins.int
    USE_SPMD_PARTITIONING_FIELD_NUMBER: builtins.int
    USE_AUTO_SPMD_PARTITIONING_FIELD_NUMBER: builtins.int
    AUTO_SPMD_PARTITIONING_MESH_SHAPE_FIELD_NUMBER: builtins.int
    AUTO_SPMD_PARTITIONING_MESH_IDS_FIELD_NUMBER: builtins.int
    DEDUPLICATE_HLO_FIELD_NUMBER: builtins.int
    ALLOW_SPMD_SHARDING_PROPAGATION_TO_PARAMETERS_FIELD_NUMBER: builtins.int
    ALLOW_SPMD_SHARDING_PROPAGATION_TO_OUTPUT_FIELD_NUMBER: builtins.int
    PARAM_REQUIRES_BROADCAST_VIA_COLLECTIVES_FIELD_NUMBER: builtins.int
    ALLOW_SEPARATE_SHARDING_PROGRAMS_FIELD_NUMBER: builtins.int
    SHARDABLE_VALUE_UPDATE_PAIRS_FIELD_NUMBER: builtins.int
    FDO_PROFILE_FIELD_NUMBER: builtins.int
    DEVICE_MEMORY_SIZE_FIELD_NUMBER: builtins.int
    USE_SHARDY_PARTITIONER_FIELD_NUMBER: builtins.int
    seed: builtins.int
    """Used to seed random-number generators used in this computation.  If this is
    0, we generate a seed ourselves.

    TODO(b/32083678): Changing the seed unnecessarily forces a recompilation.
    """
    num_replicas: builtins.int
    """Number of replicas of the computation to run. If zero, uses the default
    number of replicas for the XLA service.
    """
    alias_passthrough_params: builtins.bool
    """Alias input and output buffers for parameters that are passed-through XLA
    modules without being changed.
    """
    num_partitions: builtins.int
    """Number of partitions of the computation to run (model parallelism).
    If zero, uses the default number of partitions for the XLA service.
    """
    launch_id: builtins.int
    """Used to identify a set of programs that should be launch together."""
    use_spmd_partitioning: builtins.bool
    """Indicates whether to use SPMD (true) or MPMD (false) partitioning when
    num_partitions > 1 and XLA is requested to partition the input program.
    """
    use_auto_spmd_partitioning: builtins.bool
    """Whether to automatically generate XLA shardings for SPMD partitioner."""
    deduplicate_hlo: builtins.bool
    """If set, deduplicate hlo into function calls to reduce binary size. Only
    works on TPU.
    """
    allow_separate_sharding_programs: builtins.bool
    """If enabled, the compiler may generate sharding and unsharding programs as
    separate HLO modules, and modify the main program's input and output to
    be sharded.
    """
    fdo_profile: builtins.bytes
    """Profiling data for feedback directed optimizations. Note that this is not
    the only way to feed FDO data into the compiler and individual backends
    may choose to get FDO data by other means.
    """
    device_memory_size: builtins.int
    """Amount of device memory available for the executable to use."""
    use_shardy_partitioner: builtins.bool
    """Use Shardy, a new partitioner, to replace the existing
    ShardingPropagation and SpmdPartitioner. See go/xla-sdy-pipeline for
    details.
    """
    @property
    def shape_with_output_layout(self) -> tensorflow.compiler.xla.xla_data_pb2.ShapeProto:
        """This optional field's layout is used as a hint when storing the output of
        this computation.  Subsequent transfers of this output array to the client
        may be faster when using this layout.

        We use a Shape here to accommodate computations that return a tuple.
        """

    @property
    def debug_options(self) -> global___DebugOptions: ...
    @property
    def device_handles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tensorflow.compiler.xla.xla_data_pb2.DeviceHandle]:
        """This optional field specifies a particular set of devices to run the
        computation on. The computation will be partitioned across these devices.
        If not provided, the default device will be chosen.
        """

    @property
    def device_assignment(self) -> tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto:
        """This optional field specifies the device assignment if known at compile
        time.
        """

    @property
    def auto_spmd_partitioning_mesh_shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Device mesh shape used to create the sharding search space when
        use_auto_spmd_partitioning=true.
        """

    @property
    def auto_spmd_partitioning_mesh_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Device mesh ids compatible with the above mesh_shape used when
        use_auto_spmd_partitioning=true.
        """

    @property
    def allow_spmd_sharding_propagation_to_parameters(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Allows sharding propagation to propagate to the parameters. This changes
        the input shape of the computation (which is undesirable), but it can be
        used to allow to run partial compilation to determine what would be the
        input sharding of a computation if XLA would be allowed to propagate the
        sharding which can be used by higher level framework as a way to query
        intermediate sharding of operations when multiple computation would be
        chained and merged together.
        This is a vector of bool, because the user can control which parameters can
        have the sharding substituted. If only one boolean value is passed in the
        vector that is interpreted as the value to be applied for every parameter.
        """

    @property
    def allow_spmd_sharding_propagation_to_output(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Allows sharding propagation to propagate to the outputs. This changes the
        output shape of the computation (which is undesirable), but it can be used
        to allow to run partial compilation to determine what would be the output
        sharding of a computation if XLA would be allowed to propagate the sharding
        which can be used by higher level framework as a way to query intermediate
        sharding of operations when multiple computation would be chained and
        merged together.
        This is a vector of bool, because the user can control (if the output of
        the computation is a tuple) which elements of the tuple can have the
        sharding substituted and which don't. If only one boolean value is passed
        in the vector that's interpreted as the value to be applied for every
        single element of the output tuple. One value per element of the tuple
        means that each value is attached to one of the output elements.
        """

    @property
    def param_requires_broadcast_via_collectives(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Whether to broadcast args across all replicas. One entry per arg."""

    @property
    def shardable_value_update_pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardableValueUpdatePairProto]:
        """The list of input/output pairs in the main program that could be sharded."""

    def __init__(
        self,
        *,
        shape_with_output_layout: tensorflow.compiler.xla.xla_data_pb2.ShapeProto | None = ...,
        seed: builtins.int | None = ...,
        debug_options: global___DebugOptions | None = ...,
        device_handles: collections.abc.Iterable[tensorflow.compiler.xla.xla_data_pb2.DeviceHandle] | None = ...,
        num_replicas: builtins.int | None = ...,
        device_assignment: tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto | None = ...,
        alias_passthrough_params: builtins.bool | None = ...,
        num_partitions: builtins.int | None = ...,
        launch_id: builtins.int | None = ...,
        use_spmd_partitioning: builtins.bool | None = ...,
        use_auto_spmd_partitioning: builtins.bool | None = ...,
        auto_spmd_partitioning_mesh_shape: collections.abc.Iterable[builtins.int] | None = ...,
        auto_spmd_partitioning_mesh_ids: collections.abc.Iterable[builtins.int] | None = ...,
        deduplicate_hlo: builtins.bool | None = ...,
        allow_spmd_sharding_propagation_to_parameters: collections.abc.Iterable[builtins.bool] | None = ...,
        allow_spmd_sharding_propagation_to_output: collections.abc.Iterable[builtins.bool] | None = ...,
        param_requires_broadcast_via_collectives: collections.abc.Iterable[builtins.bool] | None = ...,
        allow_separate_sharding_programs: builtins.bool | None = ...,
        shardable_value_update_pairs: collections.abc.Iterable[global___ShardableValueUpdatePairProto] | None = ...,
        fdo_profile: builtins.bytes | None = ...,
        device_memory_size: builtins.int | None = ...,
        use_shardy_partitioner: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["debug_options", b"debug_options", "device_assignment", b"device_assignment", "shape_with_output_layout", b"shape_with_output_layout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["alias_passthrough_params", b"alias_passthrough_params", "allow_separate_sharding_programs", b"allow_separate_sharding_programs", "allow_spmd_sharding_propagation_to_output", b"allow_spmd_sharding_propagation_to_output", "allow_spmd_sharding_propagation_to_parameters", b"allow_spmd_sharding_propagation_to_parameters", "auto_spmd_partitioning_mesh_ids", b"auto_spmd_partitioning_mesh_ids", "auto_spmd_partitioning_mesh_shape", b"auto_spmd_partitioning_mesh_shape", "debug_options", b"debug_options", "deduplicate_hlo", b"deduplicate_hlo", "device_assignment", b"device_assignment", "device_handles", b"device_handles", "device_memory_size", b"device_memory_size", "fdo_profile", b"fdo_profile", "launch_id", b"launch_id", "num_partitions", b"num_partitions", "num_replicas", b"num_replicas", "param_requires_broadcast_via_collectives", b"param_requires_broadcast_via_collectives", "seed", b"seed", "shape_with_output_layout", b"shape_with_output_layout", "shardable_value_update_pairs", b"shardable_value_update_pairs", "use_auto_spmd_partitioning", b"use_auto_spmd_partitioning", "use_shardy_partitioner", b"use_shardy_partitioner", "use_spmd_partitioning", b"use_spmd_partitioning"]) -> None: ...

global___ExecutionOptions = ExecutionOptions

@typing.final
class HloModuleConfigProto(google.protobuf.message.Message):
    """Serialization of HloModuleConfig. See the C++ class definition for
    descriptions of each field.
    There are no guarantees of backwards or forwards compatibility.
    Next id: 36.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _FusionConfigCollection:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FusionConfigCollectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HloModuleConfigProto._FusionConfigCollection.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OFF: HloModuleConfigProto._FusionConfigCollection.ValueType  # 0
        """Do not collect configuration."""
        PER_EDGE: HloModuleConfigProto._FusionConfigCollection.ValueType  # 1
        """Collect per-edge configuration."""
        PER_NODE: HloModuleConfigProto._FusionConfigCollection.ValueType  # 2
        """Collect per-node configuration."""

    class FusionConfigCollection(_FusionConfigCollection, metaclass=_FusionConfigCollectionEnumTypeWrapper): ...
    OFF: HloModuleConfigProto.FusionConfigCollection.ValueType  # 0
    """Do not collect configuration."""
    PER_EDGE: HloModuleConfigProto.FusionConfigCollection.ValueType  # 1
    """Collect per-edge configuration."""
    PER_NODE: HloModuleConfigProto.FusionConfigCollection.ValueType  # 2
    """Collect per-node configuration."""

    @typing.final
    class BoolList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALS_FIELD_NUMBER: builtins.int
        @property
        def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
        def __init__(
            self,
            *,
            vals: collections.abc.Iterable[builtins.bool] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["vals", b"vals"]) -> None: ...

    @typing.final
    class Int64List(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALS_FIELD_NUMBER: builtins.int
        @property
        def vals(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
        def __init__(
            self,
            *,
            vals: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["vals", b"vals"]) -> None: ...

    @typing.final
    class Int64ListList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LISTS_FIELD_NUMBER: builtins.int
        @property
        def lists(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HloModuleConfigProto.Int64List]: ...
        def __init__(
            self,
            *,
            lists: collections.abc.Iterable[global___HloModuleConfigProto.Int64List] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["lists", b"lists"]) -> None: ...

    @typing.final
    class DotConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___HloModuleConfigProto.Int64List: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___HloModuleConfigProto.Int64List | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class AnalysisAllowanceMapEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENTRY_COMPUTATION_LAYOUT_FIELD_NUMBER: builtins.int
    SEED_FIELD_NUMBER: builtins.int
    LAUNCH_ID_FIELD_NUMBER: builtins.int
    REPLICA_COUNT_FIELD_NUMBER: builtins.int
    NUM_PARTITIONS_FIELD_NUMBER: builtins.int
    PARAM_REQUIRES_BROADCAST_VIA_COLLECTIVES_FIELD_NUMBER: builtins.int
    USE_SPMD_PARTITIONING_FIELD_NUMBER: builtins.int
    USE_AUTO_SPMD_PARTITIONING_FIELD_NUMBER: builtins.int
    AUTO_SPMD_PARTITIONING_MESH_SHAPE_FIELD_NUMBER: builtins.int
    AUTO_SPMD_PARTITIONING_MESH_IDS_FIELD_NUMBER: builtins.int
    DEDUPLICATE_HLO_FIELD_NUMBER: builtins.int
    INTRA_OP_PARALLELISM_THREADS_FIELD_NUMBER: builtins.int
    DEVICE_TYPE_FIELD_NUMBER: builtins.int
    DEBUG_OPTIONS_FIELD_NUMBER: builtins.int
    STATIC_DEVICE_ASSIGNMENT_FIELD_NUMBER: builtins.int
    PRE_SIMULATION_DEVICE_ASSIGNMENT_FIELD_NUMBER: builtins.int
    ALLOW_SEPARATE_SHARDING_PROGRAMS_FIELD_NUMBER: builtins.int
    SHARDABLE_VALUE_UPDATE_PAIRS_FIELD_NUMBER: builtins.int
    ALIAS_PASSTHROUGH_PARAMS_FIELD_NUMBER: builtins.int
    CONTENT_AWARE_COMPUTATION_SORTING_FIELD_NUMBER: builtins.int
    FUSION_CONFIG_COLLECTION_FIELD_NUMBER: builtins.int
    FUSION_CONFIG_FIELD_NUMBER: builtins.int
    DOT_CONFIG_FIELD_NUMBER: builtins.int
    LAYOUT_CONFIG_FIELD_NUMBER: builtins.int
    MEMORY_SPACE_ASSIGNMENT_CONFIG_FIELD_NUMBER: builtins.int
    PHASE_ORDERING_CONFIG_FIELD_NUMBER: builtins.int
    PHASE_INDEX_FIELD_NUMBER: builtins.int
    ALLOW_SPMD_SHARDING_PROPAGATION_TO_PARAMETERS_FIELD_NUMBER: builtins.int
    ALLOW_SPMD_SHARDING_PROPAGATION_TO_OUTPUT_FIELD_NUMBER: builtins.int
    ANALYSIS_ALLOWANCE_MAP_FIELD_NUMBER: builtins.int
    MATRIX_UNIT_OPERAND_PRECISION_FIELD_NUMBER: builtins.int
    FDO_PROFILE_FIELD_NUMBER: builtins.int
    DEVICE_MEMORY_SIZE_FIELD_NUMBER: builtins.int
    USE_SHARDY_PARTITIONER_FIELD_NUMBER: builtins.int
    seed: builtins.int
    launch_id: builtins.int
    replica_count: builtins.int
    num_partitions: builtins.int
    use_spmd_partitioning: builtins.bool
    use_auto_spmd_partitioning: builtins.bool
    deduplicate_hlo: builtins.bool
    intra_op_parallelism_threads: builtins.int
    device_type: builtins.str
    allow_separate_sharding_programs: builtins.bool
    alias_passthrough_params: builtins.bool
    content_aware_computation_sorting: builtins.bool
    fusion_config_collection: global___HloModuleConfigProto.FusionConfigCollection.ValueType
    phase_index: builtins.int
    matrix_unit_operand_precision: tensorflow.compiler.xla.xla_data_pb2.PrecisionConfig.Precision.ValueType
    fdo_profile: builtins.bytes
    device_memory_size: builtins.int
    use_shardy_partitioner: builtins.bool
    @property
    def entry_computation_layout(self) -> tensorflow.compiler.xla.xla_data_pb2.ProgramShapeProto: ...
    @property
    def param_requires_broadcast_via_collectives(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
    @property
    def auto_spmd_partitioning_mesh_shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def auto_spmd_partitioning_mesh_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def debug_options(self) -> global___DebugOptions: ...
    @property
    def static_device_assignment(self) -> tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto: ...
    @property
    def pre_simulation_device_assignment(self) -> tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto:
        """The original device assignment before being changed by a simulator.
        Simulators, like HybridSim, may change the device assignment to a smaller
        topology, to make simulation easier.
        """

    @property
    def shardable_value_update_pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardableValueUpdatePairProto]: ...
    @property
    def fusion_config(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HloModuleConfigProto.BoolList]: ...
    @property
    def dot_config(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___HloModuleConfigProto.Int64List]: ...
    @property
    def layout_config(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HloModuleConfigProto.Int64ListList]: ...
    @property
    def memory_space_assignment_config(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def phase_ordering_config(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HloModuleConfigProto.BoolList]: ...
    @property
    def allow_spmd_sharding_propagation_to_parameters(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
    @property
    def allow_spmd_sharding_propagation_to_output(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
    @property
    def analysis_allowance_map(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]: ...
    def __init__(
        self,
        *,
        entry_computation_layout: tensorflow.compiler.xla.xla_data_pb2.ProgramShapeProto | None = ...,
        seed: builtins.int | None = ...,
        launch_id: builtins.int | None = ...,
        replica_count: builtins.int | None = ...,
        num_partitions: builtins.int | None = ...,
        param_requires_broadcast_via_collectives: collections.abc.Iterable[builtins.bool] | None = ...,
        use_spmd_partitioning: builtins.bool | None = ...,
        use_auto_spmd_partitioning: builtins.bool | None = ...,
        auto_spmd_partitioning_mesh_shape: collections.abc.Iterable[builtins.int] | None = ...,
        auto_spmd_partitioning_mesh_ids: collections.abc.Iterable[builtins.int] | None = ...,
        deduplicate_hlo: builtins.bool | None = ...,
        intra_op_parallelism_threads: builtins.int | None = ...,
        device_type: builtins.str | None = ...,
        debug_options: global___DebugOptions | None = ...,
        static_device_assignment: tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto | None = ...,
        pre_simulation_device_assignment: tensorflow.compiler.xla.xla_data_pb2.DeviceAssignmentProto | None = ...,
        allow_separate_sharding_programs: builtins.bool | None = ...,
        shardable_value_update_pairs: collections.abc.Iterable[global___ShardableValueUpdatePairProto] | None = ...,
        alias_passthrough_params: builtins.bool | None = ...,
        content_aware_computation_sorting: builtins.bool | None = ...,
        fusion_config_collection: global___HloModuleConfigProto.FusionConfigCollection.ValueType | None = ...,
        fusion_config: collections.abc.Iterable[global___HloModuleConfigProto.BoolList] | None = ...,
        dot_config: collections.abc.Mapping[builtins.str, global___HloModuleConfigProto.Int64List] | None = ...,
        layout_config: collections.abc.Iterable[global___HloModuleConfigProto.Int64ListList] | None = ...,
        memory_space_assignment_config: collections.abc.Iterable[builtins.int] | None = ...,
        phase_ordering_config: collections.abc.Iterable[global___HloModuleConfigProto.BoolList] | None = ...,
        phase_index: builtins.int | None = ...,
        allow_spmd_sharding_propagation_to_parameters: collections.abc.Iterable[builtins.bool] | None = ...,
        allow_spmd_sharding_propagation_to_output: collections.abc.Iterable[builtins.bool] | None = ...,
        analysis_allowance_map: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        matrix_unit_operand_precision: tensorflow.compiler.xla.xla_data_pb2.PrecisionConfig.Precision.ValueType | None = ...,
        fdo_profile: builtins.bytes | None = ...,
        device_memory_size: builtins.int | None = ...,
        use_shardy_partitioner: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["debug_options", b"debug_options", "entry_computation_layout", b"entry_computation_layout", "pre_simulation_device_assignment", b"pre_simulation_device_assignment", "static_device_assignment", b"static_device_assignment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["alias_passthrough_params", b"alias_passthrough_params", "allow_separate_sharding_programs", b"allow_separate_sharding_programs", "allow_spmd_sharding_propagation_to_output", b"allow_spmd_sharding_propagation_to_output", "allow_spmd_sharding_propagation_to_parameters", b"allow_spmd_sharding_propagation_to_parameters", "analysis_allowance_map", b"analysis_allowance_map", "auto_spmd_partitioning_mesh_ids", b"auto_spmd_partitioning_mesh_ids", "auto_spmd_partitioning_mesh_shape", b"auto_spmd_partitioning_mesh_shape", "content_aware_computation_sorting", b"content_aware_computation_sorting", "debug_options", b"debug_options", "deduplicate_hlo", b"deduplicate_hlo", "device_memory_size", b"device_memory_size", "device_type", b"device_type", "dot_config", b"dot_config", "entry_computation_layout", b"entry_computation_layout", "fdo_profile", b"fdo_profile", "fusion_config", b"fusion_config", "fusion_config_collection", b"fusion_config_collection", "intra_op_parallelism_threads", b"intra_op_parallelism_threads", "launch_id", b"launch_id", "layout_config", b"layout_config", "matrix_unit_operand_precision", b"matrix_unit_operand_precision", "memory_space_assignment_config", b"memory_space_assignment_config", "num_partitions", b"num_partitions", "param_requires_broadcast_via_collectives", b"param_requires_broadcast_via_collectives", "phase_index", b"phase_index", "phase_ordering_config", b"phase_ordering_config", "pre_simulation_device_assignment", b"pre_simulation_device_assignment", "replica_count", b"replica_count", "seed", b"seed", "shardable_value_update_pairs", b"shardable_value_update_pairs", "static_device_assignment", b"static_device_assignment", "use_auto_spmd_partitioning", b"use_auto_spmd_partitioning", "use_shardy_partitioner", b"use_shardy_partitioner", "use_spmd_partitioning", b"use_spmd_partitioning"]) -> None: ...

global___HloModuleConfigProto = HloModuleConfigProto

@typing.final
class HloModuleProtoWithConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HLO_MODULE_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def hlo_module(self) -> tensorflow.compiler.xla.service.hlo_pb2.HloModuleProto: ...
    @property
    def config(self) -> global___HloModuleConfigProto: ...
    def __init__(
        self,
        *,
        hlo_module: tensorflow.compiler.xla.service.hlo_pb2.HloModuleProto | None = ...,
        config: global___HloModuleConfigProto | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "hlo_module", b"hlo_module"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "hlo_module", b"hlo_module"]) -> None: ...

global___HloModuleProtoWithConfig = HloModuleProtoWithConfig

@typing.final
class ScheduleProto(google.protobuf.message.Message):
    """A trace estimated by the Latency Hiding Scheduler."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Instruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        START_TIMESTAMP_CYCLES_FIELD_NUMBER: builtins.int
        END_TIMESTAMP_CYCLES_FIELD_NUMBER: builtins.int
        id: builtins.int
        """Instruction id (matches the id in HloInstructionProto)."""
        start_timestamp_cycles: builtins.float
        """Start and end timestamps in cycles."""
        end_timestamp_cycles: builtins.float
        def __init__(
            self,
            *,
            id: builtins.int | None = ...,
            start_timestamp_cycles: builtins.float | None = ...,
            end_timestamp_cycles: builtins.float | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["end_timestamp_cycles", b"end_timestamp_cycles", "id", b"id", "start_timestamp_cycles", b"start_timestamp_cycles"]) -> None: ...

    INSTRUCTIONS_FIELD_NUMBER: builtins.int
    COMPUTATION_ID_FIELD_NUMBER: builtins.int
    HLO_MODULE_FIELD_NUMBER: builtins.int
    CYCLES_PER_MICROSECOND_FIELD_NUMBER: builtins.int
    computation_id: builtins.int
    """Computation id (matches the id in HloComputationProto)."""
    cycles_per_microsecond: builtins.int
    @property
    def instructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScheduleProto.Instruction]: ...
    @property
    def hlo_module(self) -> tensorflow.compiler.xla.service.hlo_pb2.HloModuleProto: ...
    def __init__(
        self,
        *,
        instructions: collections.abc.Iterable[global___ScheduleProto.Instruction] | None = ...,
        computation_id: builtins.int | None = ...,
        hlo_module: tensorflow.compiler.xla.service.hlo_pb2.HloModuleProto | None = ...,
        cycles_per_microsecond: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hlo_module", b"hlo_module"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["computation_id", b"computation_id", "cycles_per_microsecond", b"cycles_per_microsecond", "hlo_module", b"hlo_module", "instructions", b"instructions"]) -> None: ...

global___ScheduleProto = ScheduleProto
