/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ListenerEntry;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceListenerState;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

class Listeners {
    HashSet<ListenerEntry> bundleListeners = new HashSet();
    HashSet<ListenerEntry> syncBundleListeners = new HashSet();
    private FrameworkListener[] initListeners;
    private final HashSet<ListenerEntry> frameworkListeners = new HashSet();
    ServiceListenerState serviceListeners;
    private LinkedList<AsyncEvent> asyncEventQueue = null;
    private AsyncEventThread[] threads = null;
    private HashMap<ListenerEntry, Thread> activeListeners = null;
    private PermissionOps secure;
    FrameworkContext fwCtx;
    boolean nocacheldap;
    volatile boolean quit = false;

    Listeners(FrameworkContext framework, PermissionOps perm, FrameworkListener ... initListeners) {
        this.fwCtx = framework;
        this.secure = perm;
        this.nocacheldap = framework.props.getBooleanProperty("org.knopflerfish.framework.ldap.nocache");
        this.serviceListeners = new ServiceListenerState(this);
        String ets = framework.props.getProperty("org.knopflerfish.framework.listener.n_threads");
        int n_threads = 1;
        NumberFormatException error = null;
        if (ets != null) {
            try {
                n_threads = Integer.parseInt(ets);
            }
            catch (NumberFormatException nfe) {
                error = nfe;
            }
        }
        this.initListeners = initListeners;
        if (n_threads > 0) {
            this.asyncEventQueue = new LinkedList();
            this.threads = new AsyncEventThread[n_threads];
            for (int i = 0; i < n_threads; ++i) {
                this.threads[i] = new AsyncEventThread(i);
                this.threads[i].start();
            }
            if (n_threads > 1) {
                this.activeListeners = new HashMap();
            }
            if (error != null) {
                Exception t = new Exception("Failed to parse org.knopflerfish.framework.listener.n_threads", error);
                framework.frameworkWarning(framework.systemBundle, (Throwable)t, new FrameworkListener[0]);
            }
        }
    }

    void clear() {
        this.bundleListeners.clear();
        this.syncBundleListeners.clear();
        this.frameworkListeners.clear();
        this.serviceListeners.clear();
        this.initListeners = null;
        this.secure = null;
        this.fwCtx = null;
    }

    void initDone() {
        this.initListeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(BundleContextImpl bc, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        if (listener instanceof SynchronousBundleListener) {
            this.secure.checkListenerAdminPerm(bc.bundle);
            HashSet<ListenerEntry> hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.syncBundleListeners.add(le);
            }
        }
        HashSet<ListenerEntry> hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(BundleContextImpl bc, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        if (listener instanceof SynchronousBundleListener) {
            HashSet<ListenerEntry> hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.secure.checkListenerAdminPerm(bc.bundle);
                this.syncBundleListeners.remove(le);
            }
        }
        HashSet<ListenerEntry> hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.remove(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(BundleContextImpl bc, FrameworkListener listener) {
        ListenerEntry le = new ListenerEntry(bc, listener);
        HashSet<ListenerEntry> hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(BundleContextImpl bc, FrameworkListener listener) {
        HashSet<ListenerEntry> hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.remove(new ListenerEntry(bc, listener));
        }
    }

    void addServiceListener(BundleContextImpl bc, ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.serviceListeners.add(bc, listener, filter);
    }

    void removeServiceListener(BundleContextImpl bc, ServiceListener listener) {
        this.serviceListeners.remove(bc, listener);
    }

    void removeAllListeners(BundleContextImpl bc) {
        this.removeAllListeners(this.syncBundleListeners, bc);
        this.removeAllListeners(this.bundleListeners, bc);
        this.removeAllListeners(this.frameworkListeners, bc);
        this.serviceListeners.removeAll(bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bundleChanged(BundleEvent evt) {
        HashSet<ListenerEntry> filteredSyncBundleListeners = new HashSet<ListenerEntry>();
        HashSet filteredBundleListeners = null;
        int type = evt.getType();
        if (type != 512 && type != 128 && type != 256) {
            filteredBundleListeners = new HashSet();
        }
        this.fwCtx.bundleHooks.filterBundleEventReceivers(evt, filteredSyncBundleListeners, filteredBundleListeners);
        for (ListenerEntry le : filteredSyncBundleListeners) {
            this.bundleChanged(le, evt);
        }
        if (filteredBundleListeners != null) {
            if (this.asyncEventQueue != null) {
                LinkedList<AsyncEvent> i$ = this.asyncEventQueue;
                synchronized (i$) {
                    for (ListenerEntry le : filteredBundleListeners) {
                        this.asyncEventQueue.addLast(new AsyncEvent(le, evt));
                    }
                    this.asyncEventQueue.notify();
                }
            } else {
                for (ListenerEntry le : filteredBundleListeners) {
                    this.bundleChanged(le, evt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void frameworkEvent(FrameworkEvent evt, FrameworkListener ... oneTimeListeners) {
        ListenerEntry[] fl;
        if (this.fwCtx.debug.errors && evt.getType() == 2) {
            this.fwCtx.debug.println("errors - FrameworkErrorEvent bundle #" + evt.getBundle().getBundleId());
            this.fwCtx.debug.printStackTrace("errors - FrameworkErrorEvent throwable: ", evt.getThrowable());
        }
        if (this.fwCtx.debug.warnings && evt.getType() == 16) {
            this.fwCtx.debug.println("warnings - FrameworkErrorEvent bundle #" + evt.getBundle().getBundleId());
            this.fwCtx.debug.printStackTrace("warnings - FrameworkErrorEvent throwable: ", evt.getThrowable());
        }
        if (this.fwCtx.debug.startlevel) {
            if (evt.getType() == 8) {
                this.fwCtx.debug.println("startlevel: FrameworkEvent Startlevel Changed");
            } else if (evt.getType() == 1) {
                this.fwCtx.debug.println("startlevel: FrameworkEvent Started");
            }
        }
        if (this.asyncEventQueue != null) {
            LinkedList<AsyncEvent> linkedList = this.asyncEventQueue;
            synchronized (linkedList) {
                if (oneTimeListeners != null) {
                    for (FrameworkListener fl2 : oneTimeListeners) {
                        this.asyncEventQueue.addLast(new AsyncEvent(new ListenerEntry(null, fl2), evt));
                    }
                }
                if (this.initListeners != null) {
                    for (FrameworkListener il : this.initListeners) {
                        this.asyncEventQueue.addLast(new AsyncEvent(new ListenerEntry(null, il), evt));
                    }
                }
                HashSet<ListenerEntry> hashSet = this.frameworkListeners;
                synchronized (hashSet) {
                    for (ListenerEntry listenerEntry : this.frameworkListeners) {
                        this.asyncEventQueue.addLast(new AsyncEvent(listenerEntry, evt));
                    }
                }
                this.asyncEventQueue.notify();
            }
        }
        if (oneTimeListeners != null) {
            for (FrameworkListener ofl : oneTimeListeners) {
                this.frameworkEvent(new ListenerEntry(null, ofl), evt);
            }
        }
        if (this.initListeners != null) {
            for (FrameworkListener il : this.initListeners) {
                this.frameworkEvent(new ListenerEntry(null, il), evt);
            }
        }
        HashSet<ListenerEntry> hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            fl = new ListenerEntry[this.frameworkListeners.size()];
            this.frameworkListeners.toArray(fl);
        }
        for (ListenerEntry element : fl) {
            this.frameworkEvent(element, evt);
        }
    }

    void serviceChanged(Collection<ServiceListenerEntry> receivers, ServiceEvent evt, Set<ServiceListenerEntry> matchBefore) {
        ServiceReferenceImpl sr = (ServiceReferenceImpl)evt.getServiceReference();
        String[] classes = (String[])sr.getProperty("objectClass");
        int n = 0;
        if (matchBefore != null) {
            for (ServiceListenerEntry l : receivers) {
                matchBefore.remove(l);
            }
        }
        this.fwCtx.serviceHooks.filterServiceEventReceivers(evt, receivers);
        ServicePermission perm = this.secure.checkPermissions() ? new ServicePermission(sr, "get") : null;
        block5: for (ServiceListenerEntry l : receivers) {
            try {
                if (perm != null && !l.bc.bundle.hasPermission(perm)) continue;
                boolean testAssignable = !(l.listener instanceof AllServiceListener);
                for (int i = 0; i < classes.length; ++i) {
                    if (testAssignable && !sr.isAssignableTo(l.bc.bundle, classes[i])) continue;
                    try {
                        ((ServiceListener)l.listener).serviceChanged(evt);
                        ++n;
                    }
                    catch (Throwable pe) {
                        this.fwCtx.frameworkError(l.bc, pe, new FrameworkListener[0]);
                    }
                    continue block5;
                }
            }
            catch (IllegalStateException ignore) {
            }
        }
        if (this.fwCtx.debug.ldap) {
            this.fwCtx.debug.println("Notified " + n + " listeners");
        }
    }

    Set<ServiceListenerEntry> getMatchingServiceListeners(ServiceReference<?> sr) {
        return this.serviceListeners.getMatchingListeners((ServiceReferenceImpl)sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllListeners(Set<ListenerEntry> s, BundleContext bc) {
        Set<ListenerEntry> set = s;
        synchronized (set) {
            Iterator<ListenerEntry> i = s.iterator();
            while (i.hasNext()) {
                if (i.next().bc != bc) continue;
                i.remove();
            }
        }
    }

    private void bundleChanged(ListenerEntry le, BundleEvent evt) {
        try {
            ((BundleListener)le.listener).bundleChanged(evt);
        }
        catch (Throwable pe) {
            this.fwCtx.frameworkError(le.bc, pe, new FrameworkListener[0]);
        }
    }

    private void frameworkEvent(ListenerEntry le, FrameworkEvent evt) {
        block2: {
            try {
                ((FrameworkListener)le.listener).frameworkEvent(evt);
            }
            catch (Exception pe) {
                if (evt.getType() == 2) break block2;
                this.fwCtx.frameworkError(le != null ? le.bc : null, (Throwable)pe, new FrameworkListener[0]);
            }
        }
    }

    private class AsyncEventThread
    extends Thread {
        AsyncEventThread(int i) {
            super(Listeners.this.fwCtx.threadGroup, "AsyncEventThread#" + i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AsyncEvent ae;
                Cloneable cloneable = Listeners.this.asyncEventQueue;
                synchronized (cloneable) {
                    while (!Listeners.this.quit && Listeners.this.asyncEventQueue.isEmpty()) {
                        try {
                            Listeners.this.asyncEventQueue.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    if (Listeners.this.quit) {
                        break;
                    }
                    ae = (AsyncEvent)Listeners.this.asyncEventQueue.removeFirst();
                }
                if (Listeners.this.activeListeners != null) {
                    cloneable = Listeners.this.activeListeners;
                    synchronized (cloneable) {
                        while (Listeners.this.activeListeners.containsKey(ae.le)) {
                            try {
                                Listeners.this.activeListeners.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        Listeners.this.activeListeners.put(ae.le, Thread.currentThread());
                    }
                }
                if (ae.le.bc == null || ae.le.bc.isValid()) {
                    if (ae.evt instanceof BundleEvent) {
                        Listeners.this.bundleChanged(ae.le, (BundleEvent)ae.evt);
                    } else {
                        Listeners.this.frameworkEvent(ae.le, (FrameworkEvent)ae.evt);
                    }
                }
                if (Listeners.this.activeListeners == null) continue;
                cloneable = Listeners.this.activeListeners;
                synchronized (cloneable) {
                    Listeners.this.activeListeners.remove(ae.le);
                    Listeners.this.activeListeners.notifyAll();
                }
            }
        }
    }

    static class AsyncEvent {
        final ListenerEntry le;
        final EventObject evt;

        AsyncEvent(ListenerEntry le, EventObject evt) {
            this.le = le;
            this.evt = evt;
        }
    }
}

