/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.internal.asn1.ASN1Date;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.util.Utils;

public class RevokedCertificate
extends X509CRLEntry
implements Externalizable,
ASN1Object {
    private BigInteger a;
    private Date b;
    private X509ExtensionSet c = null;
    private ASN1Sequence d = null;

    public RevokedCertificate() {
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.a = bigInteger;
        this.b = date;
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, X509ExtensionSet x509ExtensionSet) {
        this(bigInteger, date);
        if (x509ExtensionSet != null && x509ExtensionSet.c() > 0) {
            this.c = x509ExtensionSet;
        }
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, List<X509Extension> list) {
        this(bigInteger, date);
        if (list != null && list.size() > 0) {
            this.c = new X509ExtensionSet(list);
        }
    }

    public RevokedCertificate(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public BigInteger a() {
        return this.a;
    }

    @Override
    public Date getRevocationDate() {
        return this.b;
    }

    public void a(X509Extension x509Extension) {
        if (this.c == null) {
            this.c = new X509ExtensionSet();
        }
        this.c.a(x509Extension);
    }

    public X509ExtensionSet b() {
        return this.c;
    }

    public ArrayList<X509Extension> c() {
        return this.c != null ? this.c.b() : null;
    }

    public Map<ASN1ObjectID, X509Extension> d() {
        return this.c != null ? this.c.a() : null;
    }

    public X509Extension a(ASN1ObjectID aSN1ObjectID) {
        return this.c != null ? this.c.a(aSN1ObjectID) : null;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return Utils.toBytes(this);
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a();
    }

    @Override
    public boolean hasExtensions() {
        return this.c != null;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.c.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String string) {
        return this.c.getExtensionValue(string);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.c.getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.c.hasUnsupportedCriticalExtension();
    }

    @Override
    public String toString() {
        String string = "serialNo = " + this.a + ", revocationDate = " + this.b;
        if (this.c != null && this.c.c() > 0) {
            string = string + ", extensions = " + this.c;
        }
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.e();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new ASN1Integer(aSN1SequenceInputStream).c();
        this.b = new ASN1Date(aSN1SequenceInputStream).b();
        this.c = aSN1SequenceInputStream.a() ? new X509ExtensionSet(aSN1SequenceInputStream) : null;
        aSN1SequenceInputStream.b();
    }

    private void e() {
        this.d = null;
    }

    private ASN1Sequence f() {
        if (this.d == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(new ASN1Integer(this.a()));
            aSN1Sequence.a(new ASN1Date(this.getRevocationDate()));
            if (this.c != null && this.c.c() > 0) {
                aSN1Sequence.a(this.c);
            }
            this.d = aSN1Sequence;
        }
        return this.d;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.f().output(outputStream);
    }

    @Override
    public int length() {
        return this.f().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

