/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;", "Lorg/opensearch/action/ActionRequest;", "indices", "", "", "policyID", "indexType", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getIndices", "()Ljava/util/List;", "getPolicyID", "()Ljava/lang/String;", "getIndexType", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class AddPolicyRequest
extends ActionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> indices;
    @NotNull
    private final String policyID;
    @NotNull
    private final String indexType;
    @NotNull
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot add policy to more than one index name/pattern when using a custom index type";

    public AddPolicyRequest(@NotNull List<String> indices, @NotNull String policyID, @NotNull String indexType) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
        this.indices = indices;
        this.policyID = policyID;
        this.indexType = indexType;
    }

    @NotNull
    public final List<String> getIndices() {
        return this.indices;
    }

    @NotNull
    public final String getPolicyID() {
        return this.policyID;
    }

    @NotNull
    public final String getIndexType() {
        return this.indexType;
    }

    public AddPolicyRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        this(list, string, string2);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing indices", validationException);
        } else if (!Intrinsics.areEqual((Object)this.indexType, (Object)"_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indices);
        out.writeString(this.policyID);
        out.writeString(this.indexType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest$Companion;", "", "<init>", "()V", "MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

