/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.action.index.TransportIndexRollupAction;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001+BA\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u0016\u0010\"\u001a\n  *\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexManagementIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/IndexManagementIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getIndexManagementIndices", "()Lorg/opensearch/indexmanagement/IndexManagementIndices;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "IndexRollupHandler", "opensearch-index-management"})
public final class TransportIndexRollupAction
extends HandledTransportAction<IndexRollupRequest, IndexRollupResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final IndexManagementIndices indexManagementIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportIndexRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull IndexManagementIndices indexManagementIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexManagementIndices, (String)"indexManagementIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/index", transportService, actionFilters, IndexRollupRequest::new);
        this.client = client;
        this.indexManagementIndices = indexManagementIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportIndexRollupAction._init_$lambda$0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final IndexManagementIndices getIndexManagementIndices() {
        return this.indexManagementIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexRollupRequest request, @NotNull ActionListener<IndexRollupResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new IndexRollupHandler(this, this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda$0(TransportIndexRollupAction this$0, Boolean it) {
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction$IndexRollupHandler;", "", "client", "Lorg/opensearch/transport/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "request", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction;Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;Lorg/opensearch/commons/authuser/User;)V", "start", "", "onCreateMappingsResponse", "response", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "getRollup", "onGetRollup", "Lorg/opensearch/action/get/GetResponse;", "modifiedImmutableProperties", "", "", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "newRollup", "putRollup", "validateTargetIndexName", "", "opensearch-index-management"})
    public final class IndexRollupHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexRollupResponse> actionListener;
        @NotNull
        private final IndexRollupRequest request;
        @Nullable
        private final User user;
        final /* synthetic */ TransportIndexRollupAction this$0;

        public IndexRollupHandler(@NotNull TransportIndexRollupAction this$0, @NotNull Client client, @NotNull ActionListener<IndexRollupResponse> actionListener, @Nullable IndexRollupRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ IndexRollupHandler(TransportIndexRollupAction transportIndexRollupAction, Client client, ActionListener actionListener, IndexRollupRequest indexRollupRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
                user = SecurityUtils.Companion.buildUser(threadContext, indexRollupRequest.getRollup().getUser());
            }
            this(transportIndexRollupAction, client, (ActionListener<IndexRollupResponse>)actionListener, indexRollupRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            this.this$0.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportIndexRollupAction transportIndexRollupAction = this.this$0;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportIndexRollupAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"access$getFilterByEnabled$p(...)");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                IndexManagementIndices indexManagementIndices = transportIndexRollupAction.getIndexManagementIndices();
                ActionListener actionListener = ActionListener.wrap(this::onCreateMappingsResponse, arg_0 -> this.actionListener.onFailure(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)actionListener, (String)"wrap(...)");
                indexManagementIndices.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)actionListener);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onCreateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                this.this$0.log.info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                if (this.request.opType() == DocWriteRequest.OpType.CREATE) {
                    if (!this.validateTargetIndexName()) {
                        this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0])));
                        return;
                    }
                    this.putRollup();
                } else {
                    this.getRollup();
                }
            } else {
                String message = "Unable to create or update .opendistro-ism-config with newest mapping.";
                this.this$0.log.error(message);
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void getRollup() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getRollup().getId());
            this.client.get(getRequest, ActionListener.wrap(this::onGetRollup, arg_0 -> this.actionListener.onFailure(arg_0)));
        }

        private final void onGetRollup(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Rollup rollup2 = null;
            try {
                rollup2 = RollupUtilsKt.parseRollup(response2, this.this$0.getXContentRegistry());
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            User user = rollup2.getUser();
            Boolean bl = this.this$0.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, bl, "rollup", rollup2.getId(), this.actionListener)) {
                return;
            }
            List<String> modified = this.modifiedImmutableProperties(rollup2, this.request.getRollup());
            if (!((Collection)modified).isEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Not allowed to modify " + modified, RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            if (!this.validateTargetIndexName()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            this.putRollup();
        }

        private final List<String> modifiedImmutableProperties(Rollup rollup2, Rollup newRollup) {
            List modified = new ArrayList();
            if (rollup2.getContinuous() != newRollup.getContinuous()) {
                modified.add("continuous");
            }
            if (!Intrinsics.areEqual(rollup2.getDimensions(), newRollup.getDimensions())) {
                modified.add("dimensions");
            }
            if (!Intrinsics.areEqual(rollup2.getMetrics(), newRollup.getMetrics())) {
                modified.add("metrics");
            }
            if (!Intrinsics.areEqual((Object)rollup2.getSourceIndex(), (Object)newRollup.getSourceIndex())) {
                modified.add("source_index");
            }
            if (!Intrinsics.areEqual((Object)rollup2.getTargetIndex(), (Object)newRollup.getTargetIndex())) {
                modified.add("target_index");
            }
            return CollectionsKt.toList((Iterable)modified);
        }

        private final void putRollup() {
            Rollup rollup2 = Rollup.copy$default(this.request.getRollup(), null, 0L, 0L, false, IndexUtils.Companion.getIndexManagementConfigSchemaVersion(), null, null, null, null, null, null, null, null, null, 0, null, false, null, null, this.user, 524271, null);
            IndexRequest indexRequest = ((IndexRequest)this.request.index(".opendistro-ism-config")).id(this.request.getRollup().getId());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
            ToXContent.Params params = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
            indexRequest.source(rollup2.toXContent(xContentBuilder, params)).timeout(IndexRequest.DEFAULT_TIMEOUT);
            this.client.index((IndexRequest)this.request, (ActionListener)new ActionListener<IndexResponse>(this, rollup2){
                final /* synthetic */ IndexRollupHandler this$0;
                final /* synthetic */ Rollup $rollup;
                {
                    this.this$0 = $receiver;
                    this.$rollup = $rollup;
                }

                public void onResponse(IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (response2.getShardInfo().getFailed() > 0) {
                        ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"getFailures(...)");
                        String failureReasons = ArraysKt.joinToString$default((Object[])failureArray, (CharSequence)", ", null, null, (int)0, null, putRollup.1::onResponse$lambda$0, (int)30, null);
                        IndexRollupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)new OpenSearchStatusException(failureReasons, response2.status(), new Object[0])));
                    } else {
                        RestStatus status = IndexRollupHandler.access$getRequest$p(this.this$0).opType() == DocWriteRequest.OpType.CREATE ? RestStatus.CREATED : RestStatus.OK;
                        ActionListener actionListener = IndexRollupHandler.access$getActionListener$p(this.this$0);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        actionListener.onResponse((Object)((Object)new IndexRollupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), status, Rollup.copy$default(this.$rollup, null, response2.getSeqNo(), response2.getPrimaryTerm(), false, 0L, null, null, null, null, null, null, null, null, null, 0, null, false, null, null, null, 1048569, null))));
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexRollupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }

                private static final CharSequence onResponse$lambda$0(ReplicationResponse.ShardInfo.Failure it) {
                    String string = it.reason();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reason(...)");
                    return string;
                }
            });
        }

        private final boolean validateTargetIndexName() {
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(this.request.getRollup(), this.request.getRollup().getTargetIndex());
            return !StringsKt.contains$default((CharSequence)targetIndexResolvedName, (CharSequence)"*", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)targetIndexResolvedName, (CharSequence)"?", (boolean)false, (int)2, null);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexRollupHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ IndexRollupRequest access$getRequest$p(IndexRollupHandler $this) {
            return $this.request;
        }
    }
}

