/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.locks;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.tree.EnhancedTreeCellRenderer;

public class LockContentionTreeCellRenderer
extends EnhancedTreeCellRenderer {
    @Override
    protected String getLabel1Text(Object node, String value) {
        LockCCTNode n = (LockCCTNode)node;
        String name = n.getNodeName();
        if (n.isThreadLockNode()) {
            return n.getParent().getParent() == null ? "" : name;
        }
        int bracketIndex = name.indexOf(40);
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return name;
        }
        if (bracketIndex != -1) {
            name = name.substring(0, bracketIndex);
            dotIndex = name.lastIndexOf(46);
        }
        return name.substring(0, dotIndex + 1);
    }

    @Override
    protected String getLabel2Text(Object node, String value) {
        LockCCTNode n = (LockCCTNode)node;
        String name = n.getNodeName();
        if (n.isThreadLockNode()) {
            return n.getParent().getParent() == null ? name : "";
        }
        int bracketIndex = name.indexOf(40);
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1 && bracketIndex == -1) {
            return "";
        }
        if (bracketIndex != -1) {
            name = name.substring(0, bracketIndex);
            dotIndex = name.lastIndexOf(46);
        }
        return name.substring(dotIndex + 1);
    }

    @Override
    protected String getLabel3Text(Object node, String value) {
        LockCCTNode n = (LockCCTNode)node;
        if (n.isThreadLockNode()) {
            return "";
        }
        String name = n.getNodeName();
        int bracketIndex = name.indexOf(40);
        return bracketIndex != -1 ? " " + name.substring(bracketIndex) : "";
    }

    private Icon getIcon(Object node) {
        LockCCTNode n = (LockCCTNode)node;
        if (n.isThreadLockNode()) {
            return Icons.getIcon((String)"ProfilerIcons.Thread");
        }
        if (n.isMonitorNode()) {
            return Icons.getIcon((String)"ProfilerIcons.WindowLocks");
        }
        return null;
    }

    @Override
    protected Icon getLeafIcon(Object value) {
        return this.getIcon(value);
    }

    @Override
    protected Icon getOpenIcon(Object value) {
        return this.getIcon(value);
    }

    @Override
    protected Icon getClosedIcon(Object value) {
        return this.getIcon(value);
    }

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        LockContentionTreeCellRenderer renderer = new LockContentionTreeCellRenderer();
        return renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }
}

