"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const language_service_1 = require("@volar/language-service");
const featureWorkers_1 = require("@volar/language-service/lib/utils/featureWorkers");
function register(htmlLs) {
    return (pugDoc, pos) => {
        for (const htmlPos of (0, featureWorkers_1.getGeneratedPositions)(pugDoc.docs, pos)) {
            const htmlResult = htmlLs.findDocumentHighlights(pugDoc.docs[1], htmlPos, pugDoc.htmlDocument);
            return (0, language_service_1.transformLocations)(htmlResult, htmlRange => (0, featureWorkers_1.getSourceRange)(pugDoc.docs, htmlRange));
        }
    };
}
//# sourceMappingURL=documentHighlight.js.map