/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.ancestorstatistics;

import ancestris.core.actions.AncestrisAPIEntry;
import ancestris.modules.commonAncestor.CommonAncestorTree;
import ancestris.modules.gedcom.consanguinity.ComputeConsanguinity;
import ancestris.modules.gedcom.consanguinity.ConsanguiniteInfo;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.SimpleColorsOptions;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ReportAncestorStatistics
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public boolean displayMostRecentOnly = true;
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private Document doc;
    private final List<GenerationInfo> generationInfoList = new ArrayList<GenerationInfo>();
    private int coverageGen;
    private double dImplexFactor;
    private final Set<String> ancestorIDsList = new HashSet<String>();
    private final Map<Indi, DuplicateAncestor> duplicateAncestors = new HashMap<Indi, DuplicateAncestor>();
    private final Set<Indi> seenDuplicates = new HashSet<Indi>();
    private final List<ConsanguiniteInfo> commonConsanguinityList = new ArrayList<ConsanguiniteInfo>();
    private double dConsanguinityFactor;
    private final Map<Indi, List<CommonFamily>> consangIndi2CommonFamilies = new HashMap<Indi, List<CommonFamily>>();

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public Document start(Indi indi) {
        return this.main(indi);
    }

    Document main(Indi indi) {
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), this.colors.getTextColor(), this.colors.getBackgroundColor());
        String title = this.translate("title", new Object[]{indi.getName()});
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, false);
        }
        this.clearStats();
        this.computeImplexFactor(indi);
        this.computeConsanguinityFactor(indi);
        if (this.dConsanguinityFactor == -1.0) {
            return null;
        }
        int sectionSize = this.formattingOptions.common.getTextSize() + 2;
        String sectionAttr = ",text-align=left, space-before=1cm, space-after=0.5cm";
        this.doc.startSection(this.translate("section.summary"), "", 1, false, true, "font-size=" + sectionSize + sectionAttr);
        this.printSummary(indi);
        this.doc.startSection(this.translate("section.generationTable"), "", 1, this.formattingOptions.generatePageBreak, true, "font-size=" + sectionSize + sectionAttr);
        this.printGenerationTable();
        this.doc.startSection(this.translate("section.consanguinity"), "", 1, this.formattingOptions.generatePageBreak, true, "font-size=" + sectionSize + sectionAttr);
        this.printConsanguinityStats(indi);
        return this.doc;
    }

    private void printSummary(Indi indi) {
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("root_individual") + ":");
        this.doc.addText("\u00a0");
        this.doc.addText(indi.toString(), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("covered_gens") + ": " + String.valueOf(this.generationInfoList.size()));
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("coverage_gen", new Object[]{this.coverageGen}));
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("implex_factor", new Object[]{this.generationInfoList.size()}) + ":");
        this.doc.addText("\u00a0");
        this.doc.addText(String.valueOf(this.dImplexFactor) + "%", "font-weight=bold");
        this.doc.addText(" (" + this.translate("implexFactorComment") + ").");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("consanguinity_factor") + ":");
        this.doc.addText("\u00a0");
        this.doc.addText(String.format("%.6f", this.dConsanguinityFactor), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("nb_consanguineous_ancestors") + ": " + String.valueOf(this.commonConsanguinityList.size()));
        this.doc.nextParagraph();
        this.doc.addText("\u00a0");
        this.doc.nextParagraph();
        this.doc.addText(this.translate("definitions"), "font-style=italic");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("footer_info1"), "font-style=italic");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("footer_info2"), "font-style=italic");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("footer_info3"), "font-style=italic");
    }

    private void printGenerationTable() {
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String borderLeft = "border-style=dotted, border-width=0, border-color=" + textColor;
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=0cm, border-color=" + textColor);
        this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() - 1) + ", text-align=center, font-weight=bold, background-color=" + header_row, "display-align=center");
        this.doc.addText(this.translate("header_implex_generation"));
        this.doc.nextTableCell(borderLeft + ",display-align=center");
        this.doc.addText(this.translate("header_implex_possible"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_implex_known"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_implex_known_percent"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_implex_cumul"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_implex_cumul_percent"));
        this.doc.nextTableCell(borderLeft);
        this.doc.addText(this.translate("header_implex_diff"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_implex_implex"));
        DecimalFormat formatter = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        symbols.setGroupingSeparator(' ');
        formatter.setDecimalFormatSymbols(symbols);
        formatter.setGroupingUsed(true);
        formatter.setGroupingSize(3);
        formatter.applyPattern("#,###,###,###");
        if (!this.generationInfoList.isEmpty()) {
            int row = 0;
            for (GenerationInfo info : this.generationInfoList) {
                String bgColor = row % 2 == 0 ? even_row : odd_row;
                ++row;
                this.doc.nextTableRow("text-align=center, background-color=" + bgColor);
                this.doc.addText(String.valueOf(info.iLevel));
                this.doc.nextTableCell(borderLeft);
                this.doc.addText(formatter.format(info.iPossibleCount));
                this.doc.nextTableCell();
                this.doc.addText(formatter.format(info.iKnownCount));
                this.doc.nextTableCell();
                this.doc.addText(String.valueOf(info.dCoverage) + "%");
                this.doc.nextTableCell();
                this.doc.addText(formatter.format(info.iKnownCumul));
                this.doc.nextTableCell();
                this.doc.addText(String.valueOf(info.dCoverageCumul) + "%");
                this.doc.nextTableCell(borderLeft);
                this.doc.addText(formatter.format(info.iDuplicateCount));
                this.doc.nextTableCell();
                this.doc.addText(String.valueOf(info.dImplex) + "%");
            }
        } else {
            this.doc.nextTableRow("text-align=left, background-color=" + even_row, "text-align=center, number-columns-spanned=8");
            this.doc.addText(this.translate("none"));
        }
        this.doc.endTable();
        this.doc.nextParagraph("space-before=0.8cm");
        this.doc.addText(this.translate("header_implex_duplicate"), "font-weight=bold");
        this.doc.nextParagraph("space-after=0.5cm");
        if (this.displayMostRecentOnly) {
            this.doc.addText(this.translate("header_implex_duplicate_filter", new Object[]{this.duplicateAncestors.size()}));
        } else {
            this.doc.addText(this.translate("header_implex_duplicate_note", new Object[]{this.duplicateAncestors.size()}));
        }
        if (!this.duplicateAncestors.isEmpty()) {
            this.doc.startList();
            int gen = 0;
            boolean started = false;
            ArrayList<Indi> keys = new ArrayList<Indi>(this.duplicateAncestors.keySet());
            Collections.sort(keys, (o1, o2) -> {
                int diff = this.duplicateAncestors.get(o1).compareTo(this.duplicateAncestors.get(o2));
                return diff == 0 ? o1.getName().compareTo(o2.getName()) : diff;
            });
            for (Indi ancestor : keys) {
                DuplicateAncestor dupAncestor = this.duplicateAncestors.get(ancestor);
                if (this.displayMostRecentOnly && !dupAncestor.isMostRecent) continue;
                if (dupAncestor.gen != gen) {
                    gen = dupAncestor.gen;
                    if (started) {
                        this.doc.endList();
                    } else {
                        started = true;
                    }
                    this.doc.nextParagraph("space-before=0.2cm");
                    this.doc.nextListItem();
                    this.doc.addText(this.translate("generation", new Object[]{gen}));
                    this.doc.startList();
                }
                this.doc.nextListItem();
                String style = dupAncestor.isMostRecent ? "font-weight=bold" : "";
                this.doc.addText(ancestor.toString(false) + " ", style);
                this.doc.addLink("(" + ancestor.getId() + ")", ancestor.getLinkAnchor(), style);
            }
            this.doc.endList();
            this.doc.endList();
        } else {
            this.doc.nextParagraph();
            this.doc.addText("\u2219");
            this.doc.addText("\u00a0");
            this.doc.addText(this.translate("none"));
        }
    }

    private void printConsanguinityStats(Indi indi) {
        this.doc.nextParagraph("space-before=0cm");
        this.doc.addText(this.translate("header_consang_note", new Object[]{this.commonConsanguinityList.size()}), "font-weight=bold");
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=0.6cm, border-color=" + textColor);
        this.doc.addTableColumn("column-width=3%");
        this.doc.addTableColumn("column-width=22%");
        this.doc.addTableColumn("column-width=8%");
        this.doc.addTableColumn("column-width=25%");
        this.doc.addTableColumn("column-width=8%");
        this.doc.addTableColumn("column-width=34%");
        this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() - 1) + ", text-align=center, font-weight=bold, background-color=" + header_row, "display-align=center");
        this.doc.addText(this.translate("header_consang_generation"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_consang_indi"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_consang_coeff"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_consang_parents"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_consang_degree"));
        this.doc.nextTableCell("display-align=center");
        this.doc.addText(this.translate("header_consang_ancestors"));
        if (!this.commonConsanguinityList.isEmpty()) {
            int row = 0;
            Collections.reverse(this.commonConsanguinityList);
            for (ConsanguiniteInfo info : this.commonConsanguinityList) {
                Object bullet;
                String bgColor = row % 2 == 0 ? even_row : odd_row;
                ++row;
                this.doc.nextTableRow("text-align=left, background-color=" + bgColor, "text-align=center");
                this.doc.addText(String.valueOf(info.getGeneration() + 1));
                this.doc.nextTableCell();
                this.printEntity(this.doc, (Entity)info.getIndi(), "");
                this.doc.addText("\u00a0");
                this.printGraphLink(this.doc, (Entity)info.getIndi());
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(String.format("%.6f", Float.valueOf(info.getCoefficient())));
                this.doc.nextTableCell();
                this.doc.startList();
                this.doc.nextListItem("space-after=0.4cm");
                this.printEntity(this.doc, (Entity)info.getFather(), "");
                this.doc.nextListItem("space-after=0.4cm");
                this.printEntity(this.doc, (Entity)info.getMother(), "");
                this.doc.endList();
                this.doc.nextTableCell("text-align=center");
                this.doc.startList();
                List<CommonFamily> commonFamilies = this.consangIndi2CommonFamilies.get(info.getIndi());
                int i = 1;
                for (CommonFamily commonFamily : commonFamilies) {
                    bullet = commonFamilies.size() == 1 ? "\u00a0" : "(" + i + ")";
                    this.doc.nextListItem("genj:label=" + (String)bullet + ", space-after=0.4cm");
                    this.doc.addText(commonFamily.degree);
                    ++i;
                }
                this.doc.endList();
                this.doc.nextTableCell();
                this.doc.startList();
                i = 1;
                for (CommonFamily commonFamily : commonFamilies) {
                    bullet = commonFamilies.size() == 1 ? "\u00a0" : "(" + i + ")";
                    this.doc.nextListItem("genj:label=" + (String)bullet + ", space-after=0.4cm");
                    this.printEntity(this.doc, (Entity)commonFamily.family, "");
                    ++i;
                }
                this.doc.endList();
            }
        } else {
            this.doc.nextTableRow("text-align=left, background-color=" + even_row, "text-align=center, number-columns-spanned=6");
            this.doc.addText(this.translate("none"));
        }
        this.doc.endTable();
        this.doc.nextParagraph();
        this.doc.addText("\u00a0");
        this.doc.nextParagraph();
        this.doc.addText(this.translate("definitions"), "font-style=italic");
        this.doc.nextParagraph();
        this.doc.addText("\u2219");
        this.doc.addText("\u00a0");
        this.doc.addText(this.translate("footer_info4"), "font-style=italic");
        this.println("");
        this.println(this.translate("printing_completed"));
    }

    private void printEntity(Document doc, Entity entity, String style) {
        doc.addText(entity.toString(false) + " ", style);
        doc.addLink("(" + entity.getId() + ")", entity.getLinkAnchor());
    }

    private void printGraphLink(Document doc, Entity entity) {
        String buttonName = this.translate("graphButtonName");
        String fontSize = String.valueOf(this.formattingOptions.common.getTextSize() - 2);
        String bgColor = this.colors.getHeaderRowColor();
        doc.addText("  ");
        doc.addLink("[ " + buttonName + " ]", AncestrisAPIEntry.Factory.getAnchor((String)"ancestris.modules.views.graph", (String)"ancestors", (Entity)entity), "font-size=" + fontSize + ", background-color=" + bgColor);
        doc.addText("  ");
    }

    private void clearStats() {
        this.coverageGen = 0;
        this.dImplexFactor = 0.0;
        this.generationInfoList.clear();
        this.ancestorIDsList.clear();
        this.duplicateAncestors.clear();
        this.seenDuplicates.clear();
        this.dConsanguinityFactor = 0.0;
        this.commonConsanguinityList.clear();
        this.consangIndi2CommonFamilies.clear();
    }

    private void computeImplexFactor(Indi indi) {
        ArrayList<Indi> listIndi = new ArrayList<Indi>();
        listIndi.add(indi);
        this.println("");
        this.println(this.translate("computing_generations"));
        int iLevel = 1;
        while (!listIndi.isEmpty()) {
            this.println(this.translate("generation", new Object[]{iLevel}));
            ArrayList<Indi> listParent = new ArrayList<Indi>();
            this.computeGeneration(iLevel, listIndi, listParent);
            listIndi = listParent;
            ++iLevel;
        }
        BigInteger iPossibleCumul = BigInteger.ZERO;
        BigInteger iKnownCumul = BigInteger.ZERO;
        BigInteger iDuplicateCumul = BigInteger.ZERO;
        this.coverageGen = 0;
        for (GenerationInfo info : this.generationInfoList) {
            info.iPossibleCount = BigInteger.ONE.shiftLeft(info.iLevel - 1);
            iPossibleCumul = iPossibleCumul.add(info.iPossibleCount);
            iKnownCumul = iKnownCumul.add(info.iKnownCount);
            iDuplicateCumul = iDuplicateCumul.add(info.iDuplicateCount);
            info.iPossibleCumul = iPossibleCumul;
            info.iKnownCumul = iKnownCumul;
            info.iDuplicateCumul = iDuplicateCumul;
            info.dCoverage = this.ratioOf(info.iKnownCount, info.iPossibleCount);
            info.dCoverageCumul = this.ratioOf(info.iKnownCumul, info.iPossibleCumul);
            if (info.iKnownCumul.equals(info.iPossibleCumul)) {
                this.coverageGen = info.iLevel;
            }
            if (iKnownCumul.compareTo(BigInteger.ZERO) <= 0) continue;
            this.dImplexFactor = info.dImplex = this.ratioOf(info.iDuplicateCumul, info.iKnownCumul);
        }
    }

    private double ratioOf(BigInteger big1, BigInteger big2) {
        return BigInteger.TEN.multiply(BigInteger.TEN).multiply(BigInteger.TEN).multiply(BigInteger.TEN).multiply(big1).divide(big2).doubleValue() / 100.0;
    }

    private void computeGeneration(int iLevel, List<Indi> listIndi, List<Indi> listParent) {
        GenerationInfo info = new GenerationInfo(iLevel);
        this.generationInfoList.add(info);
        for (Indi ancestor : listIndi) {
            Indi indiWife;
            String ancestorID = ancestor.getId();
            if (this.ancestorIDsList.contains(ancestorID)) {
                DuplicateAncestor dupAncestor;
                boolean first;
                boolean bl = first = !this.seenDuplicates.contains(ancestor);
                if (first) {
                    this.addDuplicateAncestor(ancestor);
                }
                if ((dupAncestor = this.duplicateAncestors.get(ancestor)) == null) {
                    dupAncestor = new DuplicateAncestor(iLevel, first);
                    this.duplicateAncestors.put(ancestor, dupAncestor);
                }
                info.iDuplicateCount = info.iDuplicateCount.add(BigInteger.ONE);
            } else {
                this.ancestorIDsList.add(ancestorID);
            }
            info.iKnownCount = info.iKnownCount.add(BigInteger.ONE);
            Fam famc = ancestor.getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi indiHusband = famc.getHusband();
            if (indiHusband != null) {
                listParent.add(indiHusband);
            }
            if ((indiWife = famc.getWife()) == null) continue;
            listParent.add(indiWife);
        }
    }

    private void addDuplicateAncestor(Indi indi) {
        if (indi == null) {
            return;
        }
        if (!this.seenDuplicates.contains(indi)) {
            this.seenDuplicates.add(indi);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                this.addDuplicateAncestor(famc.getWife());
                this.addDuplicateAncestor(famc.getHusband());
            }
        }
    }

    private void computeConsanguinityFactor(Indi indi) {
        this.println("");
        this.println(this.translate("computing_consanguinity"));
        ComputeConsanguinity calculation = new ComputeConsanguinity(indi);
        this.dConsanguinityFactor = calculation.compute();
        if (this.dConsanguinityFactor != -1.0) {
            this.commonConsanguinityList.addAll(calculation.getCoefficientNotNul());
            this.println("");
            this.println(this.translate("computing_common_ancestors"));
            this.calculateCommonAncestors();
        } else {
            this.println(this.translate("loop_error", new Object[]{((ConsanguiniteInfo)calculation.getPotentialLoop().get()).getIndi()}));
        }
        this.println("");
        this.println(this.translate("calculations_completed"));
    }

    private void calculateCommonAncestors() {
        int i = 1;
        int total = this.commonConsanguinityList.size();
        for (ConsanguiniteInfo info : this.commonConsanguinityList) {
            this.println(this.translate("common_ancestors_compute", new Object[]{i, total}));
            ++i;
            List<CommonFamily> commonFamilies = this.consangIndi2CommonFamilies.get(info.getIndi());
            if (commonFamilies == null) {
                commonFamilies = new ArrayList<CommonFamily>();
                this.consangIndi2CommonFamilies.put(info.getIndi(), commonFamilies);
            }
            CommonAncestorTree commonAncestorTree = new CommonAncestorTree();
            Set fams = commonAncestorTree.findCommonAncestors(info.getFather(), info.getMother());
            for (Fam fam : fams) {
                String degree = commonAncestorTree.getRelationshipDegree(info.getFather(), info.getMother(), fam, 0);
                CommonFamily commonFamily = new CommonFamily(fam, degree);
                commonFamilies.add(commonFamily);
            }
        }
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public boolean generatePageBreak = true;
    }

    private class GenerationInfo {
        int iLevel;
        BigInteger iPossibleCount = BigInteger.ZERO;
        BigInteger iKnownCount = BigInteger.ZERO;
        BigInteger iDuplicateCount = BigInteger.ZERO;
        BigInteger iPossibleCumul = BigInteger.ZERO;
        BigInteger iKnownCumul = BigInteger.ZERO;
        BigInteger iDuplicateCumul = BigInteger.ZERO;
        double dCoverage;
        double dCoverageCumul;
        double dImplex;

        GenerationInfo(int iLevel) {
            this.iLevel = iLevel;
        }
    }

    private class DuplicateAncestor
    implements Comparable<DuplicateAncestor> {
        private int gen;
        private boolean isMostRecent;

        DuplicateAncestor(int gen, boolean isMostRecent) {
            this.gen = gen;
            this.isMostRecent = isMostRecent;
        }

        @Override
        public int compareTo(DuplicateAncestor o) {
            return Integer.compare(this.gen, o.gen);
        }
    }

    private class CommonFamily {
        private Fam family;
        private String degree;

        CommonFamily(Fam family, String degree) {
            this.family = family;
            this.degree = degree;
        }
    }
}

