/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.dashboard.Bundle;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

final class WidgetComponents {
    private WidgetComponents() {
    }

    static JComponent titleComponentFor(String title) {
        MultiLineText text = new MultiLineText(title);
        Font font = text.getFont();
        text.setFont(font.deriveFont((float)font.getSize() * 1.4f));
        return text;
    }

    static JComponent componentFor(WidgetElement element) {
        if (element instanceof WidgetElement.TextElement) {
            WidgetElement.TextElement textElement = (WidgetElement.TextElement)element;
            return WidgetComponents.componentForText(textElement);
        }
        if (element instanceof WidgetElement.ImageElement) {
            WidgetElement.ImageElement imageElement = (WidgetElement.ImageElement)element;
            return WidgetComponents.componentForImage(imageElement);
        }
        if (element instanceof WidgetElement.ActionElement) {
            WidgetElement.ActionElement actionElement = (WidgetElement.ActionElement)element;
            return WidgetComponents.componentForAction(actionElement);
        }
        if (element instanceof WidgetElement.LinkElement) {
            WidgetElement.LinkElement linkElement = (WidgetElement.LinkElement)element;
            return WidgetComponents.componentForLink(linkElement);
        }
        if (element instanceof WidgetElement.SeparatorElement) {
            WidgetElement.SeparatorElement sepElement = (WidgetElement.SeparatorElement)element;
            return WidgetComponents.componentForSeparator(sepElement);
        }
        if (element instanceof WidgetElement.ComponentElement) {
            WidgetElement.ComponentElement cmpElement = (WidgetElement.ComponentElement)element;
            return cmpElement.component();
        }
        return null;
    }

    private static JComponent componentForText(WidgetElement.TextElement element) {
        MultiLineText text = new MultiLineText(element.text());
        WidgetElement.TextElement.Kind kind = element.kind();
        if (kind == WidgetElement.TextElement.Kind.SUBHEADING) {
            Font font = text.getFont();
            text.setFont(font.deriveFont((float)font.getSize() * 1.1f));
        } else if (kind == WidgetElement.TextElement.Kind.ASIDE || kind == WidgetElement.TextElement.Kind.UNAVAILABLE) {
            Font font = text.getFont();
            text.setFont(font.deriveFont((float)font.getSize() * 0.9f));
            Color color = UIManager.getColor("controlDkShadow");
            if (color != null) {
                text.setForeground(color);
            }
        }
        return text;
    }

    private static JComponent componentForImage(WidgetElement.ImageElement element) {
        Image image = ImageUtilities.loadImage((String)element.resourcePath(), (boolean)true);
        Icon icon = ImageUtilities.image2Icon((Image)image);
        JLabel label = new JLabel(icon);
        label.setMinimumSize(new Dimension(0, 0));
        return label;
    }

    private static JComponent componentForAction(WidgetElement.ActionElement element) {
        if (element.asLink()) {
            return new LinkButton(element.action(), element.showIcon());
        }
        return new WidgetButton(element.action(), element.showIcon());
    }

    private static JComponent componentForLink(WidgetElement.LinkElement element) {
        URIOpenAction action = new URIOpenAction(element.text(), element.link());
        if (element.asButton()) {
            return new WidgetButton(action, false);
        }
        return new LinkButton(action, false);
    }

    private static JComponent componentForSeparator(WidgetElement.SeparatorElement element) {
        JSeparator sep = new JSeparator();
        sep.setPreferredSize(new Dimension(75, 8));
        return sep;
    }

    private static class MultiLineText
    extends JTextArea {
        private MultiLineText(String text) {
            super(text);
            Color labelColor;
            this.setEditable(false);
            this.setCursor(null);
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setMargin(new Insets(0, 0, 0, 0));
            Font labelFont = UIManager.getFont("Label.font");
            if (labelFont != null) {
                this.setFont(labelFont);
            }
            if ((labelColor = UIManager.getColor("Label.foreground")) != null) {
                this.setForeground(labelColor);
            }
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
        }
    }

    private static class LinkButton
    extends AbstractWidgetButton {
        private final Color linkColor;
        private final Color hoverLinkColor;
        private boolean rollover;

        private LinkButton(Action action, boolean allowIcon) {
            super(action, allowIcon);
            Color link = UIManager.getColor("nb.html.link.foreground");
            if (link != null) {
                this.linkColor = link;
                Color hover = UIManager.getColor("nb.html.link.foreground.hover");
                this.hoverLinkColor = hover == null ? this.linkColor : hover;
            } else {
                this.hoverLinkColor = this.linkColor = new Color(1461115);
            }
            this.setContentAreaFilled(false);
            this.setBorder(new LinkBorder());
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setForeground(this.linkColor);
        }

        @Override
        void onMouseEnter() {
            super.onMouseEnter();
            this.setForeground(this.hoverLinkColor);
            this.rollover = true;
            this.repaint();
        }

        @Override
        void onMouseExit() {
            super.onMouseExit();
            this.setForeground(this.linkColor);
            this.rollover = false;
            this.repaint();
        }

        private class LinkBorder
        implements Border {
            private LinkBorder() {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 1, 1, 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (LinkButton.this.rollover) {
                    int iconWidth;
                    String text = LinkButton.this.getText();
                    if (text.isEmpty()) {
                        return;
                    }
                    g.setColor(LinkButton.this.getForeground());
                    Font font = LinkButton.this.getFont();
                    FontMetrics metrics = LinkButton.this.getFontMetrics(font);
                    Icon icon = LinkButton.this.getIcon();
                    int x1 = iconWidth = icon == null ? 0 : icon.getIconWidth() + LinkButton.this.getIconTextGap();
                    int x2 = metrics.stringWidth(text) + iconWidth;
                    int y1 = metrics.getHeight();
                    g.drawLine(x1, y1, x2, y1);
                }
            }
        }
    }

    private static class WidgetButton
    extends AbstractWidgetButton {
        private final Color linkColor;
        private final Color hoverLinkColor;
        private final Color backgroundColor;
        private final Border border;
        private final Border hoverBorder;
        private boolean rollover;

        private WidgetButton(Action action, boolean allowIcon) {
            super(action, allowIcon);
            Color link = UIManager.getColor("nb.html.link.foreground");
            if (link != null) {
                this.linkColor = link;
                Color hover = UIManager.getColor("nb.html.link.foreground.hover");
                this.hoverLinkColor = hover == null ? this.linkColor : hover;
            } else {
                this.hoverLinkColor = this.linkColor = new Color(1461115);
            }
            Color bg = UIManager.getColor("Panel.background");
            if (bg == null) {
                bg = this.getBackground();
            }
            this.backgroundColor = bg;
            Border padding = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            this.border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.linkColor), padding);
            this.hoverBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.hoverLinkColor), padding);
            this.setForeground(this.linkColor);
            this.setContentAreaFilled(false);
            this.setBorder(this.border);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        void onMouseEnter() {
            super.onMouseEnter();
            this.setForeground(new Color(this.backgroundColor.getRGB()));
            this.rollover = true;
            this.setBorder(this.hoverBorder);
            this.repaint();
        }

        @Override
        void onMouseExit() {
            super.onMouseExit();
            this.setForeground(this.linkColor);
            this.rollover = false;
            this.setBorder(this.border);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.rollover) {
                Color c = g.getColor();
                g.setColor(this.linkColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(c);
            }
            super.paintComponent(g);
        }
    }

    private static class URIOpenAction
    extends AbstractAction {
        private final String text;
        private final URI uri;

        private URIOpenAction(String text, URI uri) {
            super(text);
            this.text = text;
            this.uri = uri;
            this.putValue("ShortDescription", Bundle.TXT_statusLink(uri));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURLExternal(this.uri.toURL());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static abstract class AbstractWidgetButton
    extends JButton {
        private final boolean allowIcon;

        private AbstractWidgetButton(Action action, boolean allowIcon) {
            super(action);
            this.allowIcon = allowIcon;
            if (!allowIcon) {
                this.setIcon(null);
            }
            this.setHorizontalAlignment(2);
            this.setToolTipText(null);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.onMouseEnter();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.onMouseExit();
                }
            });
        }

        void onMouseEnter() {
            Object status;
            Action action = this.getAction();
            if (action != null && (status = action.getValue("ShortDescription")) instanceof String) {
                String statusText = (String)status;
                StatusDisplayer.getDefault().setStatusText(statusText);
            }
        }

        void onMouseExit() {
            StatusDisplayer.getDefault().setStatusText("");
        }

        @Override
        protected void actionPropertyChanged(Action action, String propertyName) {
            if (this.allowedPropertyChange(propertyName)) {
                super.actionPropertyChanged(action, propertyName);
            }
        }

        private boolean allowedPropertyChange(String propertyName) {
            return switch (propertyName) {
                case "SmallIcon" -> this.allowIcon;
                case "SwingLargeIconKey" -> this.allowIcon;
                case "ShortDescription" -> false;
                case "LongDescription" -> false;
                default -> true;
            };
        }
    }
}

