/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.editors;

import ancestris.app.ErrorPanel;
import ancestris.gedcom.privacy.standard.PrivacyPolicyImpl;
import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.beans.ImageBean;
import ancestris.modules.editors.aries.beans.SexBean;
import ancestris.modules.editors.aries.editors.EntityEditor;
import ancestris.modules.editors.aries.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.aries.models.EventsListModel;
import ancestris.modules.editors.aries.panels.AliasTablePanel;
import ancestris.modules.editors.aries.panels.AssociationsTablePanel;
import ancestris.modules.editors.aries.panels.FamiliesReferenceTreeTablePanel;
import ancestris.modules.editors.aries.panels.IndividualEventPanel;
import ancestris.modules.editors.aries.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.aries.panels.NameEditorPanel;
import ancestris.modules.editors.aries.panels.NamesTablePanel;
import ancestris.modules.editors.aries.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.aries.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import ancestris.modules.gedcom.searchdupes.DuplicatesFinder;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAlias;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertySex;
import genj.io.InputSource;
import genj.util.Registry;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class IndividualEditor
extends EntityEditor {
    private Context context;
    private Context selectedEventContext;
    private Indi mIndividual;
    private PrivacyPolicyImpl privacyPolicy = new PrivacyPolicyImpl();
    private Property mEvent = null;
    private Property mMultiMediaObject;
    private boolean updateOnGoing = false;
    private final EventsListModel mEventsListModel = new EventsListModel();
    private boolean changeListInProgress = false;
    private static final ArrayList<String> INDIVIDUAL_EVENT_TAGS = new ArrayList<String>(){
        {
            this.add("BIRT");
            this.add("CHR");
            this.add("DEAT");
            this.add("BURI");
            this.add("CREM");
            this.add("ADOP");
            this.add("BAPM");
            this.add("BARM");
            this.add("BASM");
            this.add("BLES");
            this.add("CHRA");
            this.add("CONF");
            this.add("FCOM");
            this.add("ORDN");
            this.add("NATU");
            this.add("EMIG");
            this.add("IMMI");
            this.add("CENS");
            this.add("PROB");
            this.add("WILL");
            this.add("GRAD");
            this.add("RETI");
            this.add("EVEN");
            this.add("CAST");
            this.add("DSCR");
            this.add("EDUC");
            this.add("IDNO");
            this.add("NATI");
            this.add("NCHI");
            this.add("NMR");
            this.add("OCCU");
            this.add("PROP");
            this.add("RELI");
            this.add("RESI");
            this.add("SSN");
            this.add("TITL");
            this.add("FACT");
        }
    };
    private DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel<String>(new String[0]);
    private NamesTablePanel namesTablePanel;
    private Registry registry = null;
    private JLabel SOSALabel;
    private JTextField SOSATextField;
    private AliasTablePanel aliasTablePanel;
    private JPanel associationsPanel;
    private AssociationsTablePanel associationsTablePanel;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JButton deleteEventButton;
    private JComboBox<String> eventTypeComboBox;
    private JList<String> eventsList;
    private JPanel eventsListPanel;
    private JPanel eventsPanel;
    private JSplitPane eventsSplitPane;
    private JPanel familiesChildPanel;
    private FamiliesReferenceTreeTablePanel familiesChildTreeTablePanel;
    private JPanel familiesSpousePanel;
    private FamiliesReferenceTreeTablePanel familiesSpouseTreeTablePanel;
    private JPanel galleryPanel;
    private JPanel generalPanel;
    private ImageBean imageBean;
    private IndividualEventPanel individualEventEditorPanel;
    private JLabel individualIDLabel;
    private JTextField individualIDTextField;
    private JTabbedPane individualInformationTabbedPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NameEditorPanel nameEditorPanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JToggleButton privateRecordToggleButton;
    private SexBean sexBeanPanel;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;

    public IndividualEditor() {
        this(false);
    }

    public IndividualEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.selectedEventContext = null;
        this.eventsList.getSelectionModel().addListSelectionListener(new EventsListSelectionHandler());
        this.individualEventEditorPanel.setVisible(false);
        this.nameEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.individualEventEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.familiesChildTreeTablePanel.addChangeListener((ChangeListener)this.changes);
        this.familiesSpouseTreeTablePanel.addChangeListener((ChangeListener)this.changes);
        this.sourceCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.aliasTablePanel.addChangeListener((ChangeListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.associationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.multimediaObjectCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.sexBeanPanel.addChangeListener((ChangeListener)this.changes);
        this.privateRecordToggleButton.addActionListener((ActionListener)this.changes);
        JTabbedPane nameEditorTabbedPane = this.nameEditorPanel.getNameEditorTabbedPane();
        this.namesTablePanel = new NamesTablePanel();
        nameEditorTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.namesTablePanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/names.png")), this.namesTablePanel);
        JComboBox.KeySelectionManager manager = (aKey, aModel) -> {
            System.out.println(aKey);
            return -1;
        };
        this.eventTypeComboBox.setKeySelectionManager(manager);
        this.eventTypeComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.registry = Registry.get(((Object)((Object)this)).getClass());
        this.eventsSplitPane.setDividerLocation(this.registry.get("ariesindieventSplitDividerLocation", this.eventsSplitPane.getDividerLocation()));
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.individualIDLabel = new JLabel();
        this.individualIDTextField = new JTextField();
        this.sexBeanPanel = new SexBean();
        this.imageBean = new ImageBean();
        this.privateRecordToggleButton = new JToggleButton();
        this.nameEditorPanel = new NameEditorPanel();
        this.SOSALabel = new JLabel();
        this.SOSATextField = new JTextField();
        this.individualInformationTabbedPane = new JTabbedPane();
        this.eventsPanel = new JPanel();
        this.eventsSplitPane = new JSplitPane();
        this.eventsListPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.deleteEventButton = new JButton();
        this.eventTypeComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.eventsList = new JList();
        this.jPanel1 = new JPanel();
        this.individualEventEditorPanel = new IndividualEventPanel();
        this.familiesChildPanel = new JPanel();
        this.familiesChildTreeTablePanel = new FamiliesReferenceTreeTablePanel(FamiliesReferenceTreeTablePanel.EDIT_FAMC);
        this.familiesSpousePanel = new JPanel();
        this.familiesSpouseTreeTablePanel = new FamiliesReferenceTreeTablePanel(FamiliesReferenceTreeTablePanel.EDIT_FAMS);
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.galleryPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.aliasTablePanel = new AliasTablePanel();
        this.associationsPanel = new JPanel();
        this.associationsTablePanel = new AssociationsTablePanel();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.setName("");
        this.generalPanel.setMinimumSize(new Dimension(100, 200));
        this.generalPanel.setPreferredSize(new Dimension(500, 204));
        this.individualIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.individualIDLabel.text"), new Object[0]));
        this.individualIDTextField.setEditable(false);
        this.individualIDTextField.setColumns(8);
        this.individualIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.individualIDTextField.text"), new Object[0]));
        this.individualIDTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.individualIDTextField.toolTipText"), new Object[0]));
        this.sexBeanPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                IndividualEditor.this.sexBeanPanelStateChanged(evt);
            }
        });
        this.imageBean.setBorder(BorderFactory.createEtchedBorder(0));
        this.imageBean.setToolTipText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.imageBean.toolTipText"));
        this.imageBean.setAlignmentX(0.0f);
        this.imageBean.setAlignmentY(0.0f);
        this.imageBean.setMinimumSize(new Dimension(135, 180));
        this.imageBean.setPreferredSize(new Dimension(130, 173));
        this.imageBean.setRequestFocusEnabled(true);
        this.imageBean.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndividualEditor.this.imageBeanMouseClicked(evt);
            }
        });
        GroupLayout imageBeanLayout = new GroupLayout(this.imageBean);
        this.imageBean.setLayout(imageBeanLayout);
        imageBeanLayout.setHorizontalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 144, Short.MAX_VALUE));
        imageBeanLayout.setVerticalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 195, Short.MAX_VALUE));
        this.privateRecordToggleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/lock_open.png")));
        this.privateRecordToggleButton.setToolTipText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.privateRecordToggleButton.toolTipText"));
        this.privateRecordToggleButton.setMaximumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setMinimumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setPreferredSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setRolloverIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/lock_open.png")));
        this.privateRecordToggleButton.setRolloverSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/lock.png")));
        this.privateRecordToggleButton.setSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/lock.png")));
        this.nameEditorPanel.setMinimumSize(null);
        this.nameEditorPanel.setPreferredSize(null);
        this.SOSALabel.setText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.SOSALabel.text"));
        this.SOSATextField.setEditable(false);
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.imageBean, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.sexBeanPanel, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.SOSALabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SOSATextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualIDTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.privateRecordToggleButton, -2, -1, -2)).addComponent(this.nameEditorPanel, -1, 579, Short.MAX_VALUE)).addContainerGap()));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.imageBean, -1, 199, Short.MAX_VALUE).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sexBeanPanel, -2, -1, -2).addComponent(this.individualIDLabel).addComponent(this.individualIDTextField, -2, -1, -2).addComponent(this.privateRecordToggleButton, -2, -1, -2).addComponent(this.SOSALabel).addComponent(this.SOSATextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameEditorPanel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.individualInformationTabbedPane.setTabLayoutPolicy(1);
        this.eventsPanel.setPreferredSize(new Dimension(300, 150));
        this.eventsSplitPane.setDividerLocation(150);
        this.eventsSplitPane.setDividerSize(6);
        this.eventsSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndividualEditor.this.eventsSplitPanePropertyChange(evt);
            }
        });
        this.eventsListPanel.setMinimumSize(new Dimension(20, 57));
        this.eventsListPanel.setLayout(new BorderLayout());
        this.jToolBar1.setRollover(true);
        this.deleteEventButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png")));
        this.deleteEventButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.deleteEventButton.toolTipText"), new Object[0]));
        this.deleteEventButton.setHorizontalTextPosition(0);
        this.deleteEventButton.setVerticalTextPosition(3);
        this.deleteEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEditor.this.deleteEventButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.deleteEventButton);
        this.eventTypeComboBox.setModel(this.mEventsModel);
        this.eventTypeComboBox.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.eventTypeComboBox.toolTipText"), new Object[0]));
        this.eventTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEditor.this.eventTypeComboBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.eventTypeComboBox);
        this.eventsListPanel.add((Component)this.jToolBar1, "North");
        this.eventsList.setModel(this.mEventsListModel);
        this.eventsList.setSelectionMode(0);
        this.eventsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IndividualEditor.this.eventsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.eventsList);
        this.eventsListPanel.add((Component)this.jScrollPane1, "Center");
        this.eventsSplitPane.setLeftComponent(this.eventsListPanel);
        this.individualEventEditorPanel.setPreferredSize(new Dimension(597, 200));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.individualEventEditorPanel, -1, 586, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.individualEventEditorPanel, -1, 451, Short.MAX_VALUE).addContainerGap()));
        this.eventsSplitPane.setRightComponent(this.jPanel1);
        GroupLayout eventsPanelLayout = new GroupLayout(this.eventsPanel);
        this.eventsPanel.setLayout(eventsPanelLayout);
        eventsPanelLayout.setHorizontalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventsSplitPane, GroupLayout.Alignment.TRAILING, -1, 742, Short.MAX_VALUE));
        eventsPanelLayout.setVerticalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.eventsSplitPane, -1, 465, Short.MAX_VALUE).addGap(11, 11, 11)));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.eventsPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/event.png")), this.eventsPanel);
        GroupLayout familiesChildPanelLayout = new GroupLayout(this.familiesChildPanel);
        this.familiesChildPanel.setLayout(familiesChildPanelLayout);
        familiesChildPanelLayout.setHorizontalGroup(familiesChildPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesChildTreeTablePanel, -1, -1, Short.MAX_VALUE));
        familiesChildPanelLayout.setVerticalGroup(familiesChildPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, familiesChildPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.familiesChildTreeTablePanel, -1, -1, Short.MAX_VALUE)));
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.familiesChildPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/family.png")), this.familiesChildPanel);
        GroupLayout familiesSpousePanelLayout = new GroupLayout(this.familiesSpousePanel);
        this.familiesSpousePanel.setLayout(familiesSpousePanelLayout);
        familiesSpousePanelLayout.setHorizontalGroup(familiesSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesSpouseTreeTablePanel, -1, -1, Short.MAX_VALUE));
        familiesSpousePanelLayout.setVerticalGroup(familiesSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesSpouseTreeTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.familiesSpousePanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/child.png")), this.familiesSpousePanel);
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.sourcesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/source.png")), this.sourcesPanel);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.notesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/note.png")), this.notesPanel);
        GroupLayout galleryPanelLayout = new GroupLayout(this.galleryPanel);
        this.galleryPanel.setLayout(galleryPanelLayout);
        galleryPanelLayout.setHorizontalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        galleryPanelLayout.setVerticalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"FamilyEditor.galleryPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/media.png")), this.galleryPanel);
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.aliasTablePanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/Description.png")), this.aliasTablePanel);
        GroupLayout associationsPanelLayout = new GroupLayout(this.associationsPanel);
        this.associationsPanel.setLayout(associationsPanelLayout);
        associationsPanelLayout.setHorizontalGroup(associationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationsTablePanel, -1, -1, Short.MAX_VALUE));
        associationsPanelLayout.setVerticalGroup(associationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/editors/Bundle").getString("IndividualEditor.associationsPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/aries/resources/association.png")), this.associationsPanel);
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addComponent(this.individualInformationTabbedPane, -1, 742, Short.MAX_VALUE).addComponent(this.generalPanel, GroupLayout.Alignment.TRAILING, -1, 742, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.generalPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualInformationTabbedPane, -1, 513, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changeDateLabeldate, -2, 15, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.changeDateLabel).addContainerGap()))));
    }

    private void imageBeanMouseClicked(MouseEvent evt) {
        block7: {
            block5: {
                Gedcom gedcom;
                block6: {
                    gedcom = this.mIndividual.getGedcom();
                    this.mMultiMediaObject = this.mIndividual.getProperty("OBJE");
                    if (this.mMultiMediaObject != null && evt.getButton() != 3) break block5;
                    gedcom.doMuteUnitOfWork(gedcom1 -> {
                        this.mMultiMediaObject = !gedcom1.getGrammar().equals(Grammar.V55) ? this.mIndividual.getGedcom().createEntity("OBJE") : this.mIndividual.addProperty("OBJE", "");
                    });
                    MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
                    multiMediaObjectEditor.setContext(new Context(this.mMultiMediaObject));
                    if (!multiMediaObjectEditor.showPanel()) break block6;
                    Property property = this.mMultiMediaObject;
                    if (!(property instanceof Media)) break block7;
                    Media media = (Media)property;
                    this.mIndividual.addMedia(media);
                    boolean correct = this.imageBean.setImage((PropertyFile)this.mMultiMediaObject.getProperty("FILE") != null ? (InputSource)((PropertyFile)this.mMultiMediaObject.getProperty("FILE")).getInput().get() : null, this.mIndividual.getSex());
                    if (!correct) {
                        String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                        String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                        DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                    }
                    this.repaint();
                    this.changes.fireChangeEvent();
                    break block7;
                }
                gedcom.doMuteUnitOfWork(gedcom1 -> {
                    if (!gedcom1.getGrammar().equals(Grammar.V55)) {
                        this.mIndividual.getGedcom().deleteEntity((Entity)this.mMultiMediaObject);
                    } else {
                        this.mIndividual.delProperty(this.mMultiMediaObject);
                    }
                });
                break block7;
            }
            int n = 0;
            Property[] propertyArray = this.mIndividual.getProperties("OBJE");
            int n2 = propertyArray.length;
            if (n >= n2) break block7;
            Property multiMediaObject = propertyArray[n];
            MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
            multiMediaObjectEditor.setContext(new Context(multiMediaObject));
            if (multiMediaObjectEditor.showPanel()) {
                PropertyBlob propertyBlob;
                Property multimediaFile;
                boolean correct;
                if (multiMediaObject instanceof Media) {
                    Media media = (Media)multiMediaObject;
                    this.mIndividual.addMedia(media);
                }
                if (multiMediaObject instanceof PropertyMedia && multiMediaObject.isValid()) {
                    multiMediaObject = (Property)((PropertyMedia)multiMediaObject).getTargetEntity().get();
                }
                if (!(correct = (multimediaFile = multiMediaObject.getProperty("FILE", false)) != null && multimediaFile instanceof PropertyFile ? this.imageBean.setImage(((PropertyFile)multimediaFile).getInput().orElse(null), this.mIndividual.getSex()) : this.imageBean.setImage((propertyBlob = (PropertyBlob)multiMediaObject.getProperty("BLOB", true)) != null ? (InputSource)propertyBlob.getInput().get() : null, this.mIndividual.getSex()))) {
                    String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                    String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                    DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                }
                this.repaint();
                this.changes.fireChangeEvent();
            }
        }
    }

    private void deleteEventButtonActionPerformed(ActionEvent evt) {
        Property event;
        DialogManager createYesNo;
        int index = this.eventsList.getSelectedIndex();
        Gedcom gedcom = this.mIndividual.getGedcom();
        if (index != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventsList.deleteEventConfirmation.title", (Object)PropertyTag2Name.getTagName((event = this.mEventsListModel.getValueAt(index)).getTag())), (String)NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventsList.deleteEventConfirmation.text", (Object)PropertyTag2Name.getTagName(event.getTag()), (Object)this.mIndividual))).show() == DialogManager.YES_OPTION) {
            try {
                gedcom.doUnitOfWork(gedcom1 -> this.mIndividual.delProperty(this.mEventsListModel.remove(index)));
                ArrayList<Property> eventsProperties = new ArrayList<Property>();
                for (Property property : this.mIndividual.getProperties()) {
                    if (!INDIVIDUAL_EVENT_TAGS.contains(property.getTag())) continue;
                    eventsProperties.add(property);
                }
                this.seteventTypeComboBox(eventsProperties);
                this.eventsList.setSelectedIndex(0);
                this.changes.fireChangeEvent();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void eventTypeComboBoxActionPerformed(ActionEvent evt) {
        if (!this.updateOnGoing) {
            Gedcom gedcom = this.mIndividual.getGedcom();
            this.mEvent = null;
            if (this.eventTypeComboBox.getSelectedIndex() > 0) {
                String eventType = this.eventTypeComboBox.getSelectedItem().toString();
                try {
                    gedcom.doUnitOfWork(gedcom1 -> {
                        this.mEvent = this.mIndividual.addProperty(PropertyTag2Name.getPropertyTag(eventType), "");
                        if (GedcomConstants.TAG_YES_EVENTS.contains(this.mEvent.getTag())) {
                            this.mEvent.setValue("Y");
                        }
                    });
                    if (this.mEvent != null) {
                        ArrayList<Property> eventsProperties = new ArrayList<Property>();
                        for (Property property : this.mIndividual.getProperties()) {
                            if (!INDIVIDUAL_EVENT_TAGS.contains(property.getTag())) continue;
                            eventsProperties.add(property);
                        }
                        this.seteventTypeComboBox(eventsProperties);
                        if (this.mEventsListModel.indexOf(this.mEvent) == -1) {
                            this.mEventsListModel.add(this.mEvent);
                        }
                        this.selectedEventContext = new Context(this.mEvent);
                        this.eventsList.setSelectedIndex(this.mEventsListModel.indexOf(this.mEvent));
                        this.changes.fireChangeEvent();
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void eventsListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.eventsList.getSelectedIndex();
        if (index != -1 && index < this.mEventsListModel.getSize()) {
            Property prop = this.mEventsListModel.getValueAt(index);
            this.selectedEventContext = new Context(prop);
        }
    }

    private void sexBeanPanelStateChanged(ChangeEvent evt) {
        if (this.imageBean.isDefault()) {
            this.imageBean.setImage(null, this.sexBeanPanel.getSelectedSex());
        }
    }

    private void eventsSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("ariesindieventSplitDividerLocation", this.eventsSplitPane.getDividerLocation());
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Indi && entity.getGedcom() != null) {
            Property prop;
            this.mIndividual = (Indi)entity;
            this.setTitle(NbBundle.getMessage(IndividualEditor.class, (String)(this.isNew() ? "IndividualEditor.create.title" : "IndividualEditor.edit.title"), (Object)this.mIndividual.getDisplayTitle(false)));
            if (this.mIndividual.getGedcom().getGrammar().equals(Grammar.V55)) {
                this.privateRecordToggleButton.setVisible(false);
            }
            this.individualIDTextField.setText(this.mIndividual.getId());
            Property SOSANumber = this.mIndividual.getSosa(true);
            if (SOSANumber != null) {
                this.SOSALabel.setVisible(true);
                this.SOSATextField.setVisible(true);
                this.SOSATextField.setText(SOSANumber.getValue());
            } else {
                this.SOSALabel.setVisible(false);
                this.SOSATextField.setVisible(false);
                this.SOSATextField.setText("");
            }
            this.privateRecordToggleButton.setSelected(this.privacyPolicy.hasTagMarkingPrivate((Property)this.mIndividual));
            List namesList = this.mIndividual.getProperties(PropertyName.class);
            if (namesList.isEmpty()) {
                this.nameEditorPanel.set(this.mIndividual, null);
            } else {
                PropertyName name = (PropertyName)namesList.remove(0);
                if (name != null) {
                    this.nameEditorPanel.set(this.mIndividual, name);
                }
            }
            this.namesTablePanel.set(this.mIndividual, namesList);
            PropertySex sex = (PropertySex)this.mIndividual.getProperty("SEX", false);
            if (sex == null) {
                this.mIndividual.setSex(0);
                sex = (PropertySex)this.mIndividual.getProperty("SEX", true);
            } else if (!sex.isValid()) {
                sex.setValue("U");
            }
            this.sexBeanPanel.set((Property)this.mIndividual, sex);
            ArrayList<Property> individualEvents = new ArrayList<Property>();
            for (Property property : this.mIndividual.getProperties()) {
                if (!INDIVIDUAL_EVENT_TAGS.contains(property.getTag())) continue;
                individualEvents.add(property);
            }
            Collections.sort(individualEvents, (p1, p2) -> {
                PropertyDate pDate1 = (PropertyDate)p1.getProperty("DATE");
                PropertyDate pDate2 = (PropertyDate)p2.getProperty("DATE");
                if (pDate1 == null && pDate2 == null) {
                    return 0;
                }
                if (pDate1 != null && pDate2 == null) {
                    return 1;
                }
                if (pDate1 == null && pDate2 != null) {
                    return -1;
                }
                return pDate1.compareTo((Property)pDate2);
            });
            this.changeListInProgress = true;
            this.mEventsListModel.clear();
            this.mEventsListModel.addAll(individualEvents);
            this.seteventTypeComboBox(individualEvents);
            int index = 0;
            Property property = prop = this.selectedEventContext == null ? context.getProperty() : this.selectedEventContext.getProperty();
            if (prop != null && (index = this.mEventsListModel.indexOf(prop)) == -1) {
                index = 0;
            }
            if (this.eventsList.getModel().getSize() > 0) {
                this.eventsList.setSelectedIndex(index);
            } else {
                this.individualEventEditorPanel.clear((Property)this.mIndividual);
            }
            this.changeListInProgress = false;
            this.familiesChildTreeTablePanel.setFamiliesList((Property)this.mIndividual, this.mIndividual.getProperties(PropertyFamilyChild.class));
            this.familiesSpouseTreeTablePanel.setFamiliesList((Property)this.mIndividual, this.mIndividual.getProperties(PropertyFamilySpouse.class));
            this.associationsTablePanel.setAssociationsList((Entity)this.mIndividual, this.mIndividual.getProperties(PropertyAssociation.class));
            this.aliasTablePanel.set(this.mIndividual, this.mIndividual.getProperties(PropertyAlias.class));
            Property changeDate = this.mIndividual.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
            ArrayList<Property> pList = new ArrayList<Property>();
            pList.addAll(Arrays.asList(this.mIndividual.getProperties("NOTE")));
            if (this.mIndividual.isGrammar7()) {
                pList.addAll(Arrays.asList(this.mIndividual.getProperties("SNOTE")));
            }
            this.noteCitationsTablePanel.set((Property)this.mIndividual, pList);
            this.sourceCitationsTablePanel.set((Property)this.mIndividual, Arrays.asList(this.mIndividual.getProperties("SOUR")));
            Property[] multiMediaObjects = this.mIndividual.getProperties("OBJE");
            boolean found = false;
            Property[] propertyArray = this.mIndividual.getProperties("OBJE");
            int n = propertyArray.length;
            int n2 = 0;
            if (n2 < n) {
                PropertyBlob propertyBlob;
                Property multimediaFile;
                Property multiMediaObject = propertyArray[n2];
                if (!this.mIndividual.getGedcom().getGrammar().equals(Grammar.V55)) {
                    if (multiMediaObject instanceof PropertyMedia && multiMediaObject.isValid()) {
                        propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity().get()).getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            propertyFormat.getValue();
                        }
                    } else {
                        propertyFormat = multiMediaObject.getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            propertyFormat.getValue();
                        }
                    }
                } else if (multiMediaObject instanceof PropertyMedia && multiMediaObject.isValid()) {
                    propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity().get()).getProperty("FORM");
                    if (propertyFormat != null) {
                        propertyFormat.getValue();
                    }
                } else {
                    propertyFormat = multiMediaObject.getProperty("FORM");
                    if (propertyFormat != null) {
                        propertyFormat.getValue();
                    }
                }
                if (multiMediaObject instanceof PropertyMedia && multiMediaObject.isValid()) {
                    multiMediaObject = (Property)((PropertyMedia)multiMediaObject).getTargetEntity().get();
                }
                boolean correct = (multimediaFile = multiMediaObject.getProperty("FILE", false)) != null && multimediaFile instanceof PropertyFile ? this.imageBean.setImage(((PropertyFile)multimediaFile).getInput().orElse(null), this.mIndividual.getSex()) : this.imageBean.setImage((propertyBlob = (PropertyBlob)multiMediaObject.getProperty("BLOB", true)) != null ? (InputSource)propertyBlob.getInput().get() : null, this.mIndividual.getSex());
                found = true;
                if (!correct) {
                    String title = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType");
                    String text = NbBundle.getMessage(ImageBean.class, (String)"ImageBean.fileType.notSupported");
                    DialogManager.create((String)title, (String)text).setMessageType(2).setOptionType(10).setDialogId("ancestris.aries.error").show();
                }
            }
            if (!found) {
                this.imageBean.setImage(null, this.mIndividual.getSex());
            }
            this.multimediaObjectCitationsTablePanel.set((Property)this.mIndividual, Arrays.asList(multiMediaObjects));
        }
    }

    public void commit() {
        boolean restrictionNotice = this.privacyPolicy.hasTagMarkingPrivate((Property)this.mIndividual);
        if (this.privateRecordToggleButton.isSelected()) {
            if (!restrictionNotice) {
                this.privacyPolicy.setTagMarkingPrivate((Property)this.mIndividual);
            }
        } else if (restrictionNotice) {
            this.privacyPolicy.delTagMarkingPrivate((Property)this.mIndividual);
        }
        if (this.nameEditorPanel.hasChanged() || this.individualEventEditorPanel.hasChanged() || this.sexBeanPanel.hasChanged()) {
            ErrorPanel ep;
            this.mIndividual.setOld();
            this.nameEditorPanel.commit();
            this.sexBeanPanel.commit();
            this.individualEventEditorPanel.commit();
            if (GedcomOptions.getInstance().getAutoCheck() && (ep = new ErrorPanel()).setErrors((Entity)this.mIndividual)) {
                DialogManager.create((String)ep.getMessage((Entity)this.mIndividual), (JComponent)ep).setMessageType(2).setOptionType(10).show();
            }
            if (GedcomOptions.getInstance().getDuplicateAnyTime()) {
                WindowManager.getDefault().invokeWhenUIReady(() -> new DuplicatesFinder((Entity)this.mIndividual).run());
            }
        }
    }

    private void seteventTypeComboBox(List<Property> eventsList) {
        ArrayList<String> localizedEventsList = new ArrayList<String>();
        for (String tag2 : INDIVIDUAL_EVENT_TAGS) {
            localizedEventsList.add(PropertyTag2Name.getTagName(tag2));
        }
        for (Property event : eventsList) {
            if (event.getTag().equals("CENS") || event.getTag().equals("EMIG") || event.getTag().equals("EVEN") || event.getTag().equals("GRAD") || event.getTag().equals("IMMI") || event.getTag().equals("NATI") || event.getTag().equals("NATU") || event.getTag().equals("OCCU") || event.getTag().equals("PROB") || event.getTag().equals("PROP") || event.getTag().equals("RELI") || event.getTag().equals("RESI") || event.getTag().equals("FACT") || event.getTag().equals("TITL")) continue;
            localizedEventsList.remove(PropertyTag2Name.getTagName(event.getTag()));
        }
        Collections.sort(localizedEventsList);
        this.updateOnGoing = true;
        this.mEventsModel.removeAllElements();
        this.mEventsModel.addElement(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventTypeComboBox.firstElement.title"));
        localizedEventsList.forEach(tag -> this.mEventsModel.addElement((String)tag));
        this.updateOnGoing = false;
    }

    public Entity getEditedEntity() {
        return this.mIndividual;
    }

    private class EventsListSelectionHandler
    implements ListSelectionListener {
        private EventsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            ListSelectionModel lsm = (ListSelectionModel)lse.getSource();
            if (!lse.getValueIsAdjusting() && !lsm.isSelectionEmpty()) {
                AriesTopComponent etc;
                if (!IndividualEditor.this.changeListInProgress && IndividualEditor.this.individualEventEditorPanel.hasChanged() && (etc = AriesTopComponent.findEditorWindow(IndividualEditor.this.mIndividual.getGedcom())) != null) {
                    etc.commit();
                }
                if (lsm.getMinSelectionIndex() < IndividualEditor.this.mEventsListModel.getSize()) {
                    IndividualEditor.this.individualEventEditorPanel.set((Property)IndividualEditor.this.mIndividual, IndividualEditor.this.mEventsListModel.getValueAt(lsm.getMinSelectionIndex()));
                    IndividualEditor.this.individualEventEditorPanel.setVisible(true);
                }
            }
        }
    }
}

