/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.app.ActionClose;
import ancestris.app.ActionSave;
import ancestris.explorer.EntitiesChildren;
import ancestris.explorer.EntitiesNode;
import ancestris.explorer.ExplorerNode;
import ancestris.explorer.GedcomEntities;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.editors.gedcomproperties.PropertiesAction;
import ancestris.modules.editors.geoplace.format.PlaceFormatAction;
import ancestris.modules.gedcom.mergefile.GedcomMergeWizardAction;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

class GedcomFileNode
extends AbstractNode
implements ExplorerNode {
    private final InstanceContent lookupContents;
    private Context context;
    private Action saveAction;
    private Action propertiesAction;
    private Action placesAction;
    private Action mergeAction;
    private Action closeAction;

    public GedcomFileNode(Gedcom gedcom) {
        this(new Context(gedcom), new InstanceContent());
        this.saveAction = new ActionSave(this.context);
        this.propertiesAction = new PropertiesAction();
        this.placesAction = new PlaceFormatAction();
        this.mergeAction = new GedcomMergeWizardAction();
        this.closeAction = new ActionClose(this.context);
        this.setDisplayName(gedcom.getDisplayName());
        this.lookupContents.add((Object)this.context);
        if (this.context.getEntity() != null) {
            this.lookupContents.add((Object)this.context.getEntity());
        }
    }

    private GedcomFileNode(Context context, InstanceContent ic) {
        super((Children)new EntitiesChildren(context.getGedcom()), GedcomFileNode.createLookup(context, ic));
        this.lookupContents = ic;
        this.context = GedcomDirectory.getDefault().getContext(FileUtil.toFileObject((File)context.getGedcom().getOrigin().getFile()));
    }

    private static Lookup createLookup(Context context, InstanceContent ic) {
        try {
            return new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), GedcomDirectory.getDefault().getDataObject(context).getLookup()});
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new AbstractLookup((AbstractLookup.Content)ic);
        }
    }

    public PasteType getDropType(Transferable t, final int action, int index) {
        GedcomEntities movie;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (null != dropNode && null != (movie = (GedcomEntities)dropNode.getLookup().lookup(GedcomEntities.class)) && !this.equals(dropNode.getParentNode())) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    GedcomFileNode.this.getChildren().add(new Node[]{new EntitiesNode(GedcomFileNode.this.context.getGedcom(), movie)});
                    if ((action & 2) != 0) {
                        dropNode.getParentNode().getChildren().remove(new Node[]{dropNode});
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        try {
            return (T)GedcomDirectory.getDefault().getDataObject(this.context).getCookie(clazz);
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            return null;
        }
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 1, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> nodeactions = new ArrayList<Action>(8);
        nodeactions.add(this.saveAction);
        nodeactions.add(this.placesAction);
        nodeactions.add(this.propertiesAction);
        nodeactions.add(this.mergeAction);
        nodeactions.add(this.closeAction);
        return (Action[])nodeactions.toArray(Action[]::new);
    }

    public boolean canDestroy() {
        return true;
    }

    public Image getIcon(int type) {
        return Gedcom.getImage().getImage();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

