/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.transfer;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FTPRegister {
    private static final String regPrefix = "reg_";
    private String node = "";
    private String host = "";
    private String targetdir = "";
    private String localRoot = "";
    private static final String FTP_SYSTEMATIC = NbBundle.getMessage(WebBook.class, (String)"transferType.type1");
    private static final String FTP_INCREMENTAL = NbBundle.getMessage(WebBook.class, (String)"transferType.type2");
    private static final String FTP_SYNCHRONISE = NbBundle.getMessage(WebBook.class, (String)"transferType.type3");
    public String uploadType = "";
    private static final int REG_REMOTEMD5 = 0;
    private static final int REG_LOCALMD5 = 1;
    private static final int REG_TRSFDATE = 2;
    private static final int REG_GENLASTRUN = 3;
    private static final int REG_TOBETRSF = 4;
    private static final int REG_TOBEREMOVD = 5;
    private static final int REG_LOCALPATH = 6;
    private static final int REG_SIZE = 7;
    private static final String SEPARATOR = ",";
    private static final String YES = "1";
    private static final String NO = "0";
    private static final String BLANK = "-";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int nbFilesToTransfer = 0;
    private int nbFilesToRemove = 0;

    public FTPRegister(WebBookParams wp, WebHelper wh) {
        this.node = regPrefix + wh.gedcom.getName();
        this.host = wp.param_FTP_site;
        this.targetdir = wp.param_FTP_dir;
        this.localRoot = wh.getDir().getAbsolutePath();
        this.uploadType = wp.param_FTP_transfertType;
        wh.setUploadRegister(this);
        if (wp.param_FTP_upload.equals(YES) && !wp.param_FTP_resetHistory.equals(YES)) {
            this.resetFlags();
        }
    }

    private boolean resetFlags() {
        String[] keys = this.readKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!this.isValid(key)) continue;
            String[] fields = this.readKey(key);
            fields[3] = NO;
            fields[4] = NO;
            fields[5] = NO;
            this.writeKey(key, fields);
        }
        return true;
    }

    public boolean update(File file) {
        String key = this.host + this.targetdir + this.getFileDir(file) + file.getName();
        this.setLocalGen(key, file.getAbsolutePath(), YES);
        return true;
    }

    public boolean calculate(List<File> localFiles) {
        String[] keys = this.readKeys();
        if (keys.length == 0) {
            return false;
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        this.nbFilesToTransfer = 0;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!this.isValid(key) || !this.isLocal(key, localFiles)) continue;
            String[] fields = this.readKey(key);
            fields[4] = NO;
            fields[5] = NO;
            if (this.equals(fields[3], YES)) {
                fields[1] = this.getMD5(fields[6]);
            }
            if (this.uploadType.equals(FTP_SYSTEMATIC) && this.equals(fields[3], YES)) {
                fields[4] = YES;
                ++this.nbFilesToTransfer;
            }
            if (this.uploadType.equals(FTP_INCREMENTAL) && !this.equals(fields[0], fields[1]) && this.equals(fields[3], YES)) {
                fields[4] = YES;
                ++this.nbFilesToTransfer;
            }
            if (this.uploadType.equals(FTP_SYNCHRONISE) && !this.equals(fields[0], fields[1]) && this.equals(fields[3], YES)) {
                fields[4] = YES;
                ++this.nbFilesToTransfer;
            }
            if (this.uploadType.equals(FTP_SYNCHRONISE) && !this.equals(fields[0], "") && !this.equals(fields[3], YES)) {
                fields[5] = YES;
            }
            this.writeKey(key, fields);
            if (!this.equals(fields[0], BLANK) || this.equals(fields[3], YES)) continue;
            toBeRemoved.add(key);
        }
        for (String key : toBeRemoved) {
            this.removeKey(key);
        }
        return true;
    }

    public boolean isToTransfer(File file) {
        String[] fields;
        String key = this.getKey(file);
        return key != null && this.equals((fields = this.readKey(key))[4], YES);
    }

    public boolean setFileTransferred(File file) {
        String key = this.getKey(file);
        if (key != null) {
            String[] fields = this.readKey(key);
            fields[0] = fields[1];
            fields[2] = Calendar.getInstance().getTime().toString();
            this.writeKey(key, fields);
        }
        return false;
    }

    public int getNbFilesToTransfer() {
        return this.nbFilesToTransfer;
    }

    public List<String> getListToRemove() {
        String[] keys = this.readKeys();
        this.nbFilesToRemove = 0;
        ArrayList<String> listRet = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String[] fields;
            String key = keys[i];
            if (!this.isValid(key) || !this.equals((fields = this.readKey(key))[5], YES)) continue;
            listRet.add(key);
        }
        this.nbFilesToRemove = listRet.size();
        return listRet;
    }

    public boolean setFileRemoved(String key) {
        if (key != null) {
            String[] fields = this.readKey(key);
            fields[0] = BLANK;
            fields[5] = NO;
            this.writeKey(key, fields);
        }
        return false;
    }

    public int getNbFilesToRemove() {
        return this.nbFilesToRemove;
    }

    private String getFileDir(File f) {
        String file = f.getName();
        String fullDir = f.getAbsolutePath();
        int a = this.localRoot.length() == 0 ? 0 : this.localRoot.length() + 1;
        int b = fullDir.indexOf(file) < 1 ? 0 : fullDir.indexOf(file) - 1;
        return b > a ? fullDir.substring(a, b) + File.separator : "";
    }

    private boolean equals(String str1, String str2) {
        return str1.compareTo(str2) == 0;
    }

    private boolean setLocalGen(String key, String localpath, String genflag) {
        String[] fields = this.readKey(key);
        fields[3] = genflag;
        fields[6] = localpath;
        this.writeKey(key, fields);
        return true;
    }

    private String[] value2array(String value) {
        String[] fields = new String[7];
        if (value == null) {
            for (int i = 0; i < 7; ++i) {
                fields[i] = BLANK;
            }
        } else {
            String[] values = value.split(SEPARATOR);
            for (int i = 0; i < 7; ++i) {
                fields[i] = BLANK;
                if (i >= values.length || values[i].trim().length() == 0) continue;
                fields[i] = values[i];
            }
        }
        return fields;
    }

    private String array2value(String[] fields) {
        Object value = "";
        for (int i = 0; i < fields.length; ++i) {
            value = (String)value + fields[i] + (i < fields.length - 1 ? SEPARATOR : "");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMD5(String filename) {
        FileInputStream in = null;
        try {
            int length;
            MessageDigest md = MessageDigest.getInstance("MD5");
            in = new FileInputStream(filename);
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            byte[] raw = md.digest();
            String string = FTPRegister.asHex(raw);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "ABCDEFG";
    }

    private static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    private String[] readKeys() {
        String[] keys = null;
        try {
            keys = NbPreferences.forModule(FTPRegister.class).node(this.node).keys();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return keys;
    }

    private String[] readKey(String key) {
        return this.value2array(NbPreferences.forModule(FTPRegister.class).node(this.node).get(key, ""));
    }

    private void writeKey(String key, String[] fields) {
        NbPreferences.forModule(FTPRegister.class).node(this.node).put(key, this.array2value(fields));
    }

    private void removeKey(String key) {
        NbPreferences.forModule(FTPRegister.class).node(this.node).remove(key);
    }

    private boolean isValid(String key) {
        return key.indexOf(this.host + this.targetdir) == 0;
    }

    private boolean isLocal(String key, List<File> localFiles) {
        String strKey = key.substring(this.host.length() + this.targetdir.length());
        for (File file : localFiles) {
            String strLocal = file.getAbsolutePath().substring(this.localRoot.length() + 1);
            if (!strLocal.equals(strKey)) continue;
            return true;
        }
        return false;
    }

    private String getKey(File file) {
        String strLocal = file.getAbsolutePath().substring(this.localRoot.length() + 1);
        String[] keys = this.readKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!this.isValid(key)) continue;
            String[] fields = this.readKey(key);
            String strKey = key.substring(this.host.length() + this.targetdir.length());
            if (!strLocal.equals(strKey)) continue;
            return key;
        }
        return null;
    }
}

