/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.oxbow.swingbits.list.ActionCheckListModel;
import org.oxbow.swingbits.list.CheckList;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.DefaultCheckListModel;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.misc.JSearchTextField;
import org.oxbow.swingbits.popup.PopupWindow;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.TableAwareCheckListRenderer;
import org.oxbow.swingbits.util.CollectionUtils;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableFilterColumnPopup
extends PopupWindow
implements MouseListener {
    private boolean enabled = false;
    private final CheckList<DistinctColumnItem> filterList = new CheckList.Builder().build();
    private final JSearchTextField searchField = new JSearchTextField();
    private final Map<Integer, ColumnAttrs> colAttrs = new HashMap<Integer, ColumnAttrs>();
    private int mColumnIndex = -1;
    private final ITableFilter<?> filter;
    private boolean searchable;
    private IObjectToStringTranslator translator;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;

    public TableFilterColumnPopup(ITableFilter<?> iTableFilter) {
        super(true);
        this.filter = iTableFilter;
        this.filterList.getList().setVisibleRowCount(8);
        this.setupTableHeader();
        ((Container)iTableFilter.getTable()).addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableFilterColumnPopup.this.setupTableHeader();
            }
        });
        ((Container)iTableFilter.getTable()).addPropertyChangeListener("model", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableFilterColumnPopup.this.colAttrs.clear();
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                this.perform(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.perform(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.perform(documentEvent);
            }

            private void perform(DocumentEvent documentEvent) {
                TableFilterColumnPopup.this.filterList.filter(TableFilterColumnPopup.this.searchField.getText(), TableFilterColumnPopup.this.translator, CheckListFilterType.CONTAINS);
            }
        });
    }

    public void setSearchable(boolean bl) {
        this.searchable = bl;
    }

    public void setSearchTranslator(IObjectToStringTranslator iObjectToStringTranslator) {
        this.translator = iObjectToStringTranslator;
    }

    public void setActionsVisible(boolean bl) {
        this.actionsVisible = bl;
    }

    public void setUseTableRenderers(boolean bl) {
        this.useTableRenderers = bl;
    }

    private void setupTableHeader() {
        JTableHeader jTableHeader = ((JTable)this.filter.getTable()).getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this);
        }
    }

    @Override
    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jPanel.setPreferredSize(new Dimension(250, 150));
        Box box = new Box(2);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new PopupWindow.CommandAction("Clear all column filters", (Icon)new ImageIcon(this.getClass().getResource("funnel_delete.png"))){

            protected boolean perform() {
                return TableFilterColumnPopup.this.clearAllFilters();
            }
        });
        box.add(jToolBar);
        box.add(Box.createHorizontalGlue());
        box.add(new JButton(new PopupWindow.CommandAction("Apply"){

            protected boolean perform() {
                return TableFilterColumnPopup.this.applyColumnFilter();
            }
        }));
        box.add(Box.createHorizontalStrut(5));
        box.add(new JButton(new PopupWindow.CommandAction("Cancel")));
        box.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        box.setBackground(UIManager.getColor("Panel.background"));
        box.setOpaque(true);
        if (this.searchable) {
            jPanel.add((Component)this.searchField, "North");
        }
        jPanel.add((Component)new JScrollPane(this.filterList.getList()), "Center");
        jPanel.add((Component)box, "South");
        return jPanel;
    }

    private boolean applyColumnFilter() {
        Collection<DistinctColumnItem> collection = this.filterList.getCheckedItems();
        ICheckListModel<DistinctColumnItem> iCheckListModel = this.filterList.getModel();
        iCheckListModel.filter("", this.translator, CheckListFilterType.CONTAINS);
        this.filter.apply(this.mColumnIndex, collection);
        return true;
    }

    private boolean clearAllFilters() {
        this.filter.clear();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.enabled && mouseEvent.isPopupTrigger()) {
            this.showFilterPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.enabled && mouseEvent.isPopupTrigger()) {
            this.showFilterPopup(mouseEvent);
        }
    }

    private void showFilterPopup(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        TableColumnModel tableColumnModel = ((JTable)this.filter.getTable()).getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        if (n < 0) {
            return;
        }
        Rectangle rectangle = ((JTable)this.filter.getTable()).getTableHeader().getHeaderRect(n);
        if (n == 0) {
            rectangle.width -= 2;
        } else {
            rectangle.grow(-2, 0);
        }
        if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        this.mColumnIndex = ((JTable)this.filter.getTable()).convertColumnIndexToModel(n);
        this.setPreferredSize(this.getColumnAttrs((int)n).preferredSize);
        Collection<DistinctColumnItem> collection = this.filter.getDistinctColumnItems(this.mColumnIndex);
        DefaultCheckListModel<DistinctColumnItem> defaultCheckListModel = new DefaultCheckListModel<DistinctColumnItem>(collection);
        this.filterList.setModel(this.actionsVisible ? new ActionCheckListModel<DistinctColumnItem>(defaultCheckListModel) : defaultCheckListModel);
        Collection<DistinctColumnItem> collection2 = this.filter.getFilterState(this.mColumnIndex);
        this.filterList.setCheckedItems(CollectionUtils.isEmpty(collection2) ? collection : collection2);
        if (this.useTableRenderers) {
            this.filterList.getList().setCellRenderer(new TableAwareCheckListRenderer((JTable)this.filter.getTable(), n));
        }
        this.show(jTableHeader, rectangle.x, jTableHeader.getHeight());
    }

    private ColumnAttrs getColumnAttrs(int n) {
        ColumnAttrs columnAttrs = this.colAttrs.get(n);
        if (columnAttrs == null) {
            columnAttrs = new ColumnAttrs();
            this.colAttrs.put(n, columnAttrs);
        }
        return columnAttrs;
    }

    @Override
    protected void beforeShow() {
        if (this.searchable) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableFilterColumnPopup.this.searchField.setText("");
                    TableFilterColumnPopup.this.searchField.requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public void beforeHide() {
        this.getColumnAttrs((int)this.mColumnIndex).preferredSize = this.getPreferredSize();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    static class ColumnAttrs {
        public Dimension preferredSize;

        ColumnAttrs() {
        }
    }
}

