/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.tree.Model;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import gj.awt.geom.Path;
import gj.layout.tree.Branch;
import gj.layout.tree.Orientation;
import gj.model.Node;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

abstract class Parser {
    protected Model model;
    protected TreeMetrics metrics;
    protected Path shapeMarrs;
    protected Path shapeDivs;
    protected Path shapeRels;
    protected Path shapePlus;
    protected Path shapeMinus;
    protected Path shapeIndis;
    protected Path shapeIndisSquared;
    protected Path shapeIndisRounded;
    protected Path shapeFams;
    protected Path shapeFamsSquared;
    protected Path shapeFamsRounded;
    protected int[] padIndis;
    protected int[] padMinusPlus;
    protected int[] padMarrs;
    protected Path shapeEmpty;
    protected Path shapeNext1;
    protected Path shapeNext2;
    protected int[] padEmpty;
    protected int[] padNext1;
    protected int[] padNext2;

    public static Parser getInstance(boolean ancestors, boolean families, Model model, TreeMetrics metrics) {
        if (ancestors) {
            if (families) {
                return new AncestorsWithFams(model, metrics);
            }
            return new AncestorsNoFams(model, metrics);
        }
        if (families) {
            return new DescendantsWithFams(model, metrics);
        }
        return new DescendantsNoFams(model, metrics);
    }

    protected Parser(Model mOdel, TreeMetrics mEtrics) {
        this.model = mOdel;
        this.metrics = mEtrics;
        this.initEntityShapes();
        this.initFoldUnfoldShapes();
        this.initMarrShapes();
        this.initDivsShapes();
        this.initRelShapes();
        this.initNextFamShapes();
        this.shapeIndis = this.model.isRoundedRectangle() ? this.shapeIndisRounded : this.shapeIndisSquared;
        this.shapeFams = this.model.isRoundedRectangle() ? this.shapeFamsRounded : this.shapeFamsSquared;
    }

    public final TreeNode parse(Entity root) {
        return root instanceof Indi ? this.parse((Indi)root) : this.parse((Fam)root);
    }

    public TreeNode align(TreeNode other) {
        return other;
    }

    protected abstract TreeNode parse(Indi var1);

    protected abstract TreeNode parse(Fam var1);

    private void initEntityShapes() {
        this.padIndis = new int[]{(this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2};
        this.shapeIndisSquared = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wIndis / 2, -this.metrics.hIndis / 2, this.metrics.wIndis, this.metrics.hIndis));
        this.shapeIndisRounded = new Path().append((Shape)new RoundRectangle2D.Double(-this.metrics.wIndis / 2, -this.metrics.hIndis / 2, this.metrics.wIndis, this.metrics.hIndis, 5.0, 5.0));
        this.shapeFamsSquared = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wFams / 2, -this.metrics.hFams / 2, this.metrics.wFams, this.metrics.hFams));
        this.shapeFamsRounded = new Path().append((Shape)new RoundRectangle2D.Double(-this.metrics.wFams / 2, -this.metrics.hFams / 2, this.metrics.wFams, this.metrics.hFams, 5.0, 5.0));
    }

    private void initFoldUnfoldShapes() {
        int pi = (this.model.getMetrics().indisThick + 1) / 4;
        this.padMinusPlus = new int[]{-this.padIndis[0] + pi, 1, 1, this.padIndis[3] - pi};
        double d = 8.0;
        this.shapePlus = new Path();
        this.shapePlus.moveTo((Point2D)new Point2D.Double(0.0, -d * 0.3));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(0.0, d * 0.3));
        this.shapePlus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapePlus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
        this.shapeMinus = new Path();
        this.shapeMinus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapeMinus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapeMinus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
    }

    private void initMarrShapes() {
        this.shapeMarrs = new Path();
        int d = Math.min(this.metrics.wIndis / 4, this.metrics.hIndis / 4);
        if (!this.model.isMarrSymbols()) {
            this.shapeMarrs.append((Shape)new Rectangle2D.Double((float)(-(d /= 4)) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f));
        } else {
            Ellipse2D.Float e = new Ellipse2D.Float((float)(-d) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f);
            float dx = this.model.isVertical() ? (float)d * 0.2f : (float)d * 0.0f;
            float dy = this.model.isVertical() ? (float)d * 0.0f : (float)d * 0.2f;
            AffineTransform at1 = AffineTransform.getTranslateInstance(-dx, -dy);
            AffineTransform at2 = AffineTransform.getTranslateInstance(dx, dy);
            this.shapeMarrs.append(e.getPathIterator(at1));
            this.shapeMarrs.append(e.getPathIterator(at2));
        }
        int t = (this.model.getMetrics().indisThick + 1) / 2;
        int l = this.model.isVertical() ? this.metrics.hIndis / 2 : this.metrics.wIndis / 2;
        this.padMarrs = new int[]{this.padIndis[0] + l - (int)((float)d * 0.3f), t, t, 0};
    }

    private void initDivsShapes() {
        this.shapeDivs = new Path();
        int d = Math.min(this.metrics.wIndis / 4, this.metrics.hIndis / 4);
        if (!this.model.isMarrSymbols()) {
            this.shapeDivs.append((Shape)new Rectangle2D.Double((float)(-(d /= 4)) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f));
        } else {
            Ellipse2D.Float e = new Ellipse2D.Float((float)(-d) * 0.2f, (float)(-d) * 0.2f, (float)d * 0.4f, (float)d * 0.4f);
            float dx = this.model.isVertical() ? (float)d * 0.3f : (float)d * 0.0f;
            float dy = this.model.isVertical() ? (float)d * 0.0f : (float)d * 0.3f;
            AffineTransform at1 = AffineTransform.getTranslateInstance(-dx, -dy);
            AffineTransform at2 = AffineTransform.getTranslateInstance(dx, dy);
            this.shapeDivs.append(e.getPathIterator(at1));
            this.shapeDivs.append(e.getPathIterator(at2));
            this.shapeDivs.moveTo((Point2D)new Point2D.Double(this.model.isVertical() ? 0.0 : (double)((float)(-d) * 0.2f), this.model.isVertical() ? (double)((float)(-d) * 0.2f) : 0.0));
            this.shapeDivs.lineTo((Point2D)new Point2D.Double(this.model.isVertical() ? 0.0 : (double)((float)d * 0.2f), this.model.isVertical() ? (double)((float)d * 0.2f) : 0.0));
        }
    }

    private void initRelShapes() {
        this.shapeRels = new Path();
        int d = Math.min(this.metrics.wIndis / 4, this.metrics.hIndis / 4);
        if (!this.model.isMarrSymbols()) {
            this.shapeRels.append((Shape)new Rectangle2D.Double((float)(-(d /= 4)) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f));
        } else {
            Line2D.Float l = new Line2D.Float((float)(-d) * 0.2f, (float)(-d) * 0.2f, this.model.isVertical() ? (float)d * 0.6f : (float)(-d) * 0.2f, this.model.isVertical() ? (float)(-d) * 0.2f : (float)d * 0.6f);
            Line2D.Float l1 = this.model.isVertical() ? new Line2D.Float((float)(-d) * 0.2f, (float)d * 0.2f, (float)d * 0.6f, (float)d * 0.2f) : new Line2D.Float((float)d * 0.2f, (float)(-d) * 0.2f, (float)d * 0.2f, (float)d * 0.6f);
            float dx = this.model.isVertical() ? (float)d * 0.3f : (float)d * 0.0f;
            float dy = this.model.isVertical() ? (float)d * 0.0f : (float)d * 0.3f;
            AffineTransform at1 = AffineTransform.getTranslateInstance(-dx, -dy);
            this.shapeRels.append(l.getPathIterator(at1));
            this.shapeRels.append(l1.getPathIterator(at1));
        }
    }

    private void initNextFamShapes() {
        this.shapeEmpty = new Path();
        this.shapeEmpty.moveTo((Point2D)new Point2D.Double(0.0, 0.0));
        if (this.model.isVertical()) {
            this.shapeEmpty.lineTo((Point2D)new Point2D.Double(0.0, 1.0));
        } else {
            this.shapeEmpty.lineTo((Point2D)new Point2D.Double(1.0, 0.0));
        }
        this.shapeEmpty.lineTo((Point2D)new Point2D.Double(0.0, 0.0));
        this.padEmpty = new int[]{0, 0, 0, 0};
        this.shapeNext1 = new Path();
        this.shapeNext2 = new Path();
        if (this.model.isVertical()) {
            double d = Math.min((double)this.metrics.hIndis / 12.0, 10.0);
            double w = Math.min((double)this.metrics.wIndis / 12.0, 8.0);
            double h = 2.5 * d;
            double x = this.shapeMarrs.getBounds2D().getWidth() / 2.0 + (double)this.metrics.wIndis + (double)this.metrics.indisThick;
            AffineTransform tx = new AffineTransform();
            tx.rotate(3.1415927410125732);
            this.padNext1 = new int[]{(int)(-this.shapeMarrs.getBounds2D().getHeight()) * 3 / 4 - this.metrics.hIndis / 2 + (int)h / 2, 0, 0, 0};
            this.padNext2 = new int[]{-this.metrics.hIndis / 2, 0, 0, 0};
            this.shapeNext1.append(tx.createTransformedShape((Shape)this.getTmpShapeNext(x, 0.0, d, w, h)));
            this.shapeNext2.append((Shape)this.getTmpShapeNext(x, 0.0, d, w, h));
        } else {
            double d = Math.min((double)this.metrics.wIndis / 12.0, 8.0);
            double w = Math.min((double)this.metrics.hIndis / 6.0, 10.0);
            double h = 2.5 * d;
            double x = this.shapeMarrs.getBounds2D().getHeight() / 2.0 + (double)this.metrics.hIndis + (double)this.metrics.indisThick;
            AffineTransform tx1 = new AffineTransform();
            tx1.rotate(4.71238899230957);
            AffineTransform tx2 = new AffineTransform();
            tx2.rotate(1.0, 5.70796352E8);
            this.padNext1 = new int[]{(int)(-this.shapeMarrs.getBounds2D().getWidth()) * 3 / 4 - this.metrics.wIndis / 2 + (int)h / 2, 0, 0, 0};
            this.padNext2 = new int[]{-this.metrics.wIndis / 2, 0, 0, 0};
            this.shapeNext1.append(tx1.createTransformedShape((Shape)this.getTmpShapeNext(x, 0.0, d, w, h)));
            this.shapeNext2.append(tx2.createTransformedShape((Shape)this.getTmpShapeNext(x, 0.0, d, w, h)));
        }
    }

    private Path getTmpShapeNext(double x0, double y0, double d, double w, double h) {
        Path tmpShape = new Path();
        tmpShape.moveTo((Point2D)new Point2D.Double(x0, y0));
        tmpShape.lineTo((Point2D)new Point2D.Double(x0 + w / 2.0, y0));
        tmpShape.curveTo((Point2D)new Point2D.Double(x0 + w, y0), (Point2D)new Point2D.Double(x0 + w, y0), (Point2D)new Point2D.Double(x0 + w, y0 + d));
        tmpShape.lineTo((Point2D)new Point2D.Double(x0 + w, y0 + h));
        tmpShape.curveTo((Point2D)new Point2D.Double(x0 + w, y0 + h + d), (Point2D)new Point2D.Double(x0 + w, y0 + h + d), (Point2D)new Point2D.Double(x0 + w / 2.0, y0 + h + d));
        tmpShape.lineTo((Point2D)new Point2D.Double(x0, y0 + h + d));
        int l = (int)Math.max(Math.min(w / 2.0, h / 2.0), 2.0);
        tmpShape.moveTo((Point2D)new Point2D.Double(x0 + (w - (double)l) / 2.0 - 1.0, y0 + (h + d) / 2.0));
        tmpShape.lineTo((Point2D)new Point2D.Double(x0 + (w + (double)l) / 2.0 - 1.0, y0 + (h + d) / 2.0));
        tmpShape.moveTo((Point2D)new Point2D.Double(x0 + w / 2.0 - 1.0, y0 + (h + d - (double)l) / 2.0));
        tmpShape.lineTo((Point2D)new Point2D.Double(x0 + w / 2.0 - 1.0, y0 + (h + d + (double)l) / 2.0));
        return tmpShape;
    }

    protected TreeNode insertPlusMinus(Indi indi, TreeNode parent, boolean ancestors, boolean plus) {
        if (!this.model.isFoldSymbols()) {
            return parent;
        }
        Model model = this.model;
        Objects.requireNonNull(model);
        TreeNode node = this.model.add(new TreeNode(model.new Model.FoldUnfold(indi, ancestors), (Shape)(plus ? this.shapePlus : this.shapeMinus), this.padMinusPlus));
        this.model.add(new TreeArc(parent, node, false));
        return node;
    }

    protected TreeNode insertNextFamily(Indi indi, TreeNode parent, Fam[] fams, Entity entity, boolean isDescendant, boolean isFirst) {
        TreeNode node = parent;
        if (isDescendant) {
            if (fams == null || fams.length < 2) {
                return parent;
            }
            Model model = this.model;
            Objects.requireNonNull(model);
            node = this.model.add(new TreeNode(model.new Model.NextFamily(indi, fams, entity), (Shape)(isFirst ? this.shapeNext1 : this.shapeNext2), isFirst ? this.padNext1 : this.padNext2));
            this.model.add(new TreeArc(parent, node, false));
        } else {
            Model model = this.model;
            Objects.requireNonNull(model);
            node = this.model.add(new TreeNode(model.new Model.NextFamily(indi, fams, entity), (Shape)(isFirst && this.model.isVertical() || !isFirst && !this.model.isVertical() ? this.shapeNext1 : this.shapeNext2), isFirst ? this.padNext2 : this.padNext1));
            this.model.add(new TreeArc(parent, node, false));
        }
        return node;
    }

    private static class AncestorsWithFams
    extends Parser {
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int offsetSpouse;

        protected AncestorsWithFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
            int pi = (model.getMetrics().indisThick + 1) / 4;
            this.padMinusPlus = new int[]{-this.padIndis[0] + pi, 1, 1, this.padIndis[3] - pi};
            this.padFams = new int[]{this.padIndis[0], this.padIndis[1], this.padIndis[2], -((int)((double)metrics.pad * 0.4))};
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], this.padIndis[3]};
            this.offsetSpouse = (model.isVertical() ? metrics.wIndis : metrics.hIndis) / 2;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            return this.parse(fam, 0);
        }

        private TreeNode parse(Fam fam, int generation) {
            TreeNode node = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            Indi spouse = fam.getWife();
            Indi indi = fam.getHusband();
            if (!this.model.isVertical()) {
                Indi i = spouse;
                spouse = indi;
                indi = i;
            }
            Fam[] famsspouse = spouse != null ? spouse.getFamiliesWhereSpouse() : null;
            Fam[] famsindi = indi != null ? indi.getFamiliesWhereSpouse() : null;
            TreeNode nSpouse = this.model.add(new TreeNode(spouse, (Shape)this.shapeIndis, this.padHusband));
            this.model.add(new TreeArc(node, this.parse(spouse, nSpouse, this.hasParents(indi) ? -this.offsetSpouse : 0, generation + 1), false));
            TreeNode nMarr = fam.areDivorced() ? this.model.add(new TreeNode(null, (Shape)this.shapeDivs, this.padMarrs)) : (fam.areMarried() ? this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, this.padMarrs)) : this.model.add(new TreeNode(null, (Shape)this.shapeRels, this.padMarrs)));
            this.model.add(new TreeArc(node, nMarr, false));
            TreeNode nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padWife));
            this.model.add(new TreeArc(node, this.parse(indi, nIndi, this.hasParents(spouse) ? this.offsetSpouse : 0, generation + 1), false));
            if (famsspouse != null && famsspouse.length > 1) {
                TreeNode nEmpty2 = this.model.add(new TreeNode(null, (Shape)this.shapeEmpty, this.padEmpty));
                this.model.add(new TreeArc(nMarr, nEmpty2, false));
                this.insertNextFamily(spouse, nEmpty2, famsspouse, (Entity)indi, false, false);
            }
            if (famsindi != null && famsindi.length > 1) {
                TreeNode nEmpty1 = this.model.add(new TreeNode(null, (Shape)this.shapeEmpty, this.padEmpty));
                this.model.add(new TreeArc(nMarr, nEmpty1, false));
                this.insertNextFamily(indi, nEmpty1, famsindi, (Entity)spouse, false, true);
            }
            return node;
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis)), 0, 0);
        }

        private TreeNode parse(Indi indi, TreeNode nIndi, int align, int generation) {
            if (indi == null) {
                return nIndi;
            }
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                if (generation >= this.model.getMaxAscendants() || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, nIndi, true, true);
                } else {
                    TreeNode nMinus = this.insertPlusMinus(indi, nIndi, true, false);
                    this.model.add(new TreeArc(nMinus, this.parse(famc, generation), true));
                    nMinus.align = align;
                }
            }
            return nIndi;
        }

        private boolean hasParents(Indi indi) {
            if (indi == null) {
                return false;
            }
            if (this.model.isHideAncestors(indi)) {
                return false;
            }
            return indi.getFamiliesWhereChild() != null;
        }
    }

    private static class AncestorsNoFams
    extends Parser {
        protected AncestorsNoFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
        }

        @Override
        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int generation) {
            TreeNode node = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                if (generation >= this.model.getMaxAscendants() || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, node, true, true);
                } else {
                    TreeNode minus = this.insertPlusMinus(indi, node, true, false);
                    Indi wife = famc.getWife();
                    Indi husb = famc.getHusband();
                    if (!this.model.isVertical()) {
                        Indi i = wife;
                        wife = husb;
                        husb = i;
                    }
                    if (wife != null) {
                        this.model.add(new TreeArc(minus, this.parse(wife, generation + 1), true));
                    }
                    if (husb != null) {
                        this.model.add(new TreeArc(minus, this.parse(husb, generation + 1), true));
                    }
                }
            }
            return node;
        }
    }

    private static class DescendantsWithFams
    extends Parser {
        private TreeNode origin;
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int[] padNext;
        private int offsetHusband;

        protected DescendantsWithFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], 0};
            this.padFams = new int[]{-((int)((double)metrics.pad * 0.4)), this.padIndis[1], this.padIndis[2], this.padIndis[3]};
            int pf = (model.getMetrics().famsThick + 1) / 2;
            this.padMinusPlus = new int[]{-this.padIndis[0] + pf, 1, 1, this.padIndis[3]};
            this.offsetHusband = model.isVertical() ? -(metrics.wIndis + this.shapeMarrs.getBounds().width + model.getMetrics().indisThick / 2) / 2 : -(metrics.hIndis + this.shapeMarrs.getBounds().height + model.getMetrics().indisThick / 2) / 2;
        }

        @Override
        public TreeNode align(TreeNode other) {
            other.getPosition().setLocation(this.origin.getPosition());
            return other;
        }

        @Override
        protected TreeNode parse(Indi indi) {
            TreeNode nPivot = this.model.add(new TreeNode(null, null, null));
            this.origin = this.parse(indi, nPivot, 0);
            return nPivot;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            TreeNode nFam = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padIndis));
            Indi[] children = fam.getChildren();
            if (!this.model.isVertical()) {
                List<Indi> childrenList = Arrays.asList(children);
                Collections.reverse(childrenList);
                children = (Indi[])childrenList.toArray(Indi[]::new);
            }
            for (Indi children1 : children) {
                this.parse(children1, nFam, 0);
            }
            this.origin = nFam;
            return nFam;
        }

        private TreeNode parse(Indi indi, TreeNode pivot, int generation) {
            Fam[] famsindi;
            Fam[] famArray = famsindi = indi != null ? indi.getFamiliesWhereSpouse() : null;
            if (famsindi.length == 0) {
                TreeNode nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                return nIndi;
            }
            Fam fam = this.model.getFamily(indi, famsindi);
            Indi spouse = fam.getOtherSpouse(indi);
            Fam[] famsspouse = spouse != null ? spouse.getFamiliesWhereSpouse() : null;
            TreeNode nIndi = null;
            TreeNode nSpouse = null;
            TreeNode nMarr = null;
            TreeNode nFam = null;
            if (this.model.isVertical()) {
                nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padHusband){

                    @Override
                    public int getLongitude(Node node, Branch[] children, Orientation o) {
                        return super.getLongitude(node, children, o) + offsetHusband;
                    }
                });
                nSpouse = this.model.add(new TreeNode(spouse, (Shape)this.shapeIndis, this.padWife));
            } else {
                nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padWife));
                nSpouse = this.model.add(new TreeNode(spouse, (Shape)this.shapeIndis, this.padHusband){

                    @Override
                    public int getLongitude(Node node, Branch[] children, Orientation o) {
                        return super.getLongitude(node, children, o) + offsetHusband;
                    }
                });
            }
            nMarr = fam.areDivorced() ? this.model.add(new TreeNode(null, (Shape)this.shapeDivs, this.padMarrs)) : (fam.areMarried() ? this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, this.padMarrs)) : this.model.add(new TreeNode(null, (Shape)this.shapeRels, this.padMarrs)));
            nFam = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            if (this.model.isVertical()) {
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                this.model.add(new TreeArc(pivot, nMarr, false));
                this.model.add(new TreeArc(pivot, nSpouse, false));
                this.model.add(new TreeArc(nIndi, nFam, false));
            } else {
                this.model.add(new TreeArc(pivot, nSpouse, false));
                this.model.add(new TreeArc(pivot, nMarr, false));
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                this.model.add(new TreeArc(nSpouse, nFam, false));
            }
            if (famsspouse != null && famsspouse.length > 1) {
                TreeNode nEmpty2 = this.model.add(new TreeNode(null, (Shape)this.shapeEmpty, this.padEmpty));
                this.model.add(new TreeArc(nMarr, nEmpty2, false));
                this.insertNextFamily(spouse, nEmpty2, famsspouse, (Entity)fam, true, false);
            }
            if (famsindi != null && famsindi.length > 1) {
                TreeNode nEmpty1 = this.model.add(new TreeNode(null, (Shape)this.shapeEmpty, this.padEmpty));
                this.model.add(new TreeArc(nMarr, nEmpty1, false));
                this.insertNextFamily(indi, nEmpty1, famsindi, (Entity)fam, true, true);
            }
            Indi[] children = fam.getChildren();
            if (!this.model.isVertical()) {
                List<Indi> childrenList = Arrays.asList(children);
                Collections.reverse(childrenList);
                children = (Indi[])childrenList.toArray(Indi[]::new);
            }
            for (int c = 0; c < children.length; ++c) {
                if (c == 0) {
                    if (generation >= this.model.getMaxDescendants() || this.model.isHideDescendants(indi)) {
                        this.insertPlusMinus(indi, nFam, false, true);
                        break;
                    }
                    nFam = this.insertPlusMinus(indi, nFam, false, false);
                }
                this.parse(children[c], nFam, generation + 1);
            }
            return nIndi;
        }
    }

    private static class DescendantsNoFams
    extends Parser {
        protected DescendantsNoFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int generation) {
            TreeNode node = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam[] fams = indi.getFamiliesWhereSpouse();
            TreeNode pivot = node;
            ArrayList<Indi> l = new ArrayList<Indi>(fams.length);
            block0: for (Fam fam : fams) {
                Indi[] children = fam.getChildren();
                if (!this.model.isVertical()) {
                    List<Indi> childrenList = Arrays.asList(children);
                    Collections.reverse(childrenList);
                    children = (Indi[])childrenList.toArray(Indi[]::new);
                }
                for (Indi children1 : children) {
                    if (l.contains(children1)) continue;
                    l.add(children1);
                    if (node.getArcs().isEmpty()) {
                        if (generation >= this.model.getMaxDescendants() || this.model.isHideDescendants(indi)) {
                            this.insertPlusMinus(indi, node, false, true);
                            continue block0;
                        }
                        pivot = this.insertPlusMinus(indi, node, false, false);
                    }
                    this.model.add(new TreeArc(pivot, this.parse(children1, generation + 1), true));
                }
            }
            return node;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }
    }
}

