/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.FamMatcherOptions;
import ancestris.modules.gedcom.matchers.IndiMatcher;
import ancestris.util.GedcomUtilities;
import ancestris.util.swing.MergeEntityPanel;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FamMatcher
extends EntityMatcher<Fam, FamMatcherOptions> {
    private static final int NB_VALUES = 5;
    private final Map<Fam, Values> famValuesMap;
    private final IndiMatcher tmpIndi;
    private static final int[] points = new int[]{-20, -10, 3, 40, 50};

    public FamMatcher() {
        this.options = new FamMatcherOptions();
        this.tmpIndi = new IndiMatcher();
        this.famValuesMap = new HashMap<Fam, Values>();
    }

    private Values getValues(Fam fam) {
        Values values = this.famValuesMap.get(fam);
        if (values == null) {
            values = new Values(fam);
            this.famValuesMap.put(fam, values);
        }
        return values;
    }

    @Override
    public int compare(Fam left, Fam right) {
        Values leftValues = this.getValues(left);
        Values rightValues = this.getValues(right);
        int score = 0;
        int nbSure_Different = 0;
        int itemScore = 0;
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[0] * rightValues.coef[0] == 1) {
            Indi rightHusband;
            Indi leftHusband = left.getHusband();
            itemScore = leftHusband.equals(rightHusband = right.getHusband()) ? COMPARE_SURE_SAME : this.getLevel(this.tmpIndi.compare(leftHusband, rightHusband));
        }
        if (itemScore == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[1] * rightValues.coef[1] == 1) {
            Indi rightWife;
            Indi leftWife = left.getWife();
            itemScore = leftWife.equals(rightWife = right.getWife()) ? COMPARE_SURE_SAME : this.getLevel(this.tmpIndi.compare(leftWife, rightWife));
        }
        if (itemScore == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        if (leftValues.coef[2] * rightValues.coef[2] == 1) {
            MergeEntityPanel.AlignedProperties lists = new MergeEntityPanel.AlignedProperties((Property)left, (Property)right, new TagPath("FAM:CHIL"));
            Property[] leftProperties = lists.getLeft();
            Property[] rightProperties = lists.getRight();
            for (int i = 0; i < leftProperties.length; ++i) {
                PropertyChild pRightChild;
                PropertyChild pLeftChild;
                Indi leftChild = null;
                Indi rightChild = null;
                Property property = leftProperties[i];
                if (property instanceof PropertyChild && (pLeftChild = (PropertyChild)property).isValid()) {
                    leftChild = pLeftChild.getChild();
                }
                if ((property = rightProperties[i]) instanceof PropertyChild && (pRightChild = (PropertyChild)property).isValid()) {
                    leftChild = pRightChild.getChild();
                }
                if (leftChild == null || rightChild == null) continue;
                itemScore = leftChild.equals(rightChild) ? COMPARE_SURE_SAME : this.getLevel(this.tmpIndi.compare(leftChild, rightChild));
                score += points[itemScore];
            }
        }
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[3] * rightValues.coef[3] == 1 && (itemScore = FamMatcher.compareDates(leftValues.marrDate, rightValues.marrDate)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[4] * rightValues.coef[4] == 1 && (itemScore = FamMatcher.comparePlaces(leftValues.marrPlace, rightValues.marrPlace)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        if ((score += points[itemScore]) >= 40 && this.isSameLineage(left, right)) {
            return 0;
        }
        return score;
    }

    private boolean isSameLineage(Fam fam1, Fam fam2) {
        Indi husb1 = fam1.getHusband();
        Indi husb2 = fam2.getHusband();
        Indi wife1 = fam1.getWife();
        Indi wife2 = fam2.getWife();
        if (husb1 != null && husb1 != husb2 && (husb1.isAncestorOf(fam2) || husb1.isDescendantOf(fam2))) {
            return true;
        }
        if (wife1 != null && wife1 != wife2 && (wife1.isAncestorOf(fam2) || wife1.isDescendantOf(fam2))) {
            return true;
        }
        if (husb2 != null && husb2 != husb1 && (husb2.isAncestorOf(fam1) || husb2.isDescendantOf(fam1))) {
            return true;
        }
        return wife2 != null && wife2 != wife1 && (wife2.isAncestorOf(fam1) || wife2.isDescendantOf(fam1));
    }

    @Override
    public String[] getKeys(Fam entity) {
        HashSet<String> keys = new HashSet<String>();
        Values values = new Values(entity);
        this.famValuesMap.put(entity, values);
        keys.addAll(values.keys);
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(Fam fam) {
        return "00";
    }

    @Override
    public void reset() {
    }

    private class Values {
        private final EntityMatcher.DateData marrDate;
        private final EntityMatcher.PlaceData marrPlace;
        private final Set<String> keys;
        private final int[] coef = new int[5];

        public Values(Fam fam) {
            Indi husb = fam.getHusband();
            this.coef[0] = husb != null && FamMatcher.this.tmpIndi.putIndi(husb) ? 1 : 0;
            Indi wife = fam.getWife();
            this.coef[1] = wife != null && FamMatcher.this.tmpIndi.putIndi(wife) ? 1 : 0;
            this.coef[2] = 0;
            for (Indi child : fam.getChildren()) {
                if (child == null || !FamMatcher.this.tmpIndi.putIndi(child)) continue;
                this.coef[2] = 1;
            }
            PropertyDate date = fam.getMarriageDate();
            if (date == null) {
                this.marrDate = null;
                this.coef[3] = 0;
            } else {
                this.marrDate = new EntityMatcher.DateData(date);
                this.coef[3] = this.marrDate.isValid();
            }
            PropertyPlace place = fam.getMarriagePlace();
            if (place == null) {
                this.marrPlace = null;
                this.coef[4] = 0;
            } else {
                this.marrPlace = new EntityMatcher.PlaceData(place);
                this.coef[4] = this.marrPlace.isValid();
            }
            ArrayList<String> husbandNames = new ArrayList<String>();
            ArrayList<String> wifeNames = new ArrayList<String>();
            if (husb != null) {
                husbandNames.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce((String[])husb.getLastNames(), (boolean)false)));
                if (husbandNames.isEmpty()) {
                    husbandNames.add("?");
                }
            }
            if (wife != null) {
                wifeNames.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce((String[])wife.getLastNames(), (boolean)false)));
                if (wifeNames.isEmpty()) {
                    wifeNames.add("?");
                }
            }
            this.keys = new HashSet<String>();
            for (String husbandName : husbandNames) {
                for (String wifeName : wifeNames) {
                    this.keys.add(husbandName + " x " + wifeName);
                }
            }
        }
    }
}

