/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptbitcrusher";
declare description "bitcrusher filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
si = library("signals.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
};

// a slider for  bit-resolution
b = hslider("[1][lv2:integer]bit resolution", 8, 1, 30, 1): si.smoo;

// bitrcrusher
bitcrusher(nbits,x) = (funround(x * scaler) / scaler )
with {
  // a round function for earlier faust versions
  // for later versions the round() primitve can be used
  funround(x) = select2(( b>=a), b, a)
  with {
    a = int(x);
    b  = int(x + 0.5);
  };
  
  scaler = float(2^nbits - 1);
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,cptbasics.bargraphinput(i) :
				     cptbasics.stereodrywetmonofx(i, bitcrusher(b) ) :
				     cptbasics.bargraphoutput(i));

