/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereodelay";
declare description "stereo delay filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
si = library("signals.lib");
ba = library("basics.lib");
ma = library("maths.lib");
de = library("delays.lib");
cptbasics = library("lib/basics.lib");

// constanta used in this program
constant = environment {
	     nchannels = 2;// number of channels; do not change this - this is a stereo filter
	   };

//a slider for the gain
gain = hslider("[1]gain",1,0,1,0.01) : si.smoo;

//a slider for the feedback
feedback = hslider("[2]feedback", 0.5,0,1,0.01) : si.smoo;

//a slider for random feedback
randomgain = hslider("[3][lv2: integer]randomize feedback",0,0,100,1)/100 : si.smoo;

//a slider for the delay on the left channel
M = 60 / hslider("[4][lv2: integer]delay bpm left",120,1,500,1);// M in seconds

//a slider for the delay on the right channel
N = 60 / hslider("[5][lv2: integer]delay bpm right",120,1,500,1);// N in seconds

//calculating the echo
monoecho(d,f) = +~bounce(d) * feedback(f) : smoothd with {
      
  bounce(d) = de.sdelay(ma.SR * 60,1024,d);

  feedback(f) = f * (1 - randomgain,4 * randomgain * noised(12345,d) :>_);

  smoothd = si.smooth(ba.tau2pole(0.001));
};

noised(seed, period) = random / RANDMAX
with {
  mask = 4294967295; // 2^32-1
  random = +(seed) ~ ba.sAndH(clock, *(1103515245) & mask); // "linear congruential"
  clock = ba.period(period) == 0;
  RANDMAX = 2147483647.0; // = 2^31-1 = MAX_SIGNED_INT in 32 bits
};

// the process, that is going to be executed
process = (cptbasics.bargraphinput(0) :
	   cptbasics.stereodrywetmonofx(0, monoecho(ma.SR*M,feedback)) :
	   cptbasics.bargraphoutput(0)),
	  (cptbasics.bargraphinput(1) :
	   cptbasics.stereodrywetmonofx(1, monoecho(ma.SR*N,feedback) @(ma.SR*(N/2)) ) :
	   cptbasics.bargraphoutput(1)) :
	  
	  // constant.nchannels in parallel
	  par(i, constant.nchannels, _ * gain);
