/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereolowhighpass";
declare description "stereo lowpass highpass filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
si = library("signals.lib");
fi = library("effect.lib");
cptbasics = library("lib/basics.lib");

// constant variables used in this program
constant = environment {
	     nchannels = 2;// number of channels; do not change this - this is a stereo filter
	   };

//a checkbox to reverse both channels
reversechannels = checkbox ("[1]reverse channels");

//a function for the lowpass filter and the gain of the channel
lowpass = fi.lowpass(1, lowpassctFreq)
with {
  lowpassctFreq = hslider("[2][unit:Hz][lv2:integer]lowpass cutoff frequency", 20000, 1, 20000, 1) : si.smoo;
};

//a function for the highpass filter and the gain of the channel
highpass = fi.highpass(1, highpassctFreq)
with {
  highpassctFreq = hslider("[4][unit:Hz][lv2:integer]highpass cutoff frequency", 1, 1, 20000, 1) : si.smoo;
};

// the process, that is going to be executed
process = (cptbasics.bargraphinput(0) : 
	   cptbasics.stereodrywetmonofx(0, lowpass * (reversechannels==0) + (highpass * (reversechannels==1))) :
	   cptbasics.bargraphoutput(0)),
	  (cptbasics.bargraphinput(1) :
	   cptbasics.stereodrywetmonofx (1, highpass * (reversechannels==0) + (lowpass * (reversechannels==1))) : 
	   cptbasics.bargraphoutput(1));

