/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.device.graupner.ConvertContextMenu;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.device.graupner.Transmitter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class FileTransferTabItem
extends CTabItem {
    private static final int INNER_COMPOSITE_HEIGHT = 620 + (GDE.IS_MAC ? 80 : 70);
    static final String $CLASS_NAME = FileTransferTabItem.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    private ScrolledComposite scrolledComposite;
    private Composite innerComposite;
    private Composite outherComposite;
    private Composite filler;
    private Group pcFolderGroup;
    private Button pcBaseFolderButton;
    private CLabel pcBaseFolderSelectionLabel;
    private Tree pcFolderTree;
    private TreeItem pcRootTreeItem;
    private Table pcFoldersTable;
    private Group sdCardActionGroup;
    private Composite sdCardSizeComposite;
    private Composite mdlBackupComposite;
    private CLabel sdCardSpaceinfoLabel;
    private CLabel mdlBackupInfoLabel;
    private ProgressBar sdCardSpaceProgressBar;
    private ProgressBar mdlBackupProgressBar;
    private Composite sdCardActionComposite;
    private Button connectButton;
    private Button upDownLoadButton;
    private Button stopButton;
    private Button modelLoadButton;
    private Button disconnectButton;
    private Button deleteFileButton;
    private Tree sdFolderTree;
    private TreeItem sdRootDirectoryTreeItem;
    private Table sdCardFoldersTable;
    private Composite tranferProgressComposite;
    private CLabel transferProgressLabel;
    private ProgressBar transferProgressBar;
    private TableColumn indexColumn;
    private TableColumn fileNameColum;
    private TableColumn fileDateColum;
    private TableColumn fileTimeColum;
    private TableColumn fileSizeColum;
    private Group mdlBackupGroup;
    final Menu popupmenu;
    final ConvertContextMenu contextMenu;
    final CTabFolder tabFolder;
    final HoTTAdapter device;
    final HoTTAdapterSerialPort serialPort;
    final DataExplorer application = DataExplorer.getInstance();
    final Settings settings = Settings.getInstance();
    HashMap<String, String[]> sdFoldersAndFiles = new HashMap();
    StringBuilder selectedSdFolder;
    StringBuilder selectedPcBaseFolder;
    StringBuilder selectedPcFolder = this.selectedPcBaseFolder = new StringBuilder().append(this.settings.getDataFilePath());
    TreeItem lastSelectedSdTreeItem;
    TreeItem lastSelectedPcTreeItem;
    SelectionAdapter upLoadSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            log.log(Level.FINEST, "upLoadButton.widgetSelected, event=" + String.valueOf(evt));
            TableItem[] selection = FileTransferTabItem.this.sdCardFoldersTable.getSelection();
            if (selection == null || selection.length < 1 || FileTransferTabItem.this.selectedSdFolder == null || FileTransferTabItem.this.selectedSdFolder.length() < 5 || FileTransferTabItem.this.selectedSdFolder.lastIndexOf("/") < 0) {
                FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2431"));
                return;
            }
            if (FileTransferTabItem.this.selectedPcFolder == null || FileTransferTabItem.this.selectedPcFolder.length() == 0) {
                FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2433"));
                return;
            }
            final StringBuilder filesInfo = new StringBuilder();
            long tmpTotalSize = 0L;
            for (TableItem element : selection) {
                String[] date = element.getText(2).split("-");
                String[] time = element.getText(3).split(":");
                GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(date[0]), Integer.parseInt(date[1]) - 1, Integer.parseInt(date[2]), Integer.parseInt(time[0]), Integer.parseInt(time[1]));
                long timeStamp = calendar.getTimeInMillis();
                filesInfo.append(element.getText(0)).append(",").append(element.getText(1)).append(",").append(timeStamp).append(";");
                tmpTotalSize += Long.parseLong(element.getText(4));
            }
            log.log(Level.FINE, "Selection={" + String.valueOf(filesInfo) + "}");
            final long totalSize = tmpTotalSize;
            new Thread("Upload"){

                @Override
                public void run() {
                    try {
                        FileTransferTabItem.this.enableActionButtons(true);
                        FileTransferTabItem.this.serialPort.setInterruptedByUser(false);
                        FileTransferTabItem.this.serialPort.upLoadFiles(FileTransferTabItem.this.selectedSdFolder.toString() + "/", FileTransferTabItem.this.selectedPcFolder.toString(), filesInfo.toString().split(";"), totalSize, FileTransferTabItem.this);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        FileTransferTabItem.this.application.openMessageDialog(e.getMessage());
                    }
                    finally {
                        FileTransferTabItem.this.enableActionButtons(false);
                    }
                }
            }.start();
        }
    };
    private SelectionAdapter downLoadSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            log.log(Level.FINEST, "downLoadButton.widgetSelected, event=" + String.valueOf(evt));
            TableItem[] selection = FileTransferTabItem.this.pcFoldersTable.getSelection();
            if (selection == null || selection.length < 1 || FileTransferTabItem.this.selectedSdFolder == null || FileTransferTabItem.this.selectedSdFolder.length() < 5 || FileTransferTabItem.this.selectedSdFolder.lastIndexOf("/") < 0) {
                FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2431"));
                return;
            }
            if (FileTransferTabItem.this.selectedSdFolder == null || FileTransferTabItem.this.selectedPcFolder.length() == 0) {
                FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2433"));
                return;
            }
            final StringBuilder filesInfo = new StringBuilder();
            long tmpTotalSize = 0L;
            for (TableItem element : selection) {
                filesInfo.append(element.getText(0)).append(",").append(element.getText(1)).append(";");
                tmpTotalSize += Long.parseLong(element.getText(4));
            }
            log.log(Level.FINE, "Selection={" + String.valueOf(filesInfo) + "}");
            final long totalSize = tmpTotalSize;
            Thread tmpThread = new Thread("Download"){

                @Override
                public void run() {
                    try {
                        FileTransferTabItem.this.enableActionButtons(true);
                        FileTransferTabItem.this.serialPort.setInterruptedByUser(false);
                        FileTransferTabItem.this.serialPort.downLoadFiles(FileTransferTabItem.this.selectedSdFolder.toString() + "/", FileTransferTabItem.this.selectedPcFolder.toString(), filesInfo.toString().split(";"), totalSize, FileTransferTabItem.this);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        FileTransferTabItem.this.application.openMessageDialog(e.getMessage());
                    }
                    finally {
                        FileTransferTabItem.this.enableActionButtons(false);
                    }
                }
            };
            tmpThread.start();
        }
    };

    public FileTransferTabItem(CTabFolder parent, int style, int position, HoTTAdapter useDevice, HoTTAdapterSerialPort useSerialPort) {
        super(parent, style, position);
        this.tabFolder = parent;
        this.setFont(SWTResourceManager.getFont((Control)this.application, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1)), (int)0));
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.setText(Messages.getString((String)"GDE_MSGT2426"));
        SWTResourceManager.registerResourceUser((Widget)this);
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new ConvertContextMenu();
        this.create();
    }

    private void create() {
        try {
            this.scrolledComposite = new ScrolledComposite((Composite)this.tabFolder, 768);
            this.setControl((Control)this.scrolledComposite);
            this.outherComposite = new Composite((Composite)this.scrolledComposite, 0);
            this.outherComposite.setBounds(0, 0, 1100, INNER_COMPOSITE_HEIGHT + 10);
            this.outherComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            this.innerComposite = new Composite(this.outherComposite, 0);
            this.innerComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            this.innerComposite.setSize(1110, INNER_COMPOSITE_HEIGHT);
            this.innerComposite.setLocation(0, 0);
            RowLayout innerCompositeLayout = new RowLayout(512);
            this.innerComposite.setLayout((Layout)innerCompositeLayout);
            this.pcFolderGroup = new Group(this.innerComposite, 0);
            if (!GDE.IS_MAC) {
                this.pcFolderGroup.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowLayout pcGroupLayout = new RowLayout(256);
            this.pcFolderGroup.setLayout((Layout)pcGroupLayout);
            this.pcFolderGroup.setLayoutData((Object)new RowData(1090, 250));
            this.pcFolderGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)0));
            this.pcFolderGroup.setText(Messages.getString((String)"GDE_MSGT2427"));
            this.filler = new Composite((Composite)this.pcFolderGroup, 0);
            if (!GDE.IS_MAC) {
                this.filler.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            GridLayout composite1Layout = new GridLayout();
            composite1Layout.makeColumnsEqualWidth = true;
            RowData composite1LData = new RowData();
            composite1LData.width = 5;
            composite1LData.height = 20;
            this.filler.setLayoutData((Object)composite1LData);
            this.filler.setLayout((Layout)composite1Layout);
            this.pcBaseFolderButton = new Button((Composite)this.pcFolderGroup, 0x1000008);
            RowData pcBaseFolderButtonLData = new RowData();
            pcBaseFolderButtonLData.width = 155;
            pcBaseFolderButtonLData.height = 33;
            this.pcBaseFolderButton.setLayoutData((Object)pcBaseFolderButtonLData);
            this.pcBaseFolderButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.pcBaseFolderButton.setText(Messages.getString((String)"GDE_MSGT2432"));
            this.pcBaseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "pcBaseFolderButton.widgetSelected, event=" + String.valueOf(evt));
                    String baseFolderName = FileTransferTabItem.this.application.openDirFileDialog(Messages.getString((String)"GDE_MSGT2432"), FileTransferTabItem.this.selectedPcBaseFolder.toString());
                    if (baseFolderName != null && baseFolderName.length() > 0) {
                        FileTransferTabItem.this.pcBaseFolderSelectionLabel.setText(baseFolderName);
                        FileTransferTabItem.this.updatePcBaseFolder();
                    }
                }
            });
            this.pcBaseFolderSelectionLabel = new CLabel((Composite)this.pcFolderGroup, 0);
            if (!GDE.IS_MAC) {
                this.pcBaseFolderSelectionLabel.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            this.pcBaseFolderSelectionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.pcBaseFolderSelectionLabel.setText(this.selectedPcBaseFolder.toString());
            RowData pcBaseFolderSelectionLabelLData = new RowData();
            pcBaseFolderSelectionLabelLData.width = 917;
            pcBaseFolderSelectionLabelLData.height = 28;
            this.pcBaseFolderSelectionLabel.setLayoutData((Object)pcBaseFolderSelectionLabelLData);
            this.filler = new Composite((Composite)this.pcFolderGroup, 0);
            if (!GDE.IS_MAC) {
                this.filler.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            GridLayout compositeLayout = new GridLayout();
            compositeLayout.makeColumnsEqualWidth = true;
            RowData compositeLData = new RowData();
            compositeLData.width = 5;
            compositeLData.height = 180;
            this.filler.setLayoutData((Object)compositeLData);
            this.filler.setLayout((Layout)compositeLayout);
            RowData pcFolderTreeLData = new RowData();
            pcFolderTreeLData.width = 425;
            pcFolderTreeLData.height = 175;
            this.pcFolderTree = new Tree((Composite)this.pcFolderGroup, 2048);
            this.pcFolderTree.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.pcFolderTree.setLayoutData((Object)pcFolderTreeLData);
            this.pcFolderTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "pcFolderTree.widgetSelected, event=" + String.valueOf(evt));
                    TreeItem evtItem = (TreeItem)evt.item;
                    log.log(Level.FINEST, "pcFolderTree.widgetSelected, tree item = " + evtItem.getText());
                    FileTransferTabItem.this.updateSelectedPcFolder(evtItem);
                }
            });
            this.pcRootTreeItem = new TreeItem(this.pcFolderTree, 0);
            this.pcRootTreeItem.setText(this.selectedPcBaseFolder.substring(this.selectedPcBaseFolder.lastIndexOf("/") + 1));
            this.updatePcBaseFolder();
            this.filler = new Composite((Composite)this.pcFolderGroup, 0);
            if (!GDE.IS_MAC) {
                this.filler.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            composite1Layout = new GridLayout();
            composite1Layout.makeColumnsEqualWidth = true;
            composite1LData = new RowData();
            composite1LData.width = 15;
            composite1LData.height = 180;
            this.filler.setLayoutData((Object)composite1LData);
            this.filler.setLayout((Layout)composite1Layout);
            this.pcFoldersTable = new Table((Composite)this.pcFolderGroup, 67586);
            RowData targetDirectoryTableLData = new RowData();
            targetDirectoryTableLData.width = 580;
            targetDirectoryTableLData.height = 175;
            this.pcFoldersTable.setLayoutData((Object)targetDirectoryTableLData);
            this.pcFoldersTable.setLinesVisible(true);
            this.pcFoldersTable.setHeaderVisible(true);
            this.pcFoldersTable.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.setTableHeader(this.pcFoldersTable);
            this.pcFoldersTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem item = (TableItem)event.item;
                    log.log(Level.FINE, "Selection={" + item.getText(1) + "}");
                    TableItem[] selection = FileTransferTabItem.this.pcFoldersTable.getSelection();
                    FileTransferTabItem.this.upDownLoadButton.setText(Messages.getString((String)"GDE_MSGT2436"));
                    FileTransferTabItem.this.upDownLoadButton.removeSelectionListener((SelectionListener)FileTransferTabItem.this.upLoadSelectionAdapter);
                    FileTransferTabItem.this.upDownLoadButton.removeSelectionListener((SelectionListener)FileTransferTabItem.this.downLoadSelectionAdapter);
                    FileTransferTabItem.this.upDownLoadButton.addSelectionListener((SelectionListener)FileTransferTabItem.this.downLoadSelectionAdapter);
                    if (log.isLoggable(Level.FINE)) {
                        StringBuilder sb = new StringBuilder();
                        for (TableItem element : selection) {
                            sb.append(element).append(" ");
                        }
                        log.log(Level.FINE, "Selection={" + sb.toString() + "}");
                    }
                    FileTransferTabItem.this.contextMenu.createMenu(FileTransferTabItem.this.popupmenu, Transmitter.detectTransmitter(item.getText(1), String.valueOf(FileTransferTabItem.this.selectedPcFolder) + "/" + item.getText(1)), String.valueOf(FileTransferTabItem.this.selectedPcFolder) + "/" + item.getText(1));
                }
            });
            this.pcFoldersTable.setMenu(this.popupmenu);
            this.mdlBackupGroup = new Group(this.innerComposite, 0);
            if (!GDE.IS_MAC) {
                this.mdlBackupGroup.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            this.mdlBackupGroup.setLayout((Layout)new RowLayout(256));
            this.mdlBackupGroup.setLayoutData((Object)new RowData(1090, 50));
            this.mdlBackupGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)0));
            this.mdlBackupGroup.setText("MDL Backup");
            this.filler = new Composite((Composite)this.mdlBackupGroup, 0);
            if (!GDE.IS_MAC) {
                this.filler.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            this.filler.setLayoutData((Object)new RowData(5, 30));
            this.modelLoadButton = new Button((Composite)this.mdlBackupGroup, 0x1000008);
            this.modelLoadButton.setLayoutData((Object)new RowData(155, 33));
            this.modelLoadButton.setEnabled(true);
            this.modelLoadButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.modelLoadButton.setText(Messages.getString((String)"GDE_MSGT2437"));
            this.modelLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "downLoadButton.widgetSelected, event=" + String.valueOf(evt));
                    new Thread("BackupModels"){

                        @Override
                        public void run() {
                            try {
                                if (FileTransferTabItem.this.selectedPcFolder.length() < 3) {
                                    FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE2400"));
                                    return;
                                }
                                FileTransferTabItem.this.serialPort.loadModelData(new ArrayList<String>(), new ArrayList<String>(), FileTransferTabItem.this.selectedPcFolder.toString(), FileTransferTabItem.this.mdlBackupInfoLabel, FileTransferTabItem.this.mdlBackupProgressBar);
                                FileTransferTabItem.this.updatePcFolder();
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                                FileTransferTabItem.this.application.openMessageDialog(e.getMessage());
                            }
                        }
                    }.start();
                }
            });
            this.mdlBackupComposite = new Composite((Composite)this.mdlBackupGroup, 0);
            if (!GDE.IS_MAC) {
                this.mdlBackupComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            this.mdlBackupComposite.setLayoutData((Object)new RowData(900, 36));
            this.mdlBackupComposite.setLayout((Layout)new RowLayout(256));
            this.mdlBackupInfoLabel = new CLabel(this.mdlBackupComposite, 0);
            if (!GDE.IS_MAC) {
                this.mdlBackupInfoLabel.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            this.mdlBackupInfoLabel.setLayoutData((Object)new RowData(800, 15));
            this.mdlBackupInfoLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mdlBackupInfoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{0, 0}));
            this.mdlBackupProgressBar = new ProgressBar(this.mdlBackupComposite, 0);
            this.mdlBackupProgressBar.setLayoutData((Object)new RowData(900, 10));
            this.mdlBackupProgressBar.setMinimum(0);
            this.mdlBackupProgressBar.setMaximum(100);
            this.updateSelectedPcFolder(null);
            this.sdCardActionGroup = new Group(this.innerComposite, 0);
            if (!GDE.IS_MAC) {
                this.sdCardActionGroup.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowLayout TransmitterSourceGroupLayout = new RowLayout(256);
            this.sdCardActionGroup.setLayout((Layout)TransmitterSourceGroupLayout);
            this.sdCardActionGroup.setLayoutData((Object)new RowData(1090, 280));
            this.sdCardActionGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)0));
            this.sdCardActionGroup.setText(Messages.getString((String)"GDE_MSGT2428"));
            this.sdCardActionGroup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    log.log(Level.FINER, "sdCardActionGroup.paintControl, event=" + String.valueOf(evt));
                    if (FileTransferTabItem.this.device.getBaudeRate() == 115200) {
                        FileTransferTabItem.this.sdCardActionGroup.setEnabled(true);
                        FileTransferTabItem.this.connectButton.setEnabled(true);
                        if (!FileTransferTabItem.this.sdCardActionGroup.getText().equals(Messages.getString((String)"GDE_MSGT2428"))) {
                            FileTransferTabItem.this.sdCardActionGroup.setText(Messages.getString((String)"GDE_MSGT2428"));
                        }
                    } else {
                        FileTransferTabItem.this.sdCardActionGroup.setEnabled(false);
                        FileTransferTabItem.this.connectButton.setEnabled(false);
                        if (!FileTransferTabItem.this.sdCardActionGroup.getText().equals(Messages.getString((String)"GDE_MSGW2402"))) {
                            FileTransferTabItem.this.sdCardActionGroup.setText(Messages.getString((String)"GDE_MSGW2402"));
                        }
                    }
                }
            });
            this.sdCardSizeComposite = new Composite((Composite)this.sdCardActionGroup, 0);
            if (!GDE.IS_MAC) {
                this.sdCardSizeComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowLayout sdCardSizeCompositeLayout = new RowLayout(256);
            RowData sdCardSizeCompositeLData = new RowData();
            sdCardSizeCompositeLData.width = 923;
            sdCardSizeCompositeLData.height = 36;
            this.sdCardSizeComposite.setLayoutData((Object)sdCardSizeCompositeLData);
            this.sdCardSizeComposite.setLayout((Layout)sdCardSizeCompositeLayout);
            this.sdCardSpaceinfoLabel = new CLabel(this.sdCardSizeComposite, 0);
            if (!GDE.IS_MAC) {
                this.sdCardSpaceinfoLabel.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowData sdCardSpaceinfoLabelLData = new RowData();
            sdCardSpaceinfoLabelLData.width = 869;
            sdCardSpaceinfoLabelLData.height = 18;
            this.sdCardSpaceinfoLabel.setLayoutData((Object)sdCardSpaceinfoLabelLData);
            this.sdCardSpaceinfoLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.sdCardSpaceinfoLabel.setText(Messages.getString((String)"GDE_MSGT2450", (Object[])new Object[]{0, 0}));
            this.sdCardSpaceProgressBar = new ProgressBar(this.sdCardSizeComposite, 0);
            RowData sdCardSpaceProgressBarLData = new RowData();
            sdCardSpaceProgressBarLData.width = 869;
            sdCardSpaceProgressBarLData.height = 10;
            this.sdCardSpaceProgressBar.setLayoutData((Object)sdCardSpaceProgressBarLData);
            this.sdCardSpaceProgressBar.setMinimum(0);
            this.sdCardSpaceProgressBar.setMaximum(100);
            this.sdCardActionComposite = new Composite((Composite)this.sdCardActionGroup, 0);
            if (!GDE.IS_MAC) {
                this.sdCardActionComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            GridLayout composite2Layout = new GridLayout();
            composite2Layout.makeColumnsEqualWidth = true;
            this.sdCardActionComposite.setLayout((Layout)composite2Layout);
            RowData composite2LData = new RowData();
            composite2LData.width = 178;
            composite2LData.height = 190;
            this.sdCardActionComposite.setLayoutData((Object)composite2LData);
            this.connectButton = new Button(this.sdCardActionComposite, 0x1000008);
            GridData connectButtonLData = new GridData();
            connectButtonLData.widthHint = 155;
            connectButtonLData.heightHint = 33;
            this.connectButton.setLayoutData((Object)connectButtonLData);
            this.connectButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.connectButton.setText(Messages.getString((String)"GDE_MSGT2429"));
            this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "connectButton.widgetSelected, event=" + String.valueOf(evt));
                    try {
                        if (128 == FileTransferTabItem.this.application.openOkCancelMessageDialog(Messages.getString((String)"GDE_MSGW2403"))) {
                            return;
                        }
                        if (!FileTransferTabItem.this.serialPort.isConnected()) {
                            String toolTipText = HoTTAdapter.getImportToolTip();
                            FileTransferTabItem.this.device.configureSerialPortMenu(1, toolTipText, toolTipText);
                            FileTransferTabItem.this.serialPort.open();
                        }
                        FileTransferTabItem.this.enableSerialButtons(true);
                        FileTransferTabItem.this.serialPort.prepareSdCard(0);
                        long[] sdSizes = FileTransferTabItem.this.serialPort.querySdCardSizes(0);
                        if (sdSizes[0] == 0L && sdSizes[1] == 0L) {
                            FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGW2401"));
                            return;
                        }
                        FileTransferTabItem.this.updateSdCardSizes(sdSizes);
                        FileTransferTabItem.this.listSdCardBaseDirs();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        FileTransferTabItem.this.serialPort.close();
                        FileTransferTabItem.this.sdRootDirectoryTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                        FileTransferTabItem.this.enableSerialButtons(false);
                        FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0025", (Object[])new String[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            });
            this.upDownLoadButton = new Button(this.sdCardActionComposite, 0x1000008);
            GridData upLoadButtonLData = new GridData();
            upLoadButtonLData.widthHint = 155;
            upLoadButtonLData.heightHint = 33;
            this.upDownLoadButton.setLayoutData((Object)upLoadButtonLData);
            this.upDownLoadButton.setEnabled(false);
            this.upDownLoadButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.upDownLoadButton.setText(Messages.getString((String)"GDE_MSGT2434"));
            this.stopButton = new Button(this.sdCardActionComposite, 0x1000008);
            GridData stopButtonnLData = new GridData();
            stopButtonnLData.widthHint = 155;
            stopButtonnLData.heightHint = 33;
            this.stopButton.setLayoutData((Object)stopButtonnLData);
            this.stopButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stopButton.setText(Messages.getString((String)"GDE_MSGT2435"));
            this.stopButton.setEnabled(false);
            this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stopButton.widgetSelected, event=" + String.valueOf(evt));
                    FileTransferTabItem.this.serialPort.setInterruptedByUser(true);
                }
            });
            this.disconnectButton = new Button(this.sdCardActionComposite, 0x1000008);
            GridData disconnectButtonLData = new GridData();
            disconnectButtonLData.widthHint = 155;
            disconnectButtonLData.heightHint = 33;
            this.disconnectButton.setLayoutData((Object)disconnectButtonLData);
            this.disconnectButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.disconnectButton.setText(Messages.getString((String)"GDE_MSGT2441"));
            this.disconnectButton.setEnabled(false);
            this.disconnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "disconnectButton.widgetSelected, event=" + String.valueOf(evt));
                    FileTransferTabItem.this.serialPort.setInterruptedByUser(true);
                    FileTransferTabItem.this.serialPort.close();
                    FileTransferTabItem.this.setTableHeader(FileTransferTabItem.this.sdCardFoldersTable);
                    for (TreeItem item : FileTransferTabItem.this.sdRootDirectoryTreeItem.getItems()) {
                        for (TreeItem subItem : item.getItems()) {
                            log.log(Level.FINER, "dispose " + subItem.getText());
                            subItem.dispose();
                        }
                        log.log(Level.FINER, "dispose " + item.getText());
                        item.dispose();
                    }
                    FileTransferTabItem.this.sdRootDirectoryTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                    FileTransferTabItem.this.enableActionButtons(false);
                    FileTransferTabItem.this.enableSerialButtons(false);
                    String toolTipText = HoTTAdapter.getImportToolTip();
                    FileTransferTabItem.this.device.configureSerialPortMenu(2, toolTipText, toolTipText);
                }
            });
            RowData sourceFolderTreeLData = new RowData();
            sourceFolderTreeLData.width = 250;
            sourceFolderTreeLData.height = 170;
            this.sdFolderTree = new Tree((Composite)this.sdCardActionGroup, 2816);
            this.sdFolderTree.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.sdFolderTree.setLayoutData((Object)sourceFolderTreeLData);
            this.sdFolderTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "sourceFolderTree.widgetSelected, event=" + String.valueOf(evt));
                    TreeItem evtTreeitem = (TreeItem)evt.item;
                    log.log(Level.FINEST, "sourceFolderTree.widgetSelected, tree item = " + evtTreeitem.getText());
                    if (FileTransferTabItem.this.serialPort.isConnected() && !evtTreeitem.getText().equals("/")) {
                        FileTransferTabItem.this.updateSelectedSdFolder(evtTreeitem);
                    }
                }
            });
            this.sdRootDirectoryTreeItem = new TreeItem(this.sdFolderTree, 0);
            this.sdRootDirectoryTreeItem.setText("/");
            this.sdRootDirectoryTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
            this.filler = new Composite((Composite)this.sdCardActionGroup, 0);
            if (!GDE.IS_MAC) {
                this.filler.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            composite1Layout = new GridLayout();
            composite1Layout.makeColumnsEqualWidth = true;
            composite1LData = new RowData();
            composite1LData.width = 15;
            composite1LData.height = 150;
            this.filler.setLayoutData((Object)composite1LData);
            this.filler.setLayout((Layout)composite1Layout);
            this.sdCardFoldersTable = new Table((Composite)this.sdCardActionGroup, 67586);
            RowData sourceDirectoryTableLData = new RowData();
            sourceDirectoryTableLData.width = 580;
            sourceDirectoryTableLData.height = 170;
            this.sdCardFoldersTable.setLayoutData((Object)sourceDirectoryTableLData);
            this.sdCardFoldersTable.setLinesVisible(true);
            this.sdCardFoldersTable.setHeaderVisible(true);
            this.sdCardFoldersTable.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.setTableHeader(this.sdCardFoldersTable);
            this.sdCardFoldersTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem item = (TableItem)event.item;
                    log.log(Level.FINE, "Selection={" + item.getText(1) + "}");
                    TableItem[] selection = FileTransferTabItem.this.sdCardFoldersTable.getSelection();
                    FileTransferTabItem.this.upDownLoadButton.setText(Messages.getString((String)"GDE_MSGT2430"));
                    FileTransferTabItem.this.upDownLoadButton.removeSelectionListener((SelectionListener)FileTransferTabItem.this.downLoadSelectionAdapter);
                    FileTransferTabItem.this.upDownLoadButton.removeSelectionListener((SelectionListener)FileTransferTabItem.this.upLoadSelectionAdapter);
                    FileTransferTabItem.this.upDownLoadButton.addSelectionListener((SelectionListener)FileTransferTabItem.this.upLoadSelectionAdapter);
                    if (log.isLoggable(Level.FINE)) {
                        StringBuilder sb = new StringBuilder();
                        for (TableItem element : selection) {
                            sb.append(element).append(" ");
                        }
                        log.log(Level.FINE, "Selection={" + sb.toString() + "}");
                    }
                }
            });
            this.tranferProgressComposite = new Composite((Composite)this.sdCardActionGroup, 0);
            if (!GDE.IS_MAC) {
                this.tranferProgressComposite.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowLayout spacerCompositeLayout = new RowLayout(256);
            RowData spacerCompositeLData = new RowData();
            spacerCompositeLData.width = 915;
            spacerCompositeLData.height = 35;
            this.tranferProgressComposite.setLayoutData((Object)spacerCompositeLData);
            this.tranferProgressComposite.setLayout((Layout)spacerCompositeLayout);
            this.transferProgressLabel = new CLabel(this.tranferProgressComposite, 0);
            if (!GDE.IS_MAC) {
                this.transferProgressLabel.setBackground(SWTResourceManager.getColor((Color)this.settings.getUtilitySurroundingBackground()));
            }
            RowData transferProgressLabelLData = new RowData();
            transferProgressLabelLData.width = 870;
            transferProgressLabelLData.height = 18;
            this.transferProgressLabel.setLayoutData((Object)transferProgressLabelLData);
            this.transferProgressLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.transferProgressLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{0, 0}));
            RowData transferProgressBarLData = new RowData();
            transferProgressBarLData.width = 870;
            transferProgressBarLData.height = 10;
            this.transferProgressBar = new ProgressBar(this.tranferProgressComposite, 0);
            this.transferProgressBar.setLayoutData((Object)transferProgressBarLData);
            this.transferProgressBar.setMinimum(0);
            this.transferProgressBar.setMaximum(100);
            this.deleteFileButton = new Button((Composite)this.sdCardActionGroup, 0x1000008);
            RowData deleteFileButtonLData = new RowData();
            deleteFileButtonLData.width = 155;
            deleteFileButtonLData.height = 33;
            this.deleteFileButton.setLayoutData((Object)deleteFileButtonLData);
            this.deleteFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.deleteFileButton.setText(Messages.getString((String)"GDE_MSGT2444"));
            this.deleteFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "deleteFileButton.widgetSelected, event=" + String.valueOf(evt));
                    TableItem[] selection = FileTransferTabItem.this.sdCardFoldersTable.getSelection();
                    if (selection == null || selection.length < 1 || FileTransferTabItem.this.selectedSdFolder == null || FileTransferTabItem.this.selectedSdFolder.length() < 5 || FileTransferTabItem.this.selectedSdFolder.lastIndexOf("/") < 0) {
                        FileTransferTabItem.this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2431"));
                        return;
                    }
                    StringBuilder filesInfo = new StringBuilder();
                    for (TableItem element : selection) {
                        filesInfo.append(element.getText(1)).append(";");
                    }
                    log.log(Level.FINE, "Selection={" + String.valueOf(filesInfo) + "}");
                    try {
                        FileTransferTabItem.this.enableActionButtons(true);
                        FileTransferTabItem.this.serialPort.deleteFiles(FileTransferTabItem.this.selectedSdFolder.toString() + "/", filesInfo.toString().split(";"));
                        FileTransferTabItem.this.updateSelectedSdFolder(FileTransferTabItem.this.lastSelectedSdTreeItem);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                    finally {
                        FileTransferTabItem.this.enableActionButtons(false);
                    }
                }
            });
            this.innerComposite.layout();
            this.scrolledComposite.setContent((Control)this.outherComposite);
            this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent evt) {
                    log.log(Level.FINEST, "scrolledComposite.controlResized, event=" + String.valueOf(evt));
                    Rectangle bounds = FileTransferTabItem.this.scrolledComposite.getClientArea();
                    if (bounds.width > 1100 && bounds.height <= INNER_COMPOSITE_HEIGHT) {
                        FileTransferTabItem.this.outherComposite.setSize(bounds.width, INNER_COMPOSITE_HEIGHT);
                        FileTransferTabItem.this.innerComposite.setLocation((bounds.width - 1100) / 2, 0);
                    } else if (bounds.width <= 1100 && bounds.height > INNER_COMPOSITE_HEIGHT) {
                        FileTransferTabItem.this.outherComposite.setSize(1100, bounds.height);
                        FileTransferTabItem.this.innerComposite.setLocation(0, (bounds.height - INNER_COMPOSITE_HEIGHT) / 2);
                    } else if (bounds.width > 1100 && bounds.height > INNER_COMPOSITE_HEIGHT) {
                        FileTransferTabItem.this.outherComposite.setSize(bounds.width, bounds.height);
                        FileTransferTabItem.this.innerComposite.setLocation((bounds.width - 1100) / 2, (bounds.height - INNER_COMPOSITE_HEIGHT) / 2);
                    } else {
                        FileTransferTabItem.this.outherComposite.setSize(1100, INNER_COMPOSITE_HEIGHT);
                        FileTransferTabItem.this.innerComposite.setLocation(0, 0);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updatePcBaseFolder() {
        for (TreeItem item : this.pcRootTreeItem.getItems()) {
            item.dispose();
        }
        this.selectedPcBaseFolder = new StringBuilder().append(this.pcBaseFolderSelectionLabel.getText().replace('\\', '/'));
        this.pcRootTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
        String baseFolderName = this.selectedPcBaseFolder.length() > this.selectedPcBaseFolder.lastIndexOf("/") + 1 ? this.selectedPcBaseFolder.substring(this.selectedPcBaseFolder.lastIndexOf("/") + 1) : (GDE.IS_WINDOWS ? this.selectedPcBaseFolder.substring(0, this.selectedPcBaseFolder.lastIndexOf("/")) : this.selectedPcBaseFolder.substring(this.selectedPcBaseFolder.lastIndexOf("/")));
        this.pcRootTreeItem.setText(baseFolderName);
        try {
            List folderList = FileUtils.getDirListing((File)new File(this.selectedPcBaseFolder.toString()));
            for (File folder : folderList) {
                TreeItem tmpTreeItem = new TreeItem(this.pcRootTreeItem, 0);
                tmpTreeItem.setText(folder.getName());
                tmpTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
            }
            if (this.pcRootTreeItem.getItemCount() > 1) {
                this.pcRootTreeItem.setExpanded(true);
                this.pcRootTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void setTableHeader(Table table) {
        TableColumn[] columns;
        table.removeAll();
        for (TableColumn tableColumn : columns = table.getColumns()) {
            tableColumn.dispose();
        }
        this.indexColumn = new TableColumn(table, 0x1000000);
        this.indexColumn.setWidth(44);
        this.indexColumn.setText(Messages.getString((String)"GDE_MSGT2445"));
        this.fileNameColum = new TableColumn(table, 16384);
        this.fileNameColum.setWidth(218);
        this.fileNameColum.setText(Messages.getString((String)"GDE_MSGT2446"));
        this.fileDateColum = new TableColumn(table, 0x1000000);
        this.fileDateColum.setWidth(118);
        this.fileDateColum.setText(Messages.getString((String)"GDE_MSGT2447"));
        this.fileTimeColum = new TableColumn(table, 0x1000000);
        this.fileTimeColum.setWidth(64);
        this.fileTimeColum.setText(Messages.getString((String)"GDE_MSGT2448"));
        this.fileSizeColum = new TableColumn(table, 131072);
        this.fileSizeColum.setWidth(123);
        this.fileSizeColum.setText(Messages.getString((String)"GDE_MSGT2449"));
    }

    private synchronized void updateSdDataTable() {
        if (this.sdFoldersAndFiles.get("FILES") != null) {
            for (String fileItem : this.sdFoldersAndFiles.get("FILES")) {
                new TableItem(this.sdCardFoldersTable, 0).setText(fileItem.split(","));
            }
        }
    }

    private void updateSdCardSizes(long[] sdSizes) {
        if (sdSizes != null && sdSizes.length == 2 && sdSizes[0] > 1000L && sdSizes[1] > 1000L) {
            this.sdCardSpaceinfoLabel.setText(Messages.getString((String)"GDE_MSGT2450", (Object[])new Object[]{sdSizes[0], sdSizes[1]}));
            this.sdCardSpaceProgressBar.setSelection((int)((sdSizes[0] - sdSizes[1]) * 100L / sdSizes[0]));
        }
    }

    private void listSdCardBaseDirs() throws Exception {
        this.setTableHeader(this.sdCardFoldersTable);
        for (TreeItem treeItem : this.sdRootDirectoryTreeItem.getItems()) {
            for (TreeItem subItem : treeItem.getItems()) {
                log.log(Level.FINER, "dispose " + subItem.getText());
                subItem.dispose();
            }
            log.log(Level.FINER, "dispose " + treeItem.getText());
            treeItem.dispose();
        }
        for (String string : this.serialPort.querySdDirs(0)) {
            TreeItem tmpTreeItem = new TreeItem(this.sdRootDirectoryTreeItem, 0);
            tmpTreeItem.setText(string);
            tmpTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
        }
        this.sdRootDirectoryTreeItem.setExpanded(true);
        this.sdRootDirectoryTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
    }

    private void updateSelectedPcFolder(TreeItem evtItem) {
        try {
            TreeItem parentItem;
            this.setTableHeader(this.pcFoldersTable);
            if (evtItem == null) {
                evtItem = this.pcRootTreeItem;
            }
            for (TreeItem item : evtItem.getItems()) {
                item.dispose();
            }
            if (this.lastSelectedPcTreeItem != null && !this.lastSelectedPcTreeItem.isDisposed() && this.lastSelectedPcTreeItem.getParentItem() != null) {
                this.lastSelectedPcTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                while (true) {
                    parentItem = this.lastSelectedPcTreeItem.getParentItem();
                    if (this.pcRootTreeItem.getText().equals(parentItem.getText())) break;
                    parentItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                    this.lastSelectedPcTreeItem = parentItem;
                }
            }
            this.selectedPcFolder = new StringBuilder().append("/").append(evtItem.getText());
            TreeItem tmpItem = evtItem;
            parentItem = tmpItem.getParentItem();
            if (parentItem != null) {
                while (this.pcRootTreeItem != (parentItem = tmpItem.getParentItem())) {
                    this.selectedPcFolder.insert(0, parentItem.getText());
                    this.selectedPcFolder.insert(0, "/");
                    parentItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
                    tmpItem = parentItem;
                }
                this.selectedPcFolder.insert(0, this.selectedPcBaseFolder);
            } else {
                this.selectedPcFolder = new StringBuilder().append((CharSequence)this.selectedPcBaseFolder);
            }
            log.log(Level.FINE, "selectedPcFolder = " + this.selectedPcFolder.toString());
            List files = FileUtils.getFileListing((File)new File(this.selectedPcFolder.toString()), (int)0);
            int index = 0;
            for (File file : files) {
                new TableItem(this.pcFoldersTable, 0).setText(new String[]{"" + index++, file.getName(), StringHelper.getFormatedTime((String)"yyyy-MM-dd", (long)file.lastModified()), StringHelper.getFormatedTime((String)"HH:mm", (long)file.lastModified()), "" + file.length()});
            }
            List folders = FileUtils.getDirListing((File)new File(this.selectedPcFolder.toString()));
            for (File folder : folders) {
                TreeItem tmpTreeItem = new TreeItem(evtItem, 0);
                tmpTreeItem.setText(folder.getName());
                tmpTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
            }
            evtItem.setExpanded(true);
            evtItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
            this.lastSelectedPcTreeItem = evtItem;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void updateSelectedSdFolder(TreeItem evtTreeitem) {
        try {
            TreeItem parentItem;
            this.setTableHeader(this.sdCardFoldersTable);
            for (TreeItem item : evtTreeitem.getItems()) {
                item.dispose();
            }
            if (this.lastSelectedSdTreeItem != null && !this.lastSelectedSdTreeItem.isDisposed() && this.lastSelectedSdTreeItem.getParentItem() != null) {
                this.lastSelectedSdTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                while (true) {
                    parentItem = this.lastSelectedSdTreeItem.getParentItem();
                    if (this.sdRootDirectoryTreeItem.getText().equals(parentItem.getText())) break;
                    parentItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
                    this.lastSelectedSdTreeItem = parentItem;
                }
            }
            this.selectedSdFolder = new StringBuilder().append("/").append(evtTreeitem.getText());
            TreeItem tmpItem = evtTreeitem;
            while (!(parentItem = tmpItem.getParentItem()).getText().equals("/")) {
                this.selectedSdFolder.insert(0, parentItem.getText());
                this.selectedSdFolder.insert(0, "/");
                parentItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
                tmpItem = parentItem;
            }
            log.log(Level.FINE, "selectedSdFolder = " + this.selectedSdFolder.toString());
            this.sdFoldersAndFiles = this.serialPort.queryListDir(this.selectedSdFolder.toString(), 0);
            for (String folder : this.sdFoldersAndFiles.get("FOLDER")) {
                if (folder.length() < 1) continue;
                TreeItem tmpTreeItem = new TreeItem(evtTreeitem, 0);
                tmpTreeItem.setText(folder);
                tmpTreeItem.setImage(SWTResourceManager.getImage((String)"/gde/resource/Folder.gif"));
            }
            evtTreeitem.setExpanded(true);
            evtTreeitem.setImage(SWTResourceManager.getImage((String)"/gde/resource/FolderOpen.gif"));
            this.updateSdDataTable();
            this.lastSelectedSdTreeItem = evtTreeitem;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void updateMdleTransferProgress(final CLabel infoLabel, final ProgressBar progressBar, final long totalSize, final long remainingSize) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (totalSize == 0L) {
                    progressBar.setSelection(0);
                    infoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{0, 0}));
                } else {
                    progressBar.setSelection((int)((totalSize - remainingSize) * 100L / totalSize));
                    infoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{totalSize - remainingSize, totalSize}));
                }
            }
        });
    }

    public void updateFileTransferProgress(final long totalSize, final long remainingSize) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferTabItem.this.transferProgressBar.setSelection((int)((totalSize - remainingSize) * 100L / totalSize));
                FileTransferTabItem.this.transferProgressLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{totalSize - remainingSize, totalSize}));
            }
        });
    }

    public void updatePcFolder() {
        final TreeItem treeItem = this.lastSelectedPcTreeItem;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferTabItem.this.updateSelectedPcFolder(treeItem);
            }
        });
    }

    public void updateSdFolder(final long[] sdSizes) {
        final TreeItem treeItem = this.lastSelectedSdTreeItem;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferTabItem.this.updateSdCardSizes(sdSizes);
                FileTransferTabItem.this.updateSelectedSdFolder(treeItem);
            }
        });
    }

    public void enableActionButtons(final boolean enableConnectStop) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferTabItem.this.connectButton.setEnabled(!enableConnectStop);
                FileTransferTabItem.this.stopButton.setEnabled(enableConnectStop);
                FileTransferTabItem.this.upDownLoadButton.setEnabled(!enableConnectStop);
                FileTransferTabItem.this.deleteFileButton.setEnabled(!enableConnectStop);
                FileTransferTabItem.this.sdFolderTree.setEnabled(!enableConnectStop);
            }
        });
    }

    public void enableSerialButtons(final boolean enable) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferTabItem.this.upDownLoadButton.setEnabled(enable);
                FileTransferTabItem.this.disconnectButton.setEnabled(enable);
            }
        });
    }
}

