/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.Point;
import java.math.BigInteger;
import java.util.logging.Logger;

class Edge {
    private final Point.LongPoint bot;
    private final Point.LongPoint current;
    private final Point.LongPoint top;
    private final Point.LongPoint delta = new Point.LongPoint();
    double deltaX;
    Clipper.PolyType polyTyp;
    Side side;
    int windDelta;
    int windCnt;
    int windCnt2;
    int outIdx;
    Edge next;
    Edge prev;
    Edge nextInLML;
    Edge nextInAEL;
    Edge prevInAEL;
    Edge nextInSEL;
    Edge prevInSEL;
    protected static final int SKIP = -2;
    protected static final int UNASSIGNED = -1;
    protected static final double HORIZONTAL = -3.4E38;
    private static final Logger LOGGER = Logger.getLogger(Edge.class.getName());

    static boolean doesE2InsertBeforeE1(Edge e1, Edge e2) {
        if (e2.current.getX() == e1.current.getX()) {
            if (e2.top.getY() > e1.top.getY()) {
                return e2.top.getX() < Edge.topX(e1, e2.top.getY());
            }
            return e1.top.getX() > Edge.topX(e2, e1.top.getY());
        }
        return e2.current.getX() < e1.current.getX();
    }

    static boolean slopesEqual(Edge e1, Edge e2, boolean useFullRange) {
        if (useFullRange) {
            return BigInteger.valueOf(e1.getDelta().getY()).multiply(BigInteger.valueOf(e2.getDelta().getX())).equals(BigInteger.valueOf(e1.getDelta().getX()).multiply(BigInteger.valueOf(e2.getDelta().getY())));
        }
        return e1.getDelta().getY() * e2.getDelta().getX() == e1.getDelta().getX() * e2.getDelta().getY();
    }

    static void swapPolyIndexes(Edge edge1, Edge edge2) {
        int outIdx = edge1.outIdx;
        edge1.outIdx = edge2.outIdx;
        edge2.outIdx = outIdx;
    }

    static void swapSides(Edge edge1, Edge edge2) {
        Side side = edge1.side;
        edge1.side = edge2.side;
        edge2.side = side;
    }

    static long topX(Edge edge, long currentY) {
        if (currentY == edge.getTop().getY()) {
            return edge.getTop().getX();
        }
        return edge.getBot().getX() + Math.round(edge.deltaX * (double)(currentY - edge.getBot().getY()));
    }

    public Edge() {
        this.top = new Point.LongPoint();
        this.bot = new Point.LongPoint();
        this.current = new Point.LongPoint();
    }

    public Edge findNextLocMin() {
        Edge e;
        block5: {
            Edge e2;
            e = this;
            while (true) {
                if (!e.bot.equals(e.prev.bot) || e.current.equals(e.top)) {
                    e = e.next;
                    continue;
                }
                if (e.deltaX != -3.4E38 && e.prev.deltaX != -3.4E38) break block5;
                while (e.prev.deltaX == -3.4E38) {
                    e = e.prev;
                }
                e2 = e;
                while (e.deltaX == -3.4E38) {
                    e = e.next;
                }
                if (e.top.getY() != e.prev.bot.getY()) break;
            }
            if (e2.prev.bot.getX() < e.bot.getX()) {
                e = e2;
            }
        }
        return e;
    }

    public Point.LongPoint getBot() {
        return this.bot;
    }

    public Point.LongPoint getCurrent() {
        return this.current;
    }

    public Point.LongPoint getDelta() {
        return this.delta;
    }

    public Edge getMaximaPair() {
        Edge result2 = null;
        if (this.next.top.equals(this.top) && this.next.nextInLML == null) {
            result2 = this.next;
        } else if (this.prev.top.equals(this.top) && this.prev.nextInLML == null) {
            result2 = this.prev;
        }
        if (result2 != null && (result2.outIdx == -2 || result2.nextInAEL == result2.prevInAEL && !result2.isHorizontal())) {
            return null;
        }
        return result2;
    }

    public Edge getNextInAEL(Clipper.Direction direction) {
        return direction == Clipper.Direction.LEFT_TO_RIGHT ? this.nextInAEL : this.prevInAEL;
    }

    public Point.LongPoint getTop() {
        return this.top;
    }

    public boolean isContributing(Clipper.PolyFillType clipFillType, Clipper.PolyFillType subjFillType, Clipper.ClipType clipType) {
        Clipper.PolyFillType pft2;
        Clipper.PolyFillType pft;
        LOGGER.entering(Edge.class.getName(), "isContributing");
        if (this.polyTyp == Clipper.PolyType.SUBJECT) {
            pft = subjFillType;
            pft2 = clipFillType;
        } else {
            pft = clipFillType;
            pft2 = subjFillType;
        }
        switch (pft) {
            case EVEN_ODD: {
                if (this.windDelta != 0 || this.windCnt == 1) break;
                return false;
            }
            case NON_ZERO: {
                if (Math.abs(this.windCnt) == 1) break;
                return false;
            }
            case POSITIVE: {
                if (this.windCnt == 1) break;
                return false;
            }
            default: {
                if (this.windCnt == -1) break;
                return false;
            }
        }
        switch (clipType) {
            case INTERSECTION: {
                switch (pft2) {
                    case EVEN_ODD: 
                    case NON_ZERO: {
                        return this.windCnt2 != 0;
                    }
                    case POSITIVE: {
                        return this.windCnt2 > 0;
                    }
                }
                return this.windCnt2 < 0;
            }
            case UNION: {
                switch (pft2) {
                    case EVEN_ODD: 
                    case NON_ZERO: {
                        return this.windCnt2 == 0;
                    }
                    case POSITIVE: {
                        return this.windCnt2 <= 0;
                    }
                }
                return this.windCnt2 >= 0;
            }
            case DIFFERENCE: {
                if (this.polyTyp == Clipper.PolyType.SUBJECT) {
                    switch (pft2) {
                        case EVEN_ODD: 
                        case NON_ZERO: {
                            return this.windCnt2 == 0;
                        }
                        case POSITIVE: {
                            return this.windCnt2 <= 0;
                        }
                    }
                    return this.windCnt2 >= 0;
                }
                switch (pft2) {
                    case EVEN_ODD: 
                    case NON_ZERO: {
                        return this.windCnt2 != 0;
                    }
                    case POSITIVE: {
                        return this.windCnt2 > 0;
                    }
                }
                return this.windCnt2 < 0;
            }
            case XOR: {
                if (this.windDelta == 0) {
                    switch (pft2) {
                        case EVEN_ODD: 
                        case NON_ZERO: {
                            return this.windCnt2 == 0;
                        }
                        case POSITIVE: {
                            return this.windCnt2 <= 0;
                        }
                    }
                    return this.windCnt2 >= 0;
                }
                return true;
            }
        }
        return true;
    }

    public boolean isEvenOddAltFillType(Clipper.PolyFillType clipFillType, Clipper.PolyFillType subjFillType) {
        if (this.polyTyp == Clipper.PolyType.SUBJECT) {
            return clipFillType == Clipper.PolyFillType.EVEN_ODD;
        }
        return subjFillType == Clipper.PolyFillType.EVEN_ODD;
    }

    public boolean isEvenOddFillType(Clipper.PolyFillType clipFillType, Clipper.PolyFillType subjFillType) {
        if (this.polyTyp == Clipper.PolyType.SUBJECT) {
            return subjFillType == Clipper.PolyFillType.EVEN_ODD;
        }
        return clipFillType == Clipper.PolyFillType.EVEN_ODD;
    }

    public boolean isHorizontal() {
        return this.delta.getY() == 0L;
    }

    public boolean isIntermediate(double y) {
        return (double)this.top.getY() == y && this.nextInLML != null;
    }

    public boolean isMaxima(double Y) {
        return (double)this.top.getY() == Y && this.nextInLML == null;
    }

    public void reverseHorizontal() {
        long temp = this.top.getX();
        this.top.setX(this.bot.getX());
        this.bot.setX(temp);
        temp = this.top.getZ();
        this.top.setZ(this.bot.getZ());
        this.bot.setZ(temp);
    }

    public void setBot(Point.LongPoint bot) {
        this.bot.set(bot);
    }

    public void setCurrent(Point.LongPoint current) {
        this.current.set(current);
    }

    public void setTop(Point.LongPoint top2) {
        this.top.set(top2);
    }

    public String toString() {
        return "TEdge [Bot=" + this.bot + ", Curr=" + this.current + ", Top=" + this.top + ", Delta=" + this.delta + ", Dx=" + this.deltaX + ", PolyTyp=" + (Object)((Object)this.polyTyp) + ", Side=" + (Object)((Object)this.side) + ", WindDelta=" + this.windDelta + ", WindCnt=" + this.windCnt + ", WindCnt2=" + this.windCnt2 + ", OutIdx=" + this.outIdx + ", Next=" + this.next + ", Prev=" + this.prev + ", NextInLML=" + this.nextInLML + ", NextInAEL=" + this.nextInAEL + ", PrevInAEL=" + this.prevInAEL + ", NextInSEL=" + this.nextInSEL + ", PrevInSEL=" + this.prevInSEL + "]";
    }

    public void updateDeltaX() {
        this.delta.setX(this.top.getX() - this.bot.getX());
        this.delta.setY(this.top.getY() - this.bot.getY());
        this.deltaX = this.delta.getY() == 0L ? -3.4E38 : (double)this.delta.getX() / (double)this.delta.getY();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Side {
        LEFT,
        RIGHT;

    }
}

