/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.font.PrismFontFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class MacFontFinder {
    private static final int SystemFontType = 2;
    private static final int MonospacedFontType = 1;

    MacFontFinder() {
    }

    private static native String getFont(int var0);

    public static String getSystemFont() {
        return MacFontFinder.getFont(2);
    }

    public static String getMonospacedFont() {
        return MacFontFinder.getFont(1);
    }

    static native float getSystemFontSize();

    public static boolean populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        String[] stringArray;
        if (hashMap == null || hashMap2 == null || hashMap3 == null) {
            return false;
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        if ((stringArray = MacFontFinder.getFontData()) == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n++];
            String string3 = stringArray[n++];
            String string4 = stringArray[n++];
            if (PrismFontFactory.debugFonts) {
                System.err.println("[MacFontFinder] Name=" + string2);
                System.err.println("\tFamily=" + string3);
                System.err.println("\tFile=" + string4);
            }
            if (string2 == null || string3 == null || string4 == null) continue;
            String string5 = string2.toLowerCase(locale);
            String string6 = string3.toLowerCase(locale);
            hashMap.put(string5, string4);
            hashMap2.put(string5, string3);
            ArrayList<String> arrayList = hashMap3.get(string6);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap3.put(string6, arrayList);
            }
            arrayList.add(string2);
        }
        return true;
    }

    private static native String[] getFontData();

    static {
        AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_font");
            return null;
        });
    }
}

