/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.decoder;

import de.treichels.hott.decoder.internal.decoder.BaseDecoder;
import de.treichels.hott.decoder.internal.decoder.VDFDecoder;
import de.treichels.hott.decoder.internal.io.HoTTReader;
import de.treichels.hott.decoder.internal.io.HoTTWriter;
import de.treichels.hott.model.HoTTException;
import de.treichels.hott.model.enums.TransmitterType;
import de.treichels.hott.voice.CountryCode;
import de.treichels.hott.voice.VDFType;
import de.treichels.hott.voice.VoiceData;
import de.treichels.hott.voice.VoiceFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/treichels/hott/decoder/internal/decoder/VDFDecoder;", "", "()V", "HEADER_SIZE", "", "SAMPLE_RATE_11K", "SYSTEM_DATA_OFFSET_V2", "SYSTEM_DATA_OFFSET_V2_5", "SYSTEM_DATA_OFFSET_V3", "SYSTEM_DATA_SIZE_V2", "SYSTEM_DATA_SIZE_V2_5", "SYSTEM_DATA_SIZE_V3", "SYSTEM_MAX_VOICE_COUNT_V2", "SYSTEM_MAX_VOICE_COUNT_V2_5", "SYSTEM_MAX_VOICE_COUNT_V3", "SYSTEM_VDF_ID", "USER_DATA_OFFSET_V2_5", "USER_DATA_OFFSET_V3", "USER_DATA_SIZE_V2_5", "USER_DATA_SIZE_V3", "USER_MAX_VOICE_COUNT_V2_5", "USER_MAX_VOICE_COUNT_V3", "USER_VDF_ID", "VDF_FILE_CODE", "VERSION_CODE_V2", "VERSION_CODE_V2_5", "VERSION_CODE_V3", "decodeVDF", "Lde/treichels/hott/voice/VoiceFile;", "bytes", "", "encodeVDF", "voiceFile", "getDataSize", "getInfoSize", "getMaxVoiceCount", "verifyVDF", "", "HoTT-Decoder"})
public final class VDFDecoder {
    private static final int SAMPLE_RATE_11K = 11025;
    private static final int VERSION_CODE_V3 = 3000;
    private static final int VERSION_CODE_V2_5 = 2500;
    private static final int VERSION_CODE_V2 = 2000;
    private static final int VDF_FILE_CODE = 274666189;
    private static final int SYSTEM_VDF_ID = 254;
    private static final int USER_VDF_ID = 14;
    private static final int SYSTEM_DATA_OFFSET_V3 = 32768;
    private static final int SYSTEM_DATA_OFFSET_V2_5 = 12288;
    private static final int SYSTEM_DATA_OFFSET_V2 = 8192;
    private static final int SYSTEM_DATA_SIZE_V3 = 0x334000;
    private static final int SYSTEM_DATA_SIZE_V2_5 = 0x1B1000;
    private static final int SYSTEM_DATA_SIZE_V2 = 1630208;
    private static final int SYSTEM_MAX_VOICE_COUNT_V3 = 432;
    private static final int SYSTEM_MAX_VOICE_COUNT_V2_5 = 284;
    private static final int SYSTEM_MAX_VOICE_COUNT_V2 = 253;
    private static final int USER_MAX_VOICE_COUNT_V3 = 40;
    private static final int USER_MAX_VOICE_COUNT_V2_5 = 10;
    private static final int USER_DATA_OFFSET_V3 = 4096;
    private static final int USER_DATA_OFFSET_V2_5 = 4096;
    private static final int USER_DATA_SIZE_V3 = 798720;
    private static final int USER_DATA_SIZE_V2_5 = 98304;
    private static final int HEADER_SIZE = 32;
    public static final VDFDecoder INSTANCE;

    @NotNull
    public final VoiceFile decodeVDF(@NotNull byte[] bytes) {
        int i2;
        int offset;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        HoTTReader reader = new HoTTReader(bytes);
        int code = reader.readInt();
        int type1 = reader.readInt();
        int type2 = reader.readInt();
        int voiceCount = reader.readInt();
        int infoSize = reader.readInt();
        int dataSize = reader.readInt();
        int vdfVersion = reader.readInt();
        int transmitterType = reader.readInt();
        boolean bl2 = bl = reader.getOffset() == HEADER_SIZE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        boolean bl3 = bl = code == VDF_FILE_CODE;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        boolean bl4 = bl = type2 == 255 - type1;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        ArrayList<VoiceData> voiceData = new ArrayList<VoiceData>();
        int n = 0;
        int n2 = voiceCount;
        while (n < n2) {
            boolean bl5;
            boolean bl6;
            int len = reader.readInt();
            offset = reader.readInt();
            int num1 = reader.readShort();
            int num2 = reader.readShort();
            int sampleRate = reader.readUnsignedShort();
            boolean bl7 = bl6 = sampleRate == SAMPLE_RATE_11K;
            if (_Assertions.ENABLED && !bl6) {
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            String $receiver$iv = reader.readString(18);
            CharSequence $receiver$iv$iv = $receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl8 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String name = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            byte[] data2 = new byte[len];
            System.arraycopy(bytes, offset + HEADER_SIZE, data2, 0, len);
            voiceData.add(new VoiceData(name, data2));
            boolean bl9 = bl5 = num1 == ~num2;
            if (_Assertions.ENABLED && !bl5) {
                String string6 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string6));
            }
            boolean bl10 = bl5 = i2 != 0 || offset == infoSize;
            if (_Assertions.ENABLED && !bl5) {
                String string7 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string7));
            }
            ++i2;
        }
        reader.skip(infoSize - reader.getOffset());
        int n3 = i2 = reader.getOffset() == infoSize ? 1 : 0;
        if (_Assertions.ENABLED && i2 == 0) {
            String string8 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string8));
        }
        int vdfVersion2 = reader.readInt();
        int transmitterType2 = reader.readInt();
        int countryCode = reader.readByte();
        int n4 = offset = vdfVersion == vdfVersion2 ? 1 : 0;
        if (_Assertions.ENABLED && offset == 0) {
            String string9 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string9));
        }
        int n5 = offset = transmitterType == transmitterType2 ? 1 : 0;
        if (_Assertions.ENABLED && offset == 0) {
            String string10 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string10));
        }
        int n6 = offset = voiceData.size() == voiceCount ? 1 : 0;
        if (_Assertions.ENABLED && offset == 0) {
            String string11 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string11));
        }
        int n7 = offset = dataSize == voiceData.stream().mapToInt(decodeVDF.1.INSTANCE).sum() ? 1 : 0;
        if (_Assertions.ENABLED && offset == 0) {
            String string12 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string12));
        }
        int n8 = offset = bytes.length == HEADER_SIZE + infoSize + dataSize ? 1 : 0;
        if (_Assertions.ENABLED && offset == 0) {
            String string13 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string13));
        }
        VDFType type3 = type1 == SYSTEM_VDF_ID ? VDFType.System : VDFType.User;
        TransmitterType transmitterType3 = TransmitterType.Companion.forProductCode(transmitterType);
        CountryCode countryCode2 = CountryCode.Companion.forCode(countryCode);
        ObservableList observableList = FXCollections.observableList((List)voiceData);
        Intrinsics.checkExpressionValueIsNotNull(observableList, "FXCollections.observableList(voiceData)");
        return new VoiceFile(type3, transmitterType3, vdfVersion, countryCode2, (List)observableList);
    }

    @NotNull
    public final byte[] encodeVDF(@NotNull VoiceFile voiceFile) {
        int i2;
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        this.verifyVDF(voiceFile);
        HoTTWriter writer = new HoTTWriter(null, 1, null);
        TransmitterType transmitterType = voiceFile.getTransmitterType();
        ObservableList<VoiceData> list2 = voiceFile.getVoiceList();
        int voiceCount = voiceFile.getSize();
        int dataSize = voiceFile.getRawDataSize();
        int infoSize = this.getInfoSize(voiceFile);
        int typeId = voiceFile.getVdfType() == VDFType.System ? SYSTEM_VDF_ID : USER_VDF_ID;
        writer.writeInt(VDF_FILE_CODE);
        writer.writeInt(typeId);
        writer.writeInt(255 - typeId);
        writer.writeInt(voiceCount);
        writer.writeInt(infoSize);
        writer.writeInt(dataSize);
        writer.writeInt(voiceFile.getVdfVersion());
        writer.writeInt(transmitterType.getProductCode());
        int offset = infoSize;
        int n = 0;
        int n2 = voiceCount;
        while (n < n2) {
            byte[] byArray;
            VoiceData vd = (VoiceData)list2.get(i2);
            byte[] data2 = vd.getRawData();
            int len = data2.length;
            writer.writeInt(len);
            writer.writeInt(offset);
            offset += len;
            writer.writeShort(i2);
            writer.writeShort(~i2);
            writer.writeUnsignedShort(SAMPLE_RATE_11K);
            String string2 = vd.getName();
            Charset charset = BaseDecoder.Companion.getISO_8859_1();
            HoTTWriter hoTTWriter = writer;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull(string3.getBytes(charset), "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = Arrays.copyOf(byArray, 17);
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "Arrays.copyOf(vd.name.to\u2026eDecoder.ISO_8859_1), 17)");
            HoTTWriter.write$default(hoTTWriter, byArray2, 0, 0, 6, null);
            writer.writeByte(0);
            ++i2;
        }
        HoTTWriter.skip$default(writer, infoSize - writer.getOffset(), 0, 2, null);
        int n3 = i2 = writer.getOffset() == infoSize ? 1 : 0;
        if (_Assertions.ENABLED && i2 == 0) {
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        writer.writeInt(voiceFile.getVdfVersion());
        writer.writeInt(transmitterType.getProductCode());
        writer.writeByte(voiceFile.getCountry().getCode());
        HoTTWriter.skip$default(writer, 23, 0, 2, null);
        for (VoiceData voiceData : list2) {
            HoTTWriter.write$default(writer, voiceData.getRawData(), 0, 0, 6, null);
        }
        return writer.getData();
    }

    public final int getDataSize(@NotNull VoiceFile voiceFile) throws HoTTException {
        int n;
        int vdfVersion;
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        VDFType vdfType = voiceFile.getVdfType();
        int n2 = vdfVersion = voiceFile.getVdfVersion();
        if (n2 == VERSION_CODE_V2) {
            n = SYSTEM_DATA_SIZE_V2;
        } else if (n2 == VERSION_CODE_V2_5) {
            n = vdfType == VDFType.System ? SYSTEM_DATA_SIZE_V2_5 : USER_DATA_SIZE_V2_5;
        } else if (n2 == VERSION_CODE_V3) {
            n = vdfType == VDFType.System ? SYSTEM_DATA_SIZE_V3 : USER_DATA_SIZE_V3;
        } else {
            throw (Throwable)new HoTTException("UnknownVDFVersion", vdfVersion);
        }
        return n;
    }

    public final int getInfoSize(@NotNull VoiceFile voiceFile) throws HoTTException {
        int n;
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        int vdfVersion = voiceFile.getVdfVersion();
        VDFType vdfType = voiceFile.getVdfType();
        int n2 = vdfVersion;
        if (n2 == VERSION_CODE_V2) {
            n = SYSTEM_DATA_OFFSET_V2;
        } else if (n2 == VERSION_CODE_V2_5) {
            n = vdfType == VDFType.System ? SYSTEM_DATA_OFFSET_V2_5 : USER_DATA_OFFSET_V2_5;
        } else if (n2 == VERSION_CODE_V3) {
            n = vdfType == VDFType.System ? SYSTEM_DATA_OFFSET_V3 : USER_DATA_OFFSET_V3;
        } else {
            throw (Throwable)new HoTTException("UnknownVDFVersion", vdfVersion);
        }
        return n;
    }

    public final int getMaxVoiceCount(@NotNull VoiceFile voiceFile) throws HoTTException {
        int n;
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        int vdfVersion = voiceFile.getVdfVersion();
        VDFType vdfType = voiceFile.getVdfType();
        int n2 = vdfVersion;
        if (n2 == VERSION_CODE_V2) {
            n = SYSTEM_MAX_VOICE_COUNT_V2;
        } else if (n2 == VERSION_CODE_V2_5) {
            n = vdfType == VDFType.System ? SYSTEM_MAX_VOICE_COUNT_V2_5 : USER_MAX_VOICE_COUNT_V2_5;
        } else if (n2 == VERSION_CODE_V3) {
            n = vdfType == VDFType.System ? SYSTEM_MAX_VOICE_COUNT_V3 : USER_MAX_VOICE_COUNT_V3;
        } else {
            throw (Throwable)new HoTTException("UnknownVDFVersion", vdfVersion);
        }
        return n;
    }

    public final void verifyVDF(@NotNull VoiceFile voiceFile) throws HoTTException {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        int voiceCount = voiceFile.getSize();
        int infoSize = 32 + voiceCount * 32;
        int dataSize = voiceFile.getRawDataSize();
        int maxVoiceCount = this.getMaxVoiceCount(voiceFile);
        int maxInfoSize = this.getInfoSize(voiceFile);
        int maxDataSize = this.getDataSize(voiceFile);
        if (voiceFile.getVdfType() == VDFType.System && voiceCount != maxVoiceCount) {
            throw (Throwable)new HoTTException("InvalidSystemVoiceCount", voiceCount, maxVoiceCount);
        }
        if (voiceCount > maxVoiceCount) {
            throw (Throwable)new HoTTException("InvalidUserVoiceCount", voiceCount, maxVoiceCount);
        }
        if (dataSize > maxDataSize) {
            throw (Throwable)new HoTTException("InvalidDataSize", dataSize / 1024, maxDataSize / 1024);
        }
        if (infoSize > maxInfoSize) {
            throw (Throwable)new HoTTException("InvalidInfoSize", infoSize / 1024, maxInfoSize / 1024);
        }
    }

    private VDFDecoder() {
    }

    static {
        VDFDecoder vDFDecoder;
        INSTANCE = vDFDecoder = new VDFDecoder();
        SAMPLE_RATE_11K = 11025;
        VERSION_CODE_V3 = 3000;
        VERSION_CODE_V2_5 = 2500;
        VERSION_CODE_V2 = 2000;
        VDF_FILE_CODE = 274666189;
        SYSTEM_VDF_ID = 254;
        USER_VDF_ID = 14;
        SYSTEM_DATA_OFFSET_V3 = 32768;
        SYSTEM_DATA_OFFSET_V2_5 = 12288;
        SYSTEM_DATA_OFFSET_V2 = 8192;
        SYSTEM_DATA_SIZE_V3 = 0x334000;
        SYSTEM_DATA_SIZE_V2_5 = 0x1B1000;
        SYSTEM_DATA_SIZE_V2 = 1630208;
        SYSTEM_MAX_VOICE_COUNT_V3 = 432;
        SYSTEM_MAX_VOICE_COUNT_V2_5 = 284;
        SYSTEM_MAX_VOICE_COUNT_V2 = 253;
        USER_MAX_VOICE_COUNT_V3 = 40;
        USER_MAX_VOICE_COUNT_V2_5 = 10;
        USER_DATA_OFFSET_V3 = 4096;
        USER_DATA_OFFSET_V2_5 = 4096;
        USER_DATA_SIZE_V3 = 798720;
        USER_DATA_SIZE_V2_5 = 98304;
        HEADER_SIZE = 32;
    }
}

