/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\bJ4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00122\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0015"}, d2={"Lde/treichels/hott/voice/Player;", "", "()V", "play", "", "file", "Ljava/io/File;", "sync", "", "format", "Ljavax/sound/sampled/AudioFormat;", "stream", "Ljava/io/InputStream;", "data", "", "offset", "", "bufferSize", "Ljavax/sound/sampled/AudioInputStream;", "clip", "Ljavax/sound/sampled/Clip;", "HoTT-Voice"})
public final class Player {
    public static final Player INSTANCE;

    public final void play(@NotNull AudioFormat format, @NotNull byte[] data2, int offset, int bufferSize, boolean sync) {
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        this.play(format, new ByteArrayInputStream(data2, offset, bufferSize), sync);
    }

    public static /* synthetic */ void play$default(Player player, AudioFormat audioFormat, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        player.play(audioFormat, byArray, n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void play(@NotNull AudioFormat format, @NotNull InputStream stream, boolean sync) {
        SourceDataLine sourceDataLine;
        block11: {
            Intrinsics.checkParameterIsNotNull(format, "format");
            Intrinsics.checkParameterIsNotNull(stream, "stream");
            sourceDataLine = null;
            try {
                SourceDataLine sourceDataLine2 = sourceDataLine = AudioSystem.getSourceDataLine(format);
                if (sourceDataLine2 == null) {
                    Intrinsics.throwNpe();
                }
                sourceDataLine2.open();
                sourceDataLine.start();
                byte[] buffer = new byte[sourceDataLine.getBufferSize()];
                while (true) {
                    int len;
                    if ((len = stream.read(buffer)) == -1) {
                        if (sync) {
                            break;
                        }
                        break block11;
                    }
                    sourceDataLine.write(buffer, 0, len);
                }
                sourceDataLine.drain();
            }
            catch (LineUnavailableException e) {
                try {
                    throw (Throwable)new RuntimeException(e);
                    catch (IOException e2) {
                        throw (Throwable)new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (sourceDataLine != null && sourceDataLine.isRunning()) {
                        sourceDataLine.stop();
                    }
                    if (sourceDataLine == null) throw throwable;
                    if (!sourceDataLine.isOpen()) throw throwable;
                    sourceDataLine.close();
                    throw throwable;
                }
            }
        }
        if (sourceDataLine.isRunning()) {
            sourceDataLine.stop();
        }
        if (!sourceDataLine.isOpen()) return;
        sourceDataLine.close();
    }

    public static /* synthetic */ void play$default(Player player, AudioFormat audioFormat, InputStream inputStream2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        player.play(audioFormat, inputStream2, bl);
    }

    public final void play(@NotNull AudioInputStream stream, boolean sync) {
        AudioFormat sourceFormat;
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        AudioFormat audioFormat = sourceFormat = stream.getFormat();
        Intrinsics.checkExpressionValueIsNotNull(audioFormat, "sourceFormat");
        float rate = audioFormat.getSampleRate();
        int channels = sourceFormat.getChannels();
        AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, channels, channels * 2, rate, false);
        if (sourceFormat.matches(targetFormat)) {
            this.play(sourceFormat, stream, sync);
        } else {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(targetFormat, stream);
            Intrinsics.checkExpressionValueIsNotNull(audioInputStream, "AudioSystem.getAudioInpu\u2026eam(targetFormat, stream)");
            this.play(audioInputStream, sync);
        }
    }

    public static /* synthetic */ void play$default(Player player, AudioInputStream audioInputStream, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        player.play(audioInputStream, bl);
    }

    public final void play(@NotNull Clip clip, boolean sync) {
        Intrinsics.checkParameterIsNotNull(clip, "clip");
        CountDownLatch latch = new CountDownLatch(1);
        clip.addLineListener(new LineListener(sync, latch, clip){
            final /* synthetic */ boolean $sync;
            final /* synthetic */ CountDownLatch $latch;
            final /* synthetic */ Clip $clip;

            public final void update(LineEvent e) {
                LineEvent lineEvent = e;
                Intrinsics.checkExpressionValueIsNotNull(lineEvent, "e");
                if (lineEvent.getType() == LineEvent.Type.STOP) {
                    if (this.$sync) {
                        this.$latch.countDown();
                    }
                    this.$clip.close();
                }
            }
            {
                this.$sync = bl;
                this.$latch = countDownLatch;
                this.$clip = clip;
            }
        });
        clip.start();
        if (sync) {
            latch.await();
        }
    }

    public static /* synthetic */ void play$default(Player player, Clip clip, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        player.play(clip, bl);
    }

    public final void play(@NotNull File file, boolean sync) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        Intrinsics.checkExpressionValueIsNotNull(audioInputStream, "AudioSystem.getAudioInputStream(file)");
        this.play(audioInputStream, sync);
    }

    public static /* synthetic */ void play$default(Player player, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        player.play(file, bl);
    }

    private Player() {
    }

    static {
        Player player;
        INSTANCE = player = new Player();
    }
}

