/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.pcollections;

final class IntTree<V> {
    static final IntTree<Object> EMPTYNODE = new IntTree();
    private final long key;
    private final V value;
    private final IntTree<V> left;
    private final IntTree<V> right;
    private final int size;

    private IntTree() {
        this.size = 0;
        this.key = 0L;
        this.value = null;
        this.left = null;
        this.right = null;
    }

    private IntTree(long key2, V value, IntTree<V> left2, IntTree<V> right2) {
        this.key = key2;
        this.value = value;
        this.left = left2;
        this.right = right2;
        this.size = 1 + left2.size + right2.size;
    }

    private IntTree<V> withKey(long newKey) {
        if (this.size == 0 || newKey == this.key) {
            return this;
        }
        return new IntTree<V>(newKey, this.value, this.left, this.right);
    }

    V get(long key2) {
        if (this.size == 0) {
            return null;
        }
        if (key2 < this.key) {
            return this.left.get(key2 - this.key);
        }
        if (key2 > this.key) {
            return this.right.get(key2 - this.key);
        }
        return this.value;
    }

    IntTree<V> plus(long key2, V value) {
        if (this.size == 0) {
            return new IntTree<V>(key2, value, this, this);
        }
        if (key2 < this.key) {
            return this.rebalanced(this.left.plus(key2 - this.key, value), this.right);
        }
        if (key2 > this.key) {
            return this.rebalanced(this.left, this.right.plus(key2 - this.key, value));
        }
        if (value == this.value) {
            return this;
        }
        return new IntTree<V>(key2, value, this.left, this.right);
    }

    IntTree<V> minus(long key2) {
        if (this.size == 0) {
            return this;
        }
        if (key2 < this.key) {
            return this.rebalanced(this.left.minus(key2 - this.key), this.right);
        }
        if (key2 > this.key) {
            return this.rebalanced(this.left, this.right.minus(key2 - this.key));
        }
        if (this.left.size == 0) {
            return super.withKey(this.right.key + this.key);
        }
        if (this.right.size == 0) {
            return super.withKey(this.left.key + this.key);
        }
        long newKey = super.minKey() + this.key;
        V newValue = this.right.get(newKey - this.key);
        IntTree<V> newRight = this.right.minus(newKey - this.key);
        newRight = super.withKey(newRight.key + this.key - newKey);
        IntTree<V> newLeft = super.withKey(this.left.key + this.key - newKey);
        return IntTree.rebalanced(newKey, newValue, newLeft, newRight);
    }

    private long minKey() {
        if (this.left.size == 0) {
            return this.key;
        }
        return super.minKey() + this.key;
    }

    private IntTree<V> rebalanced(IntTree<V> newLeft, IntTree<V> newRight) {
        if (newLeft == this.left && newRight == this.right) {
            return this;
        }
        return IntTree.rebalanced(this.key, this.value, newLeft, newRight);
    }

    private static <V> IntTree<V> rebalanced(long key2, V value, IntTree<V> left2, IntTree<V> right2) {
        if (left2.size + right2.size > 1) {
            if (left2.size >= 5 * right2.size) {
                IntTree<V> ll = left2.left;
                IntTree<V> lr = left2.right;
                if (lr.size < 2 * ll.size) {
                    return new IntTree<V>(left2.key + key2, left2.value, ll, new IntTree<V>(-left2.key, value, super.withKey(lr.key + left2.key), right2));
                }
                IntTree<V> lrl = lr.left;
                IntTree<V> lrr = lr.right;
                return new IntTree<V>(lr.key + left2.key + key2, lr.value, new IntTree<V>(-lr.key, left2.value, ll, super.withKey(lrl.key + lr.key)), new IntTree<V>(-left2.key - lr.key, value, super.withKey(lrr.key + lr.key + left2.key), right2));
            }
            if (right2.size >= 5 * left2.size) {
                IntTree<V> rl = right2.left;
                IntTree<V> rr = right2.right;
                if (rl.size < 2 * rr.size) {
                    return new IntTree<V>(right2.key + key2, right2.value, new IntTree<V>(-right2.key, value, left2, super.withKey(rl.key + right2.key)), rr);
                }
                IntTree<V> rll = rl.left;
                IntTree<V> rlr = rl.right;
                return new IntTree<V>(rl.key + right2.key + key2, rl.value, new IntTree<V>(-right2.key - rl.key, value, left2, super.withKey(rll.key + rl.key + right2.key)), new IntTree<V>(-rl.key, right2.value, super.withKey(rlr.key + rl.key), rr));
            }
        }
        return new IntTree<V>(key2, value, left2, right2);
    }
}

