/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, wHint, hHint, flushCache);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null) {
            ((GridData)data2).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] grid, int row2, int column2, int rowCount, int columnCount, boolean first) {
        Control control = grid[row2][column2];
        if (control != null) {
            int j;
            GridData data2 = (GridData)control.getLayoutData();
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data2.verticalSpan);
            int i2 = first ? row2 + vSpan - 1 : row2 - vSpan + 1;
            int n = j = first ? column2 + hSpan - 1 : column2 - hSpan + 1;
            if (i2 >= 0 && i2 < rowCount && j >= 0 && j < columnCount && control == grid[i2][j]) {
                return data2;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        this.layout(composite, true, rect.x, rect.y, rect.width, rect.height, flushCache);
    }

    Point layout(Composite composite, boolean move2, int x, int y, int width, int height, boolean flushCache) {
        int k;
        int k2;
        int i2;
        int k3;
        int last;
        int i3;
        int j;
        GridData data2;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] children = composite.getChildren();
        int count = 0;
        int i4 = 0;
        while (i4 < children.length) {
            Control control = children[i4];
            data2 = (GridData)control.getLayoutData();
            if (data2 == null || !data2.exclude) {
                children[count++] = children[i4];
            }
            ++i4;
        }
        if (count == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            data2 = (GridData)child.getLayoutData();
            if (data2 == null) {
                data2 = new GridData();
                child.setLayoutData(data2);
            }
            if (flushCache) {
                data2.flushCache();
            }
            data2.computeSize(child, data2.widthHint, data2.heightHint, flushCache);
            if (data2.grabExcessHorizontalSpace && data2.minimumWidth > 0 && data2.cacheWidth < data2.minimumWidth) {
                int trim = 0;
                if (child instanceof Scrollable) {
                    Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                    trim = rect.width;
                } else {
                    trim = child.getBorderWidth() * 2;
                }
                data2.cacheHeight = -1;
                data2.cacheWidth = -1;
                data2.computeSize(child, Math.max(0, data2.minimumWidth - trim), data2.heightHint, false);
            }
            if (data2.grabExcessVerticalSpace && data2.minimumHeight > 0) {
                data2.cacheHeight = Math.max(data2.cacheHeight, data2.minimumHeight);
            }
            ++i4;
        }
        int row2 = 0;
        int column2 = 0;
        int rowCount = 0;
        int columnCount = this.numColumns;
        Control[][] grid = new Control[4][columnCount];
        int i5 = 0;
        while (i5 < count) {
            Control child = children[i5];
            GridData data3 = (GridData)child.getLayoutData();
            int hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data3.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row2 + vSpan) >= grid.length) {
                    Control[][] newGrid = new Control[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row2] == null) {
                    grid[row2] = new Control[columnCount];
                }
                while (column2 < columnCount && grid[row2][column2] != null) {
                    ++column2;
                }
                int endCount = column2 + hSpan;
                if (endCount <= columnCount) {
                    int index = column2;
                    while (index < endCount && grid[row2][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column2 = index;
                }
                if (column2 + hSpan < columnCount) continue;
                column2 = 0;
                ++row2;
            }
            j = 0;
            while (j < vSpan) {
                if (grid[row2 + j] == null) {
                    grid[row2 + j] = new Control[columnCount];
                }
                int k4 = 0;
                while (k4 < hSpan) {
                    grid[row2 + j][column2 + k4] = child;
                    ++k4;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row2 + vSpan);
            column2 += hSpan;
            ++i5;
        }
        int availableWidth = width - this.horizontalSpacing * (columnCount - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int expandCount = 0;
        int[] widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        j = 0;
        while (j < columnCount) {
            int hSpan;
            i3 = 0;
            while (i3 < rowCount) {
                GridData data4 = this.getData(grid, i3, j, rowCount, columnCount, true);
                if (data4 != null && (hSpan = Math.max(1, Math.min(data4.horizontalSpan, columnCount))) == 1) {
                    int w = data4.cacheWidth + data4.horizontalIndent;
                    widths[j] = Math.max(widths[j], w);
                    if (data4.grabExcessHorizontalSpace) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (!data4.grabExcessHorizontalSpace || data4.minimumWidth != 0) {
                        w = !data4.grabExcessHorizontalSpace || data4.minimumWidth == -1 ? data4.cacheWidth : data4.minimumWidth;
                        minWidths[j] = Math.max(minWidths[j], w += data4.horizontalIndent);
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < rowCount) {
                GridData data5 = this.getData(grid, i3, j, rowCount, columnCount, false);
                if (data5 != null && (hSpan = Math.max(1, Math.min(data5.horizontalSpan, columnCount))) > 1) {
                    int delta;
                    int remainder;
                    int w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k5 = 0;
                    while (k5 < hSpan) {
                        spanWidth += widths[j - k5];
                        spanMinWidth += minWidths[j - k5];
                        if (expandColumn[j - k5]) {
                            ++spanExpandCount;
                        }
                        ++k5;
                    }
                    if (data5.grabExcessHorizontalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = data5.cacheWidth + data5.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                        if (this.makeColumnsEqualWidth) {
                            int equalWidth = (w + spanWidth) / hSpan;
                            remainder = (w + spanWidth) % hSpan;
                            last = -1;
                            k3 = 0;
                            while (k3 < hSpan) {
                                last = j - k3;
                                widths[last] = Math.max(equalWidth, widths[j - k3]);
                                ++k3;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        } else if (spanExpandCount == 0) {
                            int n = j;
                            widths[n] = widths[n] + w;
                        } else {
                            delta = w / spanExpandCount;
                            remainder = w % spanExpandCount;
                            last = -1;
                            k3 = 0;
                            while (k3 < hSpan) {
                                if (expandColumn[j - k3]) {
                                    last = j - k3;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k3;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        }
                    }
                    if (!data5.grabExcessHorizontalSpace || data5.minimumWidth != 0) {
                        int n = w = !data5.grabExcessHorizontalSpace || data5.minimumWidth == -1 ? data5.cacheWidth : data5.minimumWidth;
                        if ((w += data5.horizontalIndent - spanMinWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n2 = j;
                                minWidths[n2] = minWidths[n2] + w;
                            } else {
                                delta = w / spanExpandCount;
                                remainder = w % spanExpandCount;
                                last = -1;
                                k3 = 0;
                                while (k3 < hSpan) {
                                    if (expandColumn[j - k3]) {
                                        last = j - k3;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k3;
                                }
                                if (last > -1) {
                                    int n3 = last;
                                    minWidths[n3] = minWidths[n3] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i3;
            }
            ++j;
        }
        if (this.makeColumnsEqualWidth) {
            int minColumnWidth = 0;
            int columnWidth = 0;
            int i6 = 0;
            while (i6 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i6]);
                columnWidth = Math.max(columnWidth, widths[i6]);
                ++i6;
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            i6 = 0;
            while (i6 < columnCount) {
                expandColumn[i6] = expandCount > 0;
                widths[i6] = columnWidth;
                ++i6;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            i3 = 0;
            while (i3 < columnCount) {
                totalWidth += widths[i3];
                ++i3;
            }
            int c = expandCount;
            int delta = (availableWidth - totalWidth) / c;
            int remainder = (availableWidth - totalWidth) % c;
            int last2 = -1;
            while (totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (widths[j2] + delta > minWidths[j2]) {
                            last2 = j2;
                            widths[last2] = widths[j2] + delta;
                        } else {
                            widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --c;
                        }
                    }
                    ++j2;
                }
                if (last2 > -1) {
                    int n = last2;
                    widths[n] = widths[n] + remainder;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    i2 = 0;
                    while (i2 < rowCount) {
                        int hSpan;
                        GridData data6 = this.getData(grid, i2, j2, rowCount, columnCount, false);
                        if (!(data6 == null || (hSpan = Math.max(1, Math.min(data6.horizontalSpan, columnCount))) <= 1 || data6.grabExcessHorizontalSpace && data6.minimumWidth == 0)) {
                            int w;
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            k3 = 0;
                            while (k3 < hSpan) {
                                spanWidth += widths[j2 - k3];
                                if (expandColumn[j2 - k3]) {
                                    ++spanExpandCount;
                                }
                                ++k3;
                            }
                            int n = w = !data6.grabExcessHorizontalSpace || data6.minimumWidth == -1 ? data6.cacheWidth : data6.minimumWidth;
                            if ((w += data6.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n4 = j2;
                                    widths[n4] = widths[n4] + w;
                                } else {
                                    int delta2 = w / spanExpandCount;
                                    int remainder2 = w % spanExpandCount;
                                    int last22 = -1;
                                    k2 = 0;
                                    while (k2 < hSpan) {
                                        if (expandColumn[j2 - k2]) {
                                            last22 = j2 - k2;
                                            widths[last22] = widths[last22] + delta2;
                                        }
                                        ++k2;
                                    }
                                    if (last22 > -1) {
                                        int n5 = last22;
                                        widths[n5] = widths[n5] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    ++j2;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i7 = 0;
                    while (i7 < columnCount) {
                        totalWidth += widths[i7];
                        ++i7;
                    }
                    delta = (availableWidth - totalWidth) / c;
                    remainder = (availableWidth - totalWidth) % c;
                    last2 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i8 = 0;
                while (i8 < rowCount) {
                    GridData data7 = this.getData(grid, i8, j3, rowCount, columnCount, false);
                    if (data7 != null && data7.heightHint == -1) {
                        Control child = grid[i8][j3];
                        int hSpan = Math.max(1, Math.min(data7.horizontalSpan, columnCount));
                        int currentWidth = 0;
                        int k6 = 0;
                        while (k6 < hSpan) {
                            currentWidth += widths[j3 - k6];
                            ++k6;
                        }
                        if ((currentWidth += (hSpan - 1) * this.horizontalSpacing - data7.horizontalIndent) != data7.cacheWidth && data7.horizontalAlignment == 4 || data7.cacheWidth > currentWidth) {
                            int trim = 0;
                            if (child instanceof Scrollable) {
                                Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                                trim = rect.width;
                            } else {
                                trim = child.getBorderWidth() * 2;
                            }
                            data7.cacheHeight = -1;
                            data7.cacheWidth = -1;
                            data7.computeSize(child, Math.max(0, currentWidth - trim), data7.heightHint, false);
                            if (data7.grabExcessVerticalSpace && data7.minimumHeight > 0) {
                                data7.cacheHeight = Math.max(data7.cacheHeight, data7.minimumHeight);
                            }
                            if (flush == null) {
                                flush = new GridData[count];
                            }
                            flush[flushLength++] = data7;
                        }
                    }
                    ++i8;
                }
                ++j3;
            }
        }
        int availableHeight = height - this.verticalSpacing * (rowCount - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        expandCount = 0;
        int[] heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        i2 = 0;
        while (i2 < rowCount) {
            int j4 = 0;
            while (j4 < columnCount) {
                int vSpan;
                GridData data8 = this.getData(grid, i2, j4, rowCount, columnCount, true);
                if (data8 != null && (vSpan = Math.max(1, Math.min(data8.verticalSpan, rowCount))) == 1) {
                    int h = data8.cacheHeight + data8.verticalIndent;
                    heights[i2] = Math.max(heights[i2], h);
                    if (data8.grabExcessVerticalSpace) {
                        if (!expandRow[i2]) {
                            ++expandCount;
                        }
                        expandRow[i2] = true;
                    }
                    if (!data8.grabExcessVerticalSpace || data8.minimumHeight != 0) {
                        h = !data8.grabExcessVerticalSpace || data8.minimumHeight == -1 ? data8.cacheHeight : data8.minimumHeight;
                        minHeights[i2] = Math.max(minHeights[i2], h += data8.verticalIndent);
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                int vSpan;
                GridData data9 = this.getData(grid, i2, j4, rowCount, columnCount, false);
                if (data9 != null && (vSpan = Math.max(1, Math.min(data9.verticalSpan, rowCount))) > 1) {
                    int last3;
                    int remainder;
                    int delta;
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k7 = 0;
                    while (k7 < vSpan) {
                        spanHeight += heights[i2 - k7];
                        spanMinHeight += minHeights[i2 - k7];
                        if (expandRow[i2 - k7]) {
                            ++spanExpandCount;
                        }
                        ++k7;
                    }
                    if (data9.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i2] = true;
                    }
                    if ((h = data9.cacheHeight + data9.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i2;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder = h % spanExpandCount;
                            last3 = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i2 - k]) {
                                    last3 = i2 - k;
                                    heights[last3] = heights[last3] + delta;
                                }
                                ++k;
                            }
                            if (last3 > -1) {
                                int n = last3;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    if (!data9.grabExcessVerticalSpace || data9.minimumHeight != 0) {
                        int n = h = !data9.grabExcessVerticalSpace || data9.minimumHeight == -1 ? data9.cacheHeight : data9.minimumHeight;
                        if ((h += data9.verticalIndent - spanMinHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n6 = i2;
                                minHeights[n6] = minHeights[n6] + h;
                            } else {
                                delta = h / spanExpandCount;
                                remainder = h % spanExpandCount;
                                last3 = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i2 - k]) {
                                        last3 = i2 - k;
                                        minHeights[last3] = minHeights[last3] + delta;
                                    }
                                    ++k;
                                }
                                if (last3 > -1) {
                                    int n7 = last3;
                                    minHeights[n7] = minHeights[n7] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i2;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            int i9 = 0;
            while (i9 < rowCount) {
                totalHeight += heights[i9];
                ++i9;
            }
            int c = expandCount;
            int delta = (availableHeight - totalHeight) / c;
            int remainder = (availableHeight - totalHeight) % c;
            last = -1;
            while (totalHeight != availableHeight) {
                int i10 = 0;
                while (i10 < rowCount) {
                    if (expandRow[i10]) {
                        if (heights[i10] + delta > minHeights[i10]) {
                            last = i10;
                            heights[last] = heights[i10] + delta;
                        } else {
                            heights[i10] = minHeights[i10];
                            expandRow[i10] = false;
                            --c;
                        }
                    }
                    ++i10;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i10 = 0;
                while (i10 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        GridData data10 = this.getData(grid, i10, j5, rowCount, columnCount, false);
                        if (!(data10 == null || (vSpan = Math.max(1, Math.min(data10.verticalSpan, rowCount))) <= 1 || data10.grabExcessVerticalSpace && data10.minimumHeight == 0)) {
                            int h;
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            k = 0;
                            while (k < vSpan) {
                                spanHeight += heights[i10 - k];
                                if (expandRow[i10 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int n = h = !data10.grabExcessVerticalSpace || data10.minimumHeight == -1 ? data10.cacheHeight : data10.minimumHeight;
                            if ((h += data10.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n8 = i10;
                                    heights[n8] = heights[n8] + h;
                                } else {
                                    int delta2 = h / spanExpandCount;
                                    int remainder2 = h % spanExpandCount;
                                    int last2 = -1;
                                    int k8 = 0;
                                    while (k8 < vSpan) {
                                        if (expandRow[i10 - k8]) {
                                            last2 = i10 - k8;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k8;
                                    }
                                    if (last2 > -1) {
                                        int n9 = last2;
                                        heights[n9] = heights[n9] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i10;
                }
                if (c == 0) break;
                totalHeight = 0;
                i10 = 0;
                while (i10 < rowCount) {
                    totalHeight += heights[i10];
                    ++i10;
                }
                delta = (availableHeight - totalHeight) / c;
                remainder = (availableHeight - totalHeight) % c;
                last = -1;
            }
        }
        if (move2) {
            int gridY = y + this.marginTop + this.marginHeight;
            int i11 = 0;
            while (i11 < rowCount) {
                int gridX = x + this.marginLeft + this.marginWidth;
                int j6 = 0;
                while (j6 < columnCount) {
                    GridData data11 = this.getData(grid, i11, j6, rowCount, columnCount, true);
                    if (data11 != null) {
                        int hSpan = Math.max(1, Math.min(data11.horizontalSpan, columnCount));
                        int vSpan = Math.max(1, data11.verticalSpan);
                        int cellWidth = 0;
                        int cellHeight = 0;
                        k2 = 0;
                        while (k2 < hSpan) {
                            cellWidth += widths[j6 + k2];
                            ++k2;
                        }
                        k2 = 0;
                        while (k2 < vSpan) {
                            cellHeight += heights[i11 + k2];
                            ++k2;
                        }
                        int childX = gridX + data11.horizontalIndent;
                        int childWidth = Math.min(data11.cacheWidth, cellWidth += this.horizontalSpacing * (hSpan - 1));
                        switch (data11.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childX += Math.max(0, (cellWidth - data11.horizontalIndent - childWidth) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                childX += Math.max(0, cellWidth - data11.horizontalIndent - childWidth);
                                break;
                            }
                            case 4: {
                                childWidth = cellWidth - data11.horizontalIndent;
                            }
                        }
                        int childY = gridY + data11.verticalIndent;
                        int childHeight = Math.min(data11.cacheHeight, cellHeight += this.verticalSpacing * (vSpan - 1));
                        switch (data11.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childY += Math.max(0, (cellHeight - data11.verticalIndent - childHeight) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                childY += Math.max(0, cellHeight - data11.verticalIndent - childHeight);
                                break;
                            }
                            case 4: {
                                childHeight = cellHeight - data11.verticalIndent;
                            }
                        }
                        Control child = grid[i11][j6];
                        if (child != null) {
                            child.setBounds(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j6] + this.horizontalSpacing;
                    ++j6;
                }
                gridY += heights[i11] + this.verticalSpacing;
                ++i11;
            }
        }
        i2 = 0;
        while (i2 < flushLength) {
            flush[i2].cacheHeight = -1;
            flush[i2].cacheWidth = -1;
            ++i2;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i12 = 0;
        while (i12 < columnCount) {
            totalDefaultWidth += widths[i12];
            ++i12;
        }
        i12 = 0;
        while (i12 < rowCount) {
            totalDefaultHeight += heights[i12];
            ++i12;
        }
        return new Point(totalDefaultWidth += this.horizontalSpacing * (columnCount - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, totalDefaultHeight += this.verticalSpacing * (rowCount - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string2 = this.getClass().getName();
        int index = string2.lastIndexOf(46);
        if (index == -1) {
            return string2;
        }
        return string2.substring(index + 1, string2.length());
    }

    public String toString() {
        String string2 = String.valueOf(this.getName()) + " {";
        if (this.numColumns != 1) {
            string2 = String.valueOf(string2) + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string2 = String.valueOf(string2) + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string2 = String.valueOf(string2) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string2 = String.valueOf(string2) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string2 = String.valueOf(string2) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string2 = String.valueOf(string2) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string2 = String.valueOf(string2) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string2 = String.valueOf(string2) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string2 = String.valueOf(string2) + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string2 = String.valueOf(string2) + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string2 = string2.trim();
        string2 = String.valueOf(string2) + "}";
        return string2;
    }
}

