/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSOpenGLPixelFormat;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    NSOpenGLContext context;
    NSOpenGLPixelFormat pixelFormat;
    static final int MAX_ATTRIBUTES = 32;
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";

    public GLCanvas(Composite parent, int style, GLData data2) {
        super(parent, style);
        if (data2 == null) {
            SWT.error(4);
        }
        int[] attrib = new int[32];
        int pos = 0;
        if (data2.doubleBuffer) {
            attrib[pos++] = 5;
        }
        if (data2.stereo) {
            attrib[pos++] = 6;
        }
        if (data2.redSize + data2.blueSize + data2.greenSize > 0) {
            attrib[pos++] = 8;
            attrib[pos++] = data2.redSize + data2.greenSize + data2.blueSize;
        }
        if (data2.alphaSize > 0) {
            attrib[pos++] = 11;
            attrib[pos++] = data2.alphaSize;
        }
        if (data2.depthSize > 0) {
            attrib[pos++] = 12;
            attrib[pos++] = data2.depthSize;
        }
        if (data2.stencilSize > 0) {
            attrib[pos++] = 13;
            attrib[pos++] = data2.stencilSize;
        }
        if (data2.accumRedSize + data2.accumBlueSize + data2.accumGreenSize > 0) {
            attrib[pos++] = 14;
            attrib[pos++] = data2.accumRedSize + data2.accumGreenSize + data2.accumBlueSize + data2.accumAlphaSize;
        }
        if (data2.sampleBuffers > 0) {
            attrib[pos++] = 55;
            attrib[pos++] = data2.sampleBuffers;
        }
        if (data2.samples > 0) {
            attrib[pos++] = 56;
            attrib[pos++] = data2.samples;
        }
        attrib[pos++] = 0;
        this.pixelFormat = (NSOpenGLPixelFormat)new NSOpenGLPixelFormat().alloc();
        if (this.pixelFormat == null) {
            this.dispose();
            SWT.error(38);
        }
        this.pixelFormat.initWithAttributes(attrib);
        NSOpenGLContext ctx = data2.shareContext != null ? data2.shareContext.context : null;
        this.context = (NSOpenGLContext)new NSOpenGLContext().alloc();
        if (this.context == null) {
            this.dispose();
            SWT.error(38);
        }
        this.context = this.context.initWithFormat(this.pixelFormat, ctx);
        this.context.setValues(new int[]{-1}, 235L);
        this.setData(GLCONTEXT_KEY, this.context);
        NSNotificationCenter.defaultCenter().addObserver(this.view, OS.sel_updateOpenGLContext_, OS.NSViewGlobalFrameDidChangeNotification, this.view);
        Listener listener2 = event -> {
            switch (event.type) {
                case 12: {
                    this.setData(GLCONTEXT_KEY, null);
                    NSNotificationCenter.defaultCenter().removeObserver(this.view);
                    if (this.context != null) {
                        this.context.clearDrawable();
                        this.context.release();
                    }
                    this.context = null;
                    if (this.pixelFormat != null) {
                        this.pixelFormat.release();
                    }
                    this.pixelFormat = null;
                }
            }
        };
        this.addListener(12, listener2);
    }

    public GLData getGLData() {
        int accumColorSize;
        int colorSize;
        this.checkWidget();
        GLData data2 = new GLData();
        long[] value = new long[1];
        this.pixelFormat.getValues(value, 5, 0);
        data2.doubleBuffer = value[0] != 0L;
        this.pixelFormat.getValues(value, 6, 0);
        data2.stereo = value[0] != 0L;
        this.pixelFormat.getValues(value, 11, 0);
        data2.alphaSize = (int)value[0];
        this.pixelFormat.getValues(value, 8, 0);
        data2.redSize = colorSize = (int)(value[0] - (long)data2.alphaSize) / 3;
        data2.greenSize = colorSize;
        data2.blueSize = colorSize;
        this.pixelFormat.getValues(value, 12, 0);
        data2.depthSize = (int)value[0];
        this.pixelFormat.getValues(value, 13, 0);
        data2.stencilSize = (int)value[0];
        this.pixelFormat.getValues(value, 14, 0);
        data2.accumRedSize = accumColorSize = (int)value[0] / 4;
        data2.accumGreenSize = accumColorSize;
        data2.accumBlueSize = accumColorSize;
        data2.accumAlphaSize = accumColorSize;
        this.pixelFormat.getValues(value, 55, 0);
        data2.sampleBuffers = (int)value[0];
        this.pixelFormat.getValues(value, 56, 0);
        data2.samples = (int)value[0];
        return data2;
    }

    public boolean isCurrent() {
        this.checkWidget();
        NSOpenGLContext current = NSOpenGLContext.currentContext();
        return current != null && current.id == this.context.id;
    }

    public void setCurrent() {
        this.checkWidget();
        this.context.makeCurrentContext();
    }

    public void swapBuffers() {
        this.checkWidget();
        this.context.flushBuffer();
    }
}

