/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTabView;
import org.eclipse.swt.internal.cocoa.SWTTabViewItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int itemCount;
    boolean ignoreSelect;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        Point size = super.computeSize(wHint, hHint, changed2);
        if (wHint == -1 && this.items.length > 0) {
            NSSize minSize = ((NSTabView)this.view).minimumSize();
            Rectangle trim = this.computeTrim(0, 0, (int)Math.ceil(minSize.width), 0);
            size.x = Math.max(trim.width, size.x);
        }
        return size;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        NSTabView widget = (NSTabView)this.view;
        NSRect rect = widget.contentRect();
        x = (int)((double)x - rect.x);
        y = (int)((double)y - rect.y);
        NSRect frame = widget.frame();
        width = (int)((double)width + Math.ceil(frame.width - rect.width));
        height = (int)((double)height + Math.ceil(frame.height - rect.height));
        return super.computeTrim(x, y, width, height);
    }

    @Override
    void createHandle() {
        NSTabView widget = (NSTabView)new SWTTabView().alloc();
        widget.init();
        widget.setDelegate(widget);
        if ((this.style & 0x400) != 0) {
            widget.setTabViewType(2L);
        }
        this.view = widget;
    }

    void createItem(TabItem item2, int index) {
        NSTabViewItem nsItem;
        int count = this.itemCount;
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item2;
        ++this.itemCount;
        item2.nsItem = nsItem = (NSTabViewItem)new SWTTabViewItem().alloc().init();
        item2.createJNIRef();
        item2.register();
        ((NSTabView)this.view).insertTabViewItem(nsItem, index);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tabViewFont;
    }

    void destroyItem(TabItem item2) {
        int count = this.itemCount;
        int index = 0;
        while (index < count) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new TabItem[4];
        }
        this.itemCount = count;
        ((NSTabView)this.view).removeTabViewItem(item2.nsItem);
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    @Override
    Widget findTooltip(NSPoint pt) {
        NSTabViewItem nsItem = ((NSTabView)this.view).tabViewItemAtPoint(pt = this.view.convertPoint_fromView_(pt, null));
        if (nsItem != null) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                TabItem item2 = this.items[i2];
                if (item2.nsItem.id == nsItem.id) {
                    return item2;
                }
                ++i2;
            }
        }
        return super.findTooltip(pt);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect rect = ((NSTabView)this.view).contentRect();
        int x = Math.max(0, (int)rect.x);
        int y = Math.max(0, (int)rect.y);
        int width = Math.max(0, (int)Math.ceil(rect.width));
        int height = Math.max(0, (int)Math.ceil(rect.height));
        return new Rectangle(x, y, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = this.itemCount;
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        NSPoint nsPoint = new NSPoint();
        nsPoint.x = point.x;
        nsPoint.y = point.y;
        NSTabView tabView = (NSTabView)this.view;
        NSTabViewItem tabViewItem = tabView.tabViewItemAtPoint(nsPoint);
        int i2 = 0;
        while (i2 < this.itemCount) {
            NSTabViewItem item2 = this.items[i2].nsItem;
            if (item2.isEqual(tabViewItem)) {
                return this.items[i2];
            }
            ++i2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = this.itemCount;
        TabItem[] result2 = new TabItem[count];
        System.arraycopy(this.items, 0, result2, 0, count);
        return result2;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTabViewItem selected = ((NSTabView)this.view).selectedTabViewItem();
        if (selected == null) {
            return -1;
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.items[i2].nsItem.id == selected.id) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        int count = this.itemCount;
        int i2 = 0;
        while (i2 < count) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i2 = 0;
        while (i2 < children.length) {
            Control child = children[i2];
            int index = 0;
            int count = this.itemCount;
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i2;
        }
        return new Point(width, height);
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                TabItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int count = this.itemCount;
        int i2 = 0;
        while (i2 < count) {
            TabItem item2 = this.items[i2];
            if (item2.control == control) {
                item2.setControl(null);
            }
            ++i2;
        }
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                TabItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setFont(NSFont font) {
        ((NSTabView)this.view).setFont(font);
        int index = this.getSelectionIndex();
        int i2 = 0;
        while (i2 < this.itemCount) {
            this.items[i2].updateText(i2 == index);
            ++i2;
        }
    }

    @Override
    void setForeground(double[] color) {
        super.setForeground(color);
        int index = this.getSelectionIndex();
        int i2 = 0;
        while (i2 < this.itemCount) {
            this.items[i2].updateText(i2 == index);
            ++i2;
        }
    }

    public void setSelection(TabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item2});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            int i2 = items.length - 1;
            while (i2 >= 0) {
                int index = this.indexOf(items[i2]);
                if (index != -1) {
                    this.setSelection(index, false, false);
                }
                --i2;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = this.itemCount;
        if (index < 0 || index >= count) {
            return;
        }
        this.setSelection(index, false, false);
    }

    void setSelection(int index, boolean notify, boolean force) {
        Control control;
        TabItem item2;
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int currentIndex = this.getSelectionIndex();
        if (!force && currentIndex == index) {
            return;
        }
        if (currentIndex != -1 && (item2 = this.items[currentIndex]) != null && (control = item2.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.ignoreSelect = true;
        ((NSTabView)this.view).selectTabViewItemAtIndex(index);
        this.ignoreSelect = false;
        index = this.getSelectionIndex();
        if (index != -1 && (item2 = this.items[index]) != null) {
            control = item2.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item2;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    @Override
    void setSmallSize() {
        ((NSTabView)this.view).setControlSize(1L);
    }

    @Override
    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true, false);
        return index == this.getSelectionIndex();
    }

    @Override
    void tabView_willSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
        if (tabViewItem == 0L) {
            return;
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            TabItem item2 = this.items[i2];
            if (item2.nsItem.id == tabViewItem) {
                Control control;
                TabItem selected;
                int currentIndex = this.getSelectionIndex();
                if (currentIndex != -1 && (selected = this.items[currentIndex]) != null) {
                    Control control2;
                    if (OS.VERSION >= 4208) {
                        selected.updateText(false);
                    }
                    if ((control2 = selected.control) != null && !control2.isDisposed()) {
                        control2.setVisible(false);
                    }
                }
                if ((control = item2.control) != null && !control.isDisposed()) {
                    control.setVisible(true);
                }
                if (OS.VERSION < 4208) break;
                item2.updateText(true);
                break;
            }
            ++i2;
        }
    }

    @Override
    void tabView_didSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
        if (tabViewItem == 0L) {
            return;
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            NSView topView;
            TabItem item2 = this.items[i2];
            Control control = item2.control;
            if (control != null && (topView = control.topView()).superview() == null) {
                this.contentView().addSubview(topView, -1L, null);
            }
            if (item2.nsItem.id == tabViewItem && !this.ignoreSelect) {
                Event event = new Event();
                event.item = item2;
                this.sendSelectionEvent(13, event, false);
            }
            ++i2;
        }
    }
}

