/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    NSWindow[] windows;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        if (this.parent != null) {
            Point pt = this.parent.toDisplay(newX, newY);
            newX = pt.x;
            newY = pt.y;
        }
        this.display.setCursorLocation(newX, newY);
        return new Point(newX, newY);
    }

    Point adjustResizeCursor(boolean movePointer) {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            Point pt = this.parent.toDisplay(newX, newY);
            newX = pt.x;
            newY = pt.y;
        }
        if (movePointer) {
            this.display.setCursorLocation(newX, newY);
        }
        if (this.clientCursor == null) {
            Cursor newCursor = null;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    newCursor = new Cursor(this.display, 5);
                }
            }
            this.display.lockCursor = false;
            newCursor.handle.set();
            this.display.lockCursor = true;
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = newCursor;
        }
        return new Point(newX, newY);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i2 = 1;
        while (i2 < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i2].x < xMin) {
                xMin = this.rectangles[i2].x;
            }
            if (this.rectangles[i2].y < yMin) {
                yMin = this.rectangles[i2].y;
            }
            if ((rectRight = this.rectangles[i2].x + this.rectangles[i2].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i2].y + this.rectangles[i2].height) > yMax) {
                yMax = rectBottom;
            }
            ++i2;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result2 = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i2 = 0;
            while (i2 < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i2].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i2].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i2].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i2].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result2[i2] = new Rectangle(x, y, width, height);
                ++i2;
            }
        }
        return result2;
    }

    void drawRectangles(NSWindow window, Rectangle[] rects, boolean erase) {
        NSGraphicsContext context = window.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(context);
        context.saveGraphicsState();
        Point parentOrigin = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new Point(0, 0);
        context.setCompositingOperation(erase ? 0 : 2);
        NSRect rectFrame = new NSRect();
        NSPoint globalPoint = new NSPoint();
        double screenHeight = this.display.getPrimaryFrame().height;
        int i2 = 0;
        while (i2 < rects.length) {
            Rectangle rect = rects[i2];
            rectFrame.x = rect.x + parentOrigin.x;
            rectFrame.y = screenHeight - (double)(rect.y + parentOrigin.y + rect.height);
            rectFrame.width = rect.width;
            rectFrame.height = rect.height;
            globalPoint.x = rectFrame.x;
            globalPoint.y = rectFrame.y;
            globalPoint = window.convertScreenToBase(globalPoint);
            rectFrame.x = globalPoint.x;
            rectFrame.y = globalPoint.y;
            if (erase) {
                rectFrame.width += 1.0;
                rectFrame.height += 1.0;
                NSBezierPath.fillRect(rectFrame);
            } else {
                rectFrame.x += 0.5;
                rectFrame.y += 0.5;
                NSBezierPath.strokeRect(rectFrame);
            }
            ++i2;
        }
        if (!erase) {
            context.flushGraphics();
        }
        context.restoreGraphicsState();
        NSGraphicsContext.static_restoreGraphicsState();
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result2 = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle current = this.rectangles[i2];
            result2[i2] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i2;
        }
        return result2;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void mouse(NSEvent nsEvent) {
        NSPoint location;
        if (nsEvent == null || nsEvent.type() == 5L) {
            location = NSEvent.mouseLocation();
        } else {
            location = nsEvent.locationInWindow();
            location = nsEvent.window().convertBaseToScreen(location);
        }
        location.y = this.display.getPrimaryFrame().height - location.y;
        int newX = (int)location.x;
        int newY = (int)location.y;
        if (newX != this.oldX || newY != this.oldY) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i2 = 0;
            while (i2 < this.rectangles.length) {
                Rectangle current = this.rectangles[i2];
                rectsToErase[i2] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i2;
            }
            Event event = new Event();
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                Point cursorPos;
                boolean orientationInit = this.resizeRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i4 = 0;
                    while (i4 < this.windows.length) {
                        this.drawRectangles(this.windows[i4], rectsToErase, true);
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < this.windows.length) {
                        this.drawRectangles(this.windows[i4], this.rectangles, false);
                        ++i4;
                    }
                }
                if ((cursorPos = this.adjustResizeCursor(orientationInit)) != null) {
                    newX = cursorPos.x;
                    newY = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i5 = 0;
                        while (i5 < length) {
                            if (!this.rectangles[i5].equals(rectsToErase[i5])) {
                                draw = true;
                                break;
                            }
                            ++i5;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i6 = 0;
                    while (i6 < this.windows.length) {
                        this.drawRectangles(this.windows[i6], rectsToErase, true);
                        ++i6;
                    }
                    i6 = 0;
                    while (i6 < this.windows.length) {
                        this.drawRectangles(this.windows[i6], this.rectangles, false);
                        ++i6;
                    }
                }
            }
            this.oldX = newX;
            this.oldY = newY;
        }
        switch ((int)nsEvent.type()) {
            case 2: 
            case 4: 
            case 26: {
                this.tracking = false;
            }
        }
    }

    void key(NSEvent nsEvent) {
        int nsType = (int)nsEvent.type();
        long modifierFlags = nsEvent.modifierFlags();
        short nsKeyCode = nsEvent.keyCode();
        int keyCode = Display.translateKey(nsKeyCode);
        switch (nsType) {
            case 10: 
            case 11: {
                int type2;
                Event event = new Event();
                event.keyCode = keyCode;
                int n = type2 = nsType == 10 ? 1 : 2;
                if (!this.setKeyState(event, type2, nsEvent) || this.sendKeyEvent(type2, event)) break;
                return;
            }
            case 12: {
                int mask = 0;
                switch (keyCode) {
                    case 65536: {
                        mask = 524288;
                        break;
                    }
                    case 262144: {
                        mask = 262144;
                        break;
                    }
                    case 0x400000: {
                        mask = 0x100000;
                        break;
                    }
                    case 131072: {
                        mask = 131072;
                        break;
                    }
                    case 16777298: {
                        Event event = new Event();
                        event.keyCode = keyCode;
                        this.setInputState(event, nsEvent, 1);
                        this.sendKeyEvent(1, event);
                        this.setInputState(event, nsEvent, 2);
                        this.sendKeyEvent(2, event);
                    }
                }
                if (mask == 0) break;
                int type2 = ((long)mask & modifierFlags) != 0L ? 1 : 2;
                Event event = new Event();
                event.keyCode = keyCode;
                this.setLocationMask(event, nsEvent);
                this.setInputState(event, nsEvent, type2);
                if (this.sendKeyEvent(type2, event)) break;
                return;
            }
        }
        int stepSize = (modifierFlags & 0x40000L) != 0L ? 1 : 9;
        int xChange = 0;
        int yChange = 0;
        switch (nsKeyCode) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                xChange = -stepSize;
                break;
            }
            case 124: {
                xChange = stepSize;
                break;
            }
            case 126: {
                yChange = -stepSize;
                break;
            }
            case 125: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            Point cursorPos;
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i2 = 0;
            while (i2 < this.rectangles.length) {
                Rectangle current = this.rectangles[i2];
                rectsToErase[i2] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i2;
            }
            Event event = new Event();
            int newX = this.oldX + xChange;
            int newY = this.oldY + yChange;
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i4 = 0;
                    while (i4 < this.windows.length) {
                        this.drawRectangles(this.windows[i4], rectsToErase, true);
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < this.windows.length) {
                        this.drawRectangles(this.windows[i4], this.rectangles, false);
                        ++i4;
                    }
                }
                cursorPos = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i5 = 0;
                        while (i5 < length) {
                            if (!this.rectangles[i5].equals(rectsToErase[i5])) {
                                draw = true;
                                break;
                            }
                            ++i5;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i6 = 0;
                    while (i6 < this.windows.length) {
                        this.drawRectangles(this.windows[i6], rectsToErase, true);
                        ++i6;
                    }
                    i6 = 0;
                    while (i6 < this.windows.length) {
                        this.drawRectangles(this.windows[i6], this.rectangles, false);
                        ++i6;
                    }
                }
                cursorPos = this.adjustMoveCursor();
            }
            if (cursorPos != null) {
                this.oldX = cursorPos.x;
                this.oldY = cursorPos.y;
            }
        }
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            this.rectangles[i2].x += xChange;
            this.rectangles[i2].y += yChange;
            ++i2;
        }
    }

    public boolean open() {
        Point cursorPos;
        int hStyle;
        this.checkWidget();
        Display display = this.display;
        this.cancelled = false;
        this.tracking = true;
        NSArray screens = NSScreen.screens();
        int count = (int)screens.count();
        this.windows = new NSWindow[count];
        int i2 = 0;
        while (i2 < count) {
            NSScreen screen = new NSScreen(screens.objectAtIndex(i2));
            NSRect frame = screen.frame();
            NSWindow window = (NSWindow)new NSWindow().alloc();
            window = window.initWithContentRect(frame, 0L, 2L, false);
            window.setOpaque(false);
            window.setLevel(25L);
            window.setContentView(null);
            window.setBackgroundColor(NSColor.clearColor());
            NSGraphicsContext context = window.graphicsContext();
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(context);
            context.setCompositingOperation(0L);
            frame.y = 0.0;
            frame.x = 0.0;
            NSBezierPath.fillRect(frame);
            NSGraphicsContext.static_restoreGraphicsState();
            window.orderFrontRegardless();
            this.windows[i2] = window;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.windows.length) {
            this.drawRectangles(this.windows[i2], this.rectangles, false);
            ++i2;
        }
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean down = false;
        NSApplication application = NSApplication.sharedApplication();
        NSEvent currentEvent = application.currentEvent();
        if (currentEvent != null) {
            switch ((int)currentEvent.type()) {
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 25: 
                case 27: {
                    down = true;
                }
            }
        }
        if ((cursorPos = down ? display.getCursorLocation() : ((this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor())) != null) {
            this.oldX = cursorPos.x;
            this.oldY = cursorPos.y;
        }
        Control oldTrackingControl = display.trackingControl;
        display.trackingControl = null;
        while (this.tracking && !this.cancelled) {
            display.addPool();
            try {
                if (this.parent != null && this.parent.isDisposed()) break;
                display.runSkin();
                display.runDeferredLayouts();
                NSEvent event = application.nextEventMatchingMask(-1L, NSDate.distantFuture(), OS.NSDefaultRunLoopMode, true);
                if (event == null) continue;
                int type2 = (int)event.type();
                switch (type2) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 26: 
                    case 27: {
                        this.mouse(event);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        this.key(event);
                    }
                }
                boolean dispatch = true;
                switch (type2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 26: 
                    case 27: {
                        dispatch = false;
                    }
                }
                if (dispatch) {
                    application.sendEvent(event);
                }
                if (this.clientCursor != null && this.resizeCursor == null) {
                    display.lockCursor = false;
                    this.clientCursor.handle.set();
                    display.lockCursor = true;
                }
                display.runAsyncMessages(false);
            }
            finally {
                display.removePool();
            }
        }
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        if (oldTrackingControl != null && !oldTrackingControl.isDisposed()) {
            display.trackingControl = oldTrackingControl;
        }
        display.setCursor(display.findControl(true));
        if (!this.isDisposed()) {
            int i3 = 0;
            while (i3 < this.windows.length) {
                this.drawRectangles(this.windows[i3], this.rectangles, true);
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < this.windows.length) {
            if (this.windows[i4] != null) {
                this.windows[i4].close();
                this.windows[i4] = null;
            }
            ++i4;
        }
        this.tracking = false;
        this.windows = null;
        return !this.cancelled;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener2);
        this.eventTable.unhook(10, listener2);
    }

    public void removeKeyListener(KeyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener2);
        this.eventTable.unhook(1, listener2);
    }

    boolean resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i2;
        if (this.bounds == null) {
            return false;
        }
        boolean orientationInit = false;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            orientationInit = true;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            orientationInit = true;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            orientationInit = true;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            orientationInit = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i2 = 0;
                    while (i2 < this.proportions.length) {
                        proportion = this.proportions[i2];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i2;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i2 = 0;
                while (i2 < this.proportions.length) {
                    proportion = this.proportions[i2];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i2;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i2 = 0;
                    while (i2 < this.proportions.length) {
                        proportion = this.proportions[i2];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i2;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i2 = 0;
                while (i2 < this.proportions.length) {
                    proportion = this.proportions[i2];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i2;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i3 = 0;
        while (i3 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i3];
            newRects[i3] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i3;
        }
        this.rectangles = newRects;
        return orientationInit;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
        if (newCursor != null) {
            this.display.lockCursor = false;
            if (this.inEvent) {
                newCursor.handle.set();
            }
            this.display.lockCursor = true;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i2 = 0;
        while (i2 < length) {
            Rectangle current = rectangles[i2];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i2] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i2;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

