/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.data.RecordSet;
import gde.device.MeasurementPropertyTypes;
import gde.log.Level;
import gde.ui.DataExplorer;
import java.util.logging.Logger;

public abstract class CalculationThread
extends Thread {
    private static final Logger log = Logger.getLogger(CalculationThread.class.getName());
    public static final String REGRESSION_TYPE = MeasurementPropertyTypes.REGRESSION_TYPE.value();
    public static final String REGRESSION_TYPE_LINEAR = MeasurementPropertyTypes.REGRESSION_TYPE_LINEAR.value();
    public static final String REGRESSION_TYPE_CURVE = MeasurementPropertyTypes.REGRESSION_TYPE_CURVE.value();
    public static final String REGRESSION_INTERVAL_SEC = MeasurementPropertyTypes.REGRESSION_INTERVAL_SEC.value();
    protected RecordSet recordSet;
    protected String sourceRecordKey;
    protected String targetRecordKey;
    protected int calcInterval_sec = 10;
    protected final DataExplorer application;
    protected boolean threadStop = false;

    public CalculationThread(RecordSet currentRecordSet, String inRecordKey, String outRecordKey, int calcIntervalSec) {
        super("calculation");
        this.recordSet = currentRecordSet;
        this.sourceRecordKey = inRecordKey;
        this.targetRecordKey = outRecordKey;
        this.calcInterval_sec = calcIntervalSec;
        this.application = DataExplorer.getInstance();
        log.log(Level.FINER, this.getClass().getSimpleName() + " instanciated");
        this.setPriority(10);
    }

    @Override
    public abstract void run();

    public void setRecordSet(RecordSet newRecordSet) {
        this.recordSet = newRecordSet;
    }

    public void setThreadStop(boolean doStop) {
        this.threadStop = doStop;
    }

    public void setSourceRecordKey(String inRecordKey) {
        this.sourceRecordKey = inRecordKey;
    }

    public void setTargetRecordKey(String outRecordKey) {
        this.targetRecordKey = outRecordKey;
    }

    public int getCalcInterval_sec() {
        return this.calcInterval_sec;
    }

    public void setCalcInterval_sec(int calcIntervalSec) {
        this.calcInterval_sec = calcIntervalSec;
    }
}

