/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.config.Settings;
import gde.data.RecordSet;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.GraphicsUtils;
import gde.utils.LocalizedDateTime;
import gde.utils.StringHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class TimeLine {
    static final Logger log = Logger.getLogger(TimeLine.class.getName());
    public static final int TIME_LINE_MSEC = 0;
    public static final int TIME_LINE_SEC = 1;
    public static final int TIME_LINE_SEC_MIN = 2;
    public static final int TIME_LINE_MIN = 4;
    public static final int TIME_LINE_MIN_HRS = 6;
    public static final int TIME_LINE_HRS = 8;
    public static final int TIME_LINE_HRS_DAYS = 12;
    public static final int TIME_LINE_DAYS = 14;
    public static final int TIME_LINE_DAYS_MONTH = 16;
    public static final int TIME_LINE_MONTH = 18;
    public static final int TIME_LINE_MONTH_YEARS = 20;
    public static final int TIME_LINE_YEARS = 22;
    String timeLineText = Messages.getString("GDE_MSGT0267");
    boolean isTimeLinePrepared = false;
    static final SimpleDateFormat timeFormatSeconds = new SimpleDateFormat("ss.SSS");
    static final SimpleDateFormat timeFormatMinutes = new SimpleDateFormat("mm:ss.SSS");
    static final SimpleDateFormat timeFormatHours = new SimpleDateFormat("HH:mm:ss.SSS");

    public int[] getScaleMaxTimeNumber(double totalDisplayTime_ms) {
        int maxTimeNumberFormated;
        boolean isTimeFormatAbsolute;
        int factor = 10;
        int format = 0;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "totalDisplayTime_ms = " + totalDisplayTime_ms);
        }
        long totalTime_msec = (long)totalDisplayTime_ms;
        long totalTime_sec = (long)(totalDisplayTime_ms / 1000.0);
        long totalTime_min = TimeUnit.MINUTES.convert(totalTime_sec, TimeUnit.SECONDS);
        long totalTime_std = TimeUnit.HOURS.convert(totalTime_sec, TimeUnit.SECONDS);
        long totalTime_days = TimeUnit.DAYS.convert(totalTime_sec, TimeUnit.SECONDS);
        long totalTime_month = TimeUnit.DAYS.convert(totalTime_sec, TimeUnit.SECONDS) / 30L;
        long totalTime_year = TimeUnit.DAYS.convert(totalTime_sec, TimeUnit.SECONDS) / 365L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "totalTime_std = " + totalTime_std + "; totalTime_min = " + totalTime_min + "; totalTime_sec = " + totalTime_sec + "; totalTime_ms = " + totalTime_msec + " - 2147483647");
        }
        boolean bl = isTimeFormatAbsolute = DataExplorer.getInstance().getActiveRecordSet() != null && Settings.getInstance().isTimeFormatAbsolute() && !DataExplorer.getInstance().getActiveRecordSet().isCompareSet() && !DataExplorer.getInstance().getActiveRecordSet().isZoomMode();
        if (totalTime_year > 5L) {
            maxTimeNumberFormated = (int)totalTime_year;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0714") : Messages.getString("GDE_MSGT0392");
            format = 22;
        } else if (totalTime_month >= 12L) {
            maxTimeNumberFormated = (int)totalTime_month;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0715") : Messages.getString("GDE_MSGT0393");
            format = 20;
        } else if (totalTime_month > 3L) {
            maxTimeNumberFormated = (int)totalTime_month;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0716") : Messages.getString("GDE_MSGT0394");
            format = 18;
        } else if (totalTime_days > 30L) {
            maxTimeNumberFormated = (int)totalTime_days;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0717") : Messages.getString("GDE_MSGT0395");
            format = 16;
        } else if (totalTime_days > 7L) {
            maxTimeNumberFormated = (int)totalTime_days;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0718") : Messages.getString("GDE_MSGT0396");
            format = 14;
        } else if (totalTime_std >= 72L) {
            maxTimeNumberFormated = (int)totalTime_std;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0719") : Messages.getString("GDE_MSGT0397");
            format = 12;
        } else if (totalTime_std > 5L) {
            maxTimeNumberFormated = (int)totalTime_std;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0720") : Messages.getString("GDE_MSGT0265");
            format = 8;
        } else if (totalTime_min >= 60L) {
            maxTimeNumberFormated = (int)totalTime_min;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0721") : Messages.getString("GDE_MSGT0266");
            format = 6;
        } else if (totalTime_min > 10L) {
            maxTimeNumberFormated = (int)totalTime_min;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0722") : Messages.getString("GDE_MSGT0267");
            format = 4;
        } else if (totalTime_sec >= 60L) {
            maxTimeNumberFormated = (int)totalTime_sec;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0723") : Messages.getString("GDE_MSGT0268");
            format = 2;
        } else if (totalTime_sec > 10L) {
            maxTimeNumberFormated = (int)totalTime_sec;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0724") : Messages.getString("GDE_MSGT0269");
            format = 1;
        } else if (totalTime_sec > 1L) {
            maxTimeNumberFormated = (int)totalTime_msec;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0724") : Messages.getString("GDE_MSGT0269");
            factor = 1000;
            format = 1;
        } else if (totalTime_msec > 0L) {
            maxTimeNumberFormated = (int)totalTime_msec;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0725") : Messages.getString("GDE_MSGT0271");
            factor = 1;
            format = 0;
        } else {
            maxTimeNumberFormated = (int)totalTime_msec;
            this.timeLineText = isTimeFormatAbsolute ? Messages.getString("GDE_MSGT0725") : Messages.getString("GDE_MSGT0264");
            factor = 1;
            format = 0;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.timeLineText + "  " + maxTimeNumberFormated);
        }
        this.isTimeLinePrepared = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "timeLineText = " + this.timeLineText + " maxTimeNumber = " + maxTimeNumberFormated + " factor = " + factor);
        }
        return new int[]{maxTimeNumberFormated, factor, format, (int)totalTime_msec};
    }

    public void drawTimeLine(RecordSet recordSet, GC gc, int x0, int y0, int width, int startTimeValue, int endTimeValue, int scaleFactor, int timeFormat, long deltaTime_ms, Color color) {
        if (!this.isTimeLinePrepared) {
            log.log(Level.WARNING, "isTimeLinePrepared == false -> getScaleMaxTimeNumber(RecordSet recordSet) needs to be called first");
            return;
        }
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(color);
        gc.drawLine(x0 - 1, y0, x0 + width + 1, y0);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("time line - x0=%d y0=%d - width=%d - maxNumber=%d - scaleFactor=%d", x0, y0, width, endTimeValue, timeFormat));
        }
        Point pt = gc.textExtent(this.timeLineText);
        int ticklength = pt.y / 2;
        int gap = pt.y / 3;
        int miniTicks = 4;
        this.drawTickMarks(recordSet, gc, x0, y0, width, startTimeValue, endTimeValue, scaleFactor, timeFormat, deltaTime_ms, ticklength, miniTicks, gap);
        GraphicsUtils.drawTimeLineText(this.timeLineText, x0 + width / 2, y0 + ticklength + pt.y * 2, gc, 256);
    }

    private void drawTickMarks(RecordSet recordSet, GC gc, int x0, int y0, int width, int startTimeValue, int endTimeValue, double scaleFactor, int timeFormat, long deltaTime_ms, int ticklength, int miniticks, int gap) {
        boolean isAbsoluteTime = Settings.getInstance().isTimeFormatAbsolute() && !recordSet.isCompareSet() && !recordSet.isZoomMode();
        long startTimeStamp = recordSet.getStartTimeStamp();
        long offset = 0L;
        int timeDeltaValue = endTimeValue - startTimeValue;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("timeDelta = %s startTime = %s endTime = %s", timeDeltaValue, startTimeValue, endTimeValue));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("formatedDate = %s", StringHelper.getFormatedTime("YYYY-MM-dd HH:mm:ss.SSS", startTimeStamp)));
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startTimeStamp);
        int totalTime_msec = c.get(14);
        int totalTime_sec = c.get(13);
        int totalTime_min = c.get(12);
        int totalTime_std = c.get(11);
        int totalTime_days = c.get(5);
        int totalTime_month = c.get(2);
        if (timeDeltaValue > 0) {
            double xTickPosition;
            int intXTickPosition;
            Double numberTicks;
            Double timeDelta;
            switch (timeFormat) {
                case 1: 
                case 2: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, String.format("offsetDate = %s", StringHelper.getFormatedTime("YYYY-MM-dd HH:mm:ss.SSS", c.getTimeInMillis() - startTimeStamp)));
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 1000.0;
                    break;
                }
                case 4: 
                case 6: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0 && totalTime_sec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                            ++totalTime_sec;
                        }
                        if (totalTime_sec != 0) {
                            c.add(13, 60 - totalTime_sec);
                            ++totalTime_min;
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, String.format("offsetDate = %s", StringHelper.getFormatedTime("YYYY-MM-dd HH:mm:ss.SSS", c.getTimeInMillis() - startTimeStamp)));
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 60000.0;
                    break;
                }
                case 8: 
                case 12: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0 && totalTime_sec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                            ++totalTime_sec;
                        }
                        if (totalTime_sec != 0 && totalTime_min != 0) {
                            c.add(13, 60 - totalTime_sec);
                            ++totalTime_min;
                        }
                        if (totalTime_min != 0) {
                            c.add(12, 60 - totalTime_min);
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, String.format("offsetDate = %s", StringHelper.getFormatedTime("YYYY-MM-dd HH:mm:ss.SSS", c.getTimeInMillis())));
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 3600000.0;
                    break;
                }
                case 14: 
                case 16: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0 && totalTime_sec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                            ++totalTime_sec;
                        }
                        if (totalTime_sec != 0 && totalTime_min != 0) {
                            c.add(13, 60 - totalTime_sec);
                            ++totalTime_min;
                        }
                        if (totalTime_min != 0 && totalTime_std != 0) {
                            c.add(12, 60 - totalTime_min);
                            ++totalTime_std;
                        }
                        if (totalTime_std != 0) {
                            c.add(11, 24 - totalTime_std);
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 3600000.0 / 24.0;
                    break;
                }
                case 18: 
                case 20: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0 && totalTime_sec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                            ++totalTime_sec;
                        }
                        if (totalTime_sec != 0 && totalTime_min != 0) {
                            c.add(13, 60 - totalTime_sec);
                            ++totalTime_min;
                        }
                        if (totalTime_min != 0 && totalTime_std != 0) {
                            c.add(12, 60 - totalTime_min);
                            ++totalTime_std;
                        }
                        if (totalTime_std != 0) {
                            c.add(11, 24 - totalTime_std);
                            ++totalTime_days;
                        }
                        if (totalTime_days != 0) {
                            c.add(5, 30 - totalTime_days);
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 3600000.0 / 24.0 / 30.0;
                    break;
                }
                case 22: {
                    if (isAbsoluteTime) {
                        if (totalTime_msec != 0) {
                            c.add(14, 1000 - totalTime_msec);
                            ++totalTime_sec;
                        }
                        if (totalTime_sec != 0) {
                            c.add(13, 60 - totalTime_sec);
                            ++totalTime_min;
                        }
                        if (totalTime_min != 0) {
                            c.add(12, 60 - totalTime_min);
                            ++totalTime_std;
                        }
                        if (totalTime_std != 0) {
                            c.add(11, 24 - totalTime_std);
                            ++totalTime_days;
                        }
                        if (totalTime_days != 0) {
                            c.add(5, 30 - totalTime_days);
                            ++totalTime_month;
                        }
                        if (totalTime_month != 0) {
                            c.add(2, 12 - totalTime_month);
                        }
                        offset = c.getTimeInMillis() - startTimeStamp;
                    }
                    timeDelta = (double)deltaTime_ms / 3600000.0 / 24.0 / 30.0 / 365.0;
                    break;
                }
                default: {
                    timeDelta = (double)deltaTime_ms * 1.0;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "width/timeDeltaValue = " + width / timeDeltaValue);
            }
            switch (timeFormat * (int)scaleFactor) {
                case 0: {
                    if (timeDeltaValue <= width * 2) {
                        numberTicks = timeDelta / 100.0;
                        scaleFactor = 1.0;
                        break;
                    }
                    numberTicks = timeDelta / 200.0;
                    scaleFactor = 0.5;
                    break;
                }
                case 100: {
                    if (timeDeltaValue <= width * 10) {
                        numberTicks = timeDelta / 1000.0;
                        scaleFactor = 100.0;
                        break;
                    }
                    numberTicks = timeDelta / 500.0;
                    scaleFactor = 200.0;
                    break;
                }
                case 1000: {
                    if (timeDeltaValue <= width * 10) {
                        numberTicks = timeDelta / 0.5;
                        scaleFactor = 200.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 2.0 : timeDelta / 1.0;
                    scaleFactor = 100.0;
                    break;
                }
                default: {
                    if (timeDeltaValue > 0 && timeDeltaValue <= width / 100) {
                        numberTicks = isAbsoluteTime ? timeDelta : timeDelta * 2.0;
                        scaleFactor *= 20.0;
                        break;
                    }
                    if (timeDeltaValue > width / 100 && timeDeltaValue <= width / 70) {
                        numberTicks = isAbsoluteTime ? timeDelta / 2.0 : timeDelta;
                        scaleFactor *= 10.0;
                        break;
                    }
                    if (timeDeltaValue > width / 70 && timeDeltaValue <= width / 25) {
                        numberTicks = isAbsoluteTime ? timeDelta / 3.0 : timeDelta / 2.5;
                        scaleFactor *= 4.0;
                        break;
                    }
                    if (timeDeltaValue > width / 25 && timeDeltaValue < width / 10) {
                        numberTicks = isAbsoluteTime ? timeDelta / 6.0 : timeDelta / 5.0;
                        scaleFactor *= 2.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 12.0 : timeDelta / 10.0;
                    break;
                }
                case 20: 
                case 60: {
                    if (timeDeltaValue >= 0 && timeDeltaValue <= 30) {
                        numberTicks = isAbsoluteTime ? timeDelta / 3.0 : timeDelta / 1.0;
                        scaleFactor *= 4.0;
                        break;
                    }
                    if (timeDeltaValue > width / 50 && timeDeltaValue <= width / 25) {
                        numberTicks = isAbsoluteTime ? timeDelta / 6.0 : timeDelta / 2.5;
                        scaleFactor *= 4.0;
                        break;
                    }
                    if (timeDeltaValue > width / 25 && timeDeltaValue <= width / 8) {
                        numberTicks = isAbsoluteTime ? timeDelta / 12.0 : timeDelta / 5.0;
                        scaleFactor *= 2.0;
                        break;
                    }
                    if (timeDeltaValue >= width / 8 && timeDeltaValue <= width / 4) {
                        numberTicks = isAbsoluteTime ? timeDelta / 25.0 : timeDelta / 10.0;
                        scaleFactor *= 1.0;
                        break;
                    }
                    if (timeDeltaValue >= width / 4 && timeDeltaValue <= width / 2) {
                        numberTicks = isAbsoluteTime ? timeDelta / 50.0 : timeDelta / 20.0;
                        scaleFactor /= 2.0;
                        break;
                    }
                    if (timeDeltaValue >= width / 2 && timeDeltaValue <= width) {
                        numberTicks = isAbsoluteTime ? timeDelta / 100.0 : timeDelta / 40.0;
                        scaleFactor /= 4.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 150.0 : timeDelta / 80.0;
                    scaleFactor /= 8.0;
                    break;
                }
                case 120: {
                    if (timeDeltaValue >= 0 && timeDeltaValue <= 30) {
                        numberTicks = isAbsoluteTime ? timeDelta / 5.0 : timeDelta / 2.5;
                        scaleFactor *= 4.0;
                        break;
                    }
                    if (timeDeltaValue > width / 25 && timeDeltaValue <= width / 7) {
                        numberTicks = isAbsoluteTime ? timeDelta / 7.0 : timeDelta / 5.0;
                        scaleFactor *= 2.0;
                        break;
                    }
                    if (timeDeltaValue >= width / 7 && (double)timeDeltaValue <= (double)width / 1.5) {
                        numberTicks = isAbsoluteTime ? timeDelta / 14.0 : timeDelta / 10.0;
                        scaleFactor *= 1.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 30.0 : timeDelta / 20.0;
                    scaleFactor /= 2.0;
                    break;
                }
                case 160: {
                    if (width / timeDeltaValue >= 20) {
                        numberTicks = isAbsoluteTime ? timeDelta / 3.0 : timeDelta / 2.0;
                        scaleFactor *= 5.0;
                        break;
                    }
                    if (width / timeDeltaValue >= 7) {
                        numberTicks = isAbsoluteTime ? timeDelta / 6.0 : timeDelta / 5.0;
                        scaleFactor *= 2.0;
                        break;
                    }
                    if (width / timeDeltaValue >= 3) {
                        numberTicks = isAbsoluteTime ? timeDelta / 12.0 : timeDelta / 10.0;
                        scaleFactor *= 1.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 60.0 : timeDelta / 30.0;
                    scaleFactor /= 3.0;
                    break;
                }
                case 200: {
                    if (timeDeltaValue >= width / 6) {
                        numberTicks = isAbsoluteTime ? timeDelta / 6.0 : timeDelta / 4.0;
                        scaleFactor *= 2.5;
                        break;
                    }
                    if (timeDeltaValue >= width / 15) {
                        numberTicks = isAbsoluteTime ? timeDelta / 3.0 : timeDelta / 2.0;
                        scaleFactor *= 5.0;
                        break;
                    }
                    if (timeDeltaValue > width / 60) {
                        numberTicks = isAbsoluteTime ? timeDelta / 2.0 : timeDelta;
                        scaleFactor *= 10.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta : timeDelta * 2.0;
                    scaleFactor *= 20.0;
                    break;
                }
                case 220: {
                    if (timeDeltaValue >= width / 6) {
                        numberTicks = isAbsoluteTime ? timeDelta / 4.0 : timeDelta * 3.75;
                        scaleFactor *= 1.25;
                        break;
                    }
                    if (timeDeltaValue >= width / 15) {
                        numberTicks = isAbsoluteTime ? timeDelta / 12.0 : timeDelta * 7.5;
                        scaleFactor *= 2.5;
                        break;
                    }
                    if (timeDeltaValue > width / 60) {
                        numberTicks = isAbsoluteTime ? timeDelta / 24.0 : timeDelta * 15.0;
                        scaleFactor *= 5.0;
                        break;
                    }
                    numberTicks = isAbsoluteTime ? timeDelta / 48.0 : timeDelta * 30.0;
                    scaleFactor *= 10.0;
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "timeFormat = " + timeFormat + " numberTicks = " + numberTicks + " startTimeValue = " + startTimeValue + " endTimeValue = " + endTimeValue);
            }
            double deltaTick = (double)width / numberTicks;
            if (!isAbsoluteTime) {
                ++miniticks;
            }
            Point pt = gc.textExtent("00");
            Vector<Integer> timeGrid = new Vector<Integer>();
            boolean isBuildGridVector = recordSet.getTimeGridType() == 1;
            int i = 0;
            while ((isAbsoluteTime ? (double)i < numberTicks : (double)i <= numberTicks) && (intXTickPosition = (int)((xTickPosition = offset != 0L ? 1.0 * (double)width * (double)offset / (double)deltaTime_ms + (double)x0 + (double)i * deltaTick : (double)x0 + (double)i * deltaTick) + 0.5)) <= x0 + width) {
                if (isBuildGridVector) {
                    timeGrid.add(intXTickPosition);
                }
                gc.drawLine(intXTickPosition, y0, intXTickPosition, y0 + ticklength);
                double deltaPosMini = deltaTick / (double)miniticks;
                for (int j = 1; j < miniticks && (double)i < numberTicks; ++j) {
                    double xMiniTickPos = xTickPosition + (double)j * deltaPosMini;
                    int intMiniTickPos = (int)xMiniTickPos;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "intXTickPosition=" + intXTickPosition + ", width=" + width);
                    }
                    if (intMiniTickPos >= x0 + width) continue;
                    gc.drawLine(intMiniTickPos, y0, intMiniTickPos, y0 + ticklength / 2);
                }
                if (isAbsoluteTime) {
                    this.drawValues2Scale(gc, x0, y0, width, timeFormat, deltaTime_ms, ticklength, gap, pt, timeGrid, startTimeStamp, i, xTickPosition, intXTickPosition);
                } else {
                    this.drawValues2Scale(recordSet, gc, y0, scaleFactor, timeFormat, ticklength, gap, pt, timeGrid, i, intXTickPosition);
                }
                ++i;
            }
            recordSet.setTimeGrid(timeGrid);
        }
    }

    private void drawValues2Scale(RecordSet recordSet, GC gc, int y0, double scaleFactor, int timeFormat, int ticklength, int gap, Point pt, Vector<Integer> timeGrid, int i, int intXTickPosition) {
        double timeValue = (double)i * 100.0 / scaleFactor;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "timeValue = " + timeValue);
        }
        switch (timeFormat) {
            case 2: 
            case 6: {
                String numberStr;
                double timeValue60;
                boolean isMod60 = timeValue % 60.0 == 0.0;
                double d = timeValue60 = isMod60 ? timeValue / 60.0 : timeValue % 60.0;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "timeValue = " + timeValue + ", timeValue60 = " + timeValue60);
                }
                String string = numberStr = timeValue60 % 1.0 == 0.0 || isMod60 ? String.format("%.0f", timeValue60) : String.format("%.1f", timeValue60);
                if (isMod60 && timeValue > 0.0) {
                    gc.setFont(SWTResourceManager.getFont(gc, 1));
                    if (i != 0 && recordSet.getTimeGridType() == 2) {
                        timeGrid.add(intXTickPosition);
                    }
                    GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                    gc.setFont(SWTResourceManager.getFont(gc, 0));
                    break;
                }
                GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 20: {
                String numberStr;
                double timeValue12;
                boolean isMod12 = timeValue % 12.0 == 0.0;
                double d = timeValue12 = isMod12 ? timeValue / 12.0 : timeValue % 12.0;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "timeValue = " + timeValue + ", timeValue12 = " + timeValue12);
                }
                String string = numberStr = timeValue12 % 1.0 == 0.0 || isMod12 ? String.format("%.0f", timeValue12) : String.format("%.1f", timeValue12);
                if (isMod12 && timeValue > 0.0) {
                    gc.setFont(SWTResourceManager.getFont(gc, 1));
                    if (i != 0 && recordSet.getTimeGridType() == 2) {
                        timeGrid.add(intXTickPosition);
                    }
                    GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                    gc.setFont(SWTResourceManager.getFont(gc, 0));
                    break;
                }
                GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 16: {
                String numberStr;
                double timeValue30;
                boolean isMod30 = timeValue % 30.0 == 0.0;
                double d = timeValue30 = isMod30 ? timeValue / 30.0 : timeValue % 30.0;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "timeValue = " + timeValue + ", timeValue30 = " + timeValue30);
                }
                String string = numberStr = timeValue30 % 1.0 == 0.0 || isMod30 ? String.format("%.0f", timeValue30) : String.format("%.1f", timeValue30);
                if (isMod30 && timeValue > 0.0) {
                    gc.setFont(SWTResourceManager.getFont(gc, 1));
                    if (i != 0 && recordSet.getTimeGridType() == 2) {
                        timeGrid.add(intXTickPosition);
                    }
                    GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                    gc.setFont(SWTResourceManager.getFont(gc, 0));
                    break;
                }
                GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 12: {
                String numberStr;
                double timeValue24;
                boolean isMod24 = timeValue % 24.0 == 0.0;
                double d = timeValue24 = isMod24 ? timeValue / 24.0 : timeValue % 24.0;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "timeValue = " + timeValue + ", timeValue24 = " + timeValue24);
                }
                String string = numberStr = timeValue24 % 1.0 == 0.0 || isMod24 ? String.format("%.0f", timeValue24) : String.format("%.1f", timeValue24);
                if (isMod24 && timeValue > 0.0) {
                    gc.setFont(SWTResourceManager.getFont(gc, 1));
                    if (i != 0 && recordSet.getTimeGridType() == 2) {
                        timeGrid.add(intXTickPosition);
                    }
                    GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                    gc.setFont(SWTResourceManager.getFont(gc, 0));
                    break;
                }
                GraphicsUtils.drawTextCentered(numberStr, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            default: {
                GraphicsUtils.drawTextCentered("" + timeValue, intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
            }
        }
    }

    private void drawValues2Scale(GC gc, int x0, int y0, int width, int timeFormat, long deltaTime_ms, int ticklength, int gap, Point pt, Vector<Integer> timeGrid, long startTimeStamp, int i, double xTickPosition, int intXTickPosition) {
        Double timeValue = (double)deltaTime_ms * (xTickPosition - (double)x0) / (double)width + (double)startTimeStamp;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("formatedDate = %s ", StringHelper.getFormatedTime("YYYY-MM-dd HH:mm:ss.SSS", timeValue.longValue())));
        }
        switch (timeFormat) {
            case 0: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.ssSSS, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 1: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.mmssSSS, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            default: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.HHmmss, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 8: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.dd_HHmm, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 14: 
            case 16: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.MMdd_HH, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
                break;
            }
            case 18: 
            case 20: {
                GraphicsUtils.drawTextCentered(LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyMMdd, timeValue.longValue()), intXTickPosition, y0 + ticklength + gap + pt.y / 2, gc, 256);
            }
        }
    }

    public static int convertTimeInFormatNumber(double time_ms, int timeFormat) {
        int result;
        int time_sec = (int)(time_ms / 1000.0);
        int time_min = (int)TimeUnit.MINUTES.convert(time_sec, TimeUnit.SECONDS);
        int time_std = (int)TimeUnit.HOURS.convert(time_sec, TimeUnit.SECONDS);
        int time_days = (int)TimeUnit.DAYS.convert(time_sec, TimeUnit.SECONDS);
        int time_month = (int)TimeUnit.DAYS.convert(time_sec, TimeUnit.SECONDS) / 30;
        int time_year = (int)TimeUnit.DAYS.convert(time_sec, TimeUnit.SECONDS) / 365;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "time_std = " + time_std + "; time_min = " + time_min + "; time_sec = " + time_sec + "; time_ms = " + time_ms);
        }
        switch (timeFormat) {
            case 22: {
                result = time_year;
                break;
            }
            case 18: 
            case 20: {
                result = time_month;
                break;
            }
            case 14: 
            case 16: {
                result = time_days;
                break;
            }
            case 8: 
            case 12: {
                result = time_std;
                break;
            }
            case 4: 
            case 6: {
                result = time_min;
                break;
            }
            case 1: 
            case 2: {
                result = time_sec;
                break;
            }
            default: {
                result = (int)time_ms;
            }
        }
        return result;
    }

    public static String getFomatedTimeWithUnit(double milliSeconds) {
        String time = "0";
        if (milliSeconds >= 0.0) {
            long lSeconds = (long)(milliSeconds / 1000.0);
            long lMinutes = lSeconds / 60L;
            lSeconds %= 60L;
            long lHours = lMinutes / 60L;
            time = (lMinutes %= 60L) == 0L && lHours == 0L ? String.format("%s [ss:SSS]", LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.ssSSS, (long)milliSeconds)) : (lHours == 0L ? String.format("%s [mm:ss:SSS]", LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.mmssSSS, (long)milliSeconds)) : String.format("%s [HH:mm:ss:SSS]", LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.HHmmssSSS, (long)milliSeconds)));
        }
        return time;
    }

    public static String getFomatedTime(double milliSeconds) {
        String time = "0";
        if (milliSeconds >= 0.0) {
            long lSeconds = (long)(milliSeconds / 1000.0);
            long lMinutes = lSeconds / 60L;
            lSeconds %= 60L;
            long lHours = lMinutes / 60L;
            if ((lMinutes %= 60L) == 0L && lHours == 0L) {
                time = LocalizedDateTime.getFormatedDuration(LocalizedDateTime.DurationPattern.ss_SSS, (long)milliSeconds);
            } else if (lHours == 0L) {
                time = LocalizedDateTime.getFormatedDuration(LocalizedDateTime.DurationPattern.mm_ss_SSS, (long)milliSeconds);
            } else {
                time = LocalizedDateTime.getFormatedDuration(LocalizedDateTime.DurationPattern.HH_mm_ss_SSS, (long)milliSeconds);
                if ((long)Integer.parseInt(time.substring(0, time.indexOf(58))) != lHours) {
                    time = String.format("%02d%s", lHours, time.substring(time.indexOf(58)));
                }
            }
        }
        return time;
    }
}

