/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;

public class Covariance {
    private final RealMatrix covarianceMatrix;
    private final int n;

    public Covariance() {
        this.covarianceMatrix = null;
        this.n = 0;
    }

    public Covariance(double[][] data2, boolean biasCorrected) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        this(new BlockRealMatrix(data2), biasCorrected);
    }

    public Covariance(double[][] data2) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        this(data2, true);
    }

    public Covariance(RealMatrix matrix, boolean biasCorrected) throws MathIllegalArgumentException {
        this.checkSufficientData(matrix);
        this.n = matrix.getRowDimension();
        this.covarianceMatrix = this.computeCovarianceMatrix(matrix, biasCorrected);
    }

    public Covariance(RealMatrix matrix) throws MathIllegalArgumentException {
        this(matrix, true);
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int getN() {
        return this.n;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix, boolean biasCorrected) throws MathIllegalArgumentException {
        int dimension = matrix.getColumnDimension();
        Variance variance = new Variance(biasCorrected);
        BlockRealMatrix outMatrix = new BlockRealMatrix(dimension, dimension);
        for (int i2 = 0; i2 < dimension; ++i2) {
            for (int j2 = 0; j2 < i2; ++j2) {
                double cov = this.covariance(matrix.getColumn(i2), matrix.getColumn(j2), biasCorrected);
                outMatrix.setEntry(i2, j2, cov);
                outMatrix.setEntry(j2, i2, cov);
            }
            outMatrix.setEntry(i2, i2, variance.evaluate(matrix.getColumn(i2)));
        }
        return outMatrix;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix) throws MathIllegalArgumentException {
        return this.computeCovarianceMatrix(matrix, true);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data2, boolean biasCorrected) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        return this.computeCovarianceMatrix(new BlockRealMatrix(data2), biasCorrected);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data2) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        return this.computeCovarianceMatrix(data2, true);
    }

    public double covariance(double[] xArray, double[] yArray, boolean biasCorrected) throws MathIllegalArgumentException {
        Mean mean = new Mean();
        double result2 = 0.0;
        int length = xArray.length;
        if (length != yArray.length) {
            throw new MathIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, length, yArray.length);
        }
        if (length < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, length, 2);
        }
        double xMean = mean.evaluate(xArray);
        double yMean = mean.evaluate(yArray);
        for (int i2 = 0; i2 < length; ++i2) {
            double xDev = xArray[i2] - xMean;
            double yDev = yArray[i2] - yMean;
            result2 += (xDev * yDev - result2) / (double)(i2 + 1);
        }
        return biasCorrected ? result2 * ((double)length / (double)(length - 1)) : result2;
    }

    public double covariance(double[] xArray, double[] yArray) throws MathIllegalArgumentException {
        return this.covariance(xArray, yArray, true);
    }

    private void checkSufficientData(RealMatrix matrix) throws MathIllegalArgumentException {
        int nRows = matrix.getRowDimension();
        int nCols = matrix.getColumnDimension();
        if (nRows < 2 || nCols < 1) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, nRows, nCols);
        }
    }
}

