/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    static ImageTransfer _instance = new ImageTransfer();
    static final String TIFF = OS.NSTIFFPboardType.getString();
    static final int TIFFID = ImageTransfer.registerType(TIFF);

    ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        ImageData imageData = (ImageData)object;
        Image image = new Image((Device)Display.getCurrent(), imageData);
        NSImage nSImage = image.handle;
        transferData.data = nSImage.TIFFRepresentation();
        image.dispose();
    }

    public Object nativeToJava(TransferData transferData) {
        Object object;
        Object object2;
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSData nSData = (NSData)transferData.data;
        if (nSData.length() == 0) {
            return null;
        }
        Object object3 = (NSImage)new NSImage().alloc();
        ((NSImage)object3).initWithData(nSData);
        NSSize nSSize = ((NSImage)object3).size();
        NSImageRep nSImageRep = ((NSImage)object3).bestRepresentationForDevice(null);
        if (nSSize.width != (float)nSImageRep.pixelsWide() || nSSize.height != (float)nSImageRep.pixelsHigh()) {
            nSSize.width /= (float)nSImageRep.pixelsWide() / nSSize.width;
            nSSize.height /= (float)nSImageRep.pixelsHigh() / nSSize.height;
            object2 = ((NSImage)new NSImage().alloc()).initWithSize(nSSize);
            ((NSImage)object2).lockFocus();
            object = new NSRect();
            ((NSRect)object).width = nSSize.width;
            ((NSRect)object).height = nSSize.height;
            ((NSImage)object3).drawInRect((NSRect)object, new NSRect(), 1, 1.0f);
            ((NSImage)object2).unlockFocus();
            ((NSObject)object3).release();
            object3 = object2;
        }
        object2 = Image.cocoa_new(Display.getCurrent(), 0, (NSImage)object3);
        object = ((Image)object2).getImageData();
        ((Resource)object2).dispose();
        return object;
    }

    protected int[] getTypeIds() {
        return new int[]{TIFFID};
    }

    protected String[] getTypeNames() {
        return new String[]{TIFF};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

