/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class AirspeedBlock
extends DataBlock {
    private short airspeedKmPerHour;

    public AirspeedBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("AirSpeed");
        this.measurementUnits.add("km/h");
        this.measurementFactors.add(1.0);
    }

    public short getAirspeedInKmPerHour() {
        return this.airspeedKmPerHour;
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof AirspeedBlock) {
            AirspeedBlock air = (AirspeedBlock)block;
            return air.airspeedKmPerHour == this.airspeedKmPerHour;
        }
        return false;
    }

    private void decode(byte[] rawData) {
        this.airspeedKmPerHour = Shorts.fromBytes(rawData[6], rawData[7]);
        this.measurementValues.add(Integer.valueOf(this.getAirspeedInKmPerHour()));
    }
}

