/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javafx.util.StringConverter;

public class NumberStringConverter
extends StringConverter<Number> {
    final Locale locale;
    final String pattern;
    final NumberFormat numberFormat;

    public NumberStringConverter() {
        this(Locale.getDefault());
    }

    public NumberStringConverter(Locale locale) {
        this(locale, null);
    }

    public NumberStringConverter(String string2) {
        this(Locale.getDefault(), string2);
    }

    public NumberStringConverter(Locale locale, String string2) {
        this(locale, string2, null);
    }

    public NumberStringConverter(NumberFormat numberFormat) {
        this(null, null, numberFormat);
    }

    NumberStringConverter(Locale locale, String string2, NumberFormat numberFormat) {
        this.locale = locale;
        this.pattern = string2;
        this.numberFormat = numberFormat;
    }

    @Override
    public Number fromString(String string2) {
        try {
            if (string2 == null) {
                return null;
            }
            if ((string2 = string2.trim()).length() < 1) {
                return null;
            }
            NumberFormat numberFormat = this.getNumberFormat();
            return numberFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public String toString(Number number) {
        if (number == null) {
            return "";
        }
        NumberFormat numberFormat = this.getNumberFormat();
        return numberFormat.format(number);
    }

    protected NumberFormat getNumberFormat() {
        Locale locale;
        Locale locale2 = locale = this.locale == null ? Locale.getDefault() : this.locale;
        if (this.numberFormat != null) {
            return this.numberFormat;
        }
        if (this.pattern != null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(this.pattern, decimalFormatSymbols);
        }
        return NumberFormat.getNumberInstance(locale);
    }
}

