/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import com.sun.istack.Nullable;
import gde.data.Record;
import gde.device.IChannelItem;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.NotSupportedFileFormatException;
import gde.histo.cache.ExtendedVault;
import gde.histo.datasources.SourceFolders;
import gde.histo.datasources.VaultPicker;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.log.Level;
import gde.log.Logger;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public final class HistoSet {
    private static final String $CLASS_NAME = HistoSet.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final double TOLERANCE = 1.0E-9;
    private VaultPicker vaultPicker;
    public static final double OUTLIER_SIGMA_DEFAULT = 3.0;
    public static final double OUTLIER_RANGE_FACTOR_DEFAULT = 2.0;
    public static final double SUMMARY_OUTLIER_SIGMA = 1.36;
    public static final double SUMMARY_OUTLIER_RANGE_FACTOR = 9.0;
    private RebuildStep rebuildStepInvisibleTab = RebuildStep.E_USER_INTERFACE;

    public static double decodeVaultValue(IChannelItem channelItem, double value) {
        return switch (channelItem.getUnifiedDataType()) {
            case Record.DataType.GPS_LATITUDE, Record.DataType.GPS_LONGITUDE -> value / 1000.0;
            default -> {
                double factor = channelItem.getFactor();
                double offset = channelItem.getOffset();
                double reduction = channelItem.getReduction();
                yield (value - reduction) * factor + offset;
            }
        };
    }

    public static double decodeDeltaValue(IChannelItem channelItem, double value) {
        double newValue = 0.0;
        switch (channelItem.getUnifiedDataType()) {
            case GPS_LATITUDE: 
            case GPS_LONGITUDE: {
                newValue = value / 1000.0;
                break;
            }
            default: {
                newValue = value * channelItem.getFactor();
            }
        }
        return newValue;
    }

    public static double encodeVaultValue(IChannelItem channelItem, double value) {
        return switch (channelItem.getUnifiedDataType()) {
            case Record.DataType.GPS_LATITUDE, Record.DataType.GPS_LONGITUDE -> value * 1000.0;
            default -> {
                double factor = channelItem.getFactor();
                double offset = channelItem.getOffset();
                double reduction = channelItem.getReduction();
                yield (value - offset) / factor + reduction;
            }
        };
    }

    @Deprecated
    public static double decodeVaultValue(TrailRecord record, double value) {
        double newValue = switch (record.getDataType()) {
            case Record.DataType.GPS_LATITUDE, Record.DataType.GPS_LONGITUDE -> value / 1000.0;
            default -> {
                double factor = record.getFactor();
                double offset = record.getOffset();
                double reduction = record.getReduction();
                yield (value - reduction) * factor + offset;
            }
        };
        log.fine(() -> "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Deprecated
    public static double decodeDeltaValue(TrailRecord record, double value) {
        double newValue = 0.0;
        switch (record.getDataType()) {
            case GPS_LATITUDE: 
            case GPS_LONGITUDE: {
                newValue = value / 1000.0;
                break;
            }
            default: {
                newValue = value * record.getFactor();
            }
        }
        return newValue;
    }

    public static double encodeVaultValue(TrailRecord record, double value) {
        double newValue;
        if (HistoSet.isGpsCoordinates(record)) {
            newValue = value * 1000.0;
        } else {
            double factor = record.getFactor();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            newValue = (value - offset) / factor + reduction;
        }
        log.fine(() -> "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public static boolean isGpsCoordinates(TrailRecord record) {
        return record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE;
    }

    public static boolean fuzzyEquals(double a, double b) {
        return Math.copySign(a - b, 1.0) <= 1.0E-9 || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static int fuzzyCompare(double a, double b) {
        if (HistoSet.fuzzyEquals(a, b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Boolean.compare(Double.isNaN(a), Double.isNaN(b));
    }

    public HistoSet() {
        this.initialize();
    }

    public void initialize() {
        this.vaultPicker = new VaultPicker();
        this.vaultPicker.initialize();
    }

    public boolean rebuild4Screening(RebuildStep rebuildStep) throws FileNotFoundException, IOException, NotSupportedFileFormatException, DataInconsitsentException, DataTypeException {
        return this.vaultPicker.rebuild4Screening(rebuildStep);
    }

    @Nullable
    public TrailRecordSet getTrailRecordSet() {
        return this.vaultPicker.getTrailRecordSet();
    }

    public void setRebuildStepInvisibleTabs(RebuildStep rebuildStep, boolean isRebuilt) {
        RebuildStep performedRebuildStep = isRebuilt ? RebuildStep.B_HISTOVAULTS : rebuildStep;
        RebuildStep maximumRebuildStep = this.getRebuildStepInvisibleTab().scopeOfWork > performedRebuildStep.scopeOfWork ? this.getRebuildStepInvisibleTab() : performedRebuildStep;
        RebuildStep rebuildStep2 = this.rebuildStepInvisibleTab = maximumRebuildStep.scopeOfWork > this.getRebuildStepInvisibleTab().scopeOfWork ? RebuildStep.E_USER_INTERFACE : RebuildStep.F_FILE_CHECK;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("rebuildStep=%s  performedRebuildStep=%s  maximumRebuildStep=%s  rebuildStepInvisibleTab=%s", new Object[]{rebuildStep, performedRebuildStep, maximumRebuildStep, this.getRebuildStepInvisibleTab()}));
        }
    }

    public RebuildStep getRebuildStepInvisibleTab() {
        return this.rebuildStepInvisibleTab;
    }

    public SourceFolders getSourceFolders() {
        return this.vaultPicker.getSourceFolders();
    }

    public List<Path> getExcludedPaths() {
        List<Path> result = this.vaultPicker.getExcludedFiles();
        for (ExtendedVault vault : this.vaultPicker.getSuppressedTrusses()) {
            result.add(vault.getLoadFileAsPath());
        }
        return result;
    }

    public String getDirectoryScanStatistics() {
        return Messages.getString("GDE_MSGI0064", new Object[]{String.format("%,d", this.vaultPicker.getDirectoryFilesCount()), String.format("%,d", this.vaultPicker.getMatchingFilesCount()), String.format("%.2f", (double)(this.vaultPicker.getRecordSetBytesSum() / 1024L) / 1024.0), String.format("%.2f", (double)this.vaultPicker.getElapsedTime_ms() / 1000.0), String.format("%,d", this.vaultPicker.getTrussesCount() + this.vaultPicker.getSuppressedTrusses().size()), String.format("%,d", this.vaultPicker.getTimeStepSize())});
    }

    public static enum RebuildStep {
        A_HISTOSET(6),
        B_HISTOVAULTS(5),
        C_TRAILRECORDSET(4),
        D_TRAIL_DATA(3),
        E_USER_INTERFACE(2),
        F_FILE_CHECK(1),
        G_SELECTOR_COMBO(0);

        public final int scopeOfWork;
        public static RebuildStep[] VALUES;

        private RebuildStep(int scopeOfWork) {
            this.scopeOfWork = scopeOfWork;
        }

        public boolean isEqualOrBiggerThan(RebuildStep comparisonStep) {
            return this.scopeOfWork >= comparisonStep.scopeOfWork;
        }

        static {
            VALUES = RebuildStep.values();
        }
    }
}

