/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.DefaultFormSubmissionListener;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldFactory;
import org.xhtmlrenderer.util.XRLog;

public class XhtmlForm {
    private static final String FS_DEFAULT_GROUP = "__fs_default_group_";
    private static int _defaultGroupCount = 1;
    private UserAgentCallback _userAgentCallback;
    private Map _componentCache;
    private Map _buttonGroups;
    private Element _parentFormElement;
    private FormSubmissionListener _formSubmissionListener;

    public XhtmlForm(UserAgentCallback uac, Element e2, FormSubmissionListener fsListener) {
        this._userAgentCallback = uac;
        this._buttonGroups = new HashMap();
        this._componentCache = new LinkedHashMap();
        this._parentFormElement = e2;
        this._formSubmissionListener = fsListener;
    }

    public XhtmlForm(UserAgentCallback uac, Element e2) {
        this(uac, e2, new DefaultFormSubmissionListener());
    }

    public UserAgentCallback getUserAgentCallback() {
        return this._userAgentCallback;
    }

    public void addButtonToGroup(String groupName, AbstractButton button2) {
        ButtonGroupWrapper group2;
        if (groupName == null) {
            groupName = XhtmlForm.createNewDefaultGroupName();
        }
        if ((group2 = (ButtonGroupWrapper)this._buttonGroups.get(groupName)) == null) {
            group2 = new ButtonGroupWrapper();
            this._buttonGroups.put(groupName, group2);
        }
        group2.add(button2);
    }

    private static String createNewDefaultGroupName() {
        return FS_DEFAULT_GROUP + ++_defaultGroupCount;
    }

    private static boolean isFormField(Element e2) {
        String nodeName = e2.getNodeName();
        return nodeName.equals("input") || nodeName.equals("select") || nodeName.equals("textarea");
    }

    public FormField addComponent(Element e2, LayoutContext context, BlockBox box) {
        FormField field2 = null;
        if (this._componentCache.containsKey(e2)) {
            field2 = (FormField)this._componentCache.get(e2);
        } else {
            if (!XhtmlForm.isFormField(e2)) {
                return null;
            }
            field2 = FormFieldFactory.create(this, context, box);
            if (field2 == null) {
                XRLog.layout("Unknown field type: " + e2.getNodeName());
                return null;
            }
            this._componentCache.put(e2, field2);
        }
        return field2;
    }

    public void reset() {
        Iterator buttonGroups = this._buttonGroups.values().iterator();
        while (buttonGroups.hasNext()) {
            ((ButtonGroupWrapper)buttonGroups.next()).clearSelection();
        }
        Iterator fields2 = this._componentCache.values().iterator();
        while (fields2.hasNext()) {
            ((FormField)fields2.next()).reset();
        }
    }

    public void submit(JComponent source) {
        if (this._parentFormElement == null) {
            return;
        }
        StringBuffer data2 = new StringBuffer();
        String action2 = this._parentFormElement.getAttribute("action");
        data2.append(action2).append("?");
        Iterator fields2 = this._componentCache.entrySet().iterator();
        boolean first = true;
        while (fields2.hasNext()) {
            Map.Entry entry = fields2.next();
            FormField field2 = (FormField)entry.getValue();
            if (!field2.includeInSubmission(source)) continue;
            String[] dataStrings = field2.getFormDataStrings();
            for (int i2 = 0; i2 < dataStrings.length; ++i2) {
                if (!first) {
                    data2.append('&');
                }
                data2.append(dataStrings[i2]);
                first = false;
            }
        }
        if (this._formSubmissionListener != null) {
            this._formSubmissionListener.submit(data2.toString());
        }
    }

    public static String collectText(Element e2) {
        StringBuffer result2 = new StringBuffer();
        Node node = e2.getFirstChild();
        if (node != null) {
            do {
                short nodeType;
                if ((nodeType = node.getNodeType()) != 3 && nodeType != 4) continue;
                Text text2 = (Text)node;
                result2.append(text2.getData());
            } while ((node = node.getNextSibling()) != null);
        }
        return result2.toString().trim();
    }

    private static class ButtonGroupWrapper {
        private ButtonGroup _group = new ButtonGroup();
        private AbstractButton _dummy = new JRadioButton();

        public ButtonGroupWrapper() {
            this._group.add(this._dummy);
        }

        public void add(AbstractButton b2) {
            this._group.add(b2);
        }

        public void clearSelection() {
            this._group.setSelected(this._dummy.getModel(), true);
        }
    }
}

