/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.Util;

public class SelectFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Select";
    private static final int EMPTY_SPACE_COUNT = 10;
    private static final int EXTRA_SPACE_COUNT = 4;
    private List _options;
    private int _baseline;

    public SelectFormField(LayoutContext c2, BlockBox box, int cssWidth, int cssHeight) {
        this._options = this.readOptions(box.getElement());
        this.initDimensions(c2, box, cssWidth, cssHeight);
        float fontSize = box.getStyle().getFSFont(c2).getSize2D();
        this._baseline = (int)((float)(this.getHeight() / 2) + fontSize * 0.3f);
    }

    private int getSelectedIndex() {
        int result2 = 0;
        List options = this._options;
        int offset = 0;
        for (Option option : options) {
            if (option.isSelected()) {
                result2 = offset;
            }
            ++offset;
        }
        return result2;
    }

    private String[][] getPDFOptions() {
        List options = this._options;
        String[][] result2 = new String[options.size()][];
        int offset = 0;
        for (Option option : options) {
            result2[offset] = new String[]{option.getValue(), option.getLabel()};
            ++offset;
        }
        return result2;
    }

    private int calcDefaultWidth(LayoutContext c2, BlockBox box) {
        List options = this._options;
        if (options.size() == 0) {
            return c2.getTextRenderer().getWidth(c2.getFontContext(), box.getStyle().getFSFont(c2), this.spaces(10));
        }
        int maxWidth = 0;
        for (Option option : options) {
            String result2 = option.getLabel() + this.spaces(4);
            int width = c2.getTextRenderer().getWidth(c2.getFontContext(), box.getStyle().getFSFont(c2), result2);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private List readOptions(Element e2) {
        ArrayList<Option> result2 = new ArrayList<Option>();
        for (Node n2 = e2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1 || !n2.getNodeName().equalsIgnoreCase("option")) continue;
            Element optionElem = (Element)n2;
            String label2 = this.collectText(optionElem);
            Attr valueAttr = optionElem.getAttributeNode("value");
            String value = valueAttr == null ? label2 : valueAttr.getValue();
            if (label2 == null) continue;
            Option option = new Option();
            option.setLabel(label2);
            option.setValue(value);
            if (this.isSelected(optionElem)) {
                option.setSelected(true);
            }
            result2.add(option);
        }
        return result2;
    }

    private String collectText(Element e2) {
        StringBuffer result2 = new StringBuffer();
        for (Node n2 = e2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            short nodeType = n2.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            Text t2 = (Text)n2;
            result2.append(t2.getData());
        }
        return result2.length() > 0 ? result2.toString() : null;
    }

    @Override
    protected void initDimensions(LayoutContext c2, BlockBox box, int cssWidth, int cssHeight) {
        if (cssWidth != -1) {
            this.setWidth(cssWidth);
        } else {
            this.setWidth(this.calcDefaultWidth(c2, box));
        }
        if (cssHeight != -1) {
            this.setHeight(cssHeight);
        } else {
            this.setHeight((int)(box.getStyle().getLineHeight(c2) * (float)this.getSize(box.getElement())));
        }
    }

    private int getSize(Element elem) {
        int result2 = 1;
        try {
            int i2;
            String v2 = elem.getAttribute("size").trim();
            if (v2.length() > 0 && (i2 = Integer.parseInt(v2)) > 1) {
                result2 = i2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result2;
    }

    protected boolean isMultiple(Element e2) {
        return !Util.isNullOrEmpty(e2.getAttribute("multiple"));
    }

    @Override
    protected String getFieldType() {
        return FIELD_TYPE;
    }

    @Override
    public void paint(RenderingContext c2, ITextOutputDevice outputDevice, BlockBox box) {
        PdfWriter writer = outputDevice.getWriter();
        String[][] options = this.getPDFOptions();
        int selectedIndex = this.getSelectedIndex();
        PdfFormField field2 = PdfFormField.createCombo(writer, false, options, selectedIndex);
        field2.setWidget(outputDevice.createLocalTargetArea(c2, box), PdfAnnotation.HIGHLIGHT_INVERT);
        field2.setFieldName(this.getFieldName(outputDevice, box.getElement()));
        if (options.length > 0) {
            field2.setValueAsString(options[selectedIndex][0]);
        }
        this.createAppearance(c2, outputDevice, box, field2);
        if (this.isReadOnly(box.getElement())) {
            field2.setFieldFlags(1);
        }
        writer.addAnnotation(field2);
    }

    private void createAppearance(RenderingContext c2, ITextOutputDevice outputDevice, BlockBox box, PdfFormField field2) {
        PdfWriter writer = outputDevice.getWriter();
        ITextFSFont font = (ITextFSFont)box.getStyle().getFSFont(c2);
        PdfContentByte cb = writer.getDirectContent();
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        float fontSize = outputDevice.getDeviceLength(font.getSize2D());
        PdfAppearance tp = cb.createAppearance(width, height);
        tp.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        FSColor color = box.getStyle().getColor();
        this.setFillColor(tp, color);
        field2.setDefaultAppearanceString(tp);
    }

    @Override
    public int getBaseline() {
        return this._baseline;
    }

    @Override
    public boolean hasBaseline() {
        return true;
    }

    private static final class Option {
        private String _value;
        private String _label;
        private boolean _selected;

        private Option() {
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getLabel() {
            return this._label;
        }

        public void setLabel(String label2) {
            this._label = label2;
        }

        public boolean isSelected() {
            return this._selected;
        }

        public void setSelected(boolean selected) {
            this._selected = selected;
        }
    }
}

