/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.CachedDataHandler;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.internet.SharedInputStream;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static boolean setDefaultTextCharset = true;
    private static boolean setContentTypeFileName = true;
    private static boolean encodeFileName = false;
    private static boolean decodeFileName = false;
    static boolean cacheMultipart = true;
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)((Object)inputStream);
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = ASCIIUtility.getBytes((InputStream)inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("Error reading input stream", iOException);
            }
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        this.headers = internetHeaders;
        this.content = byArray;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int n = this.contentStream.available();
                if (n > 0) {
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if (string == null) {
            string = "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType(this, string);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition(this, string);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription(this, string, string2);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName(this, string);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        Object object = this.getDataHandler().getContent();
        if (cacheMultipart && (object instanceof Multipart || object instanceof Message) && !(this.dh instanceof CachedDataHandler) && (this.content != null || this.contentStream != null)) {
            this.dh = MimeBodyPart.createCachedDataHandler(object, this.getContentType());
        }
        return object;
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText(this, string, string2, "plain");
    }

    public void setText(String string, String string2, String string3) throws MessagingException {
        MimeBodyPart.setText(this, string, string2, string3);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler(multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileDataSource fileDataSource = new FileDataSource(file);
        this.setDataHandler(new DataHandler(fileDataSource));
        this.setFileName(fileDataSource.getName());
    }

    public void attachFile(String string) throws IOException, MessagingException {
        File file = new File(string);
        this.attachFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        InputStream inputStream = this.getInputStream();
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public void saveFile(String string) throws IOException, MessagingException {
        File file = new File(string);
        this.saveFile(file);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        MimeBodyPart.writeTo(this, outputStream, null);
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders(this);
    }

    static boolean isMimeType(MimePart mimePart, String string) throws MessagingException {
        try {
            ContentType contentType = new ContentType(mimePart.getContentType());
            return contentType.match(string);
        }
        catch (ParseException parseException) {
            return mimePart.getContentType().equalsIgnoreCase(string);
        }
    }

    static void setText(MimePart mimePart, String string, String string2, String string3) throws MessagingException {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii(string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        mimePart.setContent(string, "text/" + string3 + "; charset=" + MimeUtility.quote(string2, "()<>@,;:\\\"\t []/?="));
    }

    static String getDisposition(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    static void setDisposition(MimePart mimePart, String string) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Disposition");
        } else {
            String string2 = mimePart.getHeader("Content-Disposition", null);
            if (string2 != null) {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                contentDisposition.setDisposition(string);
                string = contentDisposition.toString();
            }
            mimePart.setHeader("Content-Disposition", string);
        }
    }

    static String getDescription(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static void setDescription(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Description");
            return;
        }
        try {
            mimePart.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(string, string2, null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    static String getFileName(MimePart mimePart) throws MessagingException {
        Object object;
        String string = null;
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            object = new ContentDisposition(string2);
            string = ((ContentDisposition)object).getParameter("filename");
        }
        if (string == null && (string2 = mimePart.getHeader("Content-Type", null)) != null) {
            try {
                object = new ContentType(string2);
                string = ((ContentType)object).getParameter("name");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (decodeFileName && string != null) {
            try {
                string = MimeUtility.decodeText(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't decode filename", unsupportedEncodingException);
            }
        }
        return string;
    }

    static void setFileName(MimePart mimePart, String string) throws MessagingException {
        String string2;
        if (encodeFileName && string != null) {
            try {
                string = MimeUtility.encodeText(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't encode filename", unsupportedEncodingException);
            }
        }
        ContentDisposition contentDisposition = new ContentDisposition((string2 = mimePart.getHeader("Content-Disposition", null)) == null ? "attachment" : string2);
        contentDisposition.setParameter("filename", string);
        mimePart.setHeader("Content-Disposition", contentDisposition.toString());
        if (setContentTypeFileName && (string2 = mimePart.getHeader("Content-Type", null)) != null) {
            try {
                ContentType contentType = new ContentType(string2);
                contentType.setParameter("name", string);
                mimePart.setHeader("Content-Type", contentType.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    static String[] getContentLanguage(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = mimePart.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        Vector<String> vector = new Vector<String>();
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            vector.addElement(token.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void setContentLanguage(MimePart mimePart, String[] stringArray) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(',').append(stringArray[n]);
            ++n;
        }
        mimePart.setHeader("Content-Language", stringBuffer.toString());
    }

    static String getEncoding(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = mimePart.getHeader("Content-Transfer-Encoding", null);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("base64")) {
            return string;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            return token.getValue();
        }
        return string;
    }

    static void setEncoding(MimePart mimePart, String string) throws MessagingException {
        mimePart.setHeader("Content-Transfer-Encoding", string);
    }

    static DataHandler createCachedDataHandler(Object object, String string) {
        return new CachedDataHandler(object, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void updateHeaders(MimePart mimePart) throws MessagingException {
        DataHandler dataHandler = mimePart.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            String string;
            Object object;
            Object object2;
            String string2 = dataHandler.getContentType();
            boolean bl = false;
            boolean bl2 = mimePart.getHeader("Content-Type") == null;
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*")) {
                bl = true;
                object2 = dataHandler.getContent();
                if (!(object2 instanceof MimeMultipart)) throw new MessagingException("MIME part of type \"" + string2 + "\" contains object of type " + object2.getClass().getName() + " instead of MimeMultipart");
                ((MimeMultipart)object2).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl = true;
            }
            if (!bl) {
                if (mimePart.getHeader("Content-Transfer-Encoding") == null) {
                    MimeBodyPart.setEncoding(mimePart, MimeUtility.getEncoding(dataHandler));
                }
                if (bl2 && setDefaultTextCharset && contentType.match("text/*") && contentType.getParameter("charset") == null) {
                    object = mimePart.getEncoding();
                    object2 = object != null && ((String)object).equalsIgnoreCase("7bit") ? "us-ascii" : MimeUtility.getDefaultMIMECharset();
                    contentType.setParameter("charset", (String)object2);
                    string2 = contentType.toString();
                }
            }
            if (!bl2) return;
            object2 = mimePart.getHeader("Content-Disposition", null);
            if (object2 != null && (string = ((ContentDisposition)(object = new ContentDisposition((String)object2))).getParameter("filename")) != null) {
                contentType.setParameter("name", string);
                string2 = contentType.toString();
            }
            mimePart.setHeader("Content-Type", string2);
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", iOException);
        }
    }

    static void invalidateContentHeaders(MimePart mimePart) throws MessagingException {
        mimePart.removeHeader("Content-Type");
        mimePart.removeHeader("Content-Transfer-Encoding");
    }

    static void writeTo(MimePart mimePart, OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        LineOutputStream lineOutputStream = null;
        lineOutputStream = outputStream instanceof LineOutputStream ? (LineOutputStream)outputStream : new LineOutputStream(outputStream);
        Enumeration enumeration = mimePart.getNonMatchingHeaderLines(stringArray);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        outputStream = MimeUtility.encode(outputStream, mimePart.getEncoding());
        mimePart.getDataHandler().writeTo(outputStream);
        outputStream.flush();
    }

    static {
        try {
            String string = System.getProperty("mail.mime.setdefaulttextcharset");
            setDefaultTextCharset = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.setcontenttypefilename");
            setContentTypeFileName = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.encodefilename");
            encodeFileName = string != null && !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.decodefilename");
            decodeFileName = string != null && !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.cachemultipart");
            cacheMultipart = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

