/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.Analyzer;
import gde.device.IChannelItem;
import gde.device.ScoreGroupType;
import gde.device.ScoreLabelTypes;
import gde.device.ScoreType;
import gde.device.TrailTypes;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailSelector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class ScoregroupTrailSelector
extends TrailSelector {
    public ScoregroupTrailSelector(TrailRecord trailRecord) {
        super(trailRecord);
    }

    public ScoregroupTrailSelector(Analyzer analyzer, IChannelItem channelItem, String recordName, boolean smartStatistics) {
        super(analyzer, channelItem, recordName, smartStatistics);
    }

    @Override
    public void setMostApplicableTrailTextOrdinal() {
        this.setTrailTextSelectedIndex(0);
    }

    @Override
    protected void setApplicableTrails() {
        this.applicableTrailsOrdinals = new ArrayList();
        this.applicableTrailsTexts = new ArrayList();
        List<ScoreType> scoreTypes = ((ScoreGroupType)this.channelItem).getScore();
        for (int i = 0; i < scoreTypes.size(); ++i) {
            this.applicableTrailsOrdinals.add(scoreTypes.get(i).getTrailOrdinal());
            this.applicableTrailsTexts.add(this.getDeviceXmlReplacement(scoreTypes.get(i).getValue()));
        }
        log.finer(() -> this.recordName + " score ");
    }

    @Override
    protected void setExtremumIndices() {
        List<ScoreType> scoreTypes = ((ScoreGroupType)this.channelItem).getScore();
        int index4Min = -1;
        int index4Max = -1;
        for (int i = 0; i < this.applicableTrailsOrdinals.size(); ++i) {
            if (scoreTypes.get(i).getLabel().name().contains("MIN")) {
                index4Min = i;
            }
            if (!scoreTypes.get(i).getLabel().name().contains("MAX")) continue;
            index4Max = i;
        }
        this.extremumIndices = index4Min == -1 || index4Max == -1 ? new int[]{0, 0} : new int[]{index4Min, index4Max};
    }

    @Override
    public boolean isTrailSuite() {
        return false;
    }

    @Override
    public boolean isRangePlotSuite() {
        return false;
    }

    @Override
    public boolean isBoxPlotSuite() {
        return false;
    }

    @Override
    public boolean isOddRangeTrail() {
        List<ScoreType> scoreTypes = ((ScoreGroupType)this.channelItem).getScore();
        ScoreLabelTypes scoreLabelType = scoreTypes.get(this.trailTextSelectedIndex).getLabel();
        return EnumSet.of(ScoreLabelTypes.SENSORS, ScoreLabelTypes.SIGMA_TIME_STEP_MS, ScoreLabelTypes.LOST_PACKAGES_SIGMA_MS).contains((Object)scoreLabelType);
    }

    @Override
    public int getSuiteMasterIndex() {
        throw new UnsupportedOperationException("score suites not supported");
    }

    @Override
    public List<TrailTypes> getSuiteMembers() {
        throw new UnsupportedOperationException("score suites not supported");
    }
}

