/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.histo.recordings.SuiteRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SuiteRecords {
    Map<Integer, SuiteRecord> suiteRecords = new HashMap<Integer, SuiteRecord>();

    public void clear() {
        this.suiteRecords.clear();
    }

    public SuiteRecord get(int memberIndex) {
        return this.suiteRecords.get(memberIndex);
    }

    public SuiteRecord put(int memberIndex, SuiteRecord suiteRecord) {
        return this.suiteRecords.put(memberIndex, suiteRecord);
    }

    public int getSuiteMaxValue() {
        return this.suiteRecords.values().parallelStream().mapToInt(SuiteRecord::getMaxRecordValue).max().orElseThrow(UnsupportedOperationException::new);
    }

    public int getSuiteMinValue() {
        return this.suiteRecords.values().parallelStream().mapToInt(SuiteRecord::getMinRecordValue).min().orElseThrow(UnsupportedOperationException::new);
    }

    public int realSize() {
        int result;
        block0: {
            result = 0;
            Iterator<SuiteRecord> iterator = this.suiteRecords.values().iterator();
            if (!iterator.hasNext()) break block0;
            SuiteRecord suiteRecord = iterator.next();
            result = suiteRecord.size();
        }
        return result;
    }

    public int getSuiteLength() {
        return this.suiteRecords.size();
    }

    public Integer getSuiteValue(int memberIndex, int index) {
        return (Integer)this.suiteRecords.get(memberIndex).elementAt(index);
    }

    public String toString() {
        return "SuiteRecords [getSuiteMaxValue()=" + this.getSuiteMaxValue() + ", getSuiteMinValue()=" + this.getSuiteMinValue() + ", realSize()=" + this.realSize() + ", getSuiteLength()=" + this.getSuiteLength() + "]";
    }
}

