/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.util.logging.Logger;

public class UniLog2SerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(UniLog2SerialPort.class.getName());
    public static final String NUMBER_RECORD = "number_record";
    public static final String TIME_MILLI_SEC = "time_ms";
    public static final String A_MODUS_1_2_3 = "aModus_1_2_3";
    static final byte[] COMMAND_QUERY_STATE = new byte[]{116};
    static final byte[] COMMAND_RESET = new byte[]{27, 91, 68};
    static final byte[] COMMAND_LIVE_VALUES = new byte[]{27, 91, 0, 48};
    static final byte[] COMMAND_START_LOGGING = new byte[]{27, 91, 67};
    static final byte[] COMMAND_STOP_LOGGING = new byte[]{27, 91, 68};
    static final byte DATA_STATE_READY = 71;
    static int DATA_LENGTH_BYTES = 24;
    static int TIME_OUT_MS = 2000;
    boolean isLoggingActive = false;
    boolean isTransmitFinished = false;
    int reveiceErrors = 0;

    public UniLog2SerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String queryLiveData() throws Exception {
        byte[] readBuffer = new byte[DATA_LENGTH_BYTES];
        byte[] readBufferTmp = new byte[38];
        if (!this.isConnected()) throw new Exception(Messages.getString((String)"GDE_MSGE0031"));
        try {
            this.write(COMMAND_START_LOGGING);
            this.write(COMMAND_LIVE_VALUES);
            this.read(readBufferTmp, TIME_OUT_MS);
            System.arraycopy(readBufferTmp, 0, readBuffer, 0, 38);
            this.read(readBufferTmp, TIME_OUT_MS);
            System.arraycopy(readBufferTmp, 0, readBuffer, 38, 38);
            this.read(readBufferTmp, TIME_OUT_MS);
            System.arraycopy(readBufferTmp, 0, readBuffer, 76, 38);
            this.read(readBufferTmp, TIME_OUT_MS);
            System.arraycopy(readBufferTmp, 0, readBuffer, 114, 38);
            if (!log.isLoggable(Level.FINE)) return StringHelper.byte2CharString((byte[])readBuffer, (int)readBuffer.length);
            log.log(Level.FINE, StringHelper.byte2CharString((byte[])readBuffer, (int)readBuffer.length));
            return StringHelper.byte2CharString((byte[])readBuffer, (int)readBuffer.length);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    public boolean startLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
                WaitTimer.delay((long)2000L);
            }
            this.write(COMMAND_START_LOGGING);
            this.isLoggingActive = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return this.isLoggingActive;
    }

    public synchronized boolean stopLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.write(COMMAND_STOP_LOGGING);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return !this.isLoggingActive;
    }

    public synchronized boolean checkDataReady() throws Exception {
        byte[] buffer;
        boolean isReady = false;
        int counter = 20;
        while (!isReady && counter-- > 0) {
            this.write(COMMAND_QUERY_STATE);
            buffer = new byte[1];
            if ((buffer = this.read(buffer, TIME_OUT_MS * 2))[0] != 71) continue;
            isReady = true;
        }
        if (isReady) {
            buffer = new byte[50];
            this.read(buffer, TIME_OUT_MS * 2);
            this.read(buffer, TIME_OUT_MS * 2);
            buffer = new byte[this.waitForStableReceiveBuffer(50, 1000, 50)];
            this.read(buffer, 2000);
        }
        for (int i = 0; i < 3; ++i) {
            this.write(COMMAND_RESET);
            byte[] buffer2 = new byte[50];
            this.read(buffer2, TIME_OUT_MS * 2);
            this.read(buffer2, TIME_OUT_MS * 2);
            buffer2 = new byte[this.waitForStableReceiveBuffer(50, 1000, 50)];
            this.read(buffer2, TIME_OUT_MS * 2);
        }
        DATA_LENGTH_BYTES = 152;
        return isReady;
    }

    public void setTransmitFinished(boolean isFinished) {
        this.isTransmitFinished = isFinished;
    }

    public boolean isTransmitFinished() {
        return this.isTransmitFinished;
    }
}

