/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.bantam.EStationSerialPort;
import gde.device.bantam.GathererThread;
import gde.device.bantam.eStation;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EStationDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(EStationDialog.class.getName());
    static final String DEVICE_NAME = "eStation";
    CLabel infoText;
    Button closeButton;
    Button stopCollectDataButton;
    Button startCollectDataButton;
    Composite boundsComposite;
    Group configGroup;
    Composite composite1;
    Composite composite2;
    Composite composite3;
    CLabel inputPowerLowCutOffLabel;
    CLabel capacityCutOffLabel;
    CLabel safetyTimerLabel;
    CLabel tempCutOffLabel;
    CLabel waitTimeLabel;
    CLabel cellTypeLabel;
    CLabel inputLowPowerCutOffText;
    CLabel capacityCutOffText;
    CLabel safetyTimerText;
    CLabel tempCutOffText;
    CLabel waitTimeText;
    CLabel cellTypeText;
    CLabel inputLowPowerCutOffUnit;
    CLabel capacityCutOffUnit;
    CLabel safetyTimerUnit;
    CLabel tempCutOffUnit;
    CLabel waitTimeUnit;
    CLabel cellTypeUnit;
    boolean isConnectionWarned = false;
    String inputLowPowerCutOff = "?";
    String capacityCutOff = "?";
    String safetyTimer = "?";
    String tempCutOff = "?";
    String waitTime = "?";
    String cellType = "?";
    HashMap<String, String> configData = new HashMap();
    GathererThread dataGatherThread;
    Thread updateConfigTread;
    final eStation device;
    final EStationSerialPort serialPort;
    final Channels channels;
    final Settings settings;

    public EStationDialog(Shell parent, eStation useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                this.dialogShell.setLayout((Layout)new FormLayout());
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(350, 465);
                this.dialogShell.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent evt) {
                        log.log(Level.FINER, "dialogShell.focusGained, event=" + String.valueOf(evt));
                        if (!EStationDialog.this.isConnectionWarned && !EStationDialog.this.serialPort.isConnected()) {
                            EStationDialog.this.updateConfigTread = new Thread("updateConfig"){

                                @Override
                                public void run() {
                                    try {
                                        EStationDialog.this.configData = new HashMap();
                                        EStationDialog.this.serialPort.open();
                                        EStationDialog.this.serialPort.wait4Bytes(2000);
                                        EStationDialog.this.device.getConfigurationValues(EStationDialog.this.configData, EStationDialog.this.serialPort.getData());
                                        EStationDialog.this.getDialogShell().getDisplay().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                EStationDialog.this.updateGlobalConfigData(EStationDialog.this.configData);
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        EStationDialog.this.isConnectionWarned = true;
                                        EStationDialog.this.application.openMessageDialog(EStationDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0024", (Object[])new Object[]{e.getMessage()}));
                                    }
                                    EStationDialog.this.serialPort.close();
                                }
                            };
                            try {
                                EStationDialog.this.updateConfigTread.start();
                            }
                            catch (RuntimeException e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    }
                });
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                EStationDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        EStationDialog.this.application.openHelpDialog(EStationDialog.DEVICE_NAME, "HelpInfo.html");
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        EStationDialog.this.dispose();
                    }
                });
                this.boundsComposite = new Composite((Composite)this.dialogShell, 0);
                FormData boundsCompositeLData = new FormData();
                boundsCompositeLData.left = new FormAttachment(0, 1000, 0);
                boundsCompositeLData.right = new FormAttachment(1000, 1000, 0);
                boundsCompositeLData.top = new FormAttachment(0, 1000, 0);
                boundsCompositeLData.bottom = new FormAttachment(1000, 1000, 0);
                this.boundsComposite.setLayoutData((Object)boundsCompositeLData);
                this.boundsComposite.setLayout((Layout)new FormLayout());
                this.boundsComposite.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        log.log(Level.FINER, "boundsComposite.paintControl() " + String.valueOf(evt));
                        if (EStationDialog.this.dataGatherThread != null && EStationDialog.this.dataGatherThread.isAlive()) {
                            EStationDialog.this.startCollectDataButton.setEnabled(false);
                            EStationDialog.this.stopCollectDataButton.setEnabled(true);
                        } else {
                            EStationDialog.this.startCollectDataButton.setEnabled(true);
                            EStationDialog.this.stopCollectDataButton.setEnabled(false);
                        }
                    }
                });
                FormData infoTextLData = new FormData();
                infoTextLData.height = 80;
                infoTextLData.left = new FormAttachment(0, 1000, 12);
                infoTextLData.top = new FormAttachment(0, 1000, 20);
                infoTextLData.right = new FormAttachment(1000, 1000, -12);
                this.infoText = new CLabel(this.boundsComposite, 0x1000004);
                this.infoText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.infoText.setLayoutData((Object)infoTextLData);
                this.infoText.setText(Messages.getString((String)"GDE_MSGT1410"));
                this.infoText.setBackground(SWTResourceManager.getColor((int)22));
                this.infoText.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData startCollectDataButtonLData = new FormData();
                startCollectDataButtonLData.height = 30;
                startCollectDataButtonLData.left = new FormAttachment(0, 1000, 12);
                startCollectDataButtonLData.top = new FormAttachment(0, 1000, 110);
                startCollectDataButtonLData.right = new FormAttachment(1000, 1000, -180);
                this.startCollectDataButton = new Button(this.boundsComposite, 0x1000008);
                this.startCollectDataButton.setLayoutData((Object)startCollectDataButtonLData);
                this.startCollectDataButton.setText(Messages.getString((String)"GDE_MSGT0274"));
                this.startCollectDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        block6: {
                            log.log(Level.FINEST, "startCollectDataButton.widgetSelected, event=" + String.valueOf(evt));
                            if (!EStationDialog.this.serialPort.isConnected()) {
                                try {
                                    Channel activChannel = Channels.getInstance().getActiveChannel();
                                    if (activChannel == null) break block6;
                                    EStationDialog.this.dataGatherThread = new GathererThread(EStationDialog.this.application, EStationDialog.this.device, EStationDialog.this.serialPort, activChannel.getNumber(), EStationDialog.this);
                                    try {
                                        EStationDialog.this.dataGatherThread.start();
                                    }
                                    catch (RuntimeException e) {
                                        log.log(Level.WARNING, e.getMessage(), e);
                                    }
                                    EStationDialog.this.boundsComposite.redraw();
                                }
                                catch (Exception e) {
                                    if (EStationDialog.this.dataGatherThread != null && EStationDialog.this.dataGatherThread.isCollectDataStopped) {
                                        EStationDialog.this.dataGatherThread.stopDataGatheringThread(false, e);
                                    }
                                    EStationDialog.this.boundsComposite.redraw();
                                    EStationDialog.this.application.updateGraphicsWindow();
                                    EStationDialog.this.application.openMessageDialog(EStationDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0023", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                                }
                            }
                        }
                    }
                });
                this.startCollectDataButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData stopColletDataButtonLData = new FormData();
                stopColletDataButtonLData.height = 30;
                stopColletDataButtonLData.left = new FormAttachment(0, 1000, 170);
                stopColletDataButtonLData.top = new FormAttachment(0, 1000, 110);
                stopColletDataButtonLData.right = new FormAttachment(1000, 1000, -12);
                this.stopCollectDataButton = new Button(this.boundsComposite, 0x1000008);
                this.stopCollectDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopCollectDataButton.setLayoutData((Object)stopColletDataButtonLData);
                this.stopCollectDataButton.setText(Messages.getString((String)"GDE_MSGT0275"));
                this.stopCollectDataButton.setEnabled(false);
                this.stopCollectDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "stopColletDataButton.widgetSelected, event=" + String.valueOf(evt));
                        if (EStationDialog.this.dataGatherThread != null && EStationDialog.this.serialPort.isConnected()) {
                            EStationDialog.this.dataGatherThread.stopDataGatheringThread(false, null);
                        }
                        EStationDialog.this.boundsComposite.redraw();
                    }
                });
                this.stopCollectDataButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData configGroupLData = new FormData();
                configGroupLData.height = 200;
                configGroupLData.left = new FormAttachment(0, 1000, 12);
                configGroupLData.top = new FormAttachment(0, 1000, 155);
                configGroupLData.right = new FormAttachment(1000, 1000, -12);
                this.configGroup = new Group(this.boundsComposite, 0);
                RowLayout configGroupLayout = new RowLayout(256);
                this.configGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configGroup.setLayout((Layout)configGroupLayout);
                this.configGroup.setLayoutData((Object)configGroupLData);
                this.configGroup.setText(Messages.getString((String)"GDE_MSGT1407"));
                this.configGroup.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        log.log(Level.FINEST, "configGroup.paintControl, event=" + String.valueOf(evt));
                        EStationDialog.this.inputLowPowerCutOffText.setText(EStationDialog.this.inputLowPowerCutOff);
                        EStationDialog.this.capacityCutOffText.setText(EStationDialog.this.capacityCutOff);
                        EStationDialog.this.safetyTimerText.setText(EStationDialog.this.safetyTimer);
                        EStationDialog.this.tempCutOffText.setText(EStationDialog.this.tempCutOff);
                        EStationDialog.this.waitTimeText.setText(EStationDialog.this.waitTime);
                        EStationDialog.this.cellTypeText.setText(EStationDialog.this.cellType);
                    }
                });
                RowData composite1LData = new RowData();
                composite1LData.width = 190;
                composite1LData.height = 195;
                this.composite1 = new Composite((Composite)this.configGroup, 0);
                FillLayout composite1Layout = new FillLayout(512);
                this.composite1.setLayout((Layout)composite1Layout);
                this.composite1.setLayoutData((Object)composite1LData);
                this.inputPowerLowCutOffLabel = new CLabel(this.composite1, 0);
                this.inputPowerLowCutOffLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputPowerLowCutOffLabel.setText(Messages.getString((String)"GDE_MSGT1414"));
                this.capacityCutOffLabel = new CLabel(this.composite1, 0);
                this.capacityCutOffLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.capacityCutOffLabel.setText(Messages.getString((String)"GDE_MSGT1415"));
                this.safetyTimerLabel = new CLabel(this.composite1, 0);
                this.safetyTimerLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.safetyTimerLabel.setText(Messages.getString((String)"GDE_MSGT1416"));
                this.tempCutOffLabel = new CLabel(this.composite1, 0);
                this.tempCutOffLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tempCutOffLabel.setText(Messages.getString((String)"GDE_MSGT1417"));
                this.waitTimeLabel = new CLabel(this.composite1, 0);
                this.waitTimeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.waitTimeLabel.setText(Messages.getString((String)"GDE_MSGT1418"));
                this.cellTypeLabel = new CLabel(this.composite1, 0);
                this.cellTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.cellTypeLabel.setText(Messages.getString((String)"GDE_MSGT1420"));
                RowData composite2LData = new RowData();
                composite2LData.width = 45;
                composite2LData.height = 195;
                this.composite2 = new Composite((Composite)this.configGroup, 0);
                FillLayout composite2Layout = new FillLayout(512);
                this.composite2.setLayout((Layout)composite2Layout);
                this.composite2.setLayoutData((Object)composite2LData);
                this.inputLowPowerCutOffText = new CLabel(this.composite2, 0);
                this.inputLowPowerCutOffText.setText(this.inputLowPowerCutOff);
                this.capacityCutOffText = new CLabel(this.composite2, 0);
                this.capacityCutOffText.setText(this.capacityCutOff);
                this.safetyTimerText = new CLabel(this.composite2, 0);
                this.safetyTimerText.setText(this.safetyTimer);
                this.tempCutOffText = new CLabel(this.composite2, 0);
                this.tempCutOffText.setText(this.tempCutOff);
                this.waitTimeText = new CLabel(this.composite2, 0);
                this.waitTimeText.setText(this.waitTime);
                this.cellTypeText = new CLabel(this.composite2, 0);
                this.cellTypeText.setText(this.cellType);
                this.composite3 = new Composite((Composite)this.configGroup, 0);
                FillLayout composite3Layout = new FillLayout(512);
                RowData composite3LData = new RowData();
                composite3LData.width = 60;
                composite3LData.height = 195;
                this.composite3.setLayoutData((Object)composite3LData);
                this.composite3.setLayout((Layout)composite3Layout);
                this.inputLowPowerCutOffUnit = new CLabel(this.composite3, 0);
                this.inputLowPowerCutOffUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputLowPowerCutOffUnit.setText(Messages.getString((String)"GDE_MSGT1421"));
                this.capacityCutOffUnit = new CLabel(this.composite3, 0);
                this.capacityCutOffUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.capacityCutOffUnit.setText(Messages.getString((String)"GDE_MSGT1422"));
                this.safetyTimerUnit = new CLabel(this.composite3, 0);
                this.safetyTimerUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.safetyTimerUnit.setText(Messages.getString((String)"GDE_MSGT1423"));
                this.tempCutOffUnit = new CLabel(this.composite3, 0);
                this.tempCutOffUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tempCutOffUnit.setText(Messages.getString((String)"GDE_MSGT1424"));
                this.waitTimeUnit = new CLabel(this.composite3, 0);
                this.waitTimeUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.waitTimeUnit.setText(Messages.getString((String)"GDE_MSGT1425"));
                this.cellTypeUnit = new CLabel(this.composite3, 0);
                this.cellTypeUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.cellTypeUnit.setText("");
                this.configGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData closeButtonLData = new FormData();
                closeButtonLData.height = 30;
                closeButtonLData.bottom = new FormAttachment(1000, 1000, -12);
                closeButtonLData.left = new FormAttachment(0, 1000, 12);
                closeButtonLData.right = new FormAttachment(1000, 1000, -12);
                this.closeButton = new Button(this.boundsComposite, 0x1000008);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0188"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "okButton.widgetSelected, event=" + String.valueOf(evt));
                        EStationDialog.this.close();
                    }
                });
                this.closeButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.boundsComposite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        log.log(Level.FINE, "boundsComposite.mouseEnter, event=" + String.valueOf(evt));
                        EStationDialog.this.fadeOutAplhaBlending(evt, EStationDialog.this.boundsComposite.getSize(), 10, 10, 10, 15);
                    }

                    public void mouseHover(MouseEvent evt) {
                        log.log(Level.FINEST, "boundsComposite.mouseHover, event=" + String.valueOf(evt));
                    }

                    public void mouseExit(MouseEvent evt) {
                        log.log(Level.FINE, "boundsComposite.mouseExit, event=" + String.valueOf(evt));
                        EStationDialog.this.fadeInAlpaBlending(evt, EStationDialog.this.boundsComposite.getSize(), 10, 10, -10, 15);
                    }
                });
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void resetButtons() {
        if (!this.isDisposed()) {
            this.startCollectDataButton.setEnabled(true);
            this.stopCollectDataButton.setEnabled(false);
        }
    }

    public void updateGlobalConfigData(HashMap<String, String> newConfigData) {
        this.configData = newConfigData;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.inputLowPowerCutOff = this.configData.get("in_voltage_cut_off");
                this.inputLowPowerCutOffText.setText(this.inputLowPowerCutOff);
                this.capacityCutOff = this.configData.get("capacity_cut_off");
                this.capacityCutOffText.setText(this.capacityCutOff);
                this.safetyTimer = this.configData.get("safety_time");
                this.safetyTimerText.setText(this.safetyTimer);
                this.tempCutOff = this.configData.get("ext_temp_cut_off");
                this.tempCutOffText.setText(this.tempCutOff);
                this.waitTime = this.configData.get("wait_time");
                this.waitTimeText.setText(this.waitTime);
                if (this.configData.get("battery_type") != null) {
                    this.cellType = this.configData.get("battery_type");
                    this.cellTypeText.setText(this.cellType);
                }
                this.configGroup.redraw();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EStationDialog.this.inputLowPowerCutOff = EStationDialog.this.configData.get("in_voltage_cut_off");
                        EStationDialog.this.inputLowPowerCutOffText.setText(EStationDialog.this.inputLowPowerCutOff);
                        EStationDialog.this.capacityCutOff = EStationDialog.this.configData.get("capacity_cut_off");
                        EStationDialog.this.capacityCutOffText.setText(EStationDialog.this.capacityCutOff);
                        EStationDialog.this.safetyTimer = EStationDialog.this.configData.get("safety_time");
                        EStationDialog.this.safetyTimerText.setText(EStationDialog.this.safetyTimer);
                        EStationDialog.this.tempCutOff = EStationDialog.this.configData.get("ext_temp_cut_off");
                        EStationDialog.this.tempCutOffText.setText(EStationDialog.this.tempCutOff);
                        EStationDialog.this.waitTime = EStationDialog.this.configData.get("wait_time");
                        EStationDialog.this.waitTimeText.setText(EStationDialog.this.waitTime);
                        if (EStationDialog.this.configData.get("battery_type") != null) {
                            EStationDialog.this.cellType = EStationDialog.this.configData.get("battery_type");
                            EStationDialog.this.cellTypeText.setText(EStationDialog.this.cellType);
                        }
                        EStationDialog.this.configGroup.redraw();
                    }
                });
            }
        }
    }
}

