/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Anchor
extends Phrase {
    private static final long serialVersionUID = -852278536049236911L;
    protected String name = null;
    protected String reference = null;

    public Anchor() {
        super(16.0f);
    }

    public Anchor(float leading) {
        super(leading);
    }

    public Anchor(Chunk chunk) {
        super(chunk);
    }

    public Anchor(String string2) {
        super(string2);
    }

    public Anchor(String string2, Font font) {
        super(string2, font);
    }

    public Anchor(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Anchor(float leading, String string2) {
        super(leading, string2);
    }

    public Anchor(float leading, String string2, Font font) {
        super(leading, string2, font);
    }

    public Anchor(Phrase phrase) {
        super(phrase);
        if (phrase instanceof Anchor) {
            Anchor a2 = (Anchor)phrase;
            this.setName(a2.name);
            this.setReference(a2.reference);
        }
    }

    @Override
    public boolean process(ElementListener listener2) {
        try {
            Iterator<Chunk> i2 = this.getChunks().iterator();
            boolean localDestination = this.reference != null && this.reference.startsWith("#");
            boolean notGotoOK = true;
            while (i2.hasNext()) {
                Chunk chunk = i2.next();
                if (this.name != null && notGotoOK && !chunk.isEmpty()) {
                    chunk.setLocalDestination(this.name);
                    notGotoOK = false;
                }
                if (localDestination) {
                    chunk.setLocalGoto(this.reference.substring(1));
                }
                listener2.add(chunk);
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public List<Chunk> getChunks() {
        boolean localDestination = this.reference != null && this.reference.startsWith("#");
        boolean notGotoOK = true;
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        for (Element element : this) {
            if (element instanceof Chunk) {
                Chunk chunk = (Chunk)element;
                notGotoOK = this.applyAnchor(chunk, notGotoOK, localDestination);
                tmp.add(chunk);
                continue;
            }
            for (Chunk c2 : element.getChunks()) {
                notGotoOK = this.applyAnchor(c2, notGotoOK, localDestination);
                tmp.add(c2);
            }
        }
        return tmp;
    }

    protected boolean applyAnchor(Chunk chunk, boolean notGotoOK, boolean localDestination) {
        if (this.name != null && notGotoOK && !chunk.isEmpty()) {
            chunk.setLocalDestination(this.name);
            notGotoOK = false;
        }
        if (localDestination) {
            chunk.setLocalGoto(this.reference.substring(1));
        } else if (this.reference != null) {
            chunk.setAnchor(this.reference);
        }
        return notGotoOK;
    }

    @Override
    public int type() {
        return 17;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public URL getUrl() {
        try {
            return new URL(this.reference);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }
}

