/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt.dialogs;

import de.treichels.hott.decoder.HoTTDecoderKt;
import de.treichels.hott.mdlviewer.swt.dialogs.SelectFromTransmitterDialog;
import de.treichels.hott.model.enums.ModelType;
import de.treichels.hott.serial.FileInfo;
import de.treichels.hott.serial.FileType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectFromSdCardDialog
extends SelectFromTransmitterDialog {
    private Tree tree;

    public SelectFromSdCardDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void getSelectionComponent(Composite dialog2) {
        this.tree = new Tree(dialog2, 268437508);
        this.tree.addListener(14, new DefaultListener());
        this.tree.addListener(17, new ExpandListener());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.tree.setLayoutData(gridData);
    }

    @Override
    protected void onCancel() {
        this.model = null;
    }

    @Override
    protected void onOpen() {
        BusyIndicator.showWhile(this.getParent().getDisplay(), new OpenRunner());
    }

    @Override
    protected void onReload() {
        BusyIndicator.showWhile(this.getParent().getDisplay(), new ReloadRunner());
    }

    private final class ReloadRunner
    implements Runnable {
        private ReloadRunner() {
        }

        @Override
        public void run() {
            try {
                String[] names = SelectFromSdCardDialog.this.port.listDir("/");
                SelectFromSdCardDialog.this.tree.removeAll();
                for (String name : names) {
                    FileInfo fileInfo = SelectFromSdCardDialog.this.port.getFileInfo(name);
                    TreeItem treeItem = new TreeItem(SelectFromSdCardDialog.this.tree, 0);
                    treeItem.setData(fileInfo);
                    treeItem.setText(fileInfo.getName());
                    if (fileInfo.getType() != FileType.Dir) continue;
                    new TreeItem(treeItem, 0);
                }
            }
            catch (Throwable t2) {
                SelectFromSdCardDialog.this.showError(t2);
            }
        }
    }

    private final class OpenRunner
    implements Runnable {
        private OpenRunner() {
        }

        @Override
        public void run() {
            try {
                TreeItem selectedItem;
                FileInfo fileInfo;
                TreeItem[] selection2 = SelectFromSdCardDialog.this.tree.getSelection();
                if (selection2 != null && selection2.length > 0 && (fileInfo = (FileInfo)(selectedItem = selection2[0]).getData()) != null && fileInfo.getType() == FileType.File && fileInfo.getName().endsWith(".mdl") && fileInfo.getSize() <= 12288 && fileInfo.getSize() >= 8192) {
                    String fileName = fileInfo.getName();
                    ModelType type2 = ModelType.forChar(fileName.charAt(0));
                    String name = fileName.substring(1, fileName.length() - 4);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SelectFromSdCardDialog.this.port.readFile(fileInfo.getPath(), os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    SelectFromSdCardDialog.this.model = HoTTDecoderKt.decodeStream(type2, name, is);
                }
            }
            catch (Throwable t2) {
                SelectFromSdCardDialog.this.showError(t2);
            }
        }
    }

    private final class ExpandListener
    implements Listener {
        private ExpandListener() {
        }

        @Override
        public void handleEvent(Event event) {
            TreeItem parentTreeItem = (TreeItem)event.item;
            FileInfo parentFileInfo = (FileInfo)parentTreeItem.getData();
            parentTreeItem.removeAll();
            BusyIndicator.showWhile(SelectFromSdCardDialog.this.getParent().getDisplay(), () -> {
                try {
                    String[] names;
                    for (String name : names = SelectFromSdCardDialog.this.port.listDir(parentFileInfo.getPath())) {
                        FileInfo fileInfo = SelectFromSdCardDialog.this.port.getFileInfo(name);
                        TreeItem treeItem = new TreeItem(parentTreeItem, 0);
                        treeItem.setData(fileInfo);
                        treeItem.setText(fileInfo.getName());
                        if (fileInfo.getType() != FileType.Dir) continue;
                        new TreeItem(treeItem, 0);
                    }
                }
                catch (Throwable t2) {
                    SelectFromSdCardDialog.this.showError(t2);
                }
            });
        }
    }

    private final class DefaultListener
    implements Listener {
        private DefaultListener() {
        }

        @Override
        public void handleEvent(Event event) {
            TreeItem treeItem = (TreeItem)event.item;
            FileInfo fileInfo = (FileInfo)treeItem.getData();
            if (fileInfo != null && fileInfo.getType() == FileType.File && fileInfo.getName().endsWith(".mdl") && fileInfo.getSize() <= 12288 && fileInfo.getSize() >= 8192) {
                SelectFromSdCardDialog.this.onOpen();
                SelectFromSdCardDialog.this.dialog.close();
            }
        }
    }
}

