'\" t
.TH groff_pdfhref @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_pdfhref \- place hypertext references in PDF files created by groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_pdfhref_7_man_C
.cp 0
.
.
.\" ====================================================================
.\" Local Macro Definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.\" When typesetting as PDF, kerning of text set in block capitals,
.\" (and in particular, boldface block capitals), may look erratic.
.\" This effect becomes particularly noticeable around any embedded
.\" dots, within the typeset names of PDFHREF control variables, so
.\" define string representations for each these, so that they may
.\" be manually kerned, consistently, at each point of reference.
.\"
.\" Note that the names of the control variables themselves are not
.\" suitable here, as the definitions would interfere with internal
.\" usage in pdfmark.tmac, when typesetting this manpage itself, as
.\" a PDF document.  Thus, we use the actual control variable names,
.\" each prefixed by a "$" symbol, to define the reference strings.
.\"
.ds $PDFHREF               PDFHREF\h'0.05n'
.ds $PDFBOOKMARK           PDFBOOKMARK\h'0.25n'
.
.ds $PDFBOOKMARK.NAME      \*[$PDFBOOKMARK].\h'0.20n'NAME
.ds $PDFBOOKMARK.VIEW      \*[$PDFBOOKMARK].\h'0.10n'VIEW
.
.ds $PDFHREF.BORDER        \*[$PDFHREF].\h'0.20n'BORDER
.ds $PDFHREF.COLOR         \*[$PDFHREF].\h'0.20n'COLOR
.ds $PDFHREF.COLOUR        \*[$PDFHREF].\h'0.20n'COLOUR
.ds $PDFHREF.DESC          \*[$PDFHREF].\h'0.20n'DESC
.ds $PDFHREF.FILEREF       \*[$PDFHREF].\h'0.20n'FILEREF
.ds $PDFHREF.HEIGHT        \*[$PDFHREF].\h'0.20n'HEIGHT
.ds $PDFHREF.INFO          \*[$PDFHREF].\h'0.20n'INFO
.ds $PDFHREF.LEADING       \*[$PDFHREF].\h'0.20n'LEADING
.ds $PDFHREF.PAGEREF       \*[$PDFHREF].\h'0.20n'PAGEREF
.ds $PDFHREF.PREFIX        \*[$PDFHREF].\h'0.20n'PREFIX
.ds $PDFHREF.SECTREF       \*[$PDFHREF].\h'0.30n'SECTREF
.ds $PDFHREF.TEXT          \*[$PDFHREF].TEXT
.ds $PDFHREF.TEXT.COLOR    \*[$PDFHREF].TEXT\h'0.20n'.\h'0.20n'COLOR
.ds $PDFHREF.TEXT.COLOUR   \*[$PDFHREF].TEXT\h'0.20n'.\h'0.20n'COLOUR
.ds $PDFHREF.VIEW          \*[$PDFHREF].\h'0.10n'VIEW
.ds $PDFHREF.VIEW.LEADING  \*[$PDFHREF.VIEW]\h'0.02n'.\h'0.20n'LEADING
.ds $PDFHREF.Y             \*[$PDFHREF].\h'0.02n'Y
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the capabilities,
and the usage,
of the
.B \%pdfhref
macro,
which is provided by the
.I \%groff-pdfmark
macro package.
.
The
.B \%\%pdfhref
macro offers
.I nine
distinct capabilities,
each of which is identified by passing
a \%single-character
.RI \(lq opcode \(rq,
as the first argument,
namely:
.
.RS 2n
.ll -2n
.TP 12n
.B \%.\^pdfhref\^\ O
Create a
.I \%document\ outline
reference to a PDF
.IR \%bookmark ,
which is placed at the current location within the document body.
.
.TP
.B \%.\^pdfhref\^\ M
Place a named reference mark,
at the current location within the document body.
.
.TP
.B \%.\^pdfhref\^\ D
Add an explicit entry to a document's
.IR \%reference\ dictionary .
.
.TP
.B \%.\^pdfhref\^\ L
Create a dynamic link to a named reference mark,
within the same,
or another,
PDF document.
.
.TP
.B \%.\^pdfhref\^\ W
Create a dynamic link to an internet (or similar) resource.
.
.TP
.B \%.\^pdfhref\^\ F
Specify a macro for formatting the representation of dynamic links.
.
.TP
.B \%.\^pdfhref\^\ K
Customize the set of keywords,
which may be interpreted by the formatting macro,
to describe dynamic link representations.
.
.TP
.B \%.\^pdfhref\^\ I
Initialize a handler macro,
to support processing of
.B \%pdfhref
features;
(currently only supports initialization of a page trap handler,
for correctly mapping the page \%co-ordinates of dynamic links
which span page breaks).
.
.TP
.B \%.\^pdfhref\^\ Z
Identify the page \%co-ordinates,
for the starting and ending positions,
alternately,
which are required to map the bounds of active regions,
to be associated with any dynamic links created by the
.BR \%.\^pdfhref\^\ L ,
and
.B \%.\^pdfhref\^\ W
operations.
.ll +2n
.RE
.P
Each of these capabilities is described,
together with a detailed synopsis of the corresponding
.B \%pdfhref
macro calling semantics,
in the
.SR 1 Usage
section,
which follows.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
It is
.I strongly
recommended that
.MR pdfroff @MAN1EXT@
is used,
in preference to
.MR groff @MAN1EXT@
itself,
when formatting any document which uses the
.B \%pdfhref
macro;
this will
.I automatically
take care of the multiple-pass
.MR groff @MAN1EXT@
processing,
which is normally required to correctly resolve
.B \%pdfhref
references.
.
.P
The
.B \%pdfhref
macro is made available when the
.MR groff_pdfmark @MAN7EXT@
macro package is loaded;
this
.I may
be achieved by specifying the requirement on the command line:
.P
.RS 2n
.SY pdfroff\~\-mpdfmark
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.
.SY pdfroff\~\-m\~pdfmark
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.RE
.P
However,
it is often more convenient to have it loaded implicitly,
by some other major document layout macro package,
using the request:
.P
.RS 2n
.SY .\^mso\~pdfmark\^.\^tmac
.YS
.RE
.
.if 0 \{\
.\"if \n(.g \{\"		the formatter is groff...
.   ie dpdfhref \{\"		and pdfhref support is also loaded...
.      rn SY SY.orig \" 	then backup the SY macro definition...
.      de SY \" 		and adapt to add a PDF outline entry
.         pdfhref O 3 \\$@
.         SY.orig \\$@
.      .
.   \}
.   el .als SY.orig SY
.\}
.P
The capabilities of the
.B \%pdfhref
macro,
as summarized in the preceding
.SR 1 Description
section,
are documented in detail,
below.
.
.
.SS "Creating a Document Outline"
.
When
.B \%pdfhref
is invoked by a macro call of the form:
.
.RS 2n
.SY \%.\^pdfhref\^\ O
.RB [ \-T
.RI < tag >\ |
.B  \-N
.RI < refname >]
.RI < level >
.RI \%< descriptive\ text \ .\|.\|.>
.YS
.RE
.
.P
this operation is an
.I exact
analogue of the
.B \%pdfbookmark
macro,
as described in
.MR groff_pdfmark @MAN7EXT@ ;
it creates a named reference mark,
(either using the optional
.RI \%< refname >
argument as an explicit name,
or using an internally generated,
serialized name),
at the current output location within the document text,
and inserts an entry,
comprising the specified
.RI \%< descriptive\ text \ .\|.\|.>,
and referring to this named location,
into the document outline
.IR cache ,
at the nesting level specified by the mandatory
.RI \%< level >
argument.
.
.P
If the
.BR \%\-N \ <\c
.IR refname >
option is specified,
(noting that the
.RI \%< refname >
argument is mandatory,
and the space separating it from the
.B \%\-N
flag is required),
the
.RI \%< refname >
argument is used as an explicit
.I \%bookmark
name;
thus, the internal generation of a suitable name is not required,
and is suppressed.
.
.P
Conversely,
if the
.BR \%\-T \ <\c
.IR tag >
option is specified,
(note that the
.RI \%< tag >
argument is mandatory,
and the space separating it from the
.B \%\-T
flag is required),
the internally generated
.I \%bookmark
name is qualified,
by appending the value of the
.RI \%< tag >
argument,
as a suffix to the generated name.
This option is useful when two,
or more separately formatted PDF document files are to be combined,
to create a single finished document,
.I without
introducing collisions between internally generated
.I \%bookmark
names,
since any
.I untagged
names may be duplicated in the separately formatted parts.
.
.P
It may be inferred,
from the foregoing,
that the effects of the
.BR \%\-N \ <\c
.IR refname >,
and the
.BR \%\-T \ <\c
.IR tag >
options are mutually exclusive\|\(em\|the
latter is effective
.I only
when the reference mark name is internally generated,
which is not the case when the former is in effect.
Although it may seem to be an error,
to specify both together,
this error will not be caught;
the effect of the
.BR \%\-N \ <\c
.IR refname >
option will prevail,
and the
.BR \%\-T \ <\c
.IR tag >
option will simply be silently ignored.
.
.P
After each invocation of the
.B \%.\^pdfhref\^\ O
macro, (or the completely analogous
.B \%.\^pdfbookmark
macro),
the assigned
.I \%bookmark
name,
(whether explicitly specified,
or internally generated,
and, in the latter case,
including any
.RI \%< tag >
suffix which may have been specified),
is stored in the
.MR groff @MAN7EXT@
string object named
.BR \%\*[$PDFBOOKMARK.NAME] ;
the value of this may then be saved,
for use in subsequent
.I backward
references to the marked location,
(for example,
using the
.B \%.\^pdfhref\^\ L
operation, as described below).
This particular feature will be of little use for
.I forward
references,
(since the reference mark's name will be unknown before the
.I \%bookmark
has been placed),
or indeed, for
.I explicitly
named
.IR \%bookmarks ,
(because the name is already known,
.I without
any need to inspect the value of
.BR \%\*[$PDFBOOKMARK.NAME] );
however,
in any case where it may be found to be useful,
it is important to remember that the value of
.B \%\*[$PDFBOOKMARK.NAME]
is
.IR volatile \|\(em\|it
will be overwritten by
.I any
subsequent invocation of
.BR \%.\^pdfhref\^\ O ,
or of
.BR \%.\^pdfbookmark \|\(em\|so
it
.I must
be copied to an alternatively named
.MR groff @MAN7EXT@
string object,
of the user's choice,
.I before
it is overwritten.
.
.P
It may be noted that document outline entries are,
initially,
stored in a local cache,
rather than writing them
.I directly
into the document outline itself.
This is necessary,
because the number of directly nested child entries,
at each nesting level,
.I must
be known at the time when each outline entry is actually written,
but it isn't known until the
.I next sibling
entry is to be cached.
Thus,
the cache
.I must
always lead the actually committed document outline,
by at least one entry at every unfinished nesting level.
Consequently,
there will usually be uncommitted content in the outline cache,
at the end of input processing;
this must be flushed,
by invoking the complementary
.B \%.\^pdfsync\ O
macro, from
.MR groff_pdfmark @MAN7EXT@ ,
(or even,
just the generic
.B \%.\^pdfsync
macro),
after
.I all
input has been processed,
(typically,
from within an \%end-of-input trap).
.
.
.SS Creating Reference Marks and Links
.
The
.B \%pdfhref
macro supports three distinct operations,
for placing reference marks within PDF documents,
and defining active links to them:
.
.RS 2n
.ll -8n
.SY \%.\^pdfhref\^\ M
.RB [ \-N
.RI \%< dest-name >]
.RB [ \-E ]
.RB [ \-X ]
.RB [ \-\- ]
.RI [ descriptive\ text \ .\|.\|.]
.
.SY \%.\^pdfhref\^\ D
.B \-N
.RI \%< dest-name >
.RI [< keyword >
.RI < value >]\ .\|.\|.\ [ descriptive\ text \ .\|.\|.]
.
.SY \%.\^pdfhref\^\ L
.RB [ \-F \ \c
.RI \%<\h'-\w"\|"u' file-name >
.RB [ \-DF \ \c
.RI \%< dos-file >]
.RB [ \-MF \ \c
.RI \%< mac-file >]
.RB [ \-UF \ \c
.RI \%< unix-file >]
.RB [ \-WF \ \c
.RI \%< win-file >]]
.RB [ \-D
.RI \%< dest-name >]
.RB [ \-P
.RI \%<\h'-\w"\^"u' prefix-text >]
.RB [ \-A
.RI \%< affix-text >]
.RB [ \-X ]
.RB [ \-\- ]
.RI [ descriptive\ text \ .\|.\|.]
.YS
.ll +8n
.RE
.
.P
The
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form of this macro call creates a named reference mark,
at the current output position within the running text of the document,
and inserts a corresponding entry into the document's reference
dictionary;
the content of the reference dictionary entry is derived
from the macro arguments,
as directed by the
.B \%\*[$PDFHREF.INFO]
template,
(see section
.RK V \h'-0.2n'V\h'-0.2n'
.SR 1 \%Control\ Variables ,
below).
.
.P
On the other hand, the
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
form of the call simply inserts a record,
with its content as specified
.I directly
by the macro arguments,
into the reference dictionary.
.
.P
Finally, the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
form of the macro call creates a link to a named reference mark.
This mark would typically be created by a macro call of the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form;
it may be placed either before,
or after the link,
in
.I the same
document file,
or even in
.I a different
document file,
(in which case,
a reference dictionary entry created by the
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
form of the call may be useful).
.
.P
In all of these call forms,
when an
.I explicit
.RI \%\(lq dest-name \(rq
specification is provided,
(in the form of a
.RB \%\(lq \-D \ <\c
.IR dest-name >\(rq,
or a
.RB \%\(lq \-N \ <\c
.IR dest-name >\(rq
specification,
as appropriate),
the specified
.RI \%\(lq dest-name \(rq
serves
.I both
as the reference mark name,
.I and
as the record key,
for lookup of the associated reference dictionary entry.
.
In those cases where an explicit
.RI \%\(lq dest-name \(rq
specification is optional,
and is omitted,
the first space-delimited word of the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
argument list,
(which
.I must
be specified in any such case),
is interpreted as an
.I implicit
specification of
.RI \%\(lq dest-name \(rq,
and is used in its stead.
.
.P
In all cases, the
.RB \%\(lq \-\- \(rq
flag may be specified,
to indicate that all arguments which follow
are to be interpreted as
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq,
regardless of whether, or not,
they might otherwise be interpreted as macro options.
.
.P
In normal use, the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro call contributes
.I nothing
to the running text of the document.
This normal behaviour may be changed,
by specification of the optional
.RB \%\(lq \-E \(rq
flag;
when this is specified,
in addition to the normal behaviour,
the content of the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments will be copied into the running text,
'ne 2v
.I immediately following
the position of the named reference mark,
which the call creates.
.
.P
Also in normal use, when
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
is executed,
it creates a reference dictionary entry
.IR internally ,
within
.MR groff @MAN7EXT@
string space
.IR only ;
the string name is derived from the reference mark name,
and serves as the dictionary lookup key.
To make any reference dictionary entry
.I externally
visible, the
.RB \%\(lq \-X \(rq
flag may be specified;
this causes the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
macro to \%\(lqexport\(rq the reference mark name,
and its associated reference dictionary record content,
through the standard error output stream,
whence it will be recognized by
.MR pdfroff @MAN1EXT@ ,
and redirected,
in the form of a corresponding
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
macro call,
into a (nominally temporary) reference dictionary file;
(the
.MR pdfroff @MAN1EXT@
.RI \%\(lq \-\-reference\-dictionary =< \h'-\w"\^"u/48u'file-name >\(rq
option may be specified,
to extend the life of this file beyond the lifetime of the
.MR pdfroff @MAN1EXT@
process which creates it).
.
.P
Like the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form, the
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro call causes insertion of a named destination record into the
.I internal
reference dictionary.
As with the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form, the name of the
.MR groff @MAN7EXT@
string variable,
in which the dictionary record is stored,
and of which the name also serves as the dictionary lookup key,
is taken from the
.RB \%\(lq \-D \ <\c
.IR dest-name >\(rq
argument specification,
(which is
.IR required ,
in any
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
macro call);
unlike the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
form, however, the content of the reference dictionary record is
.I not
controlled by the
.B \%\*[$PDFHREF.INFO]
\%template;
it is, rather, determined
.IR directly ,
from the sequence of
.RI \%\(lq< keyword >\ < value >\(rq
pairs, and
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments, as specified in the
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
call.
Furthermore,
since the intent of
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
is, primarily, to
.I import
reference dictionary entries,
which had previously been
.I exported
by a
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq
call,
(often from within a separate document),
there is no equivalent to of the
.RB \%\(lq .\^pdfhref\^\ M\ \^\-X \(rq
flag, for use with
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq.
.
.P
Unlike the
.RB \%\(lq .\^pdfhref\^\ M \^\ .\|.\|.\&\(rq,
and the
.RB \%\(lq .\^pdfhref\^\ D \^\ .\|.\|.\&\(rq
operations, the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro call does not
.I create
reference dictionary entries,
but it may need to
.I consult
them;
the precise behaviour is determined by the logic
incorporated within the following processing sequence:
.RS 2n
.ll -2n
.IP \(bu 2n
If an
.I explicit
.RB \%\(lq \-D \ <\c
.IR dest-name >\(rq
argument is specified,
then
.RI \%\(lq dest-name \(rq
identifies the named reference mark
to which the link refers;
in this case,
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments become optional,
and may be omitted, or specified,
at the user's discretion.
.
.IP \(bu 2n
Conversely,
when there is no
.RB \%\(lq \-D \ <\c
.IR dest-name >\(rq
argument specification,
then the first of the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments, (at least one of which is
.IR required ,
in this case),
will be interpreted as an
.I implicit
specification of
.RI \%\(lq dest-name \(rq,
and thus
.I this
identifies the named reference mark
to which the link refers.
.
.IP \(bu 2n
If there are no
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments specified,
(which implies that there
.I must
be a
.RB \%\(lq \-D \ <\c
.IR dest-name >\(rq
specification),
then a reference dictionary lookup, keyed on
.RI \%\(lq dest-name \(rq,
is performed,
and the content of the associated record
is formatted into the active link region,
under the control of either a user-specified,
or an internal default formatting macro.
.
.IP \(bu 2n
If any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments
.I are
specified, together with the
.RB \&\(lq \-X \(rq
flag, (which exhibits distinctly
.I different
behaviour from that of
.RB \%\(lq .\^pdfhref\^\ M\ \^\-X \^\ .\|.\|.\&\(rq),
then a
.RI \%\(lq dest-name \(rq
reference dictionary lookup is again performed;
in this case, however,
.I only
.RI \%\(lq< keyword >\ < value >\(rq
pairs from the associated dictionary record,
followed by the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments from the
.RB \%\(lq .\^pdfhref\^\ L\^\ \-X \^\ .\|.\|.\&\(rq
call, are passed to the link formatting macro.
.
.IP \(bu 2n
Finally, if any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments are specified, but the
.RB \%\(lq \-X \(rq
flag is not,
then the reference dictionary is
.I not
consulted,
and the
.B \%pdfhref
link text formatting macro is
.I not
called;
the content of the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments is simply written, as is,
into the active link region,
with normal
.MR troff @MAN1EXT@
formatting applied.
.ll +2n
.RE
.
.P
By default,
.RB \%\(lq .\^pdfhref\ \^L \ \c
\^.\|.\|.\&\(rq
will assume that all named references are to be resolved
within the same document file as the link itself,
.I unless
the
.RB \%\(lq \-F \ <\c
.IR \h'-\w"\^"u/8u'file-name >\(rq
option is specified;
this causes the
.B \%pdfhref
macro to emit additional
.B \%pdfmark
code, stipulating that the named reference destination
may be found in the file named by the
.RI \%\(lq\h'-\w"\|"u' file-name \(rq
argument.
.
.P
.ne 6v
When the
.RB \%\(lq \-F \ <\c
.IR \h'-\w"\^"u/8u'file-name >\(rq
option is specified, the
.RI \%\(lq\h'-\w"\|"u' file-name \(rq
specified may not be universally suitable for use
on all file systems which it is desired to support.
To mitigate this limitation,
it is permitted to specify any of the following additional options,
together with
.RB \%\(lq \-F \ <\c
.IR \h'-\w"\^"u/8u'file-name >\(rq:
.
.RS 2n
.ll -2n
.TP 3n
.BR \-DF \ <\c
.IR dos-file >
Specify an alternative
.IR file-name ,
which is suitable for use on \%MS-DOS\(tm file systems.
.TP 3n
.BR \-MF \ <\c
.IR mac-file >
Specify an alternative
.IR file-name ,
which is suitable for use on \%Apple \%Macintosh\(tm file systems.
.TP 3n
.BR \-UF \ <\c
.IR unix-file >
Specify an alternative
.IR file-name ,
which is suitable for use on \%Unix file systems.
.TP 3n
.BR \-WF \ <\c
.IR dos-file >
Specify an alternative
.IR file-name ,
which is suitable for use on \%MS-Windows\(tm file systems.
.ll +2n
.RE
.P
The two remaining options,
which are supported by
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
macro calls,
provide a mechanism for specifying additional running-text content,
(typically punctuation),
which is to be printed immediately
.IR \%before ,
or
.I \%after
the associated link,
.I without
any intervening white space,
but
.I not
within its active region;
the
.RB \%\(lq \-P \ <\h'-\w"\^"u'\c
.IR prefix-text >\(rq
option places
.RI \%\(lq prefix-text \(rq
as such additional content,
.I before
the link, while
.RB \%\(lq \-A \ <\c
.IR affix-text >\(rq
places
.RI \%\(lq affix-text \(rq
in similar fashion,
.I after
the link.
.
.
.SS Linking to Internet Resources
.
Links to internet,
and similar resources,
are supported by a single
.B \%pdfhref
macro operation;
however, this operation may be invoked using either one
of two distinct forms of the macro call:
.
.RS 2n
.ll -2n
.SY \%.\^pdfhref\^\ W
.RB [ \-P
.RI \%<\h'-0.15n' prefix-text >]
.RB [ \-A
.RI \%< affix-text >]
.RB [ \-\- ]
.RI < URI >
.
.\"ie \n(.g .SY.orig \%.\^pdfhref\^\ W
.\"el .SY \%.\^pdfhref\^\ W
.SY \%.\^pdfhref\^\ W
.B \-D
.RI < URI >
.RB [ \-P
.RI \%<\h'-0.15n' prefix-text >]
.RB [ \-A
.RI \%< affix-text >]
.RB [ \-\- ]
.IR descriptive\ text \ .\|.\|.
.YS
.ll +2n
.RE
.P
In the first of these,
the uniform resource identifier (URI) takes the place of any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments; it
.I must
be a verbatim representation of the URI,
and will appear as such within the active region of the link,
in the published PDF document.
.
.P
In the second form,
the URI is explicitly specified by way of the
.RB \%\(lq \-D \ <\c
.IR URI >\(rq
option.
The content of the active region of the link will then be the
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments
.IR only ;
this will
.I not
include any representation of the URI,
.I unless
it is duplicated within these arguments.
.
.P
In each of these cases, the
.RB \%\(lq \-\- \(rq
flag, and each of the
.RB \%\(lq \-P \ <\h'-\w"\^"u'\c
.IR prefix-text >\(rq
and
.RB \%\(lq \-A \ <\c
.IR affix-text >\(rq
options exhibit
.I identical
behaviour to that when they are used in the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro call.
.
.
.SS "Link Format Customization"
.
When the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro is called,
either
.I without
specification of any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments,
or with the effect of the
.RB \%\(lq \-X \(rq
flag applied to any such arguments,
then the content which is placed within the active region of
the resultant link will be determined by calling
an auxiliary formatting macro.
.
.P
Although the
.I \%groff-pdfmark
macro package does provide an internal default implementation
of a suitable formatting macro,
the user may choose to supply an alternative;
this may be assigned, as required,
by a
.B \%pdfhref
macro call of the form:
.
.RS 2n
.SY \%.\^pdfhref\^\ F
.RI \%[< macro-name >]
.YS
.RE
.P
When used in this form, the optional
.RI \%\(lq< macro-name >\(rq
argument, if specified, should name a user-provided macro,
which will perform the auxiliary formatting operation for subsequent
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
calls;
if
.RI \%\(lq< macro-name >\(rq
is omitted, the internal default macro will be reassigned,
as the handler for any subsequent
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
auxiliary formatting operations.
.
.P
When
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
calls an auxilliary formatting macro,
regardless of whether it is a user-provided macro,
or the internal default macro which is called,
the content of the reference dictionary record,
which is associated with the specified link destination,
is passed as auxiliary formatting macro arguments,
while any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments which were specified for the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
macro call itself,
are passed by assigning them to a string variable named
.BR \%\*[$PDFHREF.DESC] ,
(which remains undefined, if no
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments have been specified).
Then, after processing its arguments,
together with any additional content passed in
.BR \%\*[$PDFHREF.DESC] ,
the auxiliary formatting macro ultimately returns content
for interpolation into the active region of the generated link,
'ne 2v
by assigning it to a string variable named
.BR \%\*[$PDFHREF.TEXT] .
.
.P
There is just one requirement
imposed on any user-provided auxiliary formatting macro: it
.I must
assign a string value to
.BR \%\*[$PDFHREF.TEXT] ,
for interpolation into the active region of each generated link.
On entry, it may rely on its arguments representing the content of
the reference dictionary record for the link which is to be generated,
and on the value of the
.B \%\*[$PDFHREF.DESC]
string variable having been assigned to represent any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments from the originating
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
macro call, (or on this string variable being undefined,
if there were no such arguments);
however, whatever use the formatting macro may then make
of this input information is entirely at the discretion
of the macro writer,
who may wish to consider the following sequence of operations,
as implemented for the internal default formatting macro:
.
.RS 2n
.ll -2n
.\"nr #. 0 1
.\"ie t .ds #. \s'-1.5'\\n+(#.\s'+1.5'. \w'\0.'u+0.9n
.\"el .ds #. \s'-1.5'\\n+(#.\s'+1.5'. \w'\0.'u+1n
.ds #. \(bu 2n
.IP \*(#.
The
.B \%\*[$PDFHREF.TEXT]
string variable is assigned an initial value
which is equal to that of the
.B \%\*[$PDFHREF.PREFIX]
template string variable,
if that is defined, (as it is, by default); otherwise
.B \%\*[$PDFHREF.TEXT]
is initialized as an empty string.
.
.IP \*(#.
The macro arguments are processed in sequence,
from left to right.
If the first argument is an
.I exact
match for any registered formatting keyword,
(see the
.SR 0 "Link Format Template Registration" ,
section below),
then the second argument is interpolated into
the formatting template which is associated with that keyword,
and the result is appended,
with a single intervening space,
to the currently accumulated value of
.BR \%\*[$PDFHREF.TEXT] .
The macro arguments are then shifted to discard the first two,
(thus promoting the third to become the new first argument),
and this step is repeated.
This cycle continues until
all remaiming arguments have been exhausted,
or until the first argument,
(either on entry, or after promotion),
does
.I not
match any registered formatting keyword;
thereafter, the cycle is terminated,
and processing proceeds
.I immediately
to the following step.
.
.IP \*(#.
If
.B \%\*[$PDFHREF.DESC]
was
.I not
defined,
on entry to the macro,
it is defined now,
with the entire sequence of remaining macro arguments,
separated by spaces,
being assigned as its value;
otherwise,
.B \%\*[$PDFHREF.DESC]
retains its original value,
as assigned by
.RB \%\(lq .\^pdfhref\^\ L \ \^.\|.\|.\&\(rq
before calling the auxiliary formatting macro.
.
.IP \*(#.
The deferred expansion of
.B \%\*[$PDFHREF.DESC]
is now appended to the already accumulated value of
.BR \%\*[$PDFHREF.TEXT] ,
preceded by one intervening space.
.
.IP \*(#.
Finally,
the accumulated value of
.B \%\*[$PDFHREF.TEXT]
is reinterpreted,
reassigning the resultant text back to
.B \%\*[$PDFHREF.TEXT]
itself, but
.I without
any leading spaces which may have been accumulated;
this reassigned value is then returned to the calling
.RB \%\(lq .\^pdfhref\^\ L \ \^.\|.\|.\&\(rq
instance.
.ll +2n
.RE
.P
After calling the default auxiliary formatting macro,
(which, as may seen from the foregoing sequence of operations,
is fully conformant with the requirements for such a macro),
or any user-provided alternative, the
.RB \%\(lq .\^pdfhref\^\ L \ \^.\|.\|.\&\(rq
handler interpolates the returned value of
.B \%\*[$PDFHREF.TEXT]
into the active region of the specified link,
(bracketted by any
.RI \%\(lq prefix-text \(rq,
and
.RI \%\(lq affix-text \(rq,
which may be specified);
it then deletes the
.B \%\*[$PDFHREF.DESC]
(if it is defined), and
.B \%\*[$PDFHREF.TEXT]
string variables.
.
.
.SS "Link Format Template Registration"
.
When
.RB \%\(lq .\^pdfhref\^\ L \ \^.\|.\|.\&\(rq
calls the default
.I \%groff-pdfmark
auxiliary formatting macro,
to lay out text within any active link region,
it interpolates a sequence of
.RI \%\(lq< keyword >\ < value >\(rq
pairs, as described in the
.SR 0 "Link Format Customization"
section, above;
(a user-provided auxiliary formatting macro
.IR may ,
or may not exhibit similar behaviour,
at the discretion of the macro writer).
.
.P
A small, but extensible, vocabulary of keywords,
which become subject to such interpolation,
is built into the
.I \%groff-pdfmark
package; this vocabulary may be extended,
by invocation of:
.
.RS 2n
.SY \%.\^pdfhref\^\ K
.RI < keyword >
.RI \%<\h'-0.25n' format-name >
.RI [< keyword >
.RI \%<\h'-0.25n' format-name ">]\ .\|.\|.
.YS
.RE
.P
Each specified
.RI \%\(lq< keyword >\(rq
.\"(which
.I must
be valid as a
.MR groff @MAN7EXT@
identifier;
it is registered such that it may be recognized by
an auxiliary link formatting macro,
and is associated with a
.MR groff @MAN7EXT@
string,
named as specified by the immediately following
.RI \%\(lq<\h'-0.25n' format-name >\(rq
argument, (which
.IR must ,
therefore, also be valid as a
.MR groff @MAN7EXT@
identifier),
as its corresponding formatting template;
this template will subsequently be interpolated,
as modified by the accompanying
.RI \%\(lq< value >\(rq
argument,
into the active region of a
.B \%pdfhref
link,
when the associated
.RI \%\(lq< keyword >\(rq
is encountered within the sequence of arguments
which have been passed to a
.RB \%\(lq .\^pdfhref\^\ L \ \^.\|.\|.\&\(rq
auxiliary formatting macro.
.
.P
For each
.RI \%\(lq<\h'-0.25n' format-name >\(rq
specified, the user
.I must
ensure that a suitable
.MR groff @MAN7EXT@
string definition is also provided,
for use as the requisite formatting template.
.
.P
The initially defined default
.RI \%\(lq< keyword >\(rq
vocabulary comprises the following entries:
.
.P
.RS
.TS
tab(;);
lb lb lb
lf(CI)6 lb6 lf(CI).
Keyword;Format Name;Template
_
;\*[$PDFHREF.PREFIX];\h'0.5n'see
file;\*[$PDFHREF.FILEREF];\h'0.5n'\(rs\h'-0.25n'\(rs$1
page;\*[$PDFHREF.PAGEREF];T{
\h'0.5n'page \h'-0.5n'\(rs\h'-0.25n'\(rs$1
T}
section;\*[$PDFHREF.SECTREF];T{
\h'0.5n'section \h'-0.5n'\(rs\h'-0.25n'\(rs$1
T}
_
.TE
.RE
.if t .sp 0.2v
.P
In each case, the
.RI \%\(lq \FC\(rs\h'-0.25n'\(rs$1\F[] \(rq
field,
within the template definition,
expands to the content of the
.RI \%\(lq< value >\(rq
argument,
which follows the identified
.RI \%\(lq< keyword >\(rq,
when passed as arguments to, and interpolated by,
the default auxiliary formatting macro.
.
.P
Among the pre-defined formatting templates,
enumerated above,
it may be noted that the definition of
.RB \%\(lq \*[$PDFHREF.PREFIX] \(rq
is anomalous.
In fact,
this particular template is associated with
.I neither
any
.RI \%\(lq< keyword >\(rq,
.I nor
any
.RI \%\(lq< value >\(rq
argument;
within the default auxiliary formatting macro, it is
.I automatically
interpolated at the
.I beginning
of
.I every
active link.
.
.P
Any of the formatting template strings,
whether defined by default, or by the user,
may be redefined by the user,
to modify the appearance of formatted active links.
.
.SS "Features Initialization"
.
There is one feature of the
.B \%pdfhref
macro, which can negatively affect the interpolation of active links,
if it is mishandled\|\(em\|specifically,
if a page break occurs within the active region of any link,
special handling is required,
to ensure that the region is correctly mapped.
.
.P
To handle this scenario correctly,
.I \%groff-pdfmark
provides a helper macro, which
.I must
be called from within a page trap macro,
and this
.I must
itself be invoked as the page break is traversed;
this helper macro may be attached to an existing\|\(em\|possibly
user-defined\|\(em\|page trap macro,
by an initialization macro call of the form:
.P
.RS 2n
.SY \%.\^pdfhref\|\ I
.B \|\-PT
.RI \%\|< macro-name >
.YS
.RE
.P
It is assumed that users will
have implemented their own page trap conventions,
(or will be using a standard macro package which does so), and
.I \%groff-pdfmark
cannot make pre-emptive assumptions about
how it should interact with those;
therefore, the onus for integration of the
.B \%pdfhref
page trap handler into the user's implementation,
by issuing the above initialization macro call,
is placed on the user;
(ideally, if using a standard macro package with
.I \%groff-pdfmark
bindings,
this initialization should be performed
.IR automatically ,
within the bindings for that package).
.
.P
When calling the
.I \%groff-pdfmark
page trap initialization macro, the
.RI \%\(lq< macro-name >\(rq
argument is expected to refer to an existing macro,
which has already been installed as a page trap handler;
the initialization call then simply appends a hook
to the end of that macro,
.I without
verification that the macro will subsequently
be invoked by a page trap.
.P
If no macro, with the name specified by
.RI \%\(lq< macro-name >\(rq
exists, at the time when the initialization macro is called,
then a macro of that name will be defined,
.I and
registered as a trap, at the top of each page;
this may not achieve the desired effect.
.P
If no
.RI \%\(lq< macro-name >\(rq
argument is specified, when the initialization macro is called,
(which is technically an error, but it is not considered fatal),
then the
.I \%groff-pdfmark
page trap hook will, itself, be installed as a free-standing trap,
at the top of each page;
once again, the effect may not be as intended.
.
.
.SS Mapping of Active Link Regions
.
When placing reference links, using either the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq,
or the
.RB \%\(lq .\^pdfhref\^\ W \^\ .\|.\|.\&\(rq
form of the
.B \%pdfhref
macro, the text, which may be
.I perceived
to define each link,
is not actually significant,
nor indeed, is it even incorporated within the
.I \%pdfmark
encoding of the link specification.
Rather,
together with a pointer to the named destination,
each link specification comprises a collection of
one or more rectangular regions,
each of which is defined by page co-ordinates,
and corresponding page number.
.
.P
Each aggregate collection of such linked page regions is combined,
in order to encompass all of the text which is associated with the link;
notwithstanding that, if this text spans more than a single output line,
it is likely that the shape of the aggregate region will be irregular,
and thus, it will require more than a single rectangle to cover it,
the entire aggregate is mapped out by
.I just one
pair of invocations of the
.B \%pdfhref
macro, with each call within each pair having the form:
.
.RS 2n
.SY \%.\^pdfhref\^\ Z
.RI \^<\h'-0.15n' page >
.RI < xpos >
.RI <\h'-0.12n' ypos >
.YS
.RE
.P
Within each pair of
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
calls, the first specifies the page number, and page co-ordinates,
where the text which is to be encapsulated within the link region
.IR starts ,
while the second specifies tha page number, and co-ordinates where it
.IR ends .
From this information, the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
and
.RB \%\(lq .\^pdfhref\^\ W \^\ .\|.\|.\&\(rq
macros are able to compute the number, and placement of
sufficient rectangles to encompass the text,
and so to emit the
.I \%pdfmark
code to create the active link region.
.
.P
It may appear that determination of page numbers, and co-ordinates,
to map out link regions, and to specify the corresponding sequence of
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
calls, would be an onerous task for any document author;
fortunately, this is not necessary, because
.MR pdfroff @MAN1EXT@
performs it
.IR automatically ,
thus:
.RS 2n
.ll -2n
.IP \(bu 2n
During the initial
.MR pdfroff @MAN1EXT@
document analysis phase of PDF production,
the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
and
.RB \%\(lq .\^pdfhref\^\ W \^\ .\|.\|.\&\(rq
macros insert special marker characters,
at the beginning, and at the end,
of each run of text which is to be encapsulated within a link;
the insertion of these markers produces
a sequence of location information,
on the
.I standard error
data stream, whence
.MR pdfroff @MAN1EXT@
captures it, and generates a corresponding sequence of
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
macro calls.
.
.IP \(bu 2n
During the subsequent PDF document publication phase,
.MR pdfroff @MAN1EXT@
injects the generated sequence of
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
macro calls at the beginning of the document input stream,
storeing their data content internally, in
.MR groff @MAN7EXT@
string space,
whence subsequent
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
and
.RB \%\(lq .\^pdfhref\^\ W \^\ .\|.\|.\&\(rq
macro calls may reinterpret it,
sequentially,
and emit
.I \%pdfmark
code to create the actual links,
while ultimately discarding each such reinterpreted record,
as it is processed.
.ll +2n
.RE
.
.P
There is an unfortunate side effect
of this technique for computation of link locations\|\(em\|the
special markers, which are placed around the text associated
with each link,
although each is of zero width,
do, of necessity,
incorporate a visible component,
and this is unwanted in the finished PDF document.
To avoid this,
these special markers are
.I not
inserted around any text for which a pair of
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
entries has already been recorded, in
.MR groff @MAN7EXT@
string space;
thus, since
.MR pdfroff @MAN1EXT@
.I never
injects
.RB \%\(lq .\^pdfhref\^\ Z \^\ .\|.\|.\&\(rq
macro calls during its initial document analysis phase, and
.I always
injects them during the final publication phase,
markers are
.I always
inserted while performing document analysis,
but are omitted while producing the final publication,
the unwanted visual artefacts are avoided
in the finally published document.
.
.\"if \n(.g .rn SY.orig SY  \" restore original SY
.
.
.\" ====================================================================
.SH Control Variables
.\" ====================================================================
.
The behaviour of the
.B \%pdfhref
macro may be influenced by the values which are assigned
to a collection of
.MR groff @MAN7EXT@
string variables,
and numeric registers.
.
.P
The effective string variables are:
.
.TP
.B \*[$PDFHREF.BORDER]
This string variable specifies, as a minimum,
a space separated numeric triplet,
optionally followed by further space separated
.IR \%pdfmark\~\%array ,
the aggregate effect of which is to define the properties
of the border decoration around
.B \%pdfhref
active link regions.
.
.IP
Unlike the Adobe\*R default,
which places a one pixel wide solid border around link regions,
the default setting for
.B \%\*[$PDFHREF.BORDER]
.I disables
border decoration;
the Adobe default behaviour may be achieved
by assigning a triplet of
.RI \%\(lq \FC0\0\h'-0.6n'0\0\h'-0.7n'1\F[] \(rq
to
.BR \%\*[$PDFHREF.BORDER] .
.
.TP
.B \*[$PDFHREF.COLOR]
.TQ
.B \*[$PDFHREF.COLOUR]
Each of this (normally aliased) pair of string variables
specifies a space separated triplet of floating point values,
each in the
.RI range\~ 0.0 \0\h'-\w"\0"u/2u'to\0\h'-\w"\0"u*3u/4u' 1.0 ,
representing the colour,
in the RGB colour-space,
which is to be used for
.I decoration
of, (but
.I not
for the text within),
.B \%pdfhref
active link regions on the output page.
.
.IP
The American English spelling of
.BR \%\*[$PDFHREF.COLOR] ,
and its World English counterpart,
.BR \%\*[$PDFHREF.COLOUR] ,
are interpreted synonymously;
however, if both are defined,
.I and
their values are
.IR distinct ,
precedence will be given to
.BR \%\*[$PDFHREF.COLOUR] ,
at each single point of use,
after which the two will be resynchronized,
by binding them as aliases for the triplet value specified by
.BR \%\*[$PDFHREF.COLOR] .
.
.IP
A practical reason for the specification of distinct values for
.BR \%\*[$PDFHREF.COLOUR] ,
and
.BR \%\*[$PDFHREF.COLOR] ,
might be to introduce a single-use change in the effective colour,
which is to be applied to a particular link region.
To achieve this,
it is first necessary to use the
.MR groff @MAN7EXT@
.B rm
request, to delete any existing specification of
.BR \%\*[$PDFHREF.COLOUR] ,
and thus break the alias with
.BR \%\*[$PDFHREF.COLOR] .
A new triplet may then be specified for
.B \%\*[$PDFHREF.COLOUR]
itself,
.I before
the link is inserted into the document output stream;
after the link has been formatted,
the original alias with
.B \%\*[$PDFHREF.COLOR]
is reinstated.
.
.TP
.B \*[$PDFHREF.TEXT.COLOR]
.TQ
.B \*[$PDFHREF.TEXT.COLOUR]
Another pair of normally aliased string variables,
these specify the text colour which will be used to represent active
.B \%pdfhref
links within published documents,
but unlike the specifications for
.B \%\*[$PDFHREF.COLOUR]
and
.BR \%\*[$PDFHREF.COLOR] ,
these are expressed in terms of
.MR groff @MAN7EXT@
colour names,
(with their default being an internally defined name,
which is mapped to the colour corresponding to
.BR \%\*[$PDFHREF.COLOUR] ).
.
.IP
Once again,
the American and World English spellings are considered
to be synonymous, with precedence being given to
.BR \%\*[$PDFHREF.TEXT.COLOUR] ,
if the two definitions are distinct;
however, in this case,
the distinction is preserved until
.I either one
of the two distinct definitions is deleted.
.
.IP
If
.I both
definitions are deleted,
the default equivalence with
.B \%\*[$PDFHREF.COLOUR]
will be reinstated,
when the next active link is formatted.
.
.TP
.B \*[$PDFHREF.DESC]
.TQ
.B \*[$PDFHREF.TEXT]
Reserved for internal use
.IR only ,
this pair of string variables provides a channel
for communication between the
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
handler macro,
and an auxiliary formatting macro,
for layout of text within the active regions of
.B \%pdfhref
links.
Neither of these string variables is visible to the user,
outside the scope of a user-defined auxiliary formatting macro,
within which they serve the purposes described in section
.SR 0 "Link Format Customization" ,
above.
.
.TP
.B \*[$PDFHREF.HEIGHT]
This is a string variable representation of the height of a
.B \%pdfhref
active link region,
where the content of the region is entirely accommodated
on a single line of output text.
By default,
it is set equal to the nominal line spacing of the current font,
.RI (i.e.\ \(lq \FC1\h'-0.2n'.\h'-0.3n'0v\F[] \(rq),
and changing it is
.I not
recommended.
.
.TP
.B \*[$PDFHREF.INFO]
This string variable defines a template,
which is applied to establish the content of any
.B \%pdfhref
reference dictionary entry,
which may be stored when processing a
.B \%.\^pdfhref\^\ M
macro call.
Its default value is
.RI \%\(lq \FCpage\ \h'-0.5n'\(rs\h'-0.25n'\(rsn%\c
.IR \ \h'-0.5n'\(rs\h'-0.25n'\(rs$*\F[] \(rq,
with the expansion of its
.RI \%\(lq \FC\(rs\h'-0.25n'\(rs$*\F[] \(rq
argument representing any
.RI \%\(lq descriptive\ text \ .\|.\|.\&\(rq
arguments, from the
.B \%.\^pdfhref\^\ M
macro call.
.
.TP
.B \*[$PDFHREF.PREFIX]
This string variable specifies text,
which will
.I always
be inserted into a
.B \%pdfhref
active link region,
by the default link text formatting macro,
.I before
formatting any further content which is retrieved from the
.B \%pdfhref
reference dictionary;
its default value is the single English word,
.RI \%\(lq \FCsee\F[] \(rq,
separated from its following content by a single space.
.
.TP
.B \*[$PDFHREF.FILEREF]
This string variable defines a formatting template,
which specifies how an external file name reference should be represented,
within the content of the active region of a
.B \%pdfhref
link, when a
.RI \%\(lq \FCfile \ \h'-0.25n'\F[]< \FCfile-name\F[] >\(rq
specification is encountered while interpolating
a reference dictionary entry.
It has a default value of
.RI \%\(lq \FC\(rs\h'-0.25n'\(rs$1\F[] \(rq,
which results in just the
.RI \%\(lq< \FCfile-name\F[] >\(rq
element of the reference dictionary entry
being represented within the link.
.
.TP
.B \*[$PDFHREF.PAGEREF]
This string variable serves as a template,
specifying how a page number reference should be formatted,
when it is encountered within a reference dictionary entry,
and is to be incorporated into the text which is to be included within
the active region of a
.B \%pdfhref
link.
Its default value is
.RI \%\(lq \FCpage\ \h'-0.5n'\(rs\h'-0.25n'\(rs$1\F[] \(rq,
which simply duplicates any introductory
.RI \%\(lq \FCpage\ \h'-0.5n'\(rsn%\F[] \(rq
combination,
which may have been incorporated into the reference dictionary,
'ne 2v
as a result of substitution into the
.B \%\*[$PDFHREF.INFO]
template.
.
.TP
.B \*[$PDFHREF.SECTREF]
Also serving as a template,
this string variable specifies how
a section number reference should be formatted,
when it is encountered within a reference dictionary entry,
and is to be incorporated into the text which is to be included within
the active region of a
.B \%pdfhref
link.
Its default value is
.RI \%\(lq \FCsection\ \h'-0.5n'\(rs\h'-0.25n'\(rs$1\F[] \(rq,
which duplicates any introductory
.RI \%\(lq \FCsection\ \h'-0.5n'\(rs\h'-0.25n'*\h'-0.15'(SN\F[] \(rq
combination,
.\"which may have been incorporated into the reference dictionary entry,
when this was specified in the
.B \%\*[$PDFHREF.INFO]
template,\" was processed.
for inclusion in the reference dictionary entry.
.
.TP
.B \*[$PDFHREF.VIEW]
.TQ
.B \*[$PDFBOOKMARK.VIEW]
This distinct pair of string variables specify the view properties,
for presentation of of the destinition when either a
.B \%pdfhref
active link,
(defined by a
.B \%.\^pdfhref\^\ L
macro call),
or a PDF outline reference,
(defined by either a
.BR \%.\^pdfhref\^\ O ,
or a
.B \%.\^pdfbookmark
macro call),
is clicked, respectively.
It must be assigned a value which conforms
to the array argument requirements of the
.I \%\FC/View\F[]
link annotation
.I \%pdfmark
operator,
(excluding the array's enclosing brackets,
but including any
.MR grops @MAN1EXT@
.RI \%\(lq \FCu\F[] \(rq
transformation operators,
which may be necessary to convert from the
.I \%groff
page \%co-ordinate system to the PDF viewport mapping model);
the default value, for both, is
.RI \%\(lq\h'-0.3n' \FC/FitH\ \h'-0.3n'\(rs\h'-0.25n'\(rsn[\c
.IR PDFHREF\h'-0.25n'.\h'-0.25n'Y]\ \h'-0.5n'u\F[] \(rq.
.
.P
The numeric register variables are:
.
.TP
.B \*[$PDFHREF.LEADING]
The value of this numeric register specifies the displacement
of the top of any active
.B \%pdfhref
link region,
.I above
the topmost extent of the natural bounding box for the glyphs
which are contained within it.
This may be considered to represent an
.I adjustment
to the natural leading,
which is associated with the contained glyphs,
and which may already be more than the desired leading
within each link region;
consequently, a
.I negative
value may be appropriate,
as reflected in the default setting,
which is
.RI \%\(lq \FC\-1p\F[] \(rq.
.
.TP
.B \*[$PDFHREF.VIEW.LEADING]
This numeric register specifies, in
.MR groff @MAN7EXT@
basic units,
the vertical distance below the top of the viewport window,
at which each reference mark will be placed,
when it is selected to be brought into view.
.
.IP
Note that
.B \%\*[$PDFHREF.VIEW.LEADING]
does
.I not
represent
.I true
leading,
in the typographic sense;
any text,
which has been typeset
.I above
the reference mark,
and which is located within
.B \%\*[$PDFHREF.VIEW.LEADING]
basic units of the reference mark,
.I will
remain visible within the viewport.
.
.TP
.B \*[$PDFHREF.Y]
The value of this numeric register is internally computed,
when any
.B \%pdfhref
link destination reference mark is defined;
its value represents the vertical distance, in
.MR groff @MAN7EXT@
basic units,
from the top of the output page to the location of the reference mark.
.
.IP
While it may be normal to refer to the value of
.BR \%\*[$PDFHREF.Y] ,
within any redefinition of
.BR \%\*[$PDFHREF.VIEW] ,
or of
.BR \%\*[$PDFBOOKMARK.VIEW] ;
it is
.I always
recomputed
.I immediately before
either of these view specifications is evaluated,
and it is deleted
.I immediately
thereafter,
so it is not visible,
and thus cannot serve any useful purpose,
in any other context.
.
.P
With the exception of those which are designated as
.IR reserved ,
or otherwise,
as not having any useful effect in a user-visible scope,
any of these strings, or numeric registers,
may be redefined by the user,
to achieve a change in
.B \%pdfhref
macro behaviour.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@SITE_TMACDIR@/pdfmark.tmac
Implements the
.B \%pdfhref
macro, (among others).
.
.
.\" ====================================================================
.SH Caveats and Bugs
.\" ====================================================================
.
Although the Adobe\*R PDF specification makes provision
for linking to references by page number and co-ordinates,
this mechanism is
.I not
supported by the
.B \%pdfhref
macro;
support is provided for linking to named reference marks
.IR only .
.
.P
When any reference mark name,
which is to be used as a link destination,
is implicitly derived from the initial part of
.RI \%\(lq reference\ text \ .\|.\|.\&\(rq
arguments, that part of those arguments
.I must
represent a
.I unique
and
.I valid
.MR groff @MAN7EXT@
identifier;
this limitation will often be inconvenient,
in which case, use of an explicitly named reference mark
is recommended.
.
.P
Similarly,
all
.RI \%\(lq< keyword >\(rq
and
.RI \%\(lq<\h'-0.25n' format-name >\(rq
arguments,
used in the registration of link formatting templates,
.I must
be specified as valid
.MR groff @MAN7EXT@
identifiers.
.
.P
Interpolation of either a
.RB \%\(lq .\^pdfhref\^\ L \^\ .\|.\|.\&\(rq
or a
.RB \%\(lq .\^pdfhref\^\ W \^\ .\|.\|.\&\(rq
macro call, which is
.I followed
by a
.I non-breaking
.MR groff @MAN7EXT@
.RI \%\(lq\h'0.1n' \v'+1.2p'\(aq\v'-1.2p'\h'0.05n'\FCne\F[] \(rq
request,
and which results in relocation of the output line
in which the link text appears,
may disassociate the link text from its mapped active region;
to avoid such anomalous behaviour,
ensure that the non-breaking
.RI \%\(lq\h'0.1n' \v'+1.2p'\(aq\v'-1.2p'\h'0.05n'\FCne\F[] \(rq
request is placed
.I before
calling any macro which then has the effect\|\(em\|possibly
indirectly\|\(em\|of interpolating the affected link.
.
.P
Failure to initialize the
.I \%groff-pdfmark
page trap hook, by attachment to an existing page trap macro,
may result in erratic behaviour.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%pdfhref
macro is provided by the supplementary
.MR groff_pdfmark @MAN7EXT@
macro package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
it is independently maintained at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of the
.B pdfhref
macro may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfhref_7_man_C]
.do rr *groff_pdfhref_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
