.TH pdfroff @MAN1EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
pdfroff \- generate Portable Document Format files using groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2005-2020, 2023, 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_pdfroff_1_man_C
.cp 0
.
.\" ====================================================================
.\" Local Macro Definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pdfroff
.RI [ groff-option\  \&.\|.\|.\&]
.RB [ \-\-no\-toc\-relocation ]
.RB [ \-\-no\-kill\-null\-pages [ =\c
.IR whence ]]
.if t .br
.RB [ \-\-no\-reference\-dictionary ]
.RB [ \-\-reference\-dictionary=\c
.IR name ]
.RB [ \-\-report\-progress ]
.RB [ \-\-stylesheet=\c
.IR name ]
.RB [ \-\-emit\-ps ]
.RB [ \-\-no\-pdf\-output ]
.RB [ \-\-pdf\-output=\c
.IR name ]
.RB [ \-\-keep\-temporary\-files ]
.RI [ file\  \&.\|.\|.\&]
.YS
.
.
.SY pdfroff
.B \-h
.
.SY pdfroff
.B \-\-help
.YS
.
.
.SY pdfroff
.B \-v
.RI [ groff-option\  \&.\|.\|.\&]
.
.SY pdfroff
.B \-\-version
.RI [ groff-option\  \&.\|.\|.\&]
.YS
.
.
.P
.I \%groff-option
is any short option supported by
.MR groff @MAN1EXT@
except for
.BR \-h ,
.BR \-T ,
and
.BR \-v ;
(see the
.SR 1 \%Usage
section, below).
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.B \%pdfroff
is a wrapper program for the GNU text processing system,
.MR groff @MAN1EXT@ .
.
It transparently handles the mechanics of multiple pass
.MR groff @MAN1EXT@
processing,
when applied to suitably marked up
.MR groff @MAN7EXT@
source files,
such that tables of contents and body text are formatted separately,
and are subsequently combined in the correct order,
for final publication as a single PDF document.
.
A further optional \(lqstyle sheet\(rq capability is provided;
this allows for the definition of content which is required to precede
the table of contents,
in the published document.
.
.
.P
For each invocation of
.BR \%pdfroff ,
the ultimate
.MR groff @MAN1EXT@
output stream is post-processed by the Ghostscript
.MR gs @MAN1EXT@
interpreter to produce a finished PDF document.
.
.
.P
.B \%pdfroff
makes no assumptions about,
and imposes no restrictions on,
the use of any
.MR groff_tmac @MAN5EXT@
macro packages which the user may choose to employ,
in order to achieve a desired document format;
however,
it
.I does
include specific built in support for the
.I \%pdfmark.tmac
macro package,
should the user choose to employ it.
.
Specifically,
if the
.B pdfhref
macro,
defined in the
.I \%pdfmark.tmac
package,
is used to define public reference marks,
or dynamic links to such reference marks,
then
.B \%pdfroff
performs as many preformatting
.MR groff @MAN1EXT@
passes as required,
up to a maximum limit of
.IR four ,
in order to compile a document reference dictionary,
to resolve
references,
and to expand the dynamically defined content of links.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The command line is parsed in accordance with normal GNU conventions,
but with one exception\(emwhen specifying any short form option
(i.e.,
a single character option introduced by a single hyphen),
and if that option expects an argument,
then it
.I must
be specified independently
(i.e.,
it may
.I not
be appended to any group of other single character short form options).
.
.
.P
Long form option names
(i.e.,
those introduced by a double hyphen)
may
be abbreviated to their minimum length unambiguous initial substring.
.
.
.P
Otherwise,
.B \%pdfroff
usage closely mirrors that of
.MR groff @MAN1EXT@
itself.
.
Indeed,
with the exception of the
.BR \-h ,
.BR \-v ,
and
.BI \-T \ dev
short form options,
and all long form options,
which are parsed
internally by
.BR \%pdfroff ,
all options and file name arguments specified on the command line are
passed on to
.MR groff @MAN1EXT@ ,
to control the formatting of the PDF document.
.
Consequently,
.B \%pdfroff
accepts all options and arguments,
as specified in
.MR groff @MAN1EXT@ ,
which may also be considered as the definitive reference for all
standard
.B \%pdfroff
options and argument usage.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \%pdfroff
accepts all of the short form options
(i.e.,
those introduced by a
single hyphen),
which are available with
.MR groff @MAN1EXT@
itself.
.
In most cases,
these are simply passed transparently to
.MR groff @MAN1EXT@ ;
the following,
however,
are handled specially by
.BR \%pdfroff .
.
.
.TP
.B \-h
Same as
.BR \-\-help ;
see below.
.
.
.TP
.B \-i
Process standard input,
after all other specified input files.
.
This is passed transparently to
.MR groff @MAN1EXT@ ,
but,
if grouped with other options,
it
.I must
be the first in the group.
.
Hiding it within a group breaks standard input processing,
in the multiple-pass
.MR groff @MAN1EXT@
processing context of
.BR \%pdfroff .
.
.
.TP
.BI \-T \ dev
Of
.MR groff @MAN1EXT@ 's
device selection options,
only
.BR \-T\ pdf ,
and
.B \-T\ ps
are supported by
.BR \%pdfroff .
.
.B \-T\ pdf
is silently remapped,
to implicitly produce the effect of
.BR \-T\ ps ,
and is otherwise ignored;
.I explicit
specification of
.B \-T\ ps
retains its normal effect,
but with the additional side effect of
.I implicitly
activating the effect of the
.B \-\-emit\-ps
option,
(see below).
Attempting to specify any other device causes
.B \%pdfroff
to abort.
.
.
.TP
.B \-v
Same as
.BR \-\-version ;
see below.
.
.
.P
See
.MR groff @MAN1EXT@
for a description of all other short form options,
which are
transparently passed through
.B \%pdfroff
to
.MR groff @MAN1EXT@ .
.
.
.P
All long form options
(i.e.,
those introduced by a double hyphen)
are interpreted locally by
.BR \%pdfroff ;
they are
.I not
passed on to
.MR groff @MAN1EXT@ ,
unless otherwise stated below.
.
.
.TP
.BR \-h ,\  \-\-help
Causes
.B \%pdfroff
to display a summary of the its usage syntax,
and supported options,
and then exit.
.
.
.TP
.BR \-T\ ps ,\  \-\-emit\-ps
Suppresses the final output conversion step,
causing
.B \%pdfroff
to emit PostScript output instead of PDF.
.
This may be useful to capture intermediate PostScript output when using
a specialised postprocessor,
such as
.B gpresent
for example,
in place of the default Ghostscript PDF writer.
.
.IP
Note that use of the
.B \-Tps
option is implicitly enforced,
when running
.BR \%pdfroff ;
if specified
.IR explicitly ,
it is interpreted as an alias for
.BR \-\-emit\-ps .
.
.
.TP
.B \-\-keep\-temporary\-files
Suppresses the deletion of temporary files,
which normally occurs
after
.B \%pdfroff
has completed PDF document formatting;
this may be useful when debugging formatting problems.
.
.IP
See the
.SR 1 Files
section, below, for a description of the temporary
files used by
.BR \%pdfroff .
.
.
.TP
.B \-\-no\-pdf\-output
May be used with the
.BI \%\-\-reference\-dictionary= name
option
(described below)
to eliminate the overhead of PDF formatting when running
.B \%pdfroff
to create a reference dictionary for use in a different document.
.
.
.TP
.B \-\-no\-reference\-dictionary
May be used to eliminate the overhead of creating a reference
dictionary,
when it is known that the target PDF document contains no public
references,
created by the
.B pdfhref
macro.
.
.
.TP
.B \-\-no\-toc\-relocation
May be used to eliminate the extra
.MR groff @MAN1EXT@
processing pass,
which is required to generate a table of contents,
and relocate it to the start of the PDF document,
when processing any document which lacks an automatically
generated table of contents.
.
.
.TP
.BR \-\-no\-kill\-null\-pages [ =\c
.IR whence ]
While preparing for simulation of the manual collation step,
which is traditionally required to relocate a
.I "table of contents"
to the start of a document,
.B \%pdfroff
accumulates a number of empty page descriptions
into the intermediate PostScript output stream.
.
During the final collation step,
these empty pages are normally discarded from the finished document;
this option forces
.B \%pdfroff
to leave them in place.
.
.IP
It may be noted that, in
.BR \%pdfroff 's
default mode of operation,
entirely blank pages are discarded
.I throughout
the finished document;
the optional
.I whence
argument,
which may take any
.I one
of the values,
.BR toc ,
.BR body ,
or
.BR all ,
permits a finer degree of control over \%blank-page removal.
The default behaviour,
when
.B \%\-\-no\-kill\-null\-pages
is specified
.I without
any argument,
is equivalent to the effect of specifying
.BR \%\-\-no\-kill\-null\-pages=all ;
this suppresses the removal of blank pages throughout the
.I entire
document.
More often,
it will be desired to leave blank pages in place
within the body of the document,
while removing them from the table of contents;
this may be achieved by specifying
.BR \%\-\-no\-kill\-null\-pages=body .
Conversely,
although perhaps less usefully,
blank pages may be removed from the document body,
while leaving them in place within the table of contents,
by specifying
.BR \%\-\-no\-kill\-null\-pages=toc .
.
.
.TP
.BI \-\-pdf\-output= name
Specifies the name to be used for the resultant PDF document;
if unspecified,
the PDF output is written to standard output.
.
A future version of
.B \%pdfroff
may use this option,
to encode the document name in a generated reference dictionary.
.
.
.TP
.BI \-\-reference\-dictionary= name
Specifies the name to be used for the generated reference dictionary
file;
if unspecified,
the reference dictionary is created in a temporary file,
which is deleted when
.B \%pdfroff
completes processing of the current document.
.
This option
.I must
be specified,
if it is desired to save the reference dictionary,
for use in references placed in other PDF documents.
.
.
.TP
.B \-\-report\-progress
Causes
.B \%pdfroff
to display an informational message on standard error,
at the start of each
.MR groff @MAN1EXT@
processing pass.
.
.
.TP
.BI \-\-stylesheet= name
Specifies the name of an
.IR "input file" ,
to be used as a style sheet for formatting of content,
which is to be placed
.I before
the table of contents,
in the formatted PDF document.
.
.
.TP
.BR \-v ,\  \-\-version
Causes
.B \%pdfroff
to display a version identification message.
.
The entire command line is then passed transparently to
.MR groff @MAN1EXT@ ,
in a
.I one
pass operation
.IR only ,
in order to display the associated
.MR groff @MAN1EXT@
version information,
before exiting.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
The following environment variables may be set,
and exported,
to modify the behaviour of
.BR \%pdfroff .
.
.
.TP
.B PDFROFF_COLLATE
Specifies the program to be used
for collation of the finished PDF document.
.
.
.IP
This collation step may be required to move
.I tables of contents
to the start of the finished PDF document,
when formatting with traditional macro packages,
which print them at the end.
.
However,
users should not normally need to specify
.BR \%$PDFROFF_COLLATE ,
(and indeed,
are not encouraged to do so).
.
If unspecified,
.B \%pdfroff
uses
.MR sed @MAN1EXT@
by default,
which normally suffices.
.
.
.IP
If
.B \%$PDFROFF_COLLATE
.I is
specified,
then it must act as a filter,
accepting a list of file name arguments,
and write its output to the standard output stream,
whence it is piped to the
.BR \%$PDFROFF_POSTPROCESSOR_COMMAND ,
to produce the finished PDF output.
.
.
.IP
When specifying
.BR \%$PDFROFF_COLLATE ,
it will normally be necessary to also provide
an alternative to the default specification for
.BR \%$PDFROFF_KILL_NULL_PAGES .
.
.
.IP
.B \%$PDFROFF_COLLATE
is ignored,
if
.B \%pdfroff
is invoked with the
.B \%\-\-no\-kill\-null\-pages
option.
.
.
.TP
.B PDFROFF_KILL_NULL_PAGES
Specifies options to be passed to the
.B \%$PDFROFF_COLLATE
program.
.
.
.IP
It should not normally be necessary to specify
.BR \%$PDFROFF_KILL_NULL_PAGES .
.
The internal default is a
.MR sed @MAN1EXT@
script,
which is intended to remove completely blank pages
from the collated output stream,
and which should be appropriate in most applications of
.BR \%pdfroff .
.
However,
if any alternative to
.MR sed @MAN1EXT@
is specified for
.BR \%$PDFROFF_COLLATE ,
then it is likely that a corresponding alternative specification for
.B \%$PDFROFF_KILL_NULL_PAGES
will be required.
.
.
.IP
As in the case of
.BR \%$PDFROFF_COLLATE ,
.B \%$PDFROFF_KILL_NULL_PAGES
is ignored,
if
.B \%pdfroff
is invoked with the
.B \%\-\-no\-kill\-null\-pages
option.
.
.
.TP
.B PDFROFF_POSTPROCESSOR_COMMAND
Specifies the command to be used for the final document conversion
from PostScript intermediate output to PDF.
.
It must behave as a filter,
writing its output to the standard output stream,
and must accept an arbitrary number of
.I files .\|.\|.\&
arguments,
with the special case of
.RB \(lq \- \(rq
representing the standard input stream.
.
.
.IP
.ne 4u*\n(VSu
If unspecified,
.B \%$PDFROFF_POSTPROCESSOR_COMMAND
defaults to
.
.P
.RS 12n
.EX
gs \-dBATCH \-dQUIET \-dNOPAUSE \-dSAFER \-sDEVICE=pdfwrite \e
	\-sOutputFile=\-
.EE
.RE
.
.TP
.B PDFWRITER
If specified,
this
.I must
represent one of the output device identifiers
which is supported by the
.BR \%$PDFROFF_POSTPROCESSOR_COMMAND ;
it overrides the default
.RI \%\(lq pdfwrite \(rq
assignment within the
.RI \%\(lq \-sDEVICE=pdfwrite \(rq
specification,
which itself appears as an argument within the definition of
.BR \%$PDFROFF_POSTPROCESSOR_COMMAND .
.
.IP
.B \%$PDFWRITER
is ignored if the
.B \%\-\-emit\-ps
option is specified,
(or is implied,
by explicit specification of the
.B \%\-T\ ps
option);
this has the effect of explicitly overriding
.BR \%$PDFWRITER ,
such that it becomes equivalent to
.BR \%PDFWRITER=ps2write .
.
.
.TP
.B GROFF_TMPDIR
Identifies the directory in which
.B \%pdfroff
should create any required temporary files.
.
If
.B \%$GROFF_TMPDIR
is
.I not
specified,
then the variables
.BR $TMPDIR ,
.B $TMP
and
.B $TEMP
are considered in turn,
as possible temporary file repositories.
.
If none of these are set,
then temporary files are created
in the current directory.
.
.
.TP
.B GROFF_GHOSTSCRIPT_INTERPRETER
Specifies the program to be invoked when
.B \%pdfroff
converts
.MR groff @MAN1EXT@
PostScript output to PDF.
.
If
.B \%$PDFROFF_POSTPROCESSOR_COMMAND
is specified,
then the command name, which it specifies, is
.I implicitly
assigned to
.BR \%$GROFF_GHOSTSCRIPT_INTERPRETER ;
thus, it overrides any explicit setting
which may have been specified in the environment.
.
If
.B \%$GROFF_GHOSTSCRIPT_INTERPRETER
is not specified,
then
.B \%pdfroff
searches the process
.BR $PATH ,
looking for a program with any of the well known names
for the Ghostscript interpreter;
if no Ghostscript interpreter can be found,
.B \%pdfroff
aborts.
.
.
.TP
.B GROFF_AWK_INTERPRETER
Specifies the program to be invoked when
.B \%pdfroff
is extracting reference dictionary entries from a
.MR groff @MAN1EXT@
intermediate message stream.
.
If
.B \%$GROFF_AWK_INTERPRETER
is not specified,
then
.B \%pdfroff
searches the process
.BR $PATH ,
looking for any of the preferred programs,
.MR gawk @MAN1EXT@ ,
.MR mawk @MAN1EXT@ ,
.MR nawk @MAN1EXT@ ,
and
.MR awk @MAN1EXT@ ,
in that order;
if none of these are found,
.B \%pdfroff
issues a warning message,
and continues processing;
however,
in this case,
no reference dictionary will be created.
.
.
.TP
.B OSTYPE
Typically defined automatically by the operating system,
.B \%$OSTYPE
is interpreted on Microsoft \%Win32/MS-DOS platforms
.IR only ,
to infer the default
.B \%$PATH_SEPARATOR
character,
which is used when parsing the process
.B $PATH
to search for external helper programs.
.
.
.TP
.B PATH_SEPARATOR
If set,
.B \%$PATH_SEPARATOR
overrides the default separator character,
(\(oq:\(cq on POSIX/Unix systems;
inferred from
.B \%$OSTYPE
on Microsoft \%Win32/MS-DOS),
which is used when parsing the process
.B $PATH
to search for external helper programs.
.
.
.TP
.B SHOW_PROGRESS
If this is set to a non-empty value,
then
.B \%pdfroff
always behaves as if the
.B \%\-\-report\-progress
option is specified on the command line.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
Input and output files for
.B \%pdfroff
may be named according to any convention of the user's choice.
.
Typically,
input files may be named according to the choice of the principal
normatting macro package,
e.g.,
.I file.ms
might be an input file for formatting using the
.I ms
macros
.RI ( s.tmac );
normally,
the final output file should be named
.IR file.pdf .
.
.
.P
Temporary files created by
.B \%pdfroff
are placed in the file system hierarchy,
in or below the directory specified by environment variables
(see the
.SR 1 Environment
section, above).
.
If
.MR mktemp @MAN1EXT@
is available,
it is invoked to create a private subdirectory of
the nominated temporary files directory,
(with subdirectory name derived from the template
.IR \%pdfroff\-XXXXXXXXXX );
if this subdirectory is successfully created,
the temporary files will be placed within it,
otherwise they will be placed directly in the directory
nominated in the environment.
.
.
.P
.ne 2u*\n(VSu
All temporary files themselves
are named according to the convention
.IR \%pdf $$ .* ,
where $$ is the standard shell variable
representing the process identifier of the
.B \%pdfroff
process itself,
and
.I .*
represents any of the extensions used by
.B \%pdfroff
to identify the following temporary and intermediate files.
.
.
.TP
.IR \%pdf $$ .tmp
A scratch pad file,
used to capture reference data emitted by
.MR groff @MAN1EXT@ ,
during the
.I reference dictionary
compilation phase.
.
.
.TP
.IR \%pdf $$ .ref
The
.IR "reference dictionary" ,
as compiled in the last but one pass of the
.I reference dictionary
compilation phase;
(at the start of the first pass,
this file is created empty;
in successive passes,
it contains the
.I reference dictionary
entries,
as collected in the preceding pass).
.
.
.IP
If the
.BR \%\-\-reference\-dictionary =\c
.I name
option is specified,
this intermediate file becomes permanent,
and is named
.IR name ,
rather than
.IR \%pdf $$ .ref .
.
.
.TP
.IR \%pdf $$ .cmp
Used to collect
.I reference dictionary
entries during the active pass of the
.I reference dictionary
compilation phase.
.
At the end of any pass,
when the content of
.IR \%pdf $$ .cmp
compares as identical to
.IR \%pdf $$ .ref ,
(or the corresponding file named by the
.BR \%\-\-reference\-dictionary =\c
.I name
option),
then
.I reference dictionary
compilation is terminated,
and the
.I document reference map
is appended to this intermediate file,
for inclusion in the final formatting passes.
.
.
.TP
.IR \%pdf $$ .tc
An intermediate
.I PostScript
file,
in which \(lqTable of Contents\(rq entries are collected,
to facilitate relocation before the body text,
on ultimate output to the
.I Ghostscript
postprocessor.
.
.
.TP
.IR \%pdf $$ .ps
An intermediate
.I PostScript
file,
in which the body text is collected prior to ultimate output to the
.I Ghostscript
postprocessor,
in the proper sequence,
.I after
.IR \%pdf $$ .tc .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.B \%pdfroff
was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ,
who maintains it at
his
.UR @PROJECT_HOSTING_SITE@
.I \%groff-pdfmark
project hosting \%web-site
.UE .
.
The version which is included within the
.I \%groff
distribution is no longer maintained,
and may be withdrawn in a future release.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
Additionally,
.RI \(lq "Groff: The GNU Implementation of troff" \(rq,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I \%groff
manual.
.
You may browse it interactively,
by running the
.RI \%\(lq info\ groff \(rq
command.
.
.
.P
Since
.B \%pdfroff
provides a superset of all of
.MR groff @MAN1EXT@ 's
capabilities,
the above manual,
or its terser reference pages,
.MR groff @MAN1EXT@ ,
and
.MR groff @MAN7EXT@ ,
may also be considered definitive references to all
.I standard
capabilities of
.BR \%pdfroff ,
with this
.B \%pdfroff
manual page providing the reference to
.BR \%pdfroff 's
extended features.
.
.P
While
.B \%pdfroff
imposes neither any restriction on,
nor any requirement for,
the use of any specific
.MR groff_tmac @MAN5EXT@
macro package,
a number of supplied macro packages,
and in particular those associated with the package
.IR \%pdfmark.tmac ,
are best suited for use with
.B \%pdfroff
as the preferred formatter.
.
Detailed documentation on the use of these packages may be found,
in PDF format,
in the reference guide
.RI \(lq "Portable Document Format Publishing with GNU Troff" \(rq,
written by Keith Marshall,
which is nominally included in the installed documentation set,
as
.IR @PDFDOCDIR@/\:\%pdfmark.pdf .
.
This reference guide,
together with its source,
.IR \%pdfmark.ms ,
is included within the
.I \%groff-pdfmark
distribution.
.
Alternatively,
you may read the most recently published version
of this document online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence this latest version may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfroff_1_man_C]
.do rr *groff_pdfroff_1_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
