#!/bin/bash

# Check if an argument is provided
if [ $# -ne 1 ]; then
    echo "Usage: $0 <language_code>"
    exit 1
fi

LANG_CODE=$1

# Check if the language code is valid (lowercase a-z, optionally followed by an underscore and uppercase letters)
if ! [[ $LANG_CODE =~ ^[a-z]+(_[A-Z]+)?$ ]]; then
    echo "Error: Language code should contain only lowercase letters, optionally followed by an underscore and uppercase letters."
    exit 1
fi

# Run msginit command
msginit --input=../po/pot/kickshaw.pot --locale=$LANG_CODE --output=../po/$LANG_CODE.po

# Function to copy and rename files
copy_and_rename() {
    local src_dir=$1
    local dest_dir=$2

    # Create the destination directory
    mkdir -p "$dest_dir"

    # Copy files (not directories) from the source to the destination
    find "$src_dir" -maxdepth 1 -type f -exec cp {} "$dest_dir/" \;

    # Rename files in the destination directory
    for file in "$dest_dir"/*_en_US; do
        mv "$file" "${file%_en_US}_$LANG_CODE"
    done
}

# Copy and rename in hints, info, and list_of_shortcuts
copy_and_rename "txts/hints/en_US" "txts/hints/$LANG_CODE"
copy_and_rename "txts/info/en_US" "txts/info/$LANG_CODE"
cp "txts/list_of_shortcuts/en_US" "txts/list_of_shortcuts/$LANG_CODE"

echo "Processing completed for language code: $LANG_CODE"

python3 updating/create_gresource_xml.py
python3 updating/update_makefile.py
python3 updating/update_translations_in_kickshaw_c.py
python3 updating/update_version_and_year.py
