# Copyright (c) [2023] SUSE LLC
#
# All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of version 2 of the GNU General Public License as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, contact SUSE LLC.
#
# To contact SUSE LLC about this file by physical or electronic mail, you may
# find current contact information at www.suse.com.

module Y2Storage
  # Define `==` by having the same class and same (==) instance variables.
  #
  # The strict comparison (`eql?`) is unchanged and will be `false`
  # for different objects. See Yast2::Equatable which can also
  # specify the instance variables used for the comparison:
  # https://github.com/yast/yast-yast2/blob/master/library/general/src/lib/yast2/equatable.rb
  module EqualByInstanceVariables
    # TODO: move to base library?

    def ==(other)
      return false if other.class != self.class

      instance_variables.all? do |iv|
        instance_variable_get(iv) == other.instance_variable_get(iv)
      end
    end
  end
end
