---
title: Installation
description: Official guide to install Jekyll on macOS, GNU/Linux or Windows.
permalink: /docs/installation/
---

Jekyll is a [Ruby Gem]({{ '/docs/ruby-101/#gems' | relative_url }}) that can be installed on most systems.

## Requirements

* [Ruby](https://www.ruby-lang.org/en/downloads/) version **{{ site.data.ruby.min_version }}** or higher, including all development headers (check your Ruby version using `ruby -v`)
* [RubyGems](https://rubygems.org/pages/download) (check your Gems version using `gem -v`)
* [GCC](https://gcc.gnu.org/install/) and [Make](https://www.gnu.org/software/make/) (check versions using `gcc -v`,`g++ -v`,  and `make -v`)

## Guides

For detailed install instructions, follow the guide for your operating system.

* [macOS]({{ '/docs/installation/macos/' | relative_url }})
* [Ubuntu]({{ '/docs/installation/ubuntu/' | relative_url }})
* [FreeBSD]({{ '/docs/installation/freebsd/' | relative_url }})
* [Other Linux]({{ '/docs/installation/other-linux/' | relative_url }})
* [Windows]({{ '/docs/installation/windows/' | relative_url }})